/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.Http2Processors;
import org.apache.hc.core5.http2.impl.nio.bootstrap.AsyncPushConsumerRegistry;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.SessionRequest;
import org.apache.hc.core5.reactor.SessionRequestCallback;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.testing.nio.AsyncRequester;
import org.apache.hc.core5.testing.nio.ClientSessionEndpoint;
import org.apache.hc.core5.testing.nio.InternalClientHttp2EventHandlerFactory;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class Http2TestClient
extends AsyncRequester {
    private final SSLContext sslContext;
    private final AsyncPushConsumerRegistry pushConsumerRegistry;

    public Http2TestClient(IOReactorConfig ioReactorConfig, SSLContext sslContext) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
        this.pushConsumerRegistry = new AsyncPushConsumerRegistry();
    }

    public Http2TestClient() throws IOException {
        this(IOReactorConfig.DEFAULT, null);
    }

    public void register(String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notNull((Object)uriPattern, (String)"URI pattern");
        Args.notNull(supplier, (String)"Supplier");
        this.pushConsumerRegistry.register(null, uriPattern, supplier);
    }

    public void start(IOEventHandlerFactory handlerFactory) throws IOException {
        super.execute(handlerFactory);
    }

    public void start(HttpProcessor httpProcessor, H2Config h2Config) throws IOException {
        this.start(new InternalClientHttp2EventHandlerFactory(httpProcessor, (HandlerFactory<AsyncPushConsumer>)this.pushConsumerRegistry, HttpVersionPolicy.FORCE_HTTP_2, h2Config, H1Config.DEFAULT, CharCodingConfig.DEFAULT, this.sslContext));
    }

    public void start(HttpProcessor httpProcessor, H1Config h1Config) throws IOException {
        this.start(new InternalClientHttp2EventHandlerFactory(httpProcessor, (HandlerFactory<AsyncPushConsumer>)this.pushConsumerRegistry, HttpVersionPolicy.FORCE_HTTP_1, H2Config.DEFAULT, h1Config, CharCodingConfig.DEFAULT, this.sslContext));
    }

    public void start(H2Config h2Config) throws IOException {
        this.start(Http2Processors.client(), h2Config);
    }

    public void start(H1Config h1Config) throws IOException {
        this.start(Http2Processors.client(), h1Config);
    }

    public void start() throws Exception {
        this.start(H2Config.DEFAULT);
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, TimeValue timeout, FutureCallback<ClientSessionEndpoint> callback) throws InterruptedException {
        final BasicFuture future = new BasicFuture(callback);
        this.requestSession(host, timeout, new SessionRequestCallback(){

            public void completed(SessionRequest request) {
                TlsCapableIOSession session = request.getSession();
                future.completed((Object)new ClientSessionEndpoint((IOSession)session));
            }

            public void failed(SessionRequest request) {
                future.failed((Exception)request.getException());
            }

            public void timeout(SessionRequest request) {
                future.failed((Exception)new SocketTimeoutException("Connect timeout"));
            }

            public void cancelled(SessionRequest request) {
                future.cancel();
            }
        });
        return future;
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, TimeValue timeout) throws InterruptedException {
        return this.connect(host, timeout, null);
    }

    public Future<ClientSessionEndpoint> connect(String hostname, int port, TimeValue timeout) throws InterruptedException {
        return this.connect(new HttpHost(hostname, port), timeout, null);
    }
}

