/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.AsyncServerExchangeHandlerRegistry;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import org.apache.hc.core5.http.nio.support.RequestConsumerSupplier;
import org.apache.hc.core5.http.nio.support.ResponseHandler;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.testing.nio.AsyncServer;
import org.apache.hc.core5.testing.nio.InternalServerHttp1EventHandlerFactory;

public class Http1TestServer
extends AsyncServer {
    private final AsyncServerExchangeHandlerRegistry handlerRegistry = new AsyncServerExchangeHandlerRegistry("localhost");
    private final SSLContext sslContext;

    public Http1TestServer(IOReactorConfig ioReactorConfig, SSLContext sslContext) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
    }

    public Http1TestServer() throws IOException {
        this(IOReactorConfig.DEFAULT, null);
    }

    public void register(String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        this.handlerRegistry.register(null, uriPattern, supplier);
    }

    public <T> void register(String uriPattern, final RequestConsumerSupplier<T> consumerSupplier, final ResponseHandler<T> responseHandler) {
        this.register(uriPattern, new Supplier<AsyncServerExchangeHandler>(){

            public AsyncServerExchangeHandler get() {
                return new BasicServerExchangeHandler(consumerSupplier, responseHandler);
            }
        });
    }

    public InetSocketAddress start(IOEventHandlerFactory handlerFactory) throws Exception {
        this.execute(handlerFactory);
        ListenerEndpoint listener = this.listen(new InetSocketAddress(0));
        listener.waitFor();
        return (InetSocketAddress)listener.getAddress();
    }

    public InetSocketAddress start(HttpProcessor httpProcessor, H1Config h1Config) throws Exception {
        return this.start(new InternalServerHttp1EventHandlerFactory(httpProcessor, (HandlerFactory<AsyncServerExchangeHandler>)this.handlerRegistry, h1Config, CharCodingConfig.DEFAULT, (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE, this.sslContext));
    }

    public InetSocketAddress start() throws Exception {
        return this.start(HttpProcessors.server(), H1Config.DEFAULT);
    }
}

