/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.SessionRequest;
import org.apache.hc.core5.reactor.SessionRequestCallback;
import org.apache.hc.core5.testing.nio.IOReactorExecutor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class AsyncRequester
extends IOReactorExecutor<DefaultConnectingIOReactor>
implements ConnectionInitiator {
    public AsyncRequester(IOReactorConfig ioReactorConfig) {
        super(ioReactorConfig, (ThreadFactory)new DefaultThreadFactory("connector", true), (ThreadFactory)new DefaultThreadFactory("requester-dispatch", true));
    }

    @Override
    DefaultConnectingIOReactor createIOReactor(IOEventHandlerFactory ioEventHandlerFactory, IOReactorConfig ioReactorConfig, ThreadFactory threadFactory, Callback<IOSession> sessionShutdownCallback) throws IOException {
        return new DefaultConnectingIOReactor(ioEventHandlerFactory, ioReactorConfig, threadFactory, sessionShutdownCallback);
    }

    private InetSocketAddress toSocketAddress(HttpHost host) {
        int port = host.getPort();
        if (port < 0) {
            String scheme = host.getSchemeName();
            if (URIScheme.HTTP.same(scheme)) {
                port = 80;
            } else if (URIScheme.HTTPS.same(scheme)) {
                port = 443;
            }
        }
        String hostName = host.getHostName();
        return new InetSocketAddress(hostName, port);
    }

    public SessionRequest requestSession(HttpHost host, TimeValue timeout, SessionRequestCallback callback) {
        Args.notNull((Object)host, (String)"Host");
        Args.notNull((Object)timeout, (String)"Timeout");
        SessionRequest sessionRequest = ((DefaultConnectingIOReactor)this.reactor()).connect((NamedEndpoint)host, (SocketAddress)this.toSocketAddress(host), null, null, callback);
        sessionRequest.setConnectTimeout(timeout.toMillisIntBound());
        return sessionRequest;
    }

    public SessionRequest connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Object attachment, SessionRequestCallback callback) {
        return ((DefaultConnectingIOReactor)this.reactor()).connect(remoteEndpoint, remoteAddress, localAddress, attachment, callback);
    }
}

