/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.classic;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.config.SocketConfig;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpExpectationVerifier;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpRequestHandlerMapper;
import org.apache.hc.core5.http.io.UriHttpRequestHandlerMapper;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.testing.classic.LoggingBHttpServerConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassicTestServer {
    private final SSLContext sslContext;
    private final SocketConfig socketConfig;
    private final UriHttpRequestHandlerMapper registry;
    private final AtomicReference<HttpServer> serverRef;

    public ClassicTestServer(SSLContext sslContext, SocketConfig socketConfig) {
        this.sslContext = sslContext;
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        this.registry = new UriHttpRequestHandlerMapper();
        this.serverRef = new AtomicReference<Object>(null);
    }

    public ClassicTestServer(SocketConfig socketConfig) {
        this(null, socketConfig);
    }

    public ClassicTestServer() {
        this(null, null);
    }

    public void registerHandler(String pattern, HttpRequestHandler handler) {
        this.registry.register(pattern, handler);
    }

    public int getPort() {
        HttpServer server = this.serverRef.get();
        if (server != null) {
            return server.getLocalPort();
        }
        throw new IllegalStateException("Server not running");
    }

    public InetAddress getInetAddress() {
        HttpServer server = this.serverRef.get();
        if (server != null) {
            return server.getInetAddress();
        }
        throw new IllegalStateException("Server not running");
    }

    public void start(HttpProcessor httpProcessor, HttpExpectationVerifier expectationVerifier) throws IOException {
        if (this.serverRef.get() == null) {
            HttpServer server = ServerBootstrap.bootstrap().setSocketConfig(this.socketConfig).setSslContext(this.sslContext).setHttpProcessor(httpProcessor).setExpectationVerifier(expectationVerifier).setHandlerMapper((HttpRequestHandlerMapper)this.registry).setConnectionFactory((HttpConnectionFactory)new LoggingConnFactory()).setExceptionListener((ExceptionListener)new SimpleExceptionListener()).create();
            if (this.serverRef.compareAndSet(null, server)) {
                server.start();
            }
        } else {
            throw new IllegalStateException("Server already running");
        }
    }

    public void start(HttpExpectationVerifier expectationVerifier) throws IOException {
        this.start(null, expectationVerifier);
    }

    public void start() throws IOException {
        this.start(null, null);
    }

    public void shutdown(ShutdownType shutdownType) {
        HttpServer server = this.serverRef.getAndSet(null);
        if (server != null) {
            server.shutdown(shutdownType);
        }
    }

    static class SimpleExceptionListener
    implements ExceptionListener {
        private final Logger log = LogManager.getLogger(ClassicTestServer.class);

        SimpleExceptionListener() {
        }

        public void onError(Exception ex) {
            if (ex instanceof ConnectionClosedException) {
                this.log.debug(ex.getMessage());
            } else if (ex instanceof SocketException) {
                this.log.debug(ex.getMessage());
            } else {
                this.log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    static class LoggingConnFactory
    implements HttpConnectionFactory<LoggingBHttpServerConnection> {
        LoggingConnFactory() {
        }

        public LoggingBHttpServerConnection createConnection(Socket socket) throws IOException {
            LoggingBHttpServerConnection conn = new LoggingBHttpServerConnection(socket instanceof SSLSocket ? URIScheme.HTTPS.id : URIScheme.HTTP.id, H1Config.DEFAULT);
            conn.bind(socket);
            return conn;
        }
    }
}

