/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.classic;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.config.SocketConfig;
import org.apache.hc.core5.http.impl.bootstrap.HttpRequester;
import org.apache.hc.core5.http.impl.bootstrap.RequesterBootstrap;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.testing.classic.LoggingBHttpClientConnection;

public class ClassicTestClient {
    private final SSLContext sslContext;
    private final SocketConfig socketConfig;
    private final AtomicReference<HttpRequester> requesterRef;

    public ClassicTestClient(SSLContext sslContext, SocketConfig socketConfig) {
        this.sslContext = sslContext;
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        this.requesterRef = new AtomicReference<Object>(null);
    }

    public ClassicTestClient(SocketConfig socketConfig) {
        this(null, socketConfig);
    }

    public ClassicTestClient() {
        this(null, null);
    }

    public void start() {
        this.start(null);
    }

    public void start(HttpProcessor httpProcessor) {
        if (this.requesterRef.get() != null) {
            throw new IllegalStateException("Requester has already been started");
        }
        HttpRequester requester = RequesterBootstrap.bootstrap().setSslSocketFactory(this.sslContext != null ? this.sslContext.getSocketFactory() : null).setHttpProcessor(httpProcessor).setConnectFactory((HttpConnectionFactory)new LoggingConnFactory()).create();
        this.requesterRef.compareAndSet(null, requester);
    }

    public void shutdown(ShutdownType shutdownType) {
        HttpRequester requester = this.requesterRef.getAndSet(null);
        if (requester != null) {
            requester.shutdown(shutdownType);
        }
    }

    public ClassicHttpResponse execute(HttpHost targetHost, ClassicHttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpRequester requester = this.requesterRef.get();
        if (requester == null) {
            throw new IllegalStateException("Requester has not been started");
        }
        if (request.getAuthority() == null) {
            request.setAuthority(new URIAuthority((NamedEndpoint)targetHost));
        }
        request.setScheme(targetHost.getSchemeName());
        return requester.execute(targetHost, request, this.socketConfig.getSoTimeout(), context);
    }

    class LoggingConnFactory
    implements HttpConnectionFactory<LoggingBHttpClientConnection> {
        LoggingConnFactory() {
        }

        public LoggingBHttpClientConnection createConnection(Socket socket) throws IOException {
            LoggingBHttpClientConnection conn = new LoggingBHttpClientConnection(H1Config.DEFAULT);
            conn.bind(socket);
            return conn;
        }
    }
}

