/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.sync;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.sync.ExecChain;
import org.apache.hc.client5.http.sync.ExecChainHandler;
import org.apache.hc.client5.http.sync.ServiceUnavailableRetryStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
final class ServiceUnavailableRetryExec
implements ExecChainHandler {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull((Object)retryStrategy, (String)"Retry strategy");
        this.retryStrategy = retryStrategy;
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        HttpClientContext context = scope.clientContext;
        ClassicHttpRequest currentRequest = request;
        int c = 1;
        while (true) {
            ClassicHttpResponse response = chain.proceed(currentRequest, scope);
            try {
                if (this.retryStrategy.retryRequest((HttpResponse)response, c, (HttpContext)context)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval((HttpResponse)response, (HttpContext)context);
                    if (nextInterval > 0L) {
                        try {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Wait for " + (double)nextInterval / 1000.0 + " seconds");
                            }
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                currentRequest = ExecSupport.copy(scope.originalRequest);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

