/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.sync;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.StandardMethods;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.sync.RequestEntityProxy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectException;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.sync.ExecChain;
import org.apache.hc.client5.http.sync.ExecChainHandler;
import org.apache.hc.client5.http.sync.methods.HttpGet;
import org.apache.hc.client5.http.sync.methods.RequestBuilder;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
final class RedirectExec
implements ExecChainHandler {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final RedirectStrategy redirectStrategy;
    private final HttpRoutePlanner routePlanner;

    public RedirectExec(HttpRoutePlanner routePlanner, RedirectStrategy redirectStrategy) {
        Args.notNull((Object)routePlanner, (String)"HTTP route planner");
        Args.notNull((Object)redirectStrategy, (String)"HTTP redirect strategy");
        this.routePlanner = routePlanner;
        this.redirectStrategy = redirectStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        RequestConfig config;
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        HttpClientContext context = scope.clientContext;
        List<URI> redirectLocations = context.getRedirectLocations();
        if (redirectLocations != null) {
            redirectLocations.clear();
        }
        int maxRedirects = (config = context.getRequestConfig()).getMaxRedirects() > 0 ? config.getMaxRedirects() : 50;
        ClassicHttpRequest currentRequest = request;
        ExecChain.Scope currentScope = scope;
        int redirectCount = 0;
        while (true) {
            ClassicHttpResponse response = chain.proceed(currentRequest, currentScope);
            try {
                boolean crossSiteRedirect;
                HttpHost newTarget;
                if (!config.isRedirectsEnabled()) return response;
                if (!this.redirectStrategy.isRedirected((HttpRequest)request, (HttpResponse)response, (HttpContext)context)) return response;
                if (redirectCount >= maxRedirects) {
                    throw new RedirectException("Maximum redirects (" + maxRedirects + ") exceeded");
                }
                ++redirectCount;
                URI redirectUri = this.redirectStrategy.getLocationURI((HttpRequest)currentRequest, (HttpResponse)response, (HttpContext)context);
                ClassicHttpRequest originalRequest = scope.originalRequest;
                Object redirect = null;
                int statusCode = response.getCode();
                switch (statusCode) {
                    case 301: 
                    case 302: 
                    case 303: {
                        if (!StandardMethods.isSafe(request.getMethod())) {
                            HttpGet httpGet = new HttpGet(redirectUri);
                            httpGet.setHeaders(originalRequest.getAllHeaders());
                            redirect = httpGet;
                            break;
                        }
                        redirect = null;
                        break;
                    }
                }
                if (redirect == null) {
                    redirect = RequestBuilder.copy(originalRequest).setUri(redirectUri).build();
                }
                if ((newTarget = URIUtils.extractHost(redirectUri)) == null) {
                    throw new ProtocolException("Redirect URI does not specify a valid host name: " + redirectUri);
                }
                HttpRoute currentRoute = currentScope.route;
                boolean bl = crossSiteRedirect = !currentRoute.getTargetHost().equals((Object)newTarget);
                if (crossSiteRedirect) {
                    AuthExchange proxyAuthExchange;
                    AuthScheme authScheme;
                    AuthExchange targetAuthExchange = context.getAuthExchange(currentRoute.getTargetHost());
                    this.log.debug("Resetting target auth state");
                    targetAuthExchange.reset();
                    if (currentRoute.getProxyHost() != null && (authScheme = (proxyAuthExchange = context.getAuthExchange(currentRoute.getProxyHost())).getAuthScheme()) != null && authScheme.isConnectionBased()) {
                        this.log.debug("Resetting proxy auth state");
                        proxyAuthExchange.reset();
                    }
                    currentRoute = this.routePlanner.determineRoute(newTarget, (HttpContext)context);
                    currentScope = new ExecChain.Scope(currentRoute, currentScope.originalRequest, currentScope.execRuntime, currentScope.clientContext);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Redirecting to '" + redirectUri + "' via " + currentRoute);
                }
                currentRequest = redirect;
                RequestEntityProxy.enhance(currentRequest);
                EntityUtils.consume((HttpEntity)response.getEntity());
                response.close();
            }
            catch (IOException | RuntimeException ex) {
                response.close();
                throw ex;
            }
            catch (HttpException ex) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    throw ex;
                }
                catch (IOException ioex) {
                    this.log.debug("I/O error while releasing connection", (Throwable)ioex);
                    throw ex;
                }
                finally {
                    response.close();
                }
            }
        }
    }
}

