/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.sync;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.impl.sync.CloseableHttpResponse;
import org.apache.hc.client5.http.protocol.ClientProtocolException;
import org.apache.hc.client5.http.sync.HttpClient;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.ResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpClient
implements HttpClient,
Closeable {
    private final Logger log = LogManager.getLogger(this.getClass());

    protected abstract CloseableHttpResponse doExecute(HttpHost var1, ClassicHttpRequest var2, HttpContext var3) throws IOException;

    public CloseableHttpResponse execute(HttpHost target, ClassicHttpRequest request, HttpContext context) throws IOException {
        return this.doExecute(target, request, context);
    }

    public CloseableHttpResponse execute(ClassicHttpRequest request, HttpContext context) throws IOException {
        Args.notNull((Object)request, (String)"HTTP request");
        return this.doExecute(CloseableHttpClient.determineTarget(request), request, context);
    }

    private static HttpHost determineTarget(ClassicHttpRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = null;
        try {
            requestURI = request.getUri();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (requestURI != null && requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }

    public CloseableHttpResponse execute(ClassicHttpRequest request) throws IOException {
        return this.execute(request, (HttpContext)null);
    }

    @Override
    public CloseableHttpResponse execute(HttpHost target, ClassicHttpRequest request) throws IOException {
        return this.doExecute(target, request, null);
    }

    @Override
    public <T> T execute(ClassicHttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(request, responseHandler, null);
    }

    @Override
    public <T> T execute(ClassicHttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpHost target = CloseableHttpClient.determineTarget(request);
        return this.execute(target, request, responseHandler, context);
    }

    @Override
    public <T> T execute(HttpHost target, ClassicHttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(target, request, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpHost target, ClassicHttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        Args.notNull(responseHandler, (String)"Response handler");
        Throwable throwable = null;
        try (CloseableHttpResponse response = this.execute(target, request, context);){
            Object result = responseHandler.handleResponse((ClassicHttpResponse)response);
            HttpEntity entity = response.getEntity();
            EntityUtils.consume((HttpEntity)entity);
            Object object = result;
            return (T)object;
        }
        catch (HttpException t) {
            try {
                HttpEntity entity = response.getEntity();
                try {
                    EntityUtils.consume((HttpEntity)entity);
                }
                catch (Exception t2) {
                    this.log.warn("Error consuming content after an exception.", (Throwable)t2);
                }
                throw new ClientProtocolException(t);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

