/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.H2TlsStrategy;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.pool.ConnPoolListener;
import org.apache.hc.core5.pool.ConnPoolPolicy;
import org.apache.hc.core5.util.TimeValue;

public class PoolingAsyncClientConnectionManagerBuilder {
    private TlsStrategy tlsStrategy;
    private SchemePortResolver schemePortResolver;
    private DnsResolver dnsResolver;
    private ConnPoolPolicy connPoolPolicy;
    private ConnPoolListener<HttpRoute> connPoolListener;
    private boolean systemProperties;
    private int maxConnTotal = 0;
    private int maxConnPerRoute = 0;
    private TimeValue timeToLive;
    private TimeValue validateAfterInactivity;

    public static PoolingAsyncClientConnectionManagerBuilder create() {
        return new PoolingAsyncClientConnectionManagerBuilder();
    }

    PoolingAsyncClientConnectionManagerBuilder() {
    }

    public final PoolingAsyncClientConnectionManagerBuilder setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setConnPoolPolicy(ConnPoolPolicy connPoolPolicy) {
        this.connPoolPolicy = connPoolPolicy;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setConnPoolListener(ConnPoolListener<HttpRoute> connPoolListener) {
        this.connPoolListener = connPoolListener;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setMaxConnTotal(int maxConnTotal) {
        this.maxConnTotal = maxConnTotal;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        this.maxConnPerRoute = maxConnPerRoute;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setConnectionTimeToLive(TimeValue timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setValidateAfterInactivity(TimeValue validateAfterInactivity) {
        this.validateAfterInactivity = validateAfterInactivity;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder useSystemProperties() {
        this.systemProperties = true;
        return this;
    }

    public PoolingAsyncClientConnectionManager build() {
        PoolingAsyncClientConnectionManager poolingmgr = new PoolingAsyncClientConnectionManager((Lookup<TlsStrategy>)RegistryBuilder.create().register("https", (Object)(this.tlsStrategy != null ? this.tlsStrategy : (this.systemProperties ? H2TlsStrategy.getSystemDefault() : H2TlsStrategy.getDefault()))).build(), this.schemePortResolver, this.dnsResolver, this.timeToLive, this.connPoolPolicy, this.connPoolListener);
        poolingmgr.setValidateAfterInactivity(this.validateAfterInactivity);
        if (this.maxConnTotal > 0) {
            poolingmgr.setMaxTotal(this.maxConnTotal);
        }
        if (this.maxConnPerRoute > 0) {
            poolingmgr.setDefaultMaxPerRoute(this.maxConnPerRoute);
        }
        return poolingmgr;
    }
}

