/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.nio.AsyncClientConnectionOperator;
import org.apache.hc.client5.http.impl.nio.ManagedAsyncClientConnection;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.command.ExecutionCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.nio.AsyncPingHandler;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.http2.nio.support.BasicPingHandler;
import org.apache.hc.core5.io.GracefullyCloseable;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.ConnPoolListener;
import org.apache.hc.core5.pool.ConnPoolPolicy;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.pool.StrictConnPool;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.TimeValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class PoolingAsyncClientConnectionManager
implements AsyncClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final AsyncClientConnectionOperator connectionOperator;
    private final StrictConnPool<HttpRoute, ManagedAsyncClientConnection> pool;
    private final AtomicBoolean closed;
    private volatile TimeValue validateAfterInactivity;
    private static final AtomicLong COUNT = new AtomicLong(0L);

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> tlsStrategyLookup, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, TimeValue timeToLive, ConnPoolPolicy policy, ConnPoolListener<HttpRoute> connPoolListener) {
        this.connectionOperator = new AsyncClientConnectionOperator(schemePortResolver, dnsResolver, tlsStrategyLookup);
        this.pool = new StrictConnPool(20, 50, timeToLive, policy != null ? policy : ConnPoolPolicy.LIFO, connPoolListener);
        this.closed = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.log.debug("Connection manager is shutting down");
            this.pool.shutdown(ShutdownType.GRACEFUL);
            this.log.debug("Connection manager shut down");
        }
    }

    private InternalConnectionEndpoint cast(AsyncConnectionEndpoint endpoint) {
        if (endpoint instanceof InternalConnectionEndpoint) {
            return (InternalConnectionEndpoint)endpoint;
        }
        throw new IllegalStateException("Unexpected endpoint class: " + endpoint.getClass());
    }

    @Override
    public Future<AsyncConnectionEndpoint> lease(final HttpRoute route, final Object state, TimeValue timeout, FutureCallback<AsyncConnectionEndpoint> callback) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connection request: " + ConnPoolSupport.formatStats(null, route, state, this.pool));
        }
        final ComplexFuture resultFuture = new ComplexFuture(callback);
        Future leaseFuture = this.pool.lease((Object)route, state, timeout, (FutureCallback)new FutureCallback<PoolEntry<HttpRoute, ManagedAsyncClientConnection>>(){

            void leaseCompleted(PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
                if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                    PoolingAsyncClientConnectionManager.this.log.debug("Connection leased: " + ConnPoolSupport.formatStats(poolEntry.getConnection(), route, state, (ConnPoolControl<HttpRoute>)PoolingAsyncClientConnectionManager.this.pool));
                }
                InternalConnectionEndpoint endpoint = new InternalConnectionEndpoint(poolEntry);
                if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                    PoolingAsyncClientConnectionManager.this.log.debug(ConnPoolSupport.getId(endpoint) + ": acquired " + ConnPoolSupport.getId(poolEntry.getConnection()));
                }
                resultFuture.completed((Object)endpoint);
            }

            public void completed(final PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
                if (TimeValue.isPositive((TimeValue)PoolingAsyncClientConnectionManager.this.validateAfterInactivity)) {
                    final ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)poolEntry.getConnection();
                    ProtocolVersion protocolVersion = connection.getProtocolVersion();
                    if (HttpVersion.HTTP_2_0.greaterEquals(protocolVersion)) {
                        connection.submitPriorityCommand((Command)new PingCommand((AsyncPingHandler)new BasicPingHandler((Callback)new Callback<Boolean>(){

                            public void execute(Boolean result) {
                                if (result == Boolean.FALSE) {
                                    if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                                        PoolingAsyncClientConnectionManager.this.log.debug("Connection " + ConnPoolSupport.getId(connection) + " is stale");
                                    }
                                    poolEntry.discardConnection(ShutdownType.IMMEDIATE);
                                }
                                this.leaseCompleted((PoolEntry<HttpRoute, ManagedAsyncClientConnection>)poolEntry);
                            }
                        })));
                    } else {
                        this.leaseCompleted(poolEntry);
                    }
                } else {
                    this.leaseCompleted(poolEntry);
                }
            }

            public void failed(Exception ex) {
                resultFuture.failed(ex);
            }

            public void cancelled() {
                resultFuture.cancel();
            }
        });
        resultFuture.setDependency(leaseFuture);
        return resultFuture;
    }

    @Override
    public void release(AsyncConnectionEndpoint endpoint, Object state, TimeValue keepAlive) {
        ManagedAsyncClientConnection connection;
        Args.notNull((Object)endpoint, (String)"Managed endpoint");
        Args.notNull((Object)keepAlive, (String)"Keep-alive time");
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> entry = this.cast(endpoint).detach();
        if (entry == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(ConnPoolSupport.getId(endpoint) + ": endpoint discarded");
        }
        boolean reusable = (connection = (ManagedAsyncClientConnection)entry.getConnection()) != null && connection.isOpen();
        try {
            if (reusable) {
                entry.updateState(state);
                entry.updateExpiry(keepAlive);
                if (this.log.isDebugEnabled()) {
                    String s = TimeValue.isPositive((TimeValue)keepAlive) ? "for " + keepAlive : "indefinitely";
                    this.log.debug("Connection " + ConnPoolSupport.getId(connection) + " can be kept alive " + s);
                }
            }
        }
        catch (RuntimeException ex) {
            reusable = false;
            throw ex;
        }
        finally {
            this.pool.release(entry, reusable);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Connection released: " + ConnPoolSupport.formatStats(connection, (HttpRoute)entry.getRoute(), entry.getState(), this.pool));
            }
        }
    }

    @Override
    public Future<AsyncConnectionEndpoint> connect(AsyncConnectionEndpoint endpoint, ConnectionInitiator connectionInitiator, TimeValue timeout, Object attachment, HttpContext context, FutureCallback<AsyncConnectionEndpoint> callback) {
        Args.notNull((Object)endpoint, (String)"Endpoint");
        Args.notNull((Object)connectionInitiator, (String)"Connection initiator");
        Args.notNull((Object)timeout, (String)"Timeout");
        final InternalConnectionEndpoint internalEndpoint = this.cast(endpoint);
        final ComplexFuture resultFuture = new ComplexFuture(callback);
        if (internalEndpoint.isConnected()) {
            resultFuture.completed((Object)endpoint);
            return resultFuture;
        }
        final PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = internalEndpoint.getPoolEntry();
        HttpRoute route = (HttpRoute)poolEntry.getRoute();
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        InetSocketAddress localAddress = route.getLocalSocketAddress();
        Future<ManagedAsyncClientConnection> connectFuture = this.connectionOperator.connect(connectionInitiator, host, localAddress, timeout, attachment, new FutureCallback<ManagedAsyncClientConnection>(){

            public void completed(ManagedAsyncClientConnection connection) {
                try {
                    if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                        PoolingAsyncClientConnectionManager.this.log.debug(ConnPoolSupport.getId(internalEndpoint) + ": connected " + ConnPoolSupport.getId(connection));
                    }
                    poolEntry.assignConnection((GracefullyCloseable)connection);
                    resultFuture.completed((Object)internalEndpoint);
                }
                catch (RuntimeException ex) {
                    resultFuture.failed((Exception)ex);
                }
            }

            public void failed(Exception ex) {
                resultFuture.failed(ex);
            }

            public void cancelled() {
                resultFuture.cancel();
            }
        });
        resultFuture.setDependency(connectFuture);
        return resultFuture;
    }

    @Override
    public void upgrade(AsyncConnectionEndpoint endpoint, Object attachment, HttpContext context) {
        Args.notNull((Object)endpoint, (String)"Managed endpoint");
        InternalConnectionEndpoint internalEndpoint = this.cast(endpoint);
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = internalEndpoint.getValidatedPoolEntry();
        HttpRoute route = (HttpRoute)poolEntry.getRoute();
        ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)poolEntry.getConnection();
        this.connectionOperator.upgrade((ManagedAsyncClientConnection)poolEntry.getConnection(), route.getTargetHost(), attachment);
        if (this.log.isDebugEnabled()) {
            this.log.debug(ConnPoolSupport.getId(internalEndpoint) + ": upgraded " + ConnPoolSupport.getId(connection));
        }
    }

    public void setMaxTotal(int max) {
        this.pool.setMaxTotal(max);
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    public void setDefaultMaxPerRoute(int max) {
        this.pool.setDefaultMaxPerRoute(max);
    }

    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    public void setMaxPerRoute(HttpRoute route, int max) {
        this.pool.setMaxPerRoute((Object)route, max);
    }

    public int getMaxPerRoute(HttpRoute route) {
        return this.pool.getMaxPerRoute((Object)route);
    }

    public void closeIdle(TimeValue idletime) {
        this.pool.closeIdle(idletime);
    }

    public void closeExpired() {
        this.pool.closeExpired();
    }

    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    public PoolStats getStats(HttpRoute route) {
        return this.pool.getStats((Object)route);
    }

    public TimeValue getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(TimeValue validateAfterInactivity) {
        this.validateAfterInactivity = validateAfterInactivity;
    }

    class InternalConnectionEndpoint
    extends AsyncConnectionEndpoint
    implements Identifiable {
        private final AtomicReference<PoolEntry<HttpRoute, ManagedAsyncClientConnection>> poolEntryRef;
        private final String id;

        InternalConnectionEndpoint(PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
            this.poolEntryRef = new AtomicReference<PoolEntry<HttpRoute, ManagedAsyncClientConnection>>(poolEntry);
            this.id = "ep-" + Long.toHexString(COUNT.incrementAndGet());
        }

        public String getId() {
            return this.id;
        }

        PoolEntry<HttpRoute, ManagedAsyncClientConnection> getPoolEntry() {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry == null) {
                throw new ConnectionShutdownException();
            }
            return poolEntry;
        }

        PoolEntry<HttpRoute, ManagedAsyncClientConnection> getValidatedPoolEntry() {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.getPoolEntry();
            ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)poolEntry.getConnection();
            Asserts.check((connection != null && connection.isOpen() ? 1 : 0) != 0, (String)"Endpoint is not connected");
            return poolEntry;
        }

        PoolEntry<HttpRoute, ManagedAsyncClientConnection> detach() {
            return this.poolEntryRef.getAndSet(null);
        }

        @Override
        public void shutdown() throws IOException {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry != null) {
                if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                    PoolingAsyncClientConnectionManager.this.log.debug(this.id + ": shutdown " + ShutdownType.IMMEDIATE);
                }
                poolEntry.discardConnection(ShutdownType.IMMEDIATE);
            }
        }

        @Override
        public void close() throws IOException {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry != null) {
                if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                    PoolingAsyncClientConnectionManager.this.log.debug(this.id + ": shutdown " + ShutdownType.GRACEFUL);
                }
                poolEntry.discardConnection(ShutdownType.GRACEFUL);
            }
        }

        @Override
        public boolean isConnected() {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry == null) {
                return false;
            }
            ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)poolEntry.getConnection();
            if (connection == null) {
                return false;
            }
            if (!connection.isOpen()) {
                poolEntry.discardConnection(ShutdownType.IMMEDIATE);
                return false;
            }
            return true;
        }

        @Override
        public void setSocketTimeout(int timeout) {
            ((ManagedAsyncClientConnection)this.getValidatedPoolEntry().getConnection()).setSocketTimeout(timeout);
        }

        @Override
        public void execute(AsyncClientExchangeHandler exchangeHandler, HttpContext context) {
            ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)this.getValidatedPoolEntry().getConnection();
            if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                PoolingAsyncClientConnectionManager.this.log.debug(this.id + ": executing exchange " + ConnPoolSupport.getId(exchangeHandler) + " over " + ConnPoolSupport.getId(connection));
            }
            connection.submitCommand((Command)new ExecutionCommand(exchangeHandler, context));
        }
    }
}

