/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.async.AbstractHttpAsyncClientBase;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorException;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;

public class MinimalHttpAsyncClient
extends AbstractHttpAsyncClientBase {
    private final AsyncClientConnectionManager connmgr;
    private final HttpVersionPolicy versionPolicy;

    MinimalHttpAsyncClient(IOEventHandlerFactory eventHandlerFactory, AsyncPushConsumerRegistry pushConsumerRegistry, HttpVersionPolicy versionPolicy, IOReactorConfig reactorConfig, ThreadFactory threadFactory, ThreadFactory workerThreadFactory, AsyncClientConnectionManager connmgr) throws IOReactorException {
        super(new DefaultConnectingIOReactor(eventHandlerFactory, reactorConfig, workerThreadFactory, (Callback)new Callback<IOSession>(){

            public void execute(IOSession ioSession) {
                ioSession.addFirst((Command)new ShutdownCommand(ShutdownType.GRACEFUL));
            }
        }), pushConsumerRegistry, threadFactory);
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.connmgr = connmgr;
    }

    private Future<AsyncConnectionEndpoint> leaseEndpoint(HttpHost host, final TimeValue connectTimeout, final HttpClientContext clientContext, final FutureCallback<AsyncConnectionEndpoint> callback) {
        final ComplexFuture resultFuture = new ComplexFuture(callback);
        Future<AsyncConnectionEndpoint> leaseFuture = this.connmgr.lease(new HttpRoute(host), null, connectTimeout, new FutureCallback<AsyncConnectionEndpoint>(){

            public void completed(AsyncConnectionEndpoint connectionEndpoint) {
                if (connectionEndpoint.isConnected()) {
                    resultFuture.completed((Object)connectionEndpoint);
                } else {
                    Future<AsyncConnectionEndpoint> connectFuture = MinimalHttpAsyncClient.this.connmgr.connect(connectionEndpoint, MinimalHttpAsyncClient.this.getConnectionInitiator(), connectTimeout, MinimalHttpAsyncClient.this.versionPolicy, (HttpContext)clientContext, new FutureCallback<AsyncConnectionEndpoint>(){

                        public void completed(AsyncConnectionEndpoint result) {
                            resultFuture.completed((Object)result);
                        }

                        public void failed(Exception ex) {
                            resultFuture.failed(ex);
                        }

                        public void cancelled() {
                            resultFuture.cancel(true);
                        }
                    });
                    resultFuture.setDependency(connectFuture);
                }
            }

            public void failed(Exception ex) {
                callback.failed(ex);
            }

            public void cancelled() {
                callback.cancelled();
            }
        });
        resultFuture.setDependency(leaseFuture);
        return resultFuture;
    }

    public final Future<AsyncClientEndpoint> lease(HttpHost host, FutureCallback<AsyncClientEndpoint> callback) {
        return this.lease(host, (HttpContext)HttpClientContext.create(), callback);
    }

    public Future<AsyncClientEndpoint> lease(HttpHost host, HttpContext context, FutureCallback<AsyncClientEndpoint> callback) {
        Args.notNull((Object)host, (String)"Host");
        Args.notNull((Object)context, (String)"HTTP context");
        this.ensureRunning();
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        final BasicFuture future = new BasicFuture(callback);
        this.leaseEndpoint(host, requestConfig.getConnectTimeout(), clientContext, new FutureCallback<AsyncConnectionEndpoint>(){

            public void completed(AsyncConnectionEndpoint result) {
                future.completed((Object)new InternalAsyncClientEndpoint(result));
            }

            public void failed(Exception ex) {
                future.failed(ex);
            }

            public void cancelled() {
                future.cancel(true);
            }
        });
        return future;
    }

    @Override
    public <T> Future<T> execute(final AsyncRequestProducer requestProducer, final AsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        this.ensureRunning();
        HttpRequest request = requestProducer.produceRequest();
        HttpHost target = new HttpHost((NamedEndpoint)request.getAuthority(), request.getScheme());
        final HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = null;
        if (requestProducer instanceof Configurable) {
            requestConfig = ((Configurable)requestProducer).getConfig();
        }
        if (requestConfig != null) {
            clientContext.setRequestConfig(requestConfig);
        } else {
            requestConfig = clientContext.getRequestConfig();
        }
        final ComplexFuture resultFuture = new ComplexFuture(callback);
        Future<AsyncConnectionEndpoint> leaseFuture = this.leaseEndpoint(target, requestConfig.getConnectTimeout(), clientContext, new FutureCallback<AsyncConnectionEndpoint>(){

            public void completed(AsyncConnectionEndpoint connectionEndpoint) {
                final InternalAsyncClientEndpoint endpoint = new InternalAsyncClientEndpoint(connectionEndpoint);
                endpoint.execute(requestProducer, responseConsumer, (HttpContext)clientContext, new FutureCallback<T>(){

                    public void completed(T result) {
                        endpoint.releaseAndReuse();
                        resultFuture.completed(result);
                    }

                    public void failed(Exception ex) {
                        endpoint.releaseAndDiscard();
                        resultFuture.failed(ex);
                    }

                    public void cancelled() {
                        endpoint.releaseAndDiscard();
                        resultFuture.cancel();
                    }
                });
                resultFuture.setDependency(new Cancellable(){

                    public boolean cancel() {
                        boolean active = !endpoint.isReleased();
                        endpoint.releaseAndDiscard();
                        return active;
                    }
                });
            }

            public void failed(Exception ex) {
                resultFuture.failed(ex);
            }

            public void cancelled() {
                resultFuture.cancel();
            }
        });
        resultFuture.setDependency(leaseFuture);
        return resultFuture;
    }

    private class InternalAsyncClientEndpoint
    extends AsyncClientEndpoint {
        private final AsyncConnectionEndpoint connectionEndpoint;
        private final AtomicBoolean released;

        InternalAsyncClientEndpoint(AsyncConnectionEndpoint connectionEndpoint) {
            this.connectionEndpoint = connectionEndpoint;
            this.released = new AtomicBoolean(false);
        }

        boolean isReleased() {
            return this.released.get();
        }

        public void execute(AsyncClientExchangeHandler exchangeHandler, HttpContext context) {
            Asserts.check((!this.released.get() ? 1 : 0) != 0, (String)"Endpoint has already been released");
            String exchangeId = Long.toHexString(ExecSupport.getNextExecNumber());
            if (MinimalHttpAsyncClient.this.log.isDebugEnabled()) {
                MinimalHttpAsyncClient.this.log.debug(ConnPoolSupport.getId(this.connectionEndpoint) + ": executing message exchange " + exchangeId);
            }
            this.connectionEndpoint.execute(MinimalHttpAsyncClient.this.log.isDebugEnabled() ? new LoggingAsyncClientExchangeHandler(MinimalHttpAsyncClient.this.log, exchangeId, exchangeHandler) : exchangeHandler, context);
        }

        public void releaseAndReuse() {
            if (this.released.compareAndSet(false, true)) {
                MinimalHttpAsyncClient.this.connmgr.release(this.connectionEndpoint, null, TimeValue.NEG_ONE_MILLISECONDS);
            }
        }

        public void releaseAndDiscard() {
            if (this.released.compareAndSet(false, true)) {
                try {
                    this.connectionEndpoint.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                MinimalHttpAsyncClient.this.connmgr.release(this.connectionEndpoint, null, TimeValue.ZERO_MILLISECONDS);
            }
        }
    }
}

