/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.auth.AuthSchemeProvider;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieSpecProvider;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.async.AbstractHttpAsyncClientBase;
import org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import org.apache.hc.client5.http.impl.async.AsyncExecRuntimeImpl;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.BasicAsyncEntityProducer;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncDataProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.support.BasicClientExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;

class InternalHttpAsyncClient
extends AbstractHttpAsyncClientBase {
    private final AsyncClientConnectionManager connmgr;
    private final AsyncExecChainElement execChain;
    private final HttpRoutePlanner routePlanner;
    private final HttpVersionPolicy versionPolicy;
    private final Lookup<CookieSpecProvider> cookieSpecRegistry;
    private final Lookup<AuthSchemeProvider> authSchemeRegistry;
    private final CookieStore cookieStore;
    private final CredentialsProvider credentialsProvider;
    private final RequestConfig defaultConfig;
    private final List<Closeable> closeables;

    InternalHttpAsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, AsyncClientConnectionManager connmgr, HttpRoutePlanner routePlanner, HttpVersionPolicy versionPolicy, Lookup<CookieSpecProvider> cookieSpecRegistry, Lookup<AuthSchemeProvider> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory);
        this.connmgr = connmgr;
        this.execChain = execChain;
        this.routePlanner = routePlanner;
        this.versionPolicy = versionPolicy;
        this.cookieSpecRegistry = cookieSpecRegistry;
        this.authSchemeRegistry = authSchemeRegistry;
        this.cookieStore = cookieStore;
        this.credentialsProvider = credentialsProvider;
        this.defaultConfig = defaultConfig;
        this.closeables = closeables;
    }

    @Override
    public void close() {
        super.close();
        if (this.closeables != null) {
            for (Closeable closeable : this.closeables) {
                try {
                    closeable.close();
                }
                catch (IOException ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void setupContext(HttpClientContext context) {
        if (context.getAttribute("http.authscheme-registry") == null) {
            context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        }
        if (context.getAttribute("http.cookiespec-registry") == null) {
            context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        }
        if (context.getAttribute("http.cookie-store") == null) {
            context.setAttribute("http.cookie-store", this.cookieStore);
        }
        if (context.getAttribute("http.auth.credentials-provider") == null) {
            context.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        }
        if (context.getAttribute("http.request-config") == null) {
            context.setAttribute("http.request-config", this.defaultConfig);
        }
    }

    private void executeChain(final String exchangeId, AsyncExecChainElement execChain, HttpRoute route, HttpRequest request, EntityDetails entityDetails, final AsyncClientExchangeHandler exchangeHandler, HttpClientContext clientContext, final AsyncExecRuntime execRuntime) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(exchangeId + ": preparing request execution");
        }
        if (route.isTunnelled()) {
            throw new HttpException("HTTP tunneling not supported");
        }
        this.setupContext(clientContext);
        AsyncExecChain.Scope scope = new AsyncExecChain.Scope(exchangeId, route, request, clientContext, execRuntime);
        execChain.execute(ExecSupport.copy(request), entityDetails != null ? new BasicAsyncEntityProducer((AsyncDataProducer)exchangeHandler, entityDetails) : null, scope, new AsyncExecCallback(){

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                exchangeHandler.consumeResponse(response, entityDetails);
                return exchangeHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed() {
                if (InternalHttpAsyncClient.this.log.isDebugEnabled()) {
                    InternalHttpAsyncClient.this.log.debug(exchangeId + ": message exchange successfully completed");
                }
                try {
                    exchangeHandler.releaseResources();
                }
                finally {
                    execRuntime.releaseConnection();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Exception cause) {
                if (InternalHttpAsyncClient.this.log.isDebugEnabled()) {
                    InternalHttpAsyncClient.this.log.debug(exchangeId + ": request failed: " + cause.getMessage());
                }
                try {
                    exchangeHandler.failed(cause);
                    exchangeHandler.releaseResources();
                }
                finally {
                    execRuntime.discardConnection();
                }
            }
        });
    }

    @Override
    public <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        this.ensureRunning();
        final BasicFuture future = new BasicFuture(callback);
        try {
            final HttpClientContext clientContext = HttpClientContext.adapt(context);
            RequestConfig requestConfig = null;
            if (requestProducer instanceof Configurable) {
                requestConfig = ((Configurable)requestProducer).getConfig();
            }
            if (requestConfig != null) {
                clientContext.setRequestConfig(requestConfig);
            }
            BasicClientExchangeHandler exchangeHandler = new BasicClientExchangeHandler(requestProducer, responseConsumer, new FutureCallback<T>(){

                public void completed(T result) {
                    future.completed(result);
                }

                public void failed(Exception ex) {
                    future.failed(ex);
                }

                public void cancelled() {
                    future.cancel();
                }
            });
            exchangeHandler.produceRequest(new RequestChannel((AsyncClientExchangeHandler)exchangeHandler){
                final /* synthetic */ AsyncClientExchangeHandler val$exchangeHandler;
                {
                    this.val$exchangeHandler = asyncClientExchangeHandler;
                }

                public void sendRequest(HttpRequest request, EntityDetails entityDetails) throws HttpException, IOException {
                    HttpHost target = InternalHttpAsyncClient.this.routePlanner.determineTargetHost(request, (HttpContext)clientContext);
                    HttpRoute route = InternalHttpAsyncClient.this.routePlanner.determineRoute(target, (HttpContext)clientContext);
                    String exchangeId = "ex-" + Long.toHexString(ExecSupport.getNextExecNumber());
                    AsyncExecRuntimeImpl execRuntime = new AsyncExecRuntimeImpl(InternalHttpAsyncClient.this.log, InternalHttpAsyncClient.this.connmgr, InternalHttpAsyncClient.this.getConnectionInitiator(), InternalHttpAsyncClient.this.versionPolicy);
                    InternalHttpAsyncClient.this.executeChain(exchangeId, InternalHttpAsyncClient.this.execChain, route, request, entityDetails, this.val$exchangeHandler, clientContext, execRuntime);
                }
            });
        }
        catch (IOException | HttpException ex) {
            future.failed((Exception)ex);
        }
        return future;
    }
}

