/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.async.InternalHttpAsyncClient;
import org.apache.hc.client5.http.impl.logging.LogAppendable;
import org.apache.hc.client5.http.impl.logging.LoggingIOSession;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.ConnectionListener;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpRequestWriterFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpResponseParserFactory;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.NHttpMessageParserFactory;
import org.apache.hc.core5.http.nio.NHttpMessageWriterFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.frame.FramePrinter;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiator;
import org.apache.hc.core5.http2.impl.nio.Http2StreamListener;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.util.Args;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HttpAsyncClientEventHandlerFactory
implements IOEventHandlerFactory {
    private final Logger streamLog = LogManager.getLogger(InternalHttpAsyncClient.class);
    private final Logger wireLog = LogManager.getLogger((String)"org.apache.hc.client5.http.wire");
    private final Logger headerLog = LogManager.getLogger((String)"org.apache.hc.client5.http.headers");
    private final Logger frameLog = LogManager.getLogger((String)"org.apache.hc.client5.http2.frame");
    private final Logger framePayloadLog = LogManager.getLogger((String)"org.apache.hc.client5.http2.frame.payload");
    private final Logger flowCtrlLog = LogManager.getLogger((String)"org.apache.hc.client5.http2.flow");
    private final HttpProcessor httpProcessor;
    private final HandlerFactory<AsyncPushConsumer> exchangeHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final H2Config h2Config;
    private final H1Config h1Config;
    private final CharCodingConfig charCodingConfig;
    private final ConnectionReuseStrategy http1ConnectionReuseStrategy;
    private final NHttpMessageParserFactory<HttpResponse> http1ResponseParserFactory;
    private final NHttpMessageWriterFactory<HttpRequest> http1RequestWriterFactory;

    HttpAsyncClientEventHandlerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncPushConsumer> exchangeHandlerFactory, HttpVersionPolicy versionPolicy, H2Config h2Config, H1Config h1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy) {
        this.httpProcessor = (HttpProcessor)Args.notNull((Object)httpProcessor, (String)"HTTP processor");
        this.exchangeHandlerFactory = exchangeHandlerFactory;
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.h2Config = h2Config != null ? h2Config : H2Config.DEFAULT;
        this.h1Config = h1Config != null ? h1Config : H1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.http1ConnectionReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.http1ResponseParserFactory = new DefaultHttpResponseParserFactory(h1Config);
        this.http1RequestWriterFactory = DefaultHttpRequestWriterFactory.INSTANCE;
    }

    public IOEventHandler createHandler(TlsCapableIOSession ioSession, Object attachment) {
        Logger sessionLog = LogManager.getLogger(ioSession.getClass());
        if (sessionLog.isDebugEnabled() || this.streamLog.isDebugEnabled() || this.wireLog.isDebugEnabled() || this.headerLog.isDebugEnabled() || this.frameLog.isDebugEnabled() || this.framePayloadLog.isDebugEnabled() || this.flowCtrlLog.isDebugEnabled()) {
            final String id = ConnPoolSupport.getId(ioSession);
            ConnectionListener connectionListener = new ConnectionListener(){

                public void onConnect(HttpConnection connection) {
                    if (HttpAsyncClientEventHandlerFactory.this.streamLog.isDebugEnabled()) {
                        HttpAsyncClientEventHandlerFactory.this.streamLog.debug(id + ": " + connection + " connected");
                    }
                }

                public void onDisconnect(HttpConnection connection) {
                    if (HttpAsyncClientEventHandlerFactory.this.streamLog.isDebugEnabled()) {
                        HttpAsyncClientEventHandlerFactory.this.streamLog.debug(id + ": " + connection + " disconnected");
                    }
                }

                public void onError(HttpConnection connection, Exception ex) {
                    if (ex instanceof ConnectionClosedException) {
                        return;
                    }
                    HttpAsyncClientEventHandlerFactory.this.streamLog.error(id + ": " + ex.getMessage(), (Throwable)ex);
                }
            };
            ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory = new ClientHttp1StreamDuplexerFactory(this.httpProcessor, this.h1Config, this.charCodingConfig, this.http1ConnectionReuseStrategy, this.http1ResponseParserFactory, this.http1RequestWriterFactory, connectionListener, new Http1StreamListener(){

                public void onRequestHead(HttpConnection connection, HttpRequest request) {
                    if (HttpAsyncClientEventHandlerFactory.this.headerLog.isDebugEnabled()) {
                        HttpAsyncClientEventHandlerFactory.this.headerLog.debug(id + " >> " + new RequestLine(request));
                        Iterator it = request.headerIterator();
                        while (it.hasNext()) {
                            HttpAsyncClientEventHandlerFactory.this.headerLog.debug(id + " >> " + it.next());
                        }
                    }
                }

                public void onResponseHead(HttpConnection connection, HttpResponse response) {
                    if (HttpAsyncClientEventHandlerFactory.this.headerLog.isDebugEnabled()) {
                        HttpAsyncClientEventHandlerFactory.this.headerLog.debug(id + " << " + new StatusLine(response));
                        Iterator it = response.headerIterator();
                        while (it.hasNext()) {
                            HttpAsyncClientEventHandlerFactory.this.headerLog.debug(id + " << " + it.next());
                        }
                    }
                }

                public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                    if (HttpAsyncClientEventHandlerFactory.this.streamLog.isDebugEnabled()) {
                        if (keepAlive) {
                            HttpAsyncClientEventHandlerFactory.this.streamLog.debug(id + " Connection is kept alive");
                        } else {
                            HttpAsyncClientEventHandlerFactory.this.streamLog.debug(id + " Connection is not kept alive");
                        }
                    }
                }
            });
            ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory = new ClientHttp2StreamMultiplexerFactory(this.httpProcessor, this.exchangeHandlerFactory, this.h2Config, this.charCodingConfig, connectionListener, new Http2StreamListener(){
                final FramePrinter framePrinter = new FramePrinter();

                private void logFrameInfo(String prefix, RawFrame frame) {
                    try {
                        LogAppendable logAppendable = new LogAppendable(HttpAsyncClientEventHandlerFactory.this.frameLog, prefix);
                        this.framePrinter.printFrameInfo(frame, (Appendable)logAppendable);
                        logAppendable.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                private void logFramePayload(String prefix, RawFrame frame) {
                    try {
                        LogAppendable logAppendable = new LogAppendable(HttpAsyncClientEventHandlerFactory.this.framePayloadLog, prefix);
                        this.framePrinter.printPayload(frame, (Appendable)logAppendable);
                        logAppendable.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                private void logFlowControl(String prefix, int streamId, int delta, int actualSize) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(prefix).append(" stream ").append(streamId).append(" flow control ").append(delta).append(" -> ").append(actualSize);
                    HttpAsyncClientEventHandlerFactory.this.flowCtrlLog.debug(buffer.toString());
                }

                public void onHeaderInput(HttpConnection connection, int streamId, List<? extends Header> headers) {
                    if (HttpAsyncClientEventHandlerFactory.this.headerLog.isDebugEnabled()) {
                        for (int i = 0; i < headers.size(); ++i) {
                            HttpAsyncClientEventHandlerFactory.this.headerLog.debug(id + " << " + headers.get(i));
                        }
                    }
                }

                public void onHeaderOutput(HttpConnection connection, int streamId, List<? extends Header> headers) {
                    if (HttpAsyncClientEventHandlerFactory.this.headerLog.isDebugEnabled()) {
                        for (int i = 0; i < headers.size(); ++i) {
                            HttpAsyncClientEventHandlerFactory.this.headerLog.debug(id + " >> " + headers.get(i));
                        }
                    }
                }

                public void onFrameInput(HttpConnection connection, int streamId, RawFrame frame) {
                    if (HttpAsyncClientEventHandlerFactory.this.frameLog.isDebugEnabled()) {
                        this.logFrameInfo(id + " <<", frame);
                    }
                    if (HttpAsyncClientEventHandlerFactory.this.framePayloadLog.isDebugEnabled()) {
                        this.logFramePayload(id + " <<", frame);
                    }
                }

                public void onFrameOutput(HttpConnection connection, int streamId, RawFrame frame) {
                    if (HttpAsyncClientEventHandlerFactory.this.frameLog.isDebugEnabled()) {
                        this.logFrameInfo(id + " >>", frame);
                    }
                    if (HttpAsyncClientEventHandlerFactory.this.framePayloadLog.isDebugEnabled()) {
                        this.logFramePayload(id + " >>", frame);
                    }
                }

                public void onInputFlowControl(HttpConnection connection, int streamId, int delta, int actualSize) {
                    if (HttpAsyncClientEventHandlerFactory.this.flowCtrlLog.isDebugEnabled()) {
                        this.logFlowControl(id + " <<", streamId, delta, actualSize);
                    }
                }

                public void onOutputFlowControl(HttpConnection connection, int streamId, int delta, int actualSize) {
                    if (HttpAsyncClientEventHandlerFactory.this.flowCtrlLog.isDebugEnabled()) {
                        this.logFlowControl(id + " >>", streamId, delta, actualSize);
                    }
                }
            });
            LoggingIOSession loggingIOSession = new LoggingIOSession(ioSession, id, sessionLog, this.wireLog);
            return new ClientHttpProtocolNegotiator((TlsCapableIOSession)loggingIOSession, http1StreamHandlerFactory, http2StreamHandlerFactory, attachment instanceof HttpVersionPolicy ? (HttpVersionPolicy)attachment : this.versionPolicy, connectionListener);
        }
        ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory = new ClientHttp1StreamDuplexerFactory(this.httpProcessor, this.h1Config, this.charCodingConfig, this.http1ConnectionReuseStrategy, this.http1ResponseParserFactory, this.http1RequestWriterFactory, null, null);
        ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory = new ClientHttp2StreamMultiplexerFactory(this.httpProcessor, this.exchangeHandlerFactory, this.h2Config, this.charCodingConfig, null, null);
        return new ClientHttpProtocolNegotiator(ioSession, http1StreamHandlerFactory, http2StreamHandlerFactory, attachment instanceof HttpVersionPolicy ? (HttpVersionPolicy)attachment : this.versionPolicy, null);
    }
}

