/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.sync.HttpRequestRetryHandler;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class AsyncRetryExec
implements AsyncExecChainHandler {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final HttpRequestRetryHandler retryHandler;

    public AsyncRetryExec(HttpRequestRetryHandler retryHandler) {
        Args.notNull((Object)retryHandler, (String)"HTTP request retry handler");
        this.retryHandler = retryHandler;
    }

    private void internalExecute(final int execCount, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        chain.proceed(ExecSupport.copy(request), entityProducer, scope, new AsyncExecCallback(){

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            @Override
            public void completed() {
                asyncExecCallback.completed();
            }

            @Override
            public void failed(Exception cause) {
                if (cause instanceof IOException) {
                    HttpRoute route = scope.route;
                    HttpClientContext clientContext = scope.clientContext;
                    if (AsyncRetryExec.this.retryHandler.retryRequest(request, (IOException)cause, execCount, (HttpContext)clientContext)) {
                        if (AsyncRetryExec.this.log.isInfoEnabled()) {
                            AsyncRetryExec.this.log.info("I/O exception (" + cause.getClass().getName() + ") caught when processing request to " + route + ": " + cause.getMessage());
                        }
                        if (AsyncRetryExec.this.log.isDebugEnabled()) {
                            AsyncRetryExec.this.log.debug(cause.getMessage(), (Throwable)cause);
                        }
                        if (AsyncRetryExec.this.log.isInfoEnabled()) {
                            AsyncRetryExec.this.log.info("Retrying request to " + route);
                        }
                        try {
                            scope.execRuntime.discardConnection();
                            AsyncRetryExec.this.internalExecute(execCount + 1, request, entityProducer, scope, chain, asyncExecCallback);
                            return;
                        }
                        catch (IOException | HttpException ex) {
                            AsyncRetryExec.this.log.error(ex.getMessage(), ex);
                        }
                    }
                }
                asyncExecCallback.failed(cause);
            }
        });
    }

    @Override
    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        this.internalExecute(1, request, entityProducer, scope, chain, asyncExecCallback);
    }
}

