/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.core5.util.Args;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InMemoryDnsResolver
implements DnsResolver {
    private final Logger log = LogManager.getLogger(InMemoryDnsResolver.class);
    private final Map<String, InetAddress[]> dnsMap = new ConcurrentHashMap<String, InetAddress[]>();

    public void add(String host, InetAddress ... ips) {
        Args.notNull((Object)host, (String)"Host name");
        Args.notNull((Object)ips, (String)"Array of IP addresses");
        this.dnsMap.put(host, ips);
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        Object[] resolvedAddresses = this.dnsMap.get(host);
        if (this.log.isInfoEnabled()) {
            this.log.info("Resolving " + host + " to " + Arrays.deepToString(resolvedAddresses));
        }
        if (resolvedAddresses == null) {
            throw new UnknownHostException(host + " cannot be resolved");
        }
        return resolvedAddresses;
    }

    @Override
    public String resolveCanonicalHostname(String host) throws UnknownHostException {
        InetAddress[] resolvedAddresses = this.resolve(host);
        if (resolvedAddresses.length > 0) {
            return resolvedAddresses[0].getCanonicalHostName();
        }
        return host;
    }
}

