/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.net.URI;
import org.apache.hc.client5.http.StandardMethods;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.HttpRequestWrapper;
import org.apache.hc.core5.util.Args;

public final class SimpleHttpRequest
extends HttpRequestWrapper {
    private final String body;
    private final ContentType contentType;

    public static SimpleHttpRequest get(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.GET, requestUri, null, null);
    }

    public static SimpleHttpRequest get(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.GET, URI.create(requestUri), null, null);
    }

    public static SimpleHttpRequest get(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.GET, host, path, null, null);
    }

    public static SimpleHttpRequest head(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.HEAD, requestUri, null, null);
    }

    public static SimpleHttpRequest head(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.HEAD, URI.create(requestUri), null, null);
    }

    public static SimpleHttpRequest head(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.HEAD, host, path, null, null);
    }

    public static SimpleHttpRequest post(URI requestUri, String body, ContentType contentType) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.POST, requestUri, body, contentType);
    }

    public static SimpleHttpRequest post(String requestUri, String body, ContentType contentType) {
        return new SimpleHttpRequest(StandardMethods.POST, URI.create(requestUri), body, contentType);
    }

    public static SimpleHttpRequest post(HttpHost host, String path, String body, ContentType contentType) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.POST, host, path, body, contentType);
    }

    public static SimpleHttpRequest PUT(URI requestUri, String body, ContentType contentType) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.PUT, requestUri, body, contentType);
    }

    public static SimpleHttpRequest put(String requestUri, String body, ContentType contentType) {
        return new SimpleHttpRequest(StandardMethods.PUT, URI.create(requestUri), body, contentType);
    }

    public static SimpleHttpRequest put(HttpHost host, String path, String body, ContentType contentType) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.PUT, host, path, body, contentType);
    }

    public static SimpleHttpRequest delete(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.DELETE, requestUri, null, null);
    }

    public static SimpleHttpRequest delete(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.DELETE, URI.create(requestUri), null, null);
    }

    public static SimpleHttpRequest delete(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.DELETE, host, path, null, null);
    }

    public static SimpleHttpRequest trace(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.TRACE, requestUri, null, null);
    }

    public static SimpleHttpRequest trace(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.TRACE, URI.create(requestUri), null, null);
    }

    public static SimpleHttpRequest trace(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.TRACE, host, path, null, null);
    }

    public static SimpleHttpRequest options(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.OPTIONS, requestUri, null, null);
    }

    public static SimpleHttpRequest options(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.OPTIONS, URI.create(requestUri), null, null);
    }

    public static SimpleHttpRequest options(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.OPTIONS, host, path, null, null);
    }

    public static SimpleHttpRequest patch(URI requestUri, String body, ContentType contentType) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.PATCH, requestUri, body, contentType);
    }

    public static SimpleHttpRequest patch(String requestUri, String body, ContentType contentType) {
        return new SimpleHttpRequest(StandardMethods.PATCH, URI.create(requestUri), body, contentType);
    }

    public static SimpleHttpRequest patch(HttpHost host, String path, String body, ContentType contentType) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.PATCH, host, path, body, contentType);
    }

    public SimpleHttpRequest(HttpRequest head, String body, ContentType contentType) {
        super(head);
        this.body = body;
        this.contentType = contentType;
    }

    public SimpleHttpRequest(String method, HttpHost host, String path, String body, ContentType contentType) {
        super((HttpRequest)new BasicHttpRequest(method, host, path));
        this.body = body;
        this.contentType = contentType;
    }

    SimpleHttpRequest(StandardMethods method, HttpHost host, String path, String body, ContentType contentType) {
        this(method.name(), host, path, body, contentType);
    }

    public SimpleHttpRequest(String method, URI requestUri, String body, ContentType contentType) {
        super((HttpRequest)new BasicHttpRequest(method, requestUri));
        this.body = body;
        this.contentType = contentType;
    }

    SimpleHttpRequest(StandardMethods method, URI requestUri, String body, ContentType contentType) {
        this(method.name(), requestUri, body, contentType);
    }

    public String getBody() {
        return this.body;
    }

    public ContentType getContentType() {
        return this.contentType;
    }
}

