/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.ConnectionListener;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiator;
import org.apache.hc.core5.http2.impl.nio.ServerHttp2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ServerHttp2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ServerHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.ssl.ApplicationProtocols;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServerHttpProtocolNegotiator
implements HttpConnectionEventHandler {
    static final byte[] PREFACE = ClientHttpProtocolNegotiator.PREFACE;
    private final TlsCapableIOSession ioSession;
    private final ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ServerHttp2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final ConnectionListener connectionListener;
    private final ByteBuffer bytebuf;
    private volatile boolean expectValidH2Preface;

    public ServerHttpProtocolNegotiator(TlsCapableIOSession ioSession, ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory, ServerHttp2StreamMultiplexerFactory http2StreamHandlerFactory, HttpVersionPolicy versionPolicy, ConnectionListener connectionListener) {
        this.ioSession = (TlsCapableIOSession)Args.notNull((Object)ioSession, (String)"I/O session");
        this.http1StreamHandlerFactory = (ServerHttp1StreamDuplexerFactory)Args.notNull((Object)http1StreamHandlerFactory, (String)"HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = (ServerHttp2StreamMultiplexerFactory)Args.notNull((Object)http2StreamHandlerFactory, (String)"HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.connectionListener = connectionListener;
        this.bytebuf = ByteBuffer.allocate(1024);
    }

    public void connected(IOSession session) {
        try {
            TlsDetails tlsDetails = this.ioSession.getTlsDetails();
            switch (this.versionPolicy) {
                case NEGOTIATE: {
                    if (tlsDetails == null || !ApplicationProtocols.HTTP_2.id.equals(tlsDetails.getApplicationProtocol())) break;
                    this.expectValidH2Preface = true;
                    break;
                }
                case FORCE_HTTP_1: {
                    ServerHttp1StreamDuplexer http1StreamHandler = this.http1StreamHandlerFactory.create(tlsDetails != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id, this.ioSession);
                    session.setHandler((IOEventHandler)new ServerHttp1IOEventHandler(http1StreamHandler));
                    http1StreamHandler.onConnect(null);
                }
            }
        }
        catch (Exception ex) {
            this.exception(session, ex);
        }
    }

    public void inputReady(IOSession session) {
        try {
            if (this.bytebuf.position() < PREFACE.length) {
                session.channel().read(this.bytebuf);
            }
            if (this.bytebuf.position() >= PREFACE.length) {
                this.bytebuf.flip();
                boolean validH2Preface = true;
                for (int i = 0; i < PREFACE.length; ++i) {
                    if (this.bytebuf.get() == PREFACE[i]) continue;
                    if (this.expectValidH2Preface) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected HTTP/2 preface");
                    }
                    validH2Preface = false;
                }
                if (validH2Preface) {
                    ServerHttp2StreamMultiplexer http2StreamHandler = this.http2StreamHandlerFactory.create(this.ioSession);
                    session.setHandler((IOEventHandler)new ServerHttp2IOEventHandler(http2StreamHandler));
                    http2StreamHandler.onConnect(this.bytebuf.hasRemaining() ? this.bytebuf : null);
                    http2StreamHandler.onInput();
                } else {
                    TlsDetails tlsDetails = this.ioSession.getTlsDetails();
                    ServerHttp1StreamDuplexer http1StreamHandler = this.http1StreamHandlerFactory.create(tlsDetails != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id, this.ioSession);
                    session.setHandler((IOEventHandler)new ServerHttp1IOEventHandler(http1StreamHandler));
                    this.bytebuf.rewind();
                    http1StreamHandler.onConnect(this.bytebuf);
                    http1StreamHandler.onInput();
                }
            }
        }
        catch (Exception ex) {
            this.exception(session, ex);
        }
    }

    public void outputReady(IOSession session) {
    }

    public void timeout(IOSession session) {
        this.exception(session, new SocketTimeoutException());
    }

    public void exception(IOSession session, Exception cause) {
        session.shutdown(ShutdownType.IMMEDIATE);
        if (this.connectionListener != null) {
            this.connectionListener.onError((HttpConnection)this, cause);
        }
    }

    public void disconnected(IOSession session) {
        if (this.connectionListener != null) {
            this.connectionListener.onDisconnect((HttpConnection)this);
        }
    }

    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    public EndpointDetails getEndpointDetails() {
        return null;
    }

    public void setSocketTimeout(int timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    public int getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    public ProtocolVersion getProtocolVersion() {
        return null;
    }

    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    public boolean isOpen() {
        return !this.ioSession.isClosed();
    }

    public void close() throws IOException {
        this.ioSession.close();
    }

    public void shutdown(ShutdownType shutdownType) {
        this.ioSession.shutdown(shutdownType);
    }
}

