/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.ConnectionListener;
import org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.command.ExecutionCommand;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.ssl.ApplicationProtocols;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ClientHttpProtocolNegotiator
implements HttpConnectionEventHandler {
    static final byte[] PREFACE = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};
    private final TlsCapableIOSession ioSession;
    private final ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final ConnectionListener connectionListener;
    private volatile ByteBuffer preface;

    public ClientHttpProtocolNegotiator(TlsCapableIOSession ioSession, ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory, ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory, HttpVersionPolicy versionPolicy, ConnectionListener connectionListener) {
        this.ioSession = (TlsCapableIOSession)Args.notNull((Object)ioSession, (String)"I/O session");
        this.http1StreamHandlerFactory = (ClientHttp1StreamDuplexerFactory)Args.notNull((Object)http1StreamHandlerFactory, (String)"HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = (ClientHttp2StreamMultiplexerFactory)Args.notNull((Object)http2StreamHandlerFactory, (String)"HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.connectionListener = connectionListener;
    }

    public void connected(IOSession session) {
        try {
            switch (this.versionPolicy) {
                case NEGOTIATE: {
                    TlsDetails tlsDetails = this.ioSession.getTlsDetails();
                    if (tlsDetails == null || !ApplicationProtocols.HTTP_2.id.equals(tlsDetails.getApplicationProtocol())) break;
                    this.preface = ByteBuffer.wrap(PREFACE);
                    break;
                }
                case FORCE_HTTP_2: {
                    this.preface = ByteBuffer.wrap(PREFACE);
                }
            }
            if (this.preface == null) {
                ClientHttp1StreamDuplexer http1StreamHandler = this.http1StreamHandlerFactory.create(this.ioSession);
                session.setHandler((IOEventHandler)new ClientHttp1IOEventHandler(http1StreamHandler));
                http1StreamHandler.onConnect(null);
            } else {
                this.writePreface(session);
            }
        }
        catch (Exception ex) {
            session.shutdown(ShutdownType.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    private void writePreface(IOSession session) throws IOException {
        if (this.preface.hasRemaining()) {
            ByteChannel channel = session.channel();
            channel.write(this.preface);
        }
        if (!this.preface.hasRemaining()) {
            ClientHttp2StreamMultiplexer streamMultiplexer = this.http2StreamHandlerFactory.create(this.ioSession);
            ClientHttp2IOEventHandler newHandler = new ClientHttp2IOEventHandler(streamMultiplexer);
            newHandler.connected(session);
            session.setHandler((IOEventHandler)newHandler);
        }
    }

    public void inputReady(IOSession session) {
        this.outputReady(session);
    }

    public void outputReady(IOSession session) {
        try {
            if (this.preface != null) {
                this.writePreface(session);
            } else {
                session.shutdown(ShutdownType.IMMEDIATE);
            }
        }
        catch (IOException ex) {
            session.shutdown(ShutdownType.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    public void timeout(IOSession session) {
        this.exception(session, new SocketTimeoutException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(IOSession session, Exception cause) {
        if (this.connectionListener != null) {
            this.connectionListener.onError((HttpConnection)this, (Exception)new SocketTimeoutException());
        }
        try {
            Command command;
            while ((command = this.ioSession.getCommand()) != null) {
                if (command instanceof ExecutionCommand) {
                    ExecutionCommand executionCommand = (ExecutionCommand)command;
                    AsyncClientExchangeHandler exchangeHandler = executionCommand.getExchangeHandler();
                    exchangeHandler.failed(cause);
                    exchangeHandler.releaseResources();
                    continue;
                }
                command.cancel();
            }
        }
        finally {
            session.shutdown(ShutdownType.IMMEDIATE);
        }
    }

    public void disconnected(IOSession session) {
        Command command;
        if (this.connectionListener != null) {
            this.connectionListener.onDisconnect((HttpConnection)this);
        }
        while ((command = this.ioSession.getCommand()) != null) {
            if (command instanceof ExecutionCommand) {
                ExecutionCommand executionCommand = (ExecutionCommand)command;
                AsyncClientExchangeHandler exchangeHandler = executionCommand.getExchangeHandler();
                exchangeHandler.failed((Exception)new ConnectionClosedException("Connection closed"));
                exchangeHandler.releaseResources();
                continue;
            }
            command.cancel();
        }
    }

    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    public EndpointDetails getEndpointDetails() {
        return null;
    }

    public void setSocketTimeout(int timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    public int getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    public ProtocolVersion getProtocolVersion() {
        return null;
    }

    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    public boolean isOpen() {
        return !this.ioSession.isClosed();
    }

    public void close() throws IOException {
        this.ioSession.close();
    }

    public void shutdown(ShutdownType shutdownType) {
        this.ioSession.shutdown(shutdownType);
    }
}

