/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http2.impl.nio.AbstractHttp2StreamMultiplexer;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;

class AbstractHttp2IOEventHandler
implements HttpConnectionEventHandler {
    private final AbstractHttp2StreamMultiplexer streamMultiplexer;

    AbstractHttp2IOEventHandler(AbstractHttp2StreamMultiplexer streamMultiplexer) {
        this.streamMultiplexer = (AbstractHttp2StreamMultiplexer)Args.notNull((Object)streamMultiplexer, (String)"Stream multiplexer");
    }

    public void connected(IOSession session) {
        try {
            this.streamMultiplexer.onConnect(null);
        }
        catch (Exception ex) {
            this.streamMultiplexer.onException(ex);
        }
    }

    public void inputReady(IOSession session) {
        try {
            this.streamMultiplexer.onInput();
        }
        catch (Exception ex) {
            this.streamMultiplexer.onException(ex);
        }
    }

    public void outputReady(IOSession session) {
        try {
            this.streamMultiplexer.onOutput();
        }
        catch (Exception ex) {
            this.streamMultiplexer.onException(ex);
        }
    }

    public void timeout(IOSession session) {
        try {
            this.streamMultiplexer.onTimeout();
        }
        catch (Exception ex) {
            this.streamMultiplexer.onException(ex);
        }
    }

    public void exception(IOSession session, Exception cause) {
        this.streamMultiplexer.onException(cause);
    }

    public void disconnected(IOSession session) {
        this.streamMultiplexer.onDisconnect();
    }

    public void close() throws IOException {
        this.streamMultiplexer.close();
    }

    public void shutdown(ShutdownType shutdownType) {
        this.streamMultiplexer.shutdown(shutdownType);
    }

    public boolean isOpen() {
        return this.streamMultiplexer.isOpen();
    }

    public void setSocketTimeout(int timeout) {
        this.streamMultiplexer.setSocketTimeout(timeout);
    }

    public SSLSession getSSLSession() {
        return this.streamMultiplexer.getSSLSession();
    }

    public EndpointDetails getEndpointDetails() {
        return this.streamMultiplexer.getEndpointDetails();
    }

    public int getSocketTimeout() {
        return this.streamMultiplexer.getSocketTimeout();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.streamMultiplexer.getProtocolVersion();
    }

    public SocketAddress getRemoteAddress() {
        return this.streamMultiplexer.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.streamMultiplexer.getLocalAddress();
    }

    public String toString() {
        return this.streamMultiplexer.toString();
    }
}

