/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.config;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2Config {
    public static final H2Config DEFAULT = new Builder().build();
    private final int headerTableSize;
    private final boolean pushEnabled;
    private final int maxConcurrentStreams;
    private final int initialWindowSize;
    private final int maxFrameSize;
    private final int maxHeaderListSize;
    private final boolean settingAckNeeded;

    H2Config(int headerTableSize, boolean pushEnabled, int maxConcurrentStreams, int initialWindowSize, int maxFrameSize, int maxHeaderListSize, boolean settingAckNeeded) {
        this.headerTableSize = headerTableSize;
        this.pushEnabled = pushEnabled;
        this.maxConcurrentStreams = maxConcurrentStreams;
        this.initialWindowSize = initialWindowSize;
        this.maxFrameSize = maxFrameSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.settingAckNeeded = settingAckNeeded;
    }

    public int getHeaderTableSize() {
        return this.headerTableSize;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public boolean isSettingAckNeeded() {
        return this.settingAckNeeded;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[headerTableSize=").append(this.headerTableSize).append(", pushEnabled=").append(this.pushEnabled).append(", maxConcurrentStreams=").append(this.maxConcurrentStreams).append(", initialWindowSize=").append(this.initialWindowSize).append(", maxFrameSize=").append(this.maxFrameSize).append(", maxHeaderListSize=").append(this.maxHeaderListSize).append(", settingAckNeeded=").append(this.settingAckNeeded).append("]");
        return builder.toString();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(H2Config config) {
        Args.notNull((Object)config, (String)"Connection config");
        return new Builder().setHeaderTableSize(config.getHeaderTableSize()).setPushEnabled(config.isPushEnabled()).setMaxConcurrentStreams(config.getMaxConcurrentStreams()).setInitialWindowSize(config.getInitialWindowSize()).setMaxFrameSize(config.getMaxFrameSize()).setMaxHeaderListSize(config.getMaxHeaderListSize()).setSettingAckNeeded(config.isSettingAckNeeded());
    }

    public static class Builder {
        private int headerTableSize = 8192;
        private boolean pushEnabled = false;
        private int maxConcurrentStreams = 100;
        private int initialWindowSize = 65535;
        private int maxFrameSize = 65536;
        private int maxHeaderListSize = 0xFFFFFF;
        private boolean settingAckNeeded = true;

        Builder() {
        }

        public Builder setHeaderTableSize(int headerTableSize) {
            Args.notNegative((int)headerTableSize, (String)"Header table size");
            this.headerTableSize = headerTableSize;
            return this;
        }

        public Builder setPushEnabled(boolean pushEnabled) {
            this.pushEnabled = pushEnabled;
            return this;
        }

        public Builder setMaxConcurrentStreams(int maxConcurrentStreams) {
            Args.positive((int)maxConcurrentStreams, (String)"Max concurrent streams");
            this.maxConcurrentStreams = maxConcurrentStreams;
            return this;
        }

        public Builder setInitialWindowSize(int initialWindowSize) {
            Args.positive((int)initialWindowSize, (String)"Initial window size");
            this.initialWindowSize = initialWindowSize;
            return this;
        }

        public Builder setMaxFrameSize(int maxFrameSize) {
            this.maxFrameSize = Args.checkRange((int)maxFrameSize, (int)16384, (int)0xFFFFFF, (String)"Invalid max frame size");
            return this;
        }

        public Builder setMaxHeaderListSize(int maxHeaderListSize) {
            Args.positive((int)maxHeaderListSize, (String)"Max header list size");
            this.maxHeaderListSize = maxHeaderListSize;
            return this;
        }

        public Builder setSettingAckNeeded(boolean settingAckNeeded) {
            this.settingAckNeeded = settingAckNeeded;
            return this;
        }

        public H2Config build() {
            return new H2Config(this.headerTableSize, this.pushEnabled, this.maxConcurrentStreams, this.initialWindowSize, this.maxFrameSize, this.maxHeaderListSize, this.settingAckNeeded);
        }
    }
}

