/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.search.BaseMetadataSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.server.HopServer;

@SearchableAnalyserPlugin(id="HopServerSearchableAnalyser", name="Search in hop server metadata")
public class HopServerSearchableAnalyser
extends BaseMetadataSearchableAnalyser<HopServer>
implements ISearchableAnalyser<HopServer> {
    @Override
    public Class<HopServer> getSearchableClass() {
        return HopServer.class;
    }

    public List<ISearchResult> search(ISearchable<HopServer> searchable, ISearchQuery searchQuery) {
        HopServer hopServer = (HopServer)searchable.getSearchableObject();
        String component = this.getMetadataComponent();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "Hop server name", hopServer.getName(), component);
        this.matchProperty(searchable, results, searchQuery, "Hop server hostname", hopServer.getHostname(), component);
        this.matchProperty(searchable, results, searchQuery, "Hop server port", hopServer.getPort(), component);
        this.matchProperty(searchable, results, searchQuery, "Hop server username", hopServer.getUsername(), component);
        this.matchProperty(searchable, results, searchQuery, "Hop server webapp", hopServer.getWebAppName(), component);
        return results;
    }
}

