/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.MinimalFileLinkMetadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class PreviewResult {
    protected final FileMetadata fileMetadata;
    protected final MinimalFileLinkMetadata linkMetadata;

    public PreviewResult(FileMetadata fileMetadata, MinimalFileLinkMetadata linkMetadata) {
        this.fileMetadata = fileMetadata;
        this.linkMetadata = linkMetadata;
    }

    public PreviewResult() {
        this(null, null);
    }

    public FileMetadata getFileMetadata() {
        return this.fileMetadata;
    }

    public MinimalFileLinkMetadata getLinkMetadata() {
        return this.linkMetadata;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileMetadata, this.linkMetadata});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PreviewResult other = (PreviewResult)obj;
            return (this.fileMetadata == other.fileMetadata || this.fileMetadata != null && this.fileMetadata.equals(other.fileMetadata)) && (this.linkMetadata == other.linkMetadata || this.linkMetadata != null && this.linkMetadata.equals(other.linkMetadata));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PreviewResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PreviewResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.fileMetadata != null) {
                g.writeFieldName("file_metadata");
                StoneSerializers.nullableStruct(FileMetadata.Serializer.INSTANCE).serialize(value.fileMetadata, g);
            }
            if (value.linkMetadata != null) {
                g.writeFieldName("link_metadata");
                StoneSerializers.nullableStruct(MinimalFileLinkMetadata.Serializer.INSTANCE).serialize(value.linkMetadata, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PreviewResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            MinimalFileLinkMetadata f_linkMetadata;
            FileMetadata f_fileMetadata;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_fileMetadata = null;
                f_linkMetadata = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file_metadata".equals(field)) {
                        f_fileMetadata = StoneSerializers.nullableStruct(FileMetadata.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("link_metadata".equals(field)) {
                        f_linkMetadata = StoneSerializers.nullableStruct(MinimalFileLinkMetadata.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PreviewResult value = new PreviewResult(f_fileMetadata, f_linkMetadata);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected FileMetadata fileMetadata = null;
        protected MinimalFileLinkMetadata linkMetadata = null;

        protected Builder() {
        }

        public Builder withFileMetadata(FileMetadata fileMetadata) {
            this.fileMetadata = fileMetadata;
            return this;
        }

        public Builder withLinkMetadata(MinimalFileLinkMetadata linkMetadata) {
            this.linkMetadata = linkMetadata;
            return this;
        }

        public PreviewResult build() {
            return new PreviewResult(this.fileMetadata, this.linkMetadata);
        }
    }
}

