/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.synthetic.SyntheticOptions;
import org.apache.beam.sdk.io.synthetic.delay.SyntheticDelay;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.LoadingCache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.RateLimiter;
import org.joda.time.Duration;

public class SyntheticStep
extends DoFn<KV<byte[], byte[]>, KV<byte[], byte[]>> {
    private final Options options;
    private final KV<Long, Long> idAndThroughput;
    private final Counter throttlingCounter = Metrics.counter((String)"dataflow-throttling-metrics", (String)"throttling-msecs");
    private static LoadingCache<KV<Long, Long>, RateLimiter> rateLimiterCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<KV<Long, Long>, RateLimiter>(){

        public RateLimiter load(KV<Long, Long> pair) {
            return RateLimiter.create((double)((Long)pair.getValue()).doubleValue());
        }
    });

    public SyntheticStep(Options options) {
        options.validate();
        this.options = options;
        Random rand = new Random();
        this.idAndThroughput = KV.of((Object)rand.nextLong(), (Object)options.maxWorkerThroughput);
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        int i;
        byte[] key = (byte[])((KV)c.element()).getKey();
        byte[] val = (byte[])((KV)c.element()).getValue();
        int decimalPart = (int)this.options.outputRecordsPerInputRecord;
        double fractionalPart = this.options.outputRecordsPerInputRecord - (double)decimalPart;
        long hashCodeOfVal = this.options.hashFunction().hashBytes(val).asLong();
        Random random = new Random(hashCodeOfVal);
        for (i = 0; i < decimalPart; ++i) {
            c.output(this.outputElement(key, val, hashCodeOfVal, i, random));
        }
        if (random.nextDouble() < fractionalPart) {
            c.output(this.outputElement(key, val, hashCodeOfVal, i, random));
        }
    }

    private KV<byte[], byte[]> outputElement(byte[] inputKey, byte[] inputValue, long inputValueHashcode, int index, Random random) {
        long seed = this.options.hashFunction().hashLong(inputValueHashcode + (long)index).asLong();
        Duration delay = Duration.millis((long)this.options.nextDelay(seed));
        long millisecondsSpentSleeping = 0L;
        while (delay.getMillis() > 0L) {
            millisecondsSpentSleeping += SyntheticDelay.delay(delay, this.options.cpuUtilizationInMixedDelay, this.options.delayType, random);
            if (this.isWithinThroughputLimit()) break;
            delay = Duration.millis((long)1L);
        }
        this.reportThrottlingTimeMetrics(millisecondsSpentSleeping);
        if (this.options.preservesInputKeyDistribution) {
            byte[] newValue = new byte[inputValue.length];
            random.nextBytes(newValue);
            return KV.of((Object)inputKey, (Object)newValue);
        }
        return this.options.genKvPair(seed);
    }

    private void reportThrottlingTimeMetrics(long milliseconds) {
        if (this.options.reportThrottlingMicros && milliseconds > 0L) {
            this.throttlingCounter.inc(TimeUnit.MILLISECONDS.toMicros(milliseconds));
        }
    }

    private boolean isWithinThroughputLimit() {
        return this.options.maxWorkerThroughput < 0L || ((RateLimiter)rateLimiterCache.getUnchecked(this.idAndThroughput)).tryAcquire();
    }

    @DoFn.StartBundle
    public void startBundle() throws Exception {
        if (this.options.perBundleDelay > 0L) {
            SyntheticDelay.delay(Duration.millis((long)this.options.perBundleDelay), this.options.cpuUtilizationInMixedDelay, this.options.perBundleDelayType, new Random());
        }
    }

    public static class Options
    extends SyntheticOptions {
        @JsonProperty
        public double outputRecordsPerInputRecord;
        @JsonProperty
        public boolean preservesInputKeyDistribution;
        @JsonProperty
        public long maxWorkerThroughput = -1L;
        @JsonProperty
        public long perBundleDelay = 0L;
        @JsonProperty
        public SyntheticOptions.DelayType perBundleDelayType = SyntheticOptions.DelayType.SLEEP;
        @JsonProperty
        public boolean reportThrottlingMicros;

        @Override
        public void validate() {
            super.validate();
            Preconditions.checkArgument((this.outputRecordsPerInputRecord >= 0.0 ? 1 : 0) != 0, (String)"outputRecordsPerInputRecord should be a non-negative number, but found %s.", (Object)this.outputRecordsPerInputRecord);
            Preconditions.checkArgument((this.perBundleDelay >= 0L ? 1 : 0) != 0, (String)"perBundleDelay should be a non-negative number, but found %s.", (long)this.perBundleDelay);
            if (this.maxWorkerThroughput >= 0L) {
                Preconditions.checkArgument((this.perBundleDelay == 0L ? 1 : 0) != 0, (Object)"maxWorkerThroughput and perBundleDelay cannot be enabled simultaneously.");
            }
        }
    }
}

