/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.commons.math3.stat.StatUtils;

public class BundleSplitter
implements Serializable {
    private SyntheticSourceOptions options;

    public BundleSplitter(SyntheticSourceOptions options) {
        this.options = options;
    }

    List<OffsetRange> getBundleSizes(int desiredNumBundles, long start, long end) {
        ArrayList<OffsetRange> result = new ArrayList<OffsetRange>();
        double[] relativeSizes = this.getRelativeBundleSizes(desiredNumBundles);
        double s = StatUtils.sum((double[])relativeSizes);
        long startOffset = start;
        double sizeSoFar = 0.0;
        for (int i = 0; i < relativeSizes.length; ++i) {
            long endOffset;
            long l = endOffset = i == relativeSizes.length - 1 ? end : (long)((double)start + (sizeSoFar += relativeSizes[i]) * (double)(end - start) / s);
            if (startOffset != endOffset) {
                result.add(new OffsetRange(startOffset, endOffset));
            }
            startOffset = endOffset;
        }
        return result;
    }

    private double[] getRelativeBundleSizes(int desiredNumBundles) {
        double[] relativeSizes = new double[desiredNumBundles];
        for (int i = 0; i < relativeSizes.length; ++i) {
            relativeSizes[i] = this.options.bundleSizeDistribution.sample(this.options.hashFunction().hashInt(i).asLong());
        }
        return relativeSizes;
    }
}

