/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;

@Experimental(value=Experimental.Kind.METRICS)
public class SourceMetrics {
    private static final String SOURCE_NAMESPACE = "source";
    private static final String SOURCE_SPLITS_NAMESPACE = "source.splits";
    private static final String SEPARATOR = ".";
    private static final String ELEMENTS_READ = "elements_read";
    private static final String BYTES_READ = "bytes_read";
    private static final String BACKLOG_BYTES = "backlog_bytes";
    private static final String BACKLOG_ELEMENTS = "backlog_elements";
    private static final Counter ELEMENTS_READ_COUNTER = Metrics.counter("source", "elements_read");
    private static final Counter BYTES_READ_COUNTER = Metrics.counter("source", "bytes_read");
    private static final Gauge BACKLOG_BYTES_GAUGE = Metrics.gauge("source", "backlog_bytes");
    private static final Gauge BACKLOG_ELEMENTS_GAUGE = Metrics.gauge("source", "backlog_elements");

    public static Counter elementsRead() {
        return ELEMENTS_READ_COUNTER;
    }

    public static Counter elementsReadBySplit(String splitId) {
        return Metrics.counter(SOURCE_SPLITS_NAMESPACE, SourceMetrics.renderName(splitId, ELEMENTS_READ));
    }

    public static Counter bytesRead() {
        return BYTES_READ_COUNTER;
    }

    public static Counter bytesReadBySplit(String splitId) {
        return Metrics.counter(SOURCE_SPLITS_NAMESPACE, SourceMetrics.renderName(splitId, BYTES_READ));
    }

    public static Gauge backlogBytes() {
        return BACKLOG_BYTES_GAUGE;
    }

    public static Gauge backlogBytesOfSplit(String splitId) {
        return Metrics.gauge(SOURCE_SPLITS_NAMESPACE, SourceMetrics.renderName(splitId, BACKLOG_BYTES));
    }

    public static Gauge backlogElements() {
        return BACKLOG_ELEMENTS_GAUGE;
    }

    public static Gauge backlogElementsOfSplit(String splitId) {
        return Metrics.gauge(SOURCE_SPLITS_NAMESPACE, SourceMetrics.renderName(splitId, BACKLOG_ELEMENTS));
    }

    private static String renderName(String ... nameParts) {
        return Joiner.on((String)SEPARATOR).join((Object[])nameParts);
    }
}

