/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiElements;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.ITypeFilename;
import org.apache.hop.core.gui.plugin.ITypeMetadata;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GuiCompositeWidgets {
    private IVariables variables;
    private Map<String, Control> labelsMap;
    private Map<String, Control> widgetsMap;
    private int nrItems;
    private IGuiPluginCompositeWidgetsListener compositeWidgetsListener;

    public GuiCompositeWidgets(IVariables variables) {
        this(variables, 0);
    }

    @Deprecated(since="2.0")
    public GuiCompositeWidgets(IVariables variables, int maxNrItems) {
        this.variables = variables;
        this.labelsMap = new HashMap<String, Control>();
        this.widgetsMap = new HashMap<String, Control>();
        this.compositeWidgetsListener = null;
    }

    public void createCompositeWidgets(Object sourceData, String parentKey, Composite parent, String parentGuiElementId, Control lastControl) {
        String key;
        GuiRegistry registry = GuiRegistry.getInstance();
        GuiElements guiElements = registry.findGuiElements(key = StringUtils.isEmpty((String)parentKey) ? sourceData.getClass().getName() : parentKey, parentGuiElementId);
        if (guiElements == null) {
            System.err.println("Create widgets: no GUI elements found for parent: " + key + ", parent ID: " + parentGuiElementId);
            return;
        }
        this.addCompositeWidgets(sourceData, parent, guiElements, lastControl);
        if (this.compositeWidgetsListener != null) {
            this.compositeWidgetsListener.widgetsCreated(this);
        }
        parent.layout(true, true);
    }

    private Control addCompositeWidgets(Object sourceObject, Composite parent, GuiElements guiElements, Control lastControl) {
        if (guiElements.isIgnored()) {
            return lastControl;
        }
        int extraVerticalMargin = 0;
        if (lastControl instanceof Button) {
            extraVerticalMargin = (int)(3.0 * PropsUi.getInstance().getZoomFactor());
        }
        PropsUi props = PropsUi.getInstance();
        Label label = null;
        Control control = null;
        if (guiElements.getId() != null) {
            GuiElementType elementType = guiElements.getType();
            if (StringUtils.isNotEmpty((String)guiElements.getLabel()) && elementType != GuiElementType.METADATA && elementType != GuiElementType.BUTTON && elementType != GuiElementType.LINK) {
                label = new Label(parent, 131076);
                PropsUi.setLook((Widget)label);
                label.setText(Const.NVL((String)guiElements.getLabel(), (String)""));
                if (StringUtils.isNotEmpty((String)guiElements.getToolTip())) {
                    label.setToolTipText(guiElements.getToolTip());
                }
                FormData fdLabel = new FormData();
                fdLabel.left = new FormAttachment(0, 0);
                fdLabel.top = lastControl == null ? new FormAttachment(0, props.getMargin()) : new FormAttachment(lastControl, props.getMargin() + extraVerticalMargin);
                fdLabel.right = new FormAttachment(props.getMiddlePct(), 0);
                label.setLayoutData((Object)fdLabel);
                this.labelsMap.put(guiElements.getId(), (Control)label);
            }
            switch (elementType) {
                case TEXT: 
                case FILENAME: 
                case FOLDER: {
                    control = this.getTextControl(parent, guiElements, props, lastControl, label);
                    break;
                }
                case CHECKBOX: {
                    control = this.getCheckboxControl(parent, guiElements, props, lastControl, label);
                    break;
                }
                case COMBO: {
                    control = this.getComboControl(sourceObject, parent, guiElements, props, lastControl, label);
                    break;
                }
                case METADATA: {
                    control = this.getMetadataControl(parent, guiElements, props, lastControl);
                    break;
                }
                case BUTTON: {
                    control = this.getButtonControl(sourceObject, parent, guiElements, props, lastControl);
                    break;
                }
                case LINK: {
                    control = this.getLinkControl(parent, guiElements, props, lastControl);
                }
            }
            if (control != null) {
                return control;
            }
            return lastControl;
        }
        Control previousControl = lastControl;
        List children = guiElements.getChildren();
        Collections.sort(children);
        for (GuiElements child : guiElements.getChildren()) {
            previousControl = this.addCompositeWidgets(sourceObject, parent, child, previousControl);
            ++this.nrItems;
        }
        return previousControl;
    }

    private Control getComboControl(Object sourceObject, Composite parent, GuiElements guiElements, PropsUi props, Control lastControl, Label label) {
        Object control;
        String[] comboItems = this.getEnumValues(guiElements.getFieldClass());
        if (comboItems == null) {
            comboItems = StringUtils.isNotEmpty((String)guiElements.getGetComboValuesMethod()) ? this.getComboItems(sourceObject, guiElements.getGetComboValuesMethod()) : new String[]{};
        }
        if (guiElements.isVariablesEnabled()) {
            ComboVar comboVar = new ComboVar(this.variables, parent, 18436);
            PropsUi.setLook((Widget)comboVar);
            this.widgetsMap.put(guiElements.getId(), (Control)comboVar);
            comboVar.setItems(comboItems);
            control = comboVar;
        } else {
            Combo combo = new Combo(parent, 18436);
            PropsUi.setLook((Widget)combo);
            combo.setItems(comboItems);
            this.widgetsMap.put(guiElements.getId(), (Control)combo);
            control = combo;
        }
        this.addModifyListener((Control)control, guiElements.getId());
        this.layoutControlBetweenLabelAndRightControl(props, lastControl, label, (Control)control, null);
        return control;
    }

    private Control getMetadataControl(Composite parent, GuiElements guiElements, PropsUi props, Control lastControl) {
        ITypeMetadata typeMetadata = this.instantiateTypeMetadata(guiElements);
        MetaSelectionLine metaSelectionLine = new MetaSelectionLine(this.variables, (IHopMetadataProvider)HopGui.getInstance().getMetadataProvider(), typeMetadata.getMetadataClass(), parent, 18436, guiElements.getLabel(), guiElements.getToolTip(), false, false);
        this.widgetsMap.put(guiElements.getId(), (Control)metaSelectionLine);
        try {
            metaSelectionLine.fillItems();
        }
        catch (HopException e) {
            LogChannel.UI.logError("Error getting metadata items", (Throwable)e);
        }
        this.addModifyListener((Control)metaSelectionLine.getComboWidget(), guiElements.getId());
        this.layoutControlBelowLast(props, lastControl, (Control)metaSelectionLine);
        return metaSelectionLine;
    }

    private Button getButtonControl(Object sourceObject, Composite parent, GuiElements guiElements, PropsUi props, Control lastControl) {
        Button button = new Button(parent, 8);
        PropsUi.setLook((Widget)button);
        button.setText(Const.NVL((String)guiElements.getLabel(), (String)""));
        if (StringUtils.isNotEmpty((String)guiElements.getToolTip())) {
            button.setToolTipText(guiElements.getToolTip());
        }
        this.widgetsMap.put(guiElements.getId(), (Control)button);
        button.addListener(13, event -> {
            Method buttonMethod = guiElements.getButtonMethod();
            Class<?> methodClass = buttonMethod.getDeclaringClass();
            try {
                Object guiObject = methodClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                buttonMethod.invoke(guiObject, sourceObject);
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error invoking method " + buttonMethod.getName() + " in class " + methodClass.getName(), (Throwable)e);
            }
        });
        this.layoutControlBetweenLabelAndRightControl(props, lastControl, null, (Control)button, null);
        return button;
    }

    private Link getLinkControl(Composite parent, GuiElements guiElements, PropsUi props, Control lastControl) {
        Link link = new Link(parent, 0);
        PropsUi.setLook((Widget)link);
        link.setText(Const.NVL((String)guiElements.getLabel(), (String)""));
        if (StringUtils.isNotEmpty((String)guiElements.getToolTip())) {
            link.setToolTipText(guiElements.getToolTip());
        }
        this.widgetsMap.put(guiElements.getId(), (Control)link);
        link.addListener(13, event -> {
            Method buttonMethod = guiElements.getButtonMethod();
            Class<?> methodClass = buttonMethod.getDeclaringClass();
            try {
                Object guiObject = methodClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (buttonMethod.getParameterCount() == 0) {
                    buttonMethod.invoke(guiObject, new Object[0]);
                } else {
                    buttonMethod.invoke(guiObject, event);
                }
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error invoking method " + buttonMethod.getName() + " in class " + methodClass.getName(), (Throwable)e);
            }
        });
        this.layoutControlBelowLast(props, lastControl, (Control)link);
        return link;
    }

    private String[] getEnumValues(Class<?> fieldClass) {
        try {
            if (fieldClass.isEnum()) {
                ?[] enumConstants = fieldClass.getEnumConstants();
                String[] values = new String[enumConstants.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = enumConstants[i].toString();
                }
                return values;
            }
            return null;
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error finding enum values of field class: " + fieldClass.getName(), (Throwable)e);
            return null;
        }
    }

    private Control getCheckboxControl(Composite parent, GuiElements guiElements, PropsUi props, Control lastControl, Label label) {
        Button button = new Button(parent, 16416);
        PropsUi.setLook((Widget)button);
        this.widgetsMap.put(guiElements.getId(), (Control)button);
        this.addModifyListener((Control)button, guiElements.getId());
        Button control = button;
        this.layoutControlBetweenLabelAndRightControl(props, lastControl, label, (Control)control, null);
        return control;
    }

    private Control getTextControl(Composite parent, GuiElements guiElements, PropsUi props, Control lastControl, Label label) {
        Text text;
        Object control;
        Button actionControl = null;
        switch (guiElements.getType()) {
            case FILENAME: {
                Button wbBrowse = new Button(parent, 8);
                wbBrowse.setText(BaseMessages.getString((String)"System.Button.Browse"));
                this.layoutControlOnRight(props, lastControl, (Control)wbBrowse, label);
                actionControl = wbBrowse;
                break;
            }
            case FOLDER: {
                Button wbBrowse = new Button(parent, 8);
                wbBrowse.setText(BaseMessages.getString((String)"System.Button.Browse"));
                this.layoutControlOnRight(props, lastControl, (Control)wbBrowse, label);
                actionControl = wbBrowse;
                break;
            }
        }
        if (guiElements.isVariablesEnabled()) {
            TextVar textVar = new TextVar(this.variables, parent, 18436);
            PropsUi.setLook((Widget)textVar);
            if (guiElements.isPassword()) {
                textVar.setEchoChar('*');
            }
            this.widgetsMap.put(guiElements.getId(), (Control)textVar);
            this.addModifyListener((Control)textVar.getTextWidget(), guiElements.getId());
            control = textVar;
            text = textVar.getTextWidget();
        } else {
            text = new Text(parent, 18436);
            PropsUi.setLook((Widget)text);
            if (guiElements.isPassword()) {
                text.setEchoChar('*');
            }
            this.widgetsMap.put(guiElements.getId(), (Control)text);
            this.addModifyListener((Control)text, guiElements.getId());
            control = text;
        }
        this.layoutControlBetweenLabelAndRightControl(props, lastControl, label, (Control)control, (Control)actionControl);
        switch (guiElements.getType()) {
            case FILENAME: {
                ITypeFilename typeFilename = this.instantiateTypeFilename(guiElements);
                if (actionControl == null) break;
                actionControl.addListener(13, e -> {
                    String filename = BaseDialog.presentFileDialog(parent.getShell(), null, this.variables, typeFilename.getFilterExtensions(), typeFilename.getFilterNames(), true);
                    if (StringUtils.isNotEmpty((String)filename)) {
                        text.setText(filename);
                    }
                });
                break;
            }
            case FOLDER: {
                if (actionControl == null) break;
                actionControl.addListener(13, e -> {
                    String folder = BaseDialog.presentDirectoryDialog(parent.getShell(), this.variables);
                    if (StringUtils.isNotEmpty((String)folder)) {
                        text.setText(folder);
                    }
                });
                break;
            }
        }
        return control;
    }

    public ITypeFilename instantiateTypeFilename(GuiElements guiElements) {
        Class typeFilenameClass = guiElements.getTypeFilename();
        if (typeFilenameClass == null) {
            throw new RuntimeException("Please specify a ITypeFilename class to use for widget " + guiElements.getId());
        }
        try {
            ITypeFilename typeFilename = (ITypeFilename)typeFilenameClass.newInstance();
            return typeFilename;
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating class " + typeFilenameClass.getName() + " for GUI elements " + guiElements.getId() + " and type " + guiElements.getType(), e);
        }
    }

    public ITypeMetadata instantiateTypeMetadata(GuiElements guiElements) {
        Class typeMetadataClass = guiElements.getTypeMetadata();
        if (typeMetadataClass == null) {
            throw new RuntimeException("Please specify a ITypeMetadata class to use for widget " + guiElements.getId());
        }
        try {
            ITypeMetadata typeMetadata = (ITypeMetadata)typeMetadataClass.newInstance();
            return typeMetadata;
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating class " + typeMetadataClass.getName() + " for GUI elements " + guiElements.getId() + " and type " + guiElements.getType(), e);
        }
    }

    private void layoutControlOnRight(PropsUi props, Control lastControl, Control control, Label label) {
        FormData fdControl = new FormData();
        fdControl.right = new FormAttachment(100, 0);
        fdControl.top = label != null ? new FormAttachment((Control)label, 0, 0x1000000) : (lastControl != null ? new FormAttachment(lastControl, props.getMargin()) : new FormAttachment(0, 0));
        control.setLayoutData((Object)fdControl);
    }

    private void layoutControlBetweenLabelAndRightControl(PropsUi props, Control lastControl, Label label, Control control, Control rightControl) {
        FormData fdControl = new FormData();
        if (label != null) {
            fdControl.left = new FormAttachment(props.getMiddlePct(), props.getMargin());
            fdControl.right = rightControl == null ? new FormAttachment(100, 0) : new FormAttachment(rightControl, -5);
            fdControl.top = new FormAttachment((Control)label, 0, 0x1000000);
        } else {
            fdControl.left = new FormAttachment(props.getMiddlePct(), props.getMargin());
            fdControl.right = rightControl == null ? new FormAttachment(100, 0) : new FormAttachment(rightControl, -5);
            fdControl.top = lastControl != null ? new FormAttachment(lastControl, props.getMargin()) : new FormAttachment(0, 0);
        }
        control.setLayoutData((Object)fdControl);
    }

    private void layoutControlBelowLast(PropsUi props, Control lastControl, Control control) {
        FormData fdControl = new FormData();
        fdControl.left = new FormAttachment(0, 0);
        fdControl.right = new FormAttachment(100, 0);
        fdControl.top = lastControl != null ? new FormAttachment(lastControl, props.getMargin()) : new FormAttachment(0, 0);
        control.setLayoutData((Object)fdControl);
    }

    private void addModifyListener(Control control, String widgetId) {
        if (control instanceof Button) {
            control.addListener(13, event -> this.notifyWidgetModified(event, control, widgetId));
        } else if (control instanceof Combo || control instanceof ComboVar) {
            control.addListener(13, event -> this.notifyWidgetModified(event, control, widgetId));
            control.addListener(24, event -> this.notifyWidgetModified(event, control, widgetId));
        } else {
            control.addListener(24, event -> this.notifyWidgetModified(event, control, widgetId));
        }
    }

    protected void notifyWidgetModified(Event event, Control control, String widgetId) {
        if (this.compositeWidgetsListener != null) {
            this.compositeWidgetsListener.widgetModified(this, control, widgetId);
        }
    }

    private String[] getComboItems(Object sourceObject, String getComboValuesMethod) {
        try {
            Method method = sourceObject.getClass().getMethod(getComboValuesMethod, ILogChannel.class, IHopMetadataProvider.class);
            if (method == null) {
                throw new HopException("Unable to find method '" + getComboValuesMethod + "' with parameters ILogChannel and IHopMetadataProvider in object '" + sourceObject + "'");
            }
            List names = (List)method.invoke(sourceObject, LogChannel.UI, HopGui.getInstance().getMetadataProvider());
            return names.toArray(new String[0]);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting list of combo items for method '" + getComboValuesMethod + "' on source object: " + sourceObject, (Throwable)e);
            return new String[0];
        }
    }

    public void setWidgetsContents(Object sourceData, Composite parentComposite, String parentGuiElementId) {
        GuiRegistry registry = GuiRegistry.getInstance();
        GuiElements guiElements = registry.findGuiElements(sourceData.getClass().getName(), parentGuiElementId);
        if (guiElements == null) {
            return;
        }
        this.setWidgetsData(sourceData, guiElements);
        if (this.compositeWidgetsListener != null) {
            this.compositeWidgetsListener.widgetsCreated(this);
        }
        parentComposite.layout(true, true);
    }

    private void setWidgetsData(Object sourceData, GuiElements guiElements) {
        if (guiElements.isIgnored()) {
            return;
        }
        if (guiElements.getType() == GuiElementType.BUTTON) {
            return;
        }
        if (guiElements.getId() != null) {
            Control control = this.widgetsMap.get(guiElements.getId());
            if (control != null) {
                Object value = null;
                try {
                    value = new PropertyDescriptor(guiElements.getFieldName(), sourceData.getClass()).getReadMethod().invoke(sourceData, new Object[0]);
                }
                catch (Exception e) {
                    System.err.println("Unable to get value for field: '" + guiElements.getFieldName() + "' : " + e.getMessage());
                    e.printStackTrace();
                }
                String stringValue = value == null ? "" : Const.NVL((String)value.toString(), (String)"");
                switch (guiElements.getType()) {
                    case TEXT: 
                    case FILENAME: 
                    case FOLDER: {
                        if (guiElements.isVariablesEnabled()) {
                            TextVar textVar = (TextVar)control;
                            textVar.setText(stringValue);
                            break;
                        }
                        Text text = (Text)control;
                        text.setText(stringValue);
                        break;
                    }
                    case CHECKBOX: {
                        Button button = (Button)control;
                        button.setSelection(((Boolean)value).booleanValue());
                        break;
                    }
                    case COMBO: {
                        if (guiElements.isVariablesEnabled()) {
                            ComboVar comboVar = (ComboVar)control;
                            comboVar.setText(stringValue);
                            break;
                        }
                        Combo combo = (Combo)control;
                        combo.setText(stringValue);
                        break;
                    }
                    case METADATA: {
                        MetaSelectionLine line = (MetaSelectionLine)control;
                        line.setText(stringValue);
                        break;
                    }
                    case BUTTON: 
                    case LINK: {
                        break;
                    }
                    default: {
                        System.err.println("WARNING: setting data on widget with ID " + guiElements.getId() + " : not implemented type " + guiElements.getType() + " yet.");
                        break;
                    }
                }
            } else {
                System.err.println("Widget not found to set value on for id: " + guiElements.getId() + ", label: " + guiElements.getLabel());
            }
        } else {
            for (GuiElements child : guiElements.getChildren()) {
                this.setWidgetsData(sourceData, child);
            }
        }
    }

    public void getWidgetsContents(Object sourceData, String parentGuiElementId) {
        GuiRegistry registry = GuiRegistry.getInstance();
        GuiElements guiElements = registry.findGuiElements(sourceData.getClass().getName(), parentGuiElementId);
        if (guiElements == null) {
            System.err.println("getWidgetsContents: no GUI elements found for class: " + sourceData.getClass().getName() + ", parent ID: " + parentGuiElementId);
            return;
        }
        this.getWidgetsData(sourceData, guiElements);
    }

    private void getWidgetsData(Object sourceData, GuiElements guiElements) {
        if (guiElements.isIgnored()) {
            return;
        }
        if (guiElements.getType() == GuiElementType.BUTTON) {
            return;
        }
        if (guiElements.getId() != null) {
            Control control = this.widgetsMap.get(guiElements.getId());
            if (control != null) {
                Object value = null;
                switch (guiElements.getType()) {
                    case TEXT: 
                    case FILENAME: 
                    case FOLDER: {
                        if (guiElements.isVariablesEnabled()) {
                            TextVar textVar = (TextVar)control;
                            value = textVar.getText();
                            break;
                        }
                        Text text = (Text)control;
                        value = text.getText();
                        break;
                    }
                    case CHECKBOX: {
                        Button button = (Button)control;
                        value = button.getSelection();
                        break;
                    }
                    case COMBO: {
                        if (guiElements.isVariablesEnabled()) {
                            ComboVar comboVar = (ComboVar)control;
                            value = comboVar.getText();
                            break;
                        }
                        Combo combo = (Combo)control;
                        value = combo.getText();
                        break;
                    }
                    case METADATA: {
                        MetaSelectionLine line = (MetaSelectionLine)control;
                        value = line.getText();
                        break;
                    }
                    case BUTTON: 
                    case LINK: {
                        break;
                    }
                    default: {
                        System.err.println("WARNING: getting data from widget with ID " + guiElements.getId() + " : not implemented type " + guiElements.getType() + " yet.");
                    }
                }
                try {
                    Class fieldClass = guiElements.getFieldClass();
                    if (fieldClass.isEnum()) {
                        Class enumClass = fieldClass;
                        if (value != null) {
                            value = Enum.valueOf(enumClass, value.toString());
                        }
                    }
                    new PropertyDescriptor(guiElements.getFieldName(), sourceData.getClass()).getWriteMethod().invoke(sourceData, value);
                }
                catch (Exception e) {
                    System.err.println("Unable to set value '" + value + "'on field: '" + guiElements.getFieldName() + "' : " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                System.err.println("Widget not found to set value on for id: " + guiElements.getId() + ", label: " + guiElements.getLabel());
            }
        } else {
            for (GuiElements child : guiElements.getChildren()) {
                this.getWidgetsData(sourceData, child);
            }
        }
    }

    public IGuiPluginCompositeWidgetsListener getWidgetsListener() {
        return this.compositeWidgetsListener;
    }

    public void setWidgetsListener(IGuiPluginCompositeWidgetsListener listener) {
        this.compositeWidgetsListener = listener;
    }

    public void enableWidgets(Object sourceData, String parentGuiElementId, boolean enabled) {
        GuiRegistry registry = GuiRegistry.getInstance();
        GuiElements guiElements = registry.findGuiElements(sourceData.getClass().getName(), parentGuiElementId);
        if (guiElements == null) {
            System.err.println("enableWidgets: no GUI elements found for class: " + sourceData.getClass().getName() + ", parent ID: " + parentGuiElementId);
            return;
        }
        this.enableWidget(sourceData, guiElements, enabled);
    }

    private void enableWidget(Object sourceData, GuiElements guiElements, boolean enabled) {
        if (guiElements.isIgnored()) {
            return;
        }
        if (guiElements.getId() != null) {
            if (!guiElements.getId().matches("driverClass")) {
                Control label = this.labelsMap.get(guiElements.getId());
                Control widget = this.widgetsMap.get(guiElements.getId());
                if (label != null) {
                    label.setEnabled(enabled);
                } else {
                    System.err.println("Label not found to enable/disable: " + guiElements);
                }
                if (widget != null) {
                    widget.setEnabled(enabled);
                } else {
                    System.err.println("Widget not found to enable/disable: " + guiElements);
                }
            }
        } else {
            for (GuiElements child : guiElements.getChildren()) {
                this.enableWidget(sourceData, child, enabled);
            }
        }
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public Map<String, Control> getLabelsMap() {
        return this.labelsMap;
    }

    public void setLabelsMap(Map<String, Control> labelsMap) {
        this.labelsMap = labelsMap;
    }

    public Map<String, Control> getWidgetsMap() {
        return this.widgetsMap;
    }

    public void setWidgetsMap(Map<String, Control> widgetsMap) {
        this.widgetsMap = widgetsMap;
    }
}

