/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.injection.InjectionTypeConverter;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaNone;

public class RowMetaAndData
implements Cloneable {
    private IRowMeta rowMeta;
    private Object[] data;

    public RowMetaAndData() {
        this.clear();
    }

    public RowMetaAndData(IRowMeta rowMeta, Object ... data) {
        this.rowMeta = rowMeta;
        this.data = data;
    }

    public RowMetaAndData clone() {
        RowMetaAndData c = new RowMetaAndData();
        c.rowMeta = this.rowMeta.clone();
        try {
            c.data = this.rowMeta.cloneRow(this.data);
        }
        catch (HopValueException e) {
            throw new RuntimeException("Problem with clone row detected in RowMetaAndData", e);
        }
        return c;
    }

    public String toString() {
        try {
            return this.rowMeta.getString(this.data);
        }
        catch (HopValueException e) {
            return this.rowMeta.toString() + ", error presenting data: " + e.toString();
        }
    }

    public Object[] getData() {
        return this.data;
    }

    public void setData(Object[] data) {
        this.data = data;
    }

    public IRowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(IRowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public int hashCode() {
        try {
            return this.rowMeta.hashCode(this.data);
        }
        catch (HopValueException e) {
            throw new RuntimeException("Row metadata and data: unable to calculate hashcode because of a data conversion problem", e);
        }
    }

    public boolean equals(Object obj) {
        try {
            return this.rowMeta.compare(this.data, ((RowMetaAndData)obj).getData()) == 0;
        }
        catch (HopValueException e) {
            throw new RuntimeException("Row metadata and data: unable to compare rows because of a data conversion problem", e);
        }
    }

    public void addValue(IValueMeta valueMeta, Object valueData) {
        this.data = RowDataUtil.addValueData(this.data, this.rowMeta.size(), valueData);
        this.rowMeta.addValueMeta(valueMeta);
    }

    public void addValue(String valueName, int valueType, Object valueData) {
        IValueMeta v;
        try {
            v = ValueMetaFactory.createValueMeta(valueName, valueType);
        }
        catch (HopPluginException e) {
            v = new ValueMetaNone(valueName);
        }
        this.addValue(v, valueData);
    }

    public void clear() {
        this.rowMeta = new RowMeta();
        this.data = new Object[0];
    }

    public long getInteger(String valueName, long def) throws HopValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new HopValueException("Unknown column '" + valueName + "'");
        }
        return this.getInteger(idx, def);
    }

    public long getInteger(int index, long def) throws HopValueException {
        Long number = this.rowMeta.getInteger(this.data, index);
        if (number == null) {
            return def;
        }
        return number;
    }

    public Long getInteger(String valueName) throws HopValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new HopValueException("Unknown column '" + valueName + "'");
        }
        return this.rowMeta.getInteger(this.data, idx);
    }

    public Long getInteger(int index) throws HopValueException {
        return this.rowMeta.getInteger(this.data, index);
    }

    public double getNumber(String valueName, double def) throws HopValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new HopValueException("Unknown column '" + valueName + "'");
        }
        return this.getNumber(idx, def);
    }

    public double getNumber(int index, double def) throws HopValueException {
        Double number = this.rowMeta.getNumber(this.data, index);
        if (number == null) {
            return def;
        }
        return number;
    }

    public Date getDate(String valueName, Date def) throws HopValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new HopValueException("Unknown column '" + valueName + "'");
        }
        return this.getDate(idx, def);
    }

    public Date getDate(int index, Date def) throws HopValueException {
        Date date = this.rowMeta.getDate(this.data, index);
        if (date == null) {
            return def;
        }
        return date;
    }

    public BigDecimal getBigNumber(String valueName, BigDecimal def) throws HopValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new HopValueException("Unknown column '" + valueName + "'");
        }
        return this.getBigNumber(idx, def);
    }

    public BigDecimal getBigNumber(int index, BigDecimal def) throws HopValueException {
        BigDecimal number = this.rowMeta.getBigNumber(this.data, index);
        if (number == null) {
            return def;
        }
        return number;
    }

    public boolean getBoolean(String valueName, boolean def) throws HopValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new HopValueException("Unknown column '" + valueName + "'");
        }
        return this.getBoolean(idx, def);
    }

    public boolean getBoolean(int index, boolean def) throws HopValueException {
        Boolean b = this.rowMeta.getBoolean(this.data, index);
        if (b == null) {
            return def;
        }
        return b;
    }

    public String getString(String valueName, String def) throws HopValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new HopValueException("Unknown column '" + valueName + "'");
        }
        return this.getString(idx, def);
    }

    public String getString(int index, String def) throws HopValueException {
        String string = this.rowMeta.getString(this.data, index);
        if (string == null) {
            return def;
        }
        return string;
    }

    public byte[] getBinary(String valueName, byte[] def) throws HopValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new HopValueException("Unknown column '" + valueName + "'");
        }
        return this.getBinary(idx, def);
    }

    public byte[] getBinary(int index, byte[] def) throws HopValueException {
        byte[] bin = this.rowMeta.getBinary(this.data, index);
        if (bin == null) {
            return def;
        }
        return bin;
    }

    public int compare(RowMetaAndData compare, int[] is, boolean[] bs) throws HopValueException {
        return this.rowMeta.compare(this.data, compare.getData(), is);
    }

    public boolean isNumeric(int index) {
        return this.rowMeta.getValueMeta(index).isNumeric();
    }

    public int size() {
        return this.rowMeta.size();
    }

    public IValueMeta getValueMeta(int index) {
        return this.rowMeta.getValueMeta(index);
    }

    public boolean isEmptyValue(String valueName) throws HopValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new HopValueException("Unknown column '" + valueName + "'");
        }
        IValueMeta metaType = this.rowMeta.getValueMeta(idx);
        switch (metaType.getType()) {
            case 2: {
                return this.rowMeta.getString(this.data, idx) == null;
            }
            case 4: {
                return this.rowMeta.getBoolean(this.data, idx) == null;
            }
            case 5: {
                return this.rowMeta.getInteger(this.data, idx) == null;
            }
            case 1: {
                return this.rowMeta.getNumber(this.data, idx) == null;
            }
            case 6: {
                return this.rowMeta.getBigNumber(this.data, idx) == null;
            }
            case 8: {
                return this.rowMeta.getBinary(this.data, idx) == null;
            }
            case 3: 
            case 9: {
                return this.rowMeta.getDate(this.data, idx) == null;
            }
            case 10: {
                return this.rowMeta.getString(this.data, idx) == null;
            }
        }
        throw new HopValueException("Unknown source type: " + metaType.getTypeDesc());
    }

    public static Object getStringAsJavaType(String vs, Class<?> destinationType, InjectionTypeConverter converter) throws HopValueException {
        if (String.class.isAssignableFrom(destinationType)) {
            return converter.string2string(vs);
        }
        if (Integer.TYPE.isAssignableFrom(destinationType)) {
            return converter.string2intPrimitive(vs);
        }
        if (Integer.class.isAssignableFrom(destinationType)) {
            return converter.string2integer(vs);
        }
        if (Long.TYPE.isAssignableFrom(destinationType)) {
            return converter.string2longPrimitive(vs);
        }
        if (Long.class.isAssignableFrom(destinationType)) {
            return converter.string2long(vs);
        }
        if (Boolean.TYPE.isAssignableFrom(destinationType)) {
            return converter.string2booleanPrimitive(vs);
        }
        if (Boolean.class.isAssignableFrom(destinationType)) {
            return converter.string2boolean(vs);
        }
        if (destinationType.isEnum()) {
            return converter.string2enum(destinationType, vs);
        }
        throw new RuntimeException("Wrong value conversion to " + destinationType);
    }

    public Object getAsJavaType(String valueName, Class<?> destinationType, InjectionTypeConverter converter) throws HopValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new HopValueException("Unknown column '" + valueName + "'");
        }
        IValueMeta metaType = this.rowMeta.getValueMeta(idx);
        switch (metaType.getType()) {
            case 2: {
                String vs = this.rowMeta.getString(this.data, idx);
                return RowMetaAndData.getStringAsJavaType(vs, destinationType, converter);
            }
            case 4: {
                Boolean vb = this.rowMeta.getBoolean(this.data, idx);
                if (String.class.isAssignableFrom(destinationType)) {
                    return converter.boolean2string(vb);
                }
                if (Integer.TYPE.isAssignableFrom(destinationType)) {
                    return converter.boolean2intPrimitive(vb);
                }
                if (Integer.class.isAssignableFrom(destinationType)) {
                    return converter.boolean2integer(vb);
                }
                if (Long.TYPE.isAssignableFrom(destinationType)) {
                    return converter.boolean2longPrimitive(vb);
                }
                if (Long.class.isAssignableFrom(destinationType)) {
                    return converter.boolean2long(vb);
                }
                if (Boolean.TYPE.isAssignableFrom(destinationType)) {
                    return converter.boolean2booleanPrimitive(vb);
                }
                if (Boolean.class.isAssignableFrom(destinationType)) {
                    return converter.boolean2boolean(vb);
                }
                if (destinationType.isEnum()) {
                    return converter.boolean2enum(destinationType, vb);
                }
                throw new RuntimeException("Wrong value conversion to " + destinationType);
            }
            case 5: {
                Long vi = this.rowMeta.getInteger(this.data, idx);
                if (String.class.isAssignableFrom(destinationType)) {
                    return converter.integer2string(vi);
                }
                if (Integer.TYPE.isAssignableFrom(destinationType)) {
                    return converter.integer2intPrimitive(vi);
                }
                if (Integer.class.isAssignableFrom(destinationType)) {
                    return converter.integer2integer(vi);
                }
                if (Long.TYPE.isAssignableFrom(destinationType)) {
                    return converter.integer2longPrimitive(vi);
                }
                if (Long.class.isAssignableFrom(destinationType)) {
                    return converter.integer2long(vi);
                }
                if (Boolean.TYPE.isAssignableFrom(destinationType)) {
                    return converter.integer2booleanPrimitive(vi);
                }
                if (Boolean.class.isAssignableFrom(destinationType)) {
                    return converter.integer2boolean(vi);
                }
                if (destinationType.isEnum()) {
                    return converter.integer2enum(destinationType, vi);
                }
                throw new RuntimeException("Wrong value conversion to " + destinationType);
            }
            case 1: {
                Double vn = this.rowMeta.getNumber(this.data, idx);
                if (String.class.isAssignableFrom(destinationType)) {
                    return converter.number2string(vn);
                }
                if (Integer.TYPE.isAssignableFrom(destinationType)) {
                    return converter.number2intPrimitive(vn);
                }
                if (Integer.class.isAssignableFrom(destinationType)) {
                    return converter.number2integer(vn);
                }
                if (Long.TYPE.isAssignableFrom(destinationType)) {
                    return converter.number2longPrimitive(vn);
                }
                if (Long.class.isAssignableFrom(destinationType)) {
                    return converter.number2long(vn);
                }
                if (Boolean.TYPE.isAssignableFrom(destinationType)) {
                    return converter.number2booleanPrimitive(vn);
                }
                if (Boolean.class.isAssignableFrom(destinationType)) {
                    return converter.number2boolean(vn);
                }
                if (destinationType.isEnum()) {
                    return converter.number2enum(destinationType, vn);
                }
                throw new RuntimeException("Wrong value conversion to " + destinationType);
            }
        }
        throw new HopValueException("Unknown conversion from " + metaType.getTypeDesc() + " into " + destinationType);
    }

    public void removeValue(String valueName) throws HopValueException {
        int index = this.rowMeta.indexOfValue(valueName);
        if (index < 0) {
            throw new HopValueException("Unable to find '" + valueName + "' in the row");
        }
        this.removeValue(index);
    }

    public void removeValue(int index) {
        this.rowMeta.removeValueMeta(index);
        this.data = RowDataUtil.removeItem(this.data, index);
    }

    public void mergeRowMetaAndData(RowMetaAndData rowMetaAndData, String originTransformName) {
        int originalMetaSize = this.rowMeta.size();
        this.rowMeta.mergeRowMeta(rowMetaAndData.getRowMeta(), originTransformName);
        this.data = RowDataUtil.addRowData(this.data, originalMetaSize, rowMetaAndData.getData());
    }
}

