/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.drools;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.drools.RuleResultItem;
import org.apache.hop.pipeline.transforms.drools.Rules;
import org.apache.hop.pipeline.transforms.drools.RulesExecutor;
import org.apache.hop.pipeline.transforms.drools.RulesExecutorData;

@Transform(id="RuleExecutor", image="rules_exec.svg", name="i18n::RulesExecutor.Name", description="i18n::RulesExecutor.Description", categoryDescription="i18n::Rules.Category", keywords={"i18n::RulesExecutor.keyword"}, documentationUrl="/pipeline/transforms/rulesexecutor.html")
public class RulesExecutorMeta
extends BaseTransformMeta<RulesExecutor, RulesExecutorData> {
    private static Class<?> PKG = Rules.class;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<RuleResultItem> ruleResultColumns = new ArrayList<RuleResultItem>();
    @HopMetadataProperty(key="rule-file")
    private String ruleFile;
    @HopMetadataProperty(key="rule-definition")
    private String ruleDefinition;
    private boolean keepInputFields = true;

    public List<RuleResultItem> getRuleResultColumns() {
        return this.ruleResultColumns;
    }

    public void setRuleResultColumns(List<RuleResultItem> ruleResultColumns) {
        this.ruleResultColumns = ruleResultColumns;
    }

    public void setRuleFile(String ruleFile) {
        this.ruleFile = ruleFile;
    }

    public String getRuleFile() {
        return this.ruleFile;
    }

    public void setRuleDefinition(String ruleDefinition) {
        this.ruleDefinition = ruleDefinition;
    }

    public String getRuleDefinition() {
        return this.ruleDefinition;
    }

    public boolean isKeepInputFields() {
        return this.keepInputFields;
    }

    public void setKeepInputFields(boolean keepInputFields) {
        this.keepInputFields = keepInputFields;
    }

    public void setDefault() {
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!this.keepInputFields) {
            inputRowMeta.clear();
        }
        try {
            if (this.ruleResultColumns != null) {
                for (int i = 0; i < this.ruleResultColumns.size(); ++i) {
                    int type = ValueMetaFactory.getIdForValueMeta((String)this.ruleResultColumns.get(i).getType());
                    IValueMeta vm = ValueMetaFactory.createValueMeta((String)this.ruleResultColumns.get(i).getName(), (int)type);
                    vm.setOrigin(name);
                    inputRowMeta.addValueMeta(vm);
                }
            }
        }
        catch (HopPluginException e) {
            throw new HopTransformException("Unable to get rule result columns");
        }
    }

    public String[] getExpectedResultList() {
        String[] result = new String[this.ruleResultColumns.size()];
        for (int i = 0; i < this.ruleResultColumns.size(); ++i) {
            result[i] = this.ruleResultColumns.get(i).getName();
        }
        return result;
    }
}

