/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput.ods;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.spreadsheet.IKSheet;
import org.apache.hop.core.spreadsheet.IKWorkbook;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.transforms.excelinput.ods.OdfSheet;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;

public class OdfWorkbook
implements IKWorkbook {
    private String filename;
    private String encoding;
    private OdfDocument document;
    private Map<String, OdfSheet> openSheetsMap = new HashMap<String, OdfSheet>();

    public OdfWorkbook(String filename, String encoding) throws HopException {
        this.filename = filename;
        this.encoding = encoding;
        try {
            this.document = OdfSpreadsheetDocument.loadDocument((InputStream)HopVfs.getInputStream((String)filename));
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public OdfWorkbook(InputStream inputStream, String encoding) throws HopException {
        this.encoding = encoding;
        try {
            this.document = OdfSpreadsheetDocument.loadDocument((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public void close() {
        if (this.document != null) {
            this.document.close();
        }
    }

    public IKSheet getSheet(String sheetName) {
        OdfSheet sheet = this.openSheetsMap.get(sheetName);
        if (sheet == null) {
            OdfTable table = this.document.getTableByName(sheetName);
            if (table == null) {
                return null;
            }
            sheet = new OdfSheet(table);
            this.openSheetsMap.put(sheetName, sheet);
        }
        return sheet;
    }

    public String[] getSheetNames() {
        List list = this.document.getTableList();
        int nrSheets = list.size();
        String[] names = new String[nrSheets];
        for (int i = 0; i < nrSheets; ++i) {
            names[i] = ((OdfTable)list.get(i)).getTableName();
        }
        return names;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getNumberOfSheets() {
        return this.document.getTableList().size();
    }

    public IKSheet getSheet(int sheetNr) {
        OdfTable table = (OdfTable)this.document.getTableList().get(sheetNr);
        if (table == null) {
            return null;
        }
        return new OdfSheet(table);
    }

    public String getSheetName(int sheetNr) {
        OdfTable table = (OdfTable)this.document.getTableList().get(sheetNr);
        if (table == null) {
            return null;
        }
        return table.getTableName();
    }
}

