/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.MessageSystemAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.transform.MessageAttributeValueStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.MessageSystemAttributeValueStaxUnmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class SendMessageBatchRequestEntryStaxUnmarshaller
implements Unmarshaller<SendMessageBatchRequestEntry, StaxUnmarshallerContext> {
    private static SendMessageBatchRequestEntryStaxUnmarshaller instance;

    public SendMessageBatchRequestEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        SendMessageBatchRequestEntry sendMessageBatchRequestEntry = new SendMessageBatchRequestEntry();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return sendMessageBatchRequestEntry;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                Map.Entry<String, Cloneable> entry;
                if (context.testExpression("Id", targetDepth)) {
                    sendMessageBatchRequestEntry.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MessageBody", targetDepth)) {
                    sendMessageBatchRequestEntry.setMessageBody(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DelaySeconds", targetDepth)) {
                    sendMessageBatchRequestEntry.setDelaySeconds(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MessageAttribute", targetDepth)) {
                    entry = MessageAttributesMapEntryUnmarshaller.getInstance().unmarshall(context);
                    sendMessageBatchRequestEntry.addMessageAttributesEntry(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("MessageSystemAttribute", targetDepth)) {
                    entry = MessageSystemAttributesMapEntryUnmarshaller.getInstance().unmarshall(context);
                    sendMessageBatchRequestEntry.addMessageSystemAttributesEntry(entry.getKey(), (MessageSystemAttributeValue)entry.getValue());
                    continue;
                }
                if (context.testExpression("MessageDeduplicationId", targetDepth)) {
                    sendMessageBatchRequestEntry.setMessageDeduplicationId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MessageGroupId", targetDepth)) continue;
                sendMessageBatchRequestEntry.setMessageGroupId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return sendMessageBatchRequestEntry;
    }

    public static SendMessageBatchRequestEntryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SendMessageBatchRequestEntryStaxUnmarshaller();
        }
        return instance;
    }

    private static class MessageSystemAttributesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, MessageSystemAttributeValue>, StaxUnmarshallerContext> {
        private static MessageSystemAttributesMapEntryUnmarshaller instance;

        private MessageSystemAttributesMapEntryUnmarshaller() {
        }

        public Map.Entry<String, MessageSystemAttributeValue> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Value", targetDepth)) continue;
                    entry.setValue((Object)MessageSystemAttributeValueStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static MessageSystemAttributesMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new MessageSystemAttributesMapEntryUnmarshaller();
            }
            return instance;
        }
    }

    private static class MessageAttributesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, MessageAttributeValue>, StaxUnmarshallerContext> {
        private static MessageAttributesMapEntryUnmarshaller instance;

        private MessageAttributesMapEntryUnmarshaller() {
        }

        public Map.Entry<String, MessageAttributeValue> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Value", targetDepth)) continue;
                    entry.setValue((Object)MessageAttributeValueStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static MessageAttributesMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new MessageAttributesMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

