/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.flink.translation.wrappers.streaming.PushedBackElementsHandler;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.state.ListState;

class NonKeyedPushedBackElementsHandler<T>
implements PushedBackElementsHandler<T> {
    private final ListState<T> elementState;

    static <T> NonKeyedPushedBackElementsHandler<T> create(ListState<T> elementState) {
        return new NonKeyedPushedBackElementsHandler<T>(elementState);
    }

    private NonKeyedPushedBackElementsHandler(ListState<T> elementState) {
        this.elementState = (ListState)Preconditions.checkNotNull(elementState);
    }

    @Override
    public Stream<T> getElements() throws Exception {
        return StreamSupport.stream(((Iterable)this.elementState.get()).spliterator(), false);
    }

    @Override
    public void clear() {
        this.elementState.clear();
    }

    @Override
    public void pushBack(T element) throws Exception {
        this.elementState.add(element);
    }

    @Override
    public void pushBackAll(Iterable<T> elements) throws Exception {
        for (T e : elements) {
            this.elementState.add(e);
        }
    }
}

