package org.apache.helix.controller.rebalancer.constraint;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.List;
import java.util.Map;

import org.apache.helix.api.rebalancer.constraint.AbnormalStateResolver;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.Partition;
import org.apache.helix.model.StateModelDefinition;

/**
 * A mock abnormal state resolver for supporting tests.
 * It always return dummy result.
 */
public class MockAbnormalStateResolver implements AbnormalStateResolver {
  @Override
  public boolean checkCurrentStates(final CurrentStateOutput currentStateOutput,
      final String resourceName, final Partition partition,
      final StateModelDefinition stateModelDef) {
    // By default, all current states are valid.
    return true;
  }

  public Map<String, String> computeRecoveryAssignment(final CurrentStateOutput currentStateOutput,
      final String resourceName, final Partition partition,
      final StateModelDefinition stateModelDef, final List<String> preferenceList) {
    throw new UnsupportedOperationException("The mock resolver won't recover abnormal states.");
  }
}
