/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.scheduler;

import groovyx.gpars.scheduler.Pool;
import groovyx.gpars.util.PoolUtils;
import java.util.concurrent.TimeUnit;
import jsr166y.ForkJoinPool;

public class FJPool
implements Pool {
    protected final ForkJoinPool pool;
    private final int configuredPoolSize;
    private static final long DEFAULT_SHUTDOWN_TIMEOUT = 30L;

    public FJPool() {
        this(PoolUtils.retrieveDefaultPoolSize());
    }

    public FJPool(int configuredPoolSize) {
        PoolUtils.checkValidPoolSize(configuredPoolSize);
        this.configuredPoolSize = configuredPoolSize;
        this.pool = FJPool.createPool(configuredPoolSize);
    }

    public FJPool(ForkJoinPool pool) {
        this.pool = pool;
        this.configuredPoolSize = pool.getPoolSize();
    }

    private static ForkJoinPool createPool(int poolSize) {
        assert (poolSize > 0);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                System.err.println("Uncaught exception occurred in gpars pool " + t.getName());
                e.printStackTrace(System.err);
            }
        };
        return new ForkJoinPool(poolSize, ForkJoinPool.defaultForkJoinWorkerThreadFactory, uncaughtExceptionHandler, false);
    }

    @Override
    public final void resize(int poolSize) {
        throw new UnsupportedOperationException("ForkJoin pools can't change size");
    }

    @Override
    public final void resetDefaultSize() {
        this.resize(PoolUtils.retrieveDefaultPoolSize());
    }

    @Override
    public int getPoolSize() {
        return this.pool.getPoolSize();
    }

    @Override
    public void execute(Runnable task) {
        this.pool.submit(task);
    }

    public final ForkJoinPool getForkJoinPool() {
        return this.pool;
    }

    @Override
    public final void shutdown() {
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    protected final int getConfiguredPoolSize() {
        return this.configuredPoolSize;
    }
}

