/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.NullCheck;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class NullCheckASTTransformation
extends AbstractASTTransformation {
    private static final Class MY_CLASS = NullCheck.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode EXCEPTION = ClassHelper.make(IllegalArgumentException.class);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            if (!this.checkNotInterface(cNode, MY_TYPE_NAME)) {
                return;
            }
            for (ConstructorNode cn : cNode.getDeclaredConstructors()) {
                this.adjustMethod(cn);
            }
            for (MethodNode mn : cNode.getAllDeclaredMethods()) {
                this.adjustMethod(mn);
            }
        } else if (parent instanceof MethodNode) {
            this.adjustMethod((MethodNode)parent);
        }
    }

    private void adjustMethod(MethodNode mn) {
        Statement origCode = mn.getCode();
        BlockStatement newCode = new BlockStatement();
        if (mn.getParameters().length == 0) {
            return;
        }
        for (Parameter p : mn.getParameters()) {
            newCode.addStatement(GeneralUtils.ifS((Expression)GeneralUtils.isNullX(GeneralUtils.varX(p)), GeneralUtils.throwS(GeneralUtils.ctorX(EXCEPTION, GeneralUtils.constX(p.getName() + " cannot be null")))));
        }
        if (origCode instanceof BlockStatement) {
            for (Statement s : ((BlockStatement)origCode).getStatements()) {
                newCode.addStatement(s);
            }
        } else {
            newCode.addStatement(origCode);
        }
        mn.setCode(newCode);
    }
}

