/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.netrexx;

import COM.ibm.netrexx.process.NetRexxC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import netrexx.lang.BadArgumentException;
import netrexx.lang.Rexx;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.apache.bsf.util.EngineUtils;
import org.apache.bsf.util.MethodUtils;
import org.apache.bsf.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetRexxEngine
extends BSFEngineImpl {
    BSFFunctions mgrfuncs;
    static Hashtable codeToClass = new Hashtable();
    static String serializeCompilation = "";
    static String placeholder = "$$CLASSNAME$$";
    String minorPrefix;
    private Log logger = LogFactory.getLog((String)this.getClass().getName());
    private static int uniqueFileOffset = 0;

    public NetRexxEngine() {
        new BadArgumentException();
    }

    public Object call(Object object, String method, Object[] args) throws BSFException {
        throw new BSFException(499, "NetRexx doesn't currently support call()", null);
    }

    Object callStatic(Class rexxclass, String method, Object[] args) throws BSFException {
        Object retval = null;
        try {
            if (rexxclass != null) {
                Class[] argtypes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    argtypes[i] = args[i].getClass();
                }
                Method m = MethodUtils.getMethod(rexxclass, method, argtypes);
                retval = m.invoke(null, args);
            } else {
                this.logger.error((Object)"NetRexxEngine: ERROR: rexxclass==null!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                t.printStackTrace();
            }
            throw new BSFException(10, e.getMessage(), e);
        }
        return retval;
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
    }

    public Object eval(String source, int lineNo, int columnNo, Object script) throws BSFException {
        return this.execEvalShared(source, lineNo, columnNo, script, true);
    }

    public void exec(String source, int lineNo, int columnNo, Object script) throws BSFException {
        this.execEvalShared(source, lineNo, columnNo, script, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object execEvalShared(String source, int lineNo, int columnNo, Object oscript, boolean returnsObject) throws BSFException {
        String basescript;
        Object retval = null;
        String classname = null;
        GeneratedFile gf = null;
        Class rexxclass = null;
        String script = basescript = oscript.toString();
        try {
            try {
                rexxclass = (Class)codeToClass.get(basescript);
                if (rexxclass != null) {
                    this.logger.debug((Object)("NetRexxEngine: Found pre-compiled class for script '" + basescript + "'"));
                    classname = rexxclass.getName();
                } else {
                    gf = this.openUniqueFile(this.tempDir, "BSFNetRexx", ".nrx");
                    if (gf == null) {
                        throw new BSFException("couldn't create NetRexx scratchfile");
                    }
                    classname = gf.className;
                    String returnsDecl = "";
                    if (returnsObject) {
                        returnsDecl = "returns java.lang.Object";
                    }
                    gf.fos.write(("class " + classname + ";\n").getBytes());
                    gf.fos.write(("method BSFNetRexxEngineEntry(bsf=org.apache.bsf.util.BSFFunctions)  public static " + returnsDecl + ";\n").getBytes());
                    int startpoint = script.indexOf(placeholder);
                    if (startpoint >= 0) {
                        StringBuffer changed = new StringBuffer();
                        while (startpoint >= 0) {
                            changed.setLength(0);
                            if (startpoint > 0) {
                                changed.append(script.substring(0, startpoint));
                            }
                            changed.append(classname);
                            int endpoint = startpoint + placeholder.length();
                            if (endpoint < script.length()) {
                                changed.append(script.substring(endpoint));
                            }
                            script = changed.toString();
                            startpoint = script.indexOf(placeholder, startpoint);
                        }
                    }
                    for (int i = 0; i < this.declaredBeans.size(); ++i) {
                        BSFDeclaredBean tempBean = (BSFDeclaredBean)this.declaredBeans.elementAt(i);
                        String className = StringUtils.getClassName(tempBean.type);
                        gf.fos.write((tempBean.name + " =" + className + "   bsf.lookupBean(\"" + tempBean.name + "\");").getBytes());
                    }
                    if (returnsObject) {
                        gf.fos.write("return ".getBytes());
                    }
                    gf.fos.write(script.getBytes());
                    gf.fos.close();
                    this.logger.debug((Object)("NetRexxEngine: wrote temp file " + gf.file.getPath() + ", now compiling"));
                    String command = gf.file.getPath();
                    if (this.logger.isDebugEnabled()) {
                        command = command + " -verbose4";
                    } else {
                        command = command + " -noverbose";
                        command = command + " -noconsole";
                    }
                    Rexx cmdline = new Rexx(command);
                    String string = serializeCompilation;
                    // MONITORENTER : string
                    int retValue = NetRexxC.main((Rexx)cmdline, (PrintWriter)new PrintWriter(System.err));
                    // MONITOREXIT : string
                    if (retValue == 2) {
                        throw new BSFException(100, "There were NetRexx errors.");
                    }
                    this.logger.debug((Object)("NetRexxEngine: loading class " + classname));
                    rexxclass = EngineUtils.loadClass(this.mgr, classname);
                    codeToClass.put(basescript, rexxclass);
                }
                Object[] args = new Object[]{this.mgrfuncs};
                retval = this.callStatic(rexxclass, "BSFNetRexxEngineEntry", args);
            }
            catch (BSFException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!(e instanceof InvocationTargetException)) throw new BSFException(10, e.getMessage(), e);
                Throwable t = ((InvocationTargetException)e).getTargetException();
                t.printStackTrace();
                throw new BSFException(10, e.getMessage(), e);
            }
            Object var23_25 = null;
            if (gf != null && gf.file != null && gf.file.exists()) {
                gf.file.delete();
            }
            if (classname == null) return retval;
            File file = new File(this.tempDir + File.separatorChar + classname + ".java");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(classname + ".class")).exists()) {
                file.delete();
            }
            if ((file = new File(this.tempDir + File.separatorChar + classname + ".crossref")).exists()) {
                file.delete();
            }
            file = new File(this.tempDir);
            this.minorPrefix = classname + "$";
            String[] minor_classfiles = file.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return 0 == name.indexOf(NetRexxEngine.this.minorPrefix) && name.lastIndexOf(".class") == name.length() - 6;
                }
            });
            if (minor_classfiles == null) return retval;
            int i = minor_classfiles.length;
            while (i > 0) {
                file = new File(minor_classfiles[--i]);
                file.delete();
            }
            return retval;
        }
        catch (Throwable throwable) {
            Object var23_26 = null;
            if (gf != null && gf.file != null && gf.file.exists()) {
                gf.file.delete();
            }
            if (classname == null) throw throwable;
            File file = new File(this.tempDir + File.separatorChar + classname + ".java");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(classname + ".class")).exists()) {
                file.delete();
            }
            if ((file = new File(this.tempDir + File.separatorChar + classname + ".crossref")).exists()) {
                file.delete();
            }
            file = new File(this.tempDir);
            this.minorPrefix = classname + "$";
            String[] minor_classfiles = file.list(new /* invalid duplicate definition of identical inner class */);
            if (minor_classfiles == null) throw throwable;
            int i = minor_classfiles.length;
            while (i > 0) {
                file = new File(minor_classfiles[--i]);
                file.delete();
            }
            throw throwable;
        }
    }

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.mgrfuncs = new BSFFunctions(mgr, this);
    }

    private GeneratedFile openUniqueFile(String directory, String prefix, String suffix) {
        File file = null;
        File obj = null;
        FileOutputStream fos = null;
        int max = 1000;
        GeneratedFile gf = null;
        String className = null;
        int i = max;
        ++uniqueFileOffset;
        while (fos == null && i > 0) {
            block6: {
                try {
                    className = prefix + uniqueFileOffset;
                    file = new File(directory + File.separatorChar + className + suffix);
                    obj = new File(directory + File.separatorChar + className + ".class");
                    if (file != null && !file.exists() & obj != null & !obj.exists()) {
                        fos = new FileOutputStream(file);
                    }
                }
                catch (Exception e) {
                    if (file.exists()) break block6;
                    this.logger.error((Object)("openUniqueFile: unexpected " + e));
                }
            }
            --i;
            ++uniqueFileOffset;
        }
        if (fos == null) {
            this.logger.error((Object)("openUniqueFile: Failed " + max + "attempts."));
        } else {
            gf = new GeneratedFile(file, fos, className);
        }
        return gf;
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
    }

    private class GeneratedFile {
        File file = null;
        FileOutputStream fos = null;
        String className = null;

        GeneratedFile(File file, FileOutputStream fos, String className) {
            this.file = file;
            this.fos = fos;
            this.className = className;
        }
    }
}

