/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import groovy.lang.DelegatesTo;
import groovy.lang.IntRange;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import groovy.transform.TypeChecked;
import groovy.transform.TypeCheckingMode;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.ClosureSignatureConflictResolver;
import groovy.transform.stc.ClosureSignatureHint;
import groovyjarjaropenbeans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.apache.groovy.internal.util.Function;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.ReturnAdder;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.TokenUtil;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.stc.DefaultTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.DelegationMetadata;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.Receiver;
import org.codehaus.groovy.transform.stc.SecondPassExpression;
import org.codehaus.groovy.transform.stc.SharedVariableCollector;
import org.codehaus.groovy.transform.stc.SignatureCodec;
import org.codehaus.groovy.transform.stc.SignatureCodecVersion1;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.groovy.transform.stc.TraitTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.TypeCheckingContext;
import org.codehaus.groovy.transform.stc.TypeCheckingExtension;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.groovy.util.ListHashMap;

public class StaticTypeCheckingVisitor
extends ClassCodeVisitorSupport {
    private static final boolean DEBUG_GENERATED_CODE = Boolean.getBoolean("groovy.stc.debug");
    private static final AtomicLong UNIQUE_LONG = new AtomicLong();
    protected static final Object ERROR_COLLECTOR = ErrorCollector.class;
    protected static final ClassNode ITERABLE_TYPE = ClassHelper.make(Iterable.class);
    protected static final List<MethodNode> EMPTY_METHODNODE_LIST = Collections.emptyList();
    protected static final ClassNode TYPECHECKED_CLASSNODE = ClassHelper.make(TypeChecked.class);
    protected static final ClassNode[] TYPECHECKING_ANNOTATIONS = new ClassNode[]{TYPECHECKED_CLASSNODE};
    protected static final ClassNode TYPECHECKING_INFO_NODE = ClassHelper.make(TypeChecked.TypeCheckingInfo.class);
    protected static final ClassNode DGM_CLASSNODE = ClassHelper.make(DefaultGroovyMethods.class);
    protected static final int CURRENT_SIGNATURE_PROTOCOL_VERSION = 1;
    protected static final Expression CURRENT_SIGNATURE_PROTOCOL = new ConstantExpression(1, true);
    protected static final MethodNode GET_DELEGATE = ClassHelper.CLOSURE_TYPE.getGetterMethod("getDelegate");
    protected static final MethodNode GET_OWNER = ClassHelper.CLOSURE_TYPE.getGetterMethod("getOwner");
    protected static final MethodNode GET_THISOBJECT = ClassHelper.CLOSURE_TYPE.getGetterMethod("getThisObject");
    protected static final ClassNode DELEGATES_TO = ClassHelper.make(DelegatesTo.class);
    protected static final ClassNode DELEGATES_TO_TARGET = ClassHelper.make(DelegatesTo.Target.class);
    protected static final ClassNode LINKEDHASHMAP_CLASSNODE = ClassHelper.make(LinkedHashMap.class);
    protected static final ClassNode CLOSUREPARAMS_CLASSNODE = ClassHelper.make(ClosureParams.class);
    protected static final ClassNode NAMED_PARAMS_CLASSNODE = ClassHelper.make(NamedParams.class);
    protected static final ClassNode MAP_ENTRY_TYPE = ClassHelper.make(Map.Entry.class);
    protected static final ClassNode ENUMERATION_TYPE = ClassHelper.make(Enumeration.class);
    public static final Statement GENERATED_EMPTY_STATEMENT = new EmptyStatement();
    public static final MethodNode CLOSURE_CALL_NO_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", Parameter.EMPTY_ARRAY);
    public static final MethodNode CLOSURE_CALL_ONE_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "arg")});
    public static final MethodNode CLOSURE_CALL_VARGS = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE.makeArray(), "args")});
    protected final ReturnAdder.ReturnStatementListener returnListener = new ReturnAdder.ReturnStatementListener(){

        @Override
        public void returnStatementAdded(ReturnStatement returnStatement) {
            if (StaticTypeCheckingVisitor.isNullConstant(returnStatement.getExpression())) {
                return;
            }
            ClassNode returnType = StaticTypeCheckingVisitor.this.checkReturnType(returnStatement);
            if (StaticTypeCheckingVisitor.this.typeCheckingContext.getEnclosingClosure() != null) {
                StaticTypeCheckingVisitor.this.addClosureReturnType(returnType);
            } else if (StaticTypeCheckingVisitor.this.typeCheckingContext.getEnclosingMethod() == null) {
                throw new GroovyBugError("Unexpected return statement at " + returnStatement.getLineNumber() + ":" + returnStatement.getColumnNumber() + " " + returnStatement.getText());
            }
        }
    };
    protected final ReturnAdder returnAdder = new ReturnAdder(this.returnListener);
    protected FieldNode currentField;
    protected PropertyNode currentProperty;
    protected DefaultTypeCheckingExtension extension;
    protected TypeCheckingContext typeCheckingContext = new TypeCheckingContext(this);

    public StaticTypeCheckingVisitor(SourceUnit source, ClassNode classNode) {
        this.typeCheckingContext.pushEnclosingClassNode(classNode);
        this.typeCheckingContext.pushTemporaryTypeInfo();
        this.typeCheckingContext.pushErrorCollector(source.getErrorCollector());
        this.typeCheckingContext.source = source;
        this.extension = new DefaultTypeCheckingExtension(this);
        this.extension.addHandler(new TraitTypeCheckingExtension(this));
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.typeCheckingContext.getSource();
    }

    public void initialize() {
        this.extension.setup();
    }

    public TypeCheckingContext getTypeCheckingContext() {
        return this.typeCheckingContext;
    }

    public void addTypeCheckingExtension(TypeCheckingExtension extension) {
        this.extension.addHandler(extension);
    }

    public void setCompilationUnit(CompilationUnit compilationUnit) {
        this.typeCheckingContext.setCompilationUnit(compilationUnit);
    }

    @Override
    public void visitClass(ClassNode node) {
        if (this.shouldSkipClassNode(node)) {
            return;
        }
        if (this.extension.beforeVisitClass(node)) {
            this.extension.afterVisitClass(node);
            return;
        }
        Object type = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (type != null) {
            this.typeCheckingContext.pushErrorCollector();
        }
        this.typeCheckingContext.pushEnclosingClassNode(node);
        Set<MethodNode> oldVisitedMethod = this.typeCheckingContext.alreadyVisitedMethods;
        this.typeCheckingContext.alreadyVisitedMethods = new LinkedHashSet<MethodNode>();
        super.visitClass(node);
        Iterator<InnerClassNode> innerClasses = node.getInnerClasses();
        while (innerClasses.hasNext()) {
            InnerClassNode innerClassNode = innerClasses.next();
            this.visitClass(innerClassNode);
        }
        this.typeCheckingContext.alreadyVisitedMethods = oldVisitedMethod;
        this.typeCheckingContext.popEnclosingClassNode();
        if (type != null) {
            this.typeCheckingContext.popErrorCollector();
        }
        node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, node);
        for (MethodNode methodNode : node.getMethods()) {
            methodNode.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
        }
        for (ConstructorNode constructorNode : node.getDeclaredConstructors()) {
            constructorNode.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
        }
        this.extension.afterVisitClass(node);
    }

    protected ClassNode[] getTypeCheckingAnnotations() {
        return TYPECHECKING_ANNOTATIONS;
    }

    protected boolean shouldSkipClassNode(ClassNode node) {
        return Boolean.TRUE.equals(node.getNodeMetaData(StaticTypeCheckingVisitor.class)) || this.isSkipMode(node);
    }

    public boolean isSkipMode(AnnotatedNode node) {
        if (node == null) {
            return false;
        }
        for (ClassNode tca : this.getTypeCheckingAnnotations()) {
            List<AnnotationNode> annotations = node.getAnnotations(tca);
            if (annotations == null) continue;
            for (AnnotationNode annotation : annotations) {
                Expression value = annotation.getMember("value");
                if (value == null) continue;
                if (value instanceof ConstantExpression) {
                    ConstantExpression ce = (ConstantExpression)value;
                    if (!TypeCheckingMode.SKIP.toString().equals(ce.getValue().toString())) continue;
                    return true;
                }
                if (!(value instanceof PropertyExpression)) continue;
                PropertyExpression pe = (PropertyExpression)value;
                if (!TypeCheckingMode.SKIP.toString().equals(pe.getPropertyAsString())) continue;
                return true;
            }
        }
        if (node instanceof MethodNode) {
            return this.isSkipMode(node.getDeclaringClass());
        }
        return this.isSkippedInnerClass(node);
    }

    protected boolean isSkippedInnerClass(AnnotatedNode node) {
        if (!(node instanceof InnerClassNode)) {
            return false;
        }
        MethodNode enclosingMethod = ((InnerClassNode)node).getEnclosingMethod();
        return enclosingMethod != null && this.isSkipMode(enclosingMethod);
    }

    @Override
    public void visitClassExpression(ClassExpression expression) {
        super.visitClassExpression(expression);
        ClassNode cn = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn == null) {
            this.storeType(expression, this.getType(expression));
        }
    }

    private static ClassNode getOutermost(ClassNode cn) {
        while (cn.getOuterClass() != null) {
            cn = cn.getOuterClass();
        }
        return cn;
    }

    private static void addPrivateFieldOrMethodAccess(Expression source, ClassNode cn, StaticTypesMarker type, ASTNode accessedMember) {
        LinkedHashSet<ASTNode> set = (LinkedHashSet<ASTNode>)cn.getNodeMetaData((Object)type);
        if (set == null) {
            set = new LinkedHashSet<ASTNode>();
            cn.putNodeMetaData((Object)type, set);
        }
        set.add(accessedMember);
        source.putNodeMetaData((Object)type, accessedMember);
    }

    private void checkOrMarkPrivateAccess(Expression source, FieldNode fn, boolean lhsOfAssignment) {
        ClassNode enclosingClass;
        if (fn == null || !fn.isPrivate()) {
            return;
        }
        ClassNode declaringClass = fn.getDeclaringClass();
        if (declaringClass == (enclosingClass = this.typeCheckingContext.getEnclosingClassNode()) && this.typeCheckingContext.getEnclosingClosure() == null) {
            return;
        }
        if (declaringClass == enclosingClass || StaticTypeCheckingVisitor.getOutermost(declaringClass) == StaticTypeCheckingVisitor.getOutermost(enclosingClass)) {
            StaticTypesMarker accessKind = lhsOfAssignment ? StaticTypesMarker.PV_FIELDS_MUTATION : StaticTypesMarker.PV_FIELDS_ACCESS;
            StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, declaringClass, accessKind, fn);
        }
    }

    private void checkOrMarkPrivateAccess(Expression source, MethodNode mn) {
        ClassNode enclosingClassNode;
        if (mn == null) {
            return;
        }
        ClassNode declaringClass = mn.getDeclaringClass();
        if (declaringClass != (enclosingClassNode = this.typeCheckingContext.getEnclosingClassNode()) || this.typeCheckingContext.getEnclosingClosure() != null) {
            int mods = mn.getModifiers();
            boolean sameModule = declaringClass.getModule() == enclosingClassNode.getModule();
            String packageName = declaringClass.getPackageName();
            if (packageName == null) {
                packageName = "";
            }
            if (Modifier.isPrivate(mods) && sameModule) {
                StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, declaringClass, StaticTypesMarker.PV_METHODS_ACCESS, mn);
            } else if (Modifier.isProtected(mods) && !packageName.equals(enclosingClassNode.getPackageName()) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(enclosingClassNode, declaringClass)) {
                ClassNode cn = enclosingClassNode;
                while ((cn = cn.getOuterClass()) != null) {
                    if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(cn, declaringClass)) continue;
                    StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, cn, StaticTypesMarker.PV_METHODS_ACCESS, mn);
                    break;
                }
            }
        }
    }

    private void checkSuperCallFromClosure(Expression call, MethodNode directCallTarget) {
        if (call instanceof MethodCallExpression && this.typeCheckingContext.getEnclosingClosure() != null && ExpressionUtils.isSuperExpression(((MethodCallExpression)call).getObjectExpression())) {
            ClassNode current = this.typeCheckingContext.getEnclosingClassNode();
            LinkedList<MethodNode> list = (LinkedList<MethodNode>)current.getNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED);
            if (list == null) {
                list = new LinkedList<MethodNode>();
                current.putNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED, list);
            }
            list.add(directCallTarget);
            call.putNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED, current);
        }
    }

    private static ClassNode makeType(ClassNode cn, boolean usingClass) {
        if (usingClass) {
            ClassNode clazzType = ClassHelper.CLASS_Type.getPlainNodeReference();
            clazzType.setGenericsTypes(new GenericsType[]{new GenericsType(cn)});
            return clazzType;
        }
        return cn;
    }

    private boolean storeTypeForThis(VariableExpression vexp) {
        if (vexp == VariableExpression.THIS_EXPRESSION) {
            return true;
        }
        if (!vexp.isThisExpression()) {
            return false;
        }
        this.storeType(vexp, !ClassHelper.OBJECT_TYPE.equals(vexp.getType()) ? vexp.getType() : this.makeThis());
        return true;
    }

    private boolean storeTypeForSuper(VariableExpression vexp) {
        if (vexp == VariableExpression.SUPER_EXPRESSION) {
            return true;
        }
        if (!vexp.isSuperExpression()) {
            return false;
        }
        this.storeType(vexp, this.makeSuper());
        return true;
    }

    @Override
    public void visitVariableExpression(VariableExpression vexp) {
        ClassNode inferredType;
        super.visitVariableExpression(vexp);
        if (this.storeTypeForSuper(vexp)) {
            return;
        }
        if (this.storeTypeForThis(vexp)) {
            return;
        }
        String name = vexp.getName();
        Variable accessedVariable = vexp.getAccessedVariable();
        TypeCheckingContext.EnclosingClosure enclosingClosure = this.typeCheckingContext.getEnclosingClosure();
        if (accessedVariable instanceof PropertyNode) {
            BinaryExpression enclosingBinaryExpression;
            if (this.tryVariableExpressionAsProperty(vexp, name) && (enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression()) != null) {
                Expression leftExpression = enclosingBinaryExpression.getLeftExpression();
                Expression rightExpression = enclosingBinaryExpression.getRightExpression();
                SetterInfo setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(leftExpression);
                if (setterInfo != null && !this.ensureValidSetter(vexp, leftExpression, rightExpression, setterInfo)) {
                    return;
                }
            }
        } else if (accessedVariable instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)accessedVariable;
            if (enclosingClosure != null) {
                FieldNode veFieldNode;
                ClassNode owner;
                if (this.tryVariableExpressionAsProperty(vexp, name) && vexp.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER) == null && (owner = (ClassNode)vexp.getNodeMetaData((Object)StaticCompilationMetadataKeys.PROPERTY_OWNER)) != null && (veFieldNode = owner.getField(name)) != null) {
                    fieldNode = veFieldNode;
                    boolean lhsOfEnclosingAssignment = this.isLHSOfEnclosingAssignment(vexp);
                    vexp.setAccessedVariable(fieldNode);
                    this.checkOrMarkPrivateAccess(vexp, fieldNode, lhsOfEnclosingAssignment);
                }
            } else {
                this.checkOrMarkPrivateAccess(vexp, fieldNode, this.isLHSOfEnclosingAssignment(vexp));
                inferredType = this.getInferredTypeFromTempInfo(vexp, null);
                if (inferredType != null && !inferredType.getName().equals("java.lang.Object") && !inferredType.equals(accessedVariable.getType())) {
                    vexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, inferredType);
                } else {
                    this.storeType(vexp, this.getType(vexp));
                }
            }
        }
        if (!(accessedVariable instanceof DynamicVariable)) {
            VariableExpression variable = null;
            if (accessedVariable instanceof Parameter) {
                Parameter parameter = (Parameter)accessedVariable;
                variable = new ParameterVariableExpression(parameter);
            } else if (accessedVariable instanceof VariableExpression) {
                variable = (VariableExpression)accessedVariable;
            }
            if (variable != null && (inferredType = this.getInferredTypeFromTempInfo(variable, (ClassNode)variable.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE))) != null && !inferredType.getName().equals("java.lang.Object") && !inferredType.equals(accessedVariable.getType())) {
                vexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, inferredType);
            }
            return;
        }
        if (enclosingClosure != null) {
            switch (name) {
                case "delegate": {
                    DelegationMetadata dm = this.getDelegationMetadata(enclosingClosure.getClosureExpression());
                    if (dm != null) {
                        this.storeType(vexp, dm.getType());
                        return;
                    }
                }
                case "owner": {
                    if (this.typeCheckingContext.getEnclosingClosureStack().size() > 1) {
                        this.storeType(vexp, ClassHelper.CLOSURE_TYPE);
                        return;
                    }
                }
                case "thisObject": {
                    this.storeType(vexp, this.typeCheckingContext.getEnclosingClassNode());
                    return;
                }
                case "parameterTypes": {
                    this.storeType(vexp, ClassHelper.CLASS_Type.makeArray());
                    return;
                }
                case "maximumNumberOfParameters": 
                case "resolveStrategy": 
                case "directive": {
                    this.storeType(vexp, ClassHelper.int_TYPE);
                    return;
                }
            }
        }
        if (this.tryVariableExpressionAsProperty(vexp, name)) {
            return;
        }
        if (!this.extension.handleUnresolvedVariableExpression(vexp)) {
            this.addStaticTypeError("The variable [" + name + "] is undeclared.", vexp);
        }
    }

    private boolean tryVariableExpressionAsProperty(VariableExpression vexp, String dynName) {
        PropertyExpression pexp = GeneralUtils.thisPropX(true, dynName);
        if (this.visitPropertyExpressionSilent(pexp, vexp)) {
            vexp.copyNodeMetaData(pexp.getObjectExpression());
            for (Object key : new Object[]{StaticTypesMarker.IMPLICIT_RECEIVER, StaticTypesMarker.READONLY_PROPERTY, StaticTypesMarker.PV_FIELDS_ACCESS, StaticTypesMarker.PV_FIELDS_MUTATION, StaticTypesMarker.DECLARATION_INFERRED_TYPE, StaticTypesMarker.DIRECT_METHOD_CALL_TARGET}) {
                Object val = pexp.getNodeMetaData(key);
                if (val == null) continue;
                vexp.putNodeMetaData(key, val);
            }
            vexp.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            ClassNode type = (ClassNode)pexp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            this.storeType(vexp, type != null ? type : pexp.getType());
            String receiver = (String)vexp.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER);
            Boolean dynamic = (Boolean)pexp.getNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION);
            if ((receiver != null && !receiver.endsWith("owner") || Boolean.TRUE.equals(dynamic)) && !(vexp.getAccessedVariable() instanceof DynamicVariable)) {
                vexp.setAccessedVariable(new DynamicVariable(dynName, false));
            }
            return true;
        }
        return false;
    }

    private boolean visitPropertyExpressionSilent(PropertyExpression pe, Expression lhsPart) {
        return this.existsProperty(pe, !this.isLHSOfEnclosingAssignment(lhsPart));
    }

    @Override
    public void visitPropertyExpression(PropertyExpression pexp) {
        this.typeCheckingContext.pushEnclosingPropertyExpression(pexp);
        try {
            if (this.visitPropertyExpressionSilent(pexp, pexp)) {
                return;
            }
            if (!this.extension.handleUnresolvedProperty(pexp)) {
                Expression objectExpression = pexp.getObjectExpression();
                this.addStaticTypeError("No such property: " + pexp.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, this.getType(objectExpression)).toString(false), pexp);
            }
        }
        finally {
            this.typeCheckingContext.popEnclosingPropertyExpression();
        }
    }

    private boolean isLHSOfEnclosingAssignment(Expression expression) {
        BinaryExpression ec = this.typeCheckingContext.getEnclosingBinaryExpression();
        return ec != null && ec.getLeftExpression() == expression && StaticTypeCheckingSupport.isAssignment(ec.getOperation().getType());
    }

    @Override
    public void visitAttributeExpression(AttributeExpression expression) {
        if (!this.existsProperty(expression, true) && !this.extension.handleUnresolvedAttribute(expression)) {
            Expression objectExpression = expression.getObjectExpression();
            this.addStaticTypeError("No such attribute: " + expression.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, this.getType(objectExpression)).toString(false), expression);
        }
    }

    @Override
    public void visitRangeExpression(RangeExpression expression) {
        super.visitRangeExpression(expression);
        ClassNode fromType = ClassHelper.getWrapper(this.getType(expression.getFrom()));
        ClassNode toType = ClassHelper.getWrapper(this.getType(expression.getTo()));
        if (ClassHelper.Integer_TYPE.equals(fromType) && ClassHelper.Integer_TYPE.equals(toType)) {
            this.storeType(expression, ClassHelper.make(IntRange.class));
        } else {
            ClassNode rangeType = ClassHelper.RANGE_TYPE.getPlainNodeReference();
            rangeType.setGenericsTypes(new GenericsType[]{new GenericsType(WideningCategories.lowestUpperBound(fromType, toType))});
            this.storeType(expression, rangeType);
        }
    }

    @Override
    public void visitNotExpression(NotExpression expression) {
        this.typeCheckingContext.pushTemporaryTypeInfo();
        super.visitNotExpression(expression);
        this.typeCheckingContext.popTemporaryTypeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        int op = expression.getOperation().getType();
        if (op == 121) {
            return;
        }
        BinaryExpression enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
        this.typeCheckingContext.pushEnclosingBinaryExpression(expression);
        try {
            boolean isEmptyDeclaration;
            VariableExpression leftVar;
            ClassNode resultType;
            ClassNode lType;
            Expression leftExpression = expression.getLeftExpression();
            Expression rightExpression = expression.getRightExpression();
            leftExpression.visit(this);
            SetterInfo setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(leftExpression);
            if (setterInfo != null) {
                if (this.ensureValidSetter(expression, leftExpression, rightExpression, setterInfo)) {
                    return;
                }
                lType = this.getType(leftExpression);
            } else {
                if (op == 100) {
                    lType = this.getOriginalDeclarationType(leftExpression);
                    if (StaticTypeCheckingVisitor.isFunctionalInterface(lType)) {
                        this.processFunctionalInterfaceAssignment(lType, rightExpression);
                    } else if (StaticTypeCheckingVisitor.isClosureWithType(lType) && rightExpression instanceof ClosureExpression) {
                        this.storeInferredReturnType(rightExpression, StaticTypeCheckingSupport.getCombinedBoundType(lType.getGenericsTypes()[0]));
                    }
                } else {
                    lType = leftExpression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(leftExpression) ? this.getInferredReturnType(leftExpression) : this.getType(leftExpression);
                }
                rightExpression.visit(this);
            }
            ClassNode rType = StaticTypeCheckingVisitor.isNullConstant(rightExpression) && !ClassHelper.isPrimitiveType(lType) ? StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE : this.getInferredTypeFromTempInfo(rightExpression, this.getType(rightExpression));
            BinaryExpression reversedBinaryExpression = GeneralUtils.binX(rightExpression, expression.getOperation(), leftExpression);
            ClassNode classNode = resultType = op == 573 ? this.getResultType(rType, op, lType, reversedBinaryExpression) : this.getResultType(lType, op, rType, expression);
            if (op == 573) {
                this.storeTargetMethod(expression, (MethodNode)reversedBinaryExpression.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
            } else if (StaticTypeCheckingSupport.isArrayOp(op) && leftExpression instanceof VariableExpression && leftExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE) == null) {
                this.storeType(leftExpression, lType);
            }
            if (resultType == null) {
                resultType = lType;
            }
            if (leftExpression instanceof VariableExpression && (leftVar = (VariableExpression)leftExpression).isClosureSharedVariable()) {
                this.typeCheckingContext.secondPassExpressions.add(new SecondPassExpression(expression));
            }
            if (StaticTypeCheckingSupport.isArrayOp(op) && !lType.isArray() && enclosingBinaryExpression != null && enclosingBinaryExpression.getLeftExpression() == expression && StaticTypeCheckingSupport.isAssignment(enclosingBinaryExpression.getOperation().getType())) {
                Expression enclosingBE_rightExpr = enclosingBinaryExpression.getRightExpression();
                if (!(enclosingBE_rightExpr instanceof ClosureExpression)) {
                    enclosingBE_rightExpr.visit(this);
                }
                ClassNode[] arguments = new ClassNode[]{rType, this.getType(enclosingBE_rightExpr)};
                List<MethodNode> nodes = this.findMethod(lType.redirect(), "putAt", arguments);
                if (nodes.size() == 1) {
                    this.typeCheckMethodsWithGenericsOrFail(lType, arguments, nodes.get(0), enclosingBE_rightExpr);
                } else if (nodes.isEmpty()) {
                    this.addNoMatchingMethodError(lType, "putAt", arguments, enclosingBinaryExpression);
                }
            }
            boolean bl = isEmptyDeclaration = expression instanceof DeclarationExpression && (rightExpression instanceof EmptyExpression || rType == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE);
            if (!isEmptyDeclaration && StaticTypeCheckingSupport.isAssignment(op)) {
                if (rightExpression instanceof ConstructorCallExpression) {
                    this.inferDiamondType((ConstructorCallExpression)rightExpression, lType);
                }
                if (lType.isUsingGenerics() && StaticTypeCheckingSupport.missesGenericsTypes(resultType)) {
                    if (lType.equals(resultType)) {
                        if (!lType.isGenericsPlaceHolder()) {
                            resultType = lType;
                        }
                    } else if (!resultType.isGenericsPlaceHolder()) {
                        HashMap<GenericsType.GenericsTypeName, GenericsType> gt = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                        StaticTypeCheckingSupport.extractGenericsConnections(gt, resultType, resultType.redirect());
                        ClassNode sc = resultType;
                        while ((sc = ClassHelper.getNextSuperClass(sc, lType)) != null && !sc.equals(lType)) {
                        }
                        StaticTypeCheckingSupport.extractGenericsConnections(gt, lType, sc);
                        resultType = StaticTypeCheckingSupport.applyGenericsContext(gt, resultType.redirect());
                    }
                }
                ClassNode originType = this.getOriginalDeclarationType(leftExpression);
                this.typeCheckAssignment(expression, leftExpression, originType, rightExpression, resultType);
                if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(StaticTypeCheckingVisitor.wrapTypeIfNecessary(resultType), StaticTypeCheckingVisitor.wrapTypeIfNecessary(originType))) {
                    resultType = originType;
                } else if (ClassHelper.isPrimitiveType(originType) && resultType.equals(ClassHelper.getWrapper(originType))) {
                    resultType = originType;
                } else {
                    int modifiers = resultType.getModifiers();
                    ClassNode enclosingType = this.typeCheckingContext.getEnclosingClassNode();
                    if (!(Modifier.isPublic(modifiers) || enclosingType.equals(resultType) || StaticTypeCheckingVisitor.getOutermost(enclosingType).equals(StaticTypeCheckingVisitor.getOutermost(resultType)) || !Modifier.isPrivate(modifiers) && Objects.equals(enclosingType.getPackageName(), resultType.getPackageName()))) {
                        resultType = originType;
                    } else if (GenericsUtils.hasUnresolvedGenerics(resultType)) {
                        Map<GenericsType.GenericsTypeName, GenericsType> enclosing = StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext);
                        if (enclosing == null) {
                            enclosing = Collections.emptyMap();
                        }
                        resultType = StaticTypeCheckingSupport.fullyResolveType(resultType, enclosing);
                    }
                }
                if (leftExpression instanceof VariableExpression && this.typeCheckingContext.ifElseForWhileAssignmentTracker != null) {
                    Variable accessedVariable = ((VariableExpression)leftExpression).getAccessedVariable();
                    if (accessedVariable instanceof Parameter) {
                        accessedVariable = new ParameterVariableExpression((Parameter)accessedVariable);
                    }
                    if (accessedVariable instanceof VariableExpression) {
                        this.recordAssignment((VariableExpression)accessedVariable, resultType);
                    }
                }
                this.storeType(leftExpression, resultType);
                if (leftExpression instanceof VariableExpression) {
                    Variable targetVariable;
                    if (rightExpression instanceof ClosureExpression) {
                        Parameter[] parameters = ((ClosureExpression)rightExpression).getParameters();
                        leftExpression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, parameters);
                    } else if (rightExpression instanceof VariableExpression && ((VariableExpression)rightExpression).getAccessedVariable() instanceof Expression && ((Expression)((Object)((VariableExpression)rightExpression).getAccessedVariable())).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS) != null && (targetVariable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)leftExpression)) instanceof ASTNode) {
                        ((ASTNode)((Object)targetVariable)).putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, ((Expression)((Object)((VariableExpression)rightExpression).getAccessedVariable())).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS));
                    }
                }
            } else if (op == 544) {
                this.pushInstanceOfTypeInfo(leftExpression, rightExpression);
            }
            if (!isEmptyDeclaration) {
                this.storeType(expression, resultType);
            }
        }
        finally {
            this.typeCheckingContext.popEnclosingBinaryExpression();
        }
    }

    private boolean ensureValidSetter(Expression expression, Expression leftExpression, Expression rightExpression, final SetterInfo setterInfo) {
        VariableExpression ve = GeneralUtils.varX("%", setterInfo.receiverType);
        ve.setType(setterInfo.receiverType);
        Function<MethodNode, ClassNode> firstParamType = new Function<MethodNode, ClassNode>(){

            @Override
            public ClassNode apply(MethodNode method) {
                ClassNode type = method.getParameters()[0].getOriginType();
                if (!method.isStatic() && !(method instanceof ExtensionMethodNode) && GenericsUtils.hasUnresolvedGenerics(type)) {
                    Map spec = StaticTypeCheckingVisitor.extractPlaceHolders(null, setterInfo.receiverType, method.getDeclaringClass());
                    type = StaticTypeCheckingSupport.applyGenericsContext((Map<GenericsType.GenericsTypeName, GenericsType>)spec, type);
                }
                return type;
            }
        };
        Expression newRightExpression = StaticTypeCheckingVisitor.isCompoundAssignment(expression) ? GeneralUtils.binX(leftExpression, StaticTypeCheckingVisitor.getOpWithoutEqual(expression), rightExpression) : rightExpression;
        MethodCallExpression call = GeneralUtils.callX((Expression)ve, setterInfo.name, newRightExpression);
        call.setImplicitThis(false);
        this.visitMethodCallExpression(call);
        MethodNode directSetterCandidate = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (directSetterCandidate == null) {
            for (MethodNode setter : setterInfo.setters) {
                ClassNode type = ClassHelper.getWrapper((ClassNode)firstParamType.apply(setter));
                if (!ClassHelper.Boolean_TYPE.equals(type) && !ClassHelper.STRING_TYPE.equals(type) && !ClassHelper.CLASS_Type.equals(type)) continue;
                call = GeneralUtils.callX((Expression)ve, setterInfo.name, (Expression)GeneralUtils.castX(type, newRightExpression));
                call.setImplicitThis(false);
                this.visitMethodCallExpression(call);
                directSetterCandidate = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                if (directSetterCandidate == null) continue;
                break;
            }
        }
        if (directSetterCandidate != null) {
            for (MethodNode setter : setterInfo.setters) {
                if (setter != directSetterCandidate) continue;
                leftExpression.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, directSetterCandidate);
                leftExpression.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                ClassNode setterType = (ClassNode)firstParamType.apply(setter);
                this.storeType(leftExpression, setterType);
                break;
            }
            return false;
        }
        ClassNode firstSetterType = (ClassNode)firstParamType.apply(setterInfo.setters.get(0));
        this.addAssignmentError(firstSetterType, this.getType(newRightExpression), expression);
        return true;
    }

    private static boolean isClosureWithType(ClassNode type) {
        return type.equals(ClassHelper.CLOSURE_TYPE) && type.getGenericsTypes() != null && type.getGenericsTypes().length == 1;
    }

    private static boolean isFunctionalInterface(ClassNode type) {
        return type.isInterface() && ClassHelper.isSAMType(type);
    }

    private void processFunctionalInterfaceAssignment(ClassNode lhsType, Expression rhsExpression) {
        if (rhsExpression instanceof ClosureExpression) {
            MethodNode abstractMethod = ClassHelper.findSAM(lhsType);
            Map<GenericsType, GenericsType> mappings = GenericsUtils.makeDeclaringAndActualGenericsTypeMapOfExactType(abstractMethod.getDeclaringClass(), lhsType);
            ClassNode[] samParameterTypes = StaticTypeCheckingVisitor.extractTypesFromParameters(abstractMethod.getParameters());
            for (int i = 0; i < samParameterTypes.length; ++i) {
                if (!samParameterTypes[i].isGenericsPlaceHolder()) continue;
                samParameterTypes[i] = GenericsUtils.findActualTypeByGenericsPlaceholderName(samParameterTypes[i].getUnresolvedName(), mappings);
            }
            Parameter[] closureParameters = ClosureUtils.getParametersSafe((ClosureExpression)rhsExpression);
            if (closureParameters.length == samParameterTypes.length || 1 == samParameterTypes.length && ClosureUtils.hasImplicitParameter((ClosureExpression)rhsExpression)) {
                for (int i = 0; i < closureParameters.length; ++i) {
                    Parameter parameter = closureParameters[i];
                    if (!parameter.isDynamicTyped()) continue;
                    parameter.setType(samParameterTypes[i]);
                    parameter.setOriginType(samParameterTypes[i]);
                }
            } else {
                String descriptor = StaticTypeCheckingSupport.toMethodParametersString(ClassHelper.findSAM(lhsType).getName(), samParameterTypes);
                this.addStaticTypeError("Wrong number of parameters for method target " + descriptor, rhsExpression);
            }
            ClassNode returnType = abstractMethod.getReturnType();
            if (returnType.isGenericsPlaceHolder()) {
                returnType = GenericsUtils.findActualTypeByGenericsPlaceholderName(returnType.getUnresolvedName(), mappings);
            }
            this.storeInferredReturnType(rhsExpression, returnType);
        }
    }

    private static boolean isCompoundAssignment(Expression exp) {
        if (!(exp instanceof BinaryExpression)) {
            return false;
        }
        int type = ((BinaryExpression)exp).getOperation().getType();
        return StaticTypeCheckingSupport.isAssignment(type) && type != 100;
    }

    private static Token getOpWithoutEqual(Expression exp) {
        if (!(exp instanceof BinaryExpression)) {
            return null;
        }
        Token op = ((BinaryExpression)exp).getOperation();
        int typeWithoutEqual = TokenUtil.removeAssignment(op.getType());
        return new Token(typeWithoutEqual, op.getText(), op.getStartLine(), op.getStartColumn());
    }

    protected ClassNode getOriginalDeclarationType(Expression lhs) {
        if (lhs instanceof VariableExpression) {
            Variable var = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)lhs);
            if (!(var instanceof DynamicVariable) && !(var instanceof PropertyNode)) {
                return var.getOriginType();
            }
        } else if (lhs instanceof FieldExpression) {
            return ((FieldExpression)lhs).getField().getOriginType();
        }
        return this.getType(lhs);
    }

    protected void inferDiamondType(ConstructorCallExpression cce, ClassNode lType) {
        ClassNode cceType = cce.getType();
        ClassNode inferredType = lType;
        if (cceType.getGenericsTypes() != null && cceType.getGenericsTypes().length == 0) {
            ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(cce.getArguments());
            ConstructorNode constructor = (ConstructorNode)cce.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            if (constructor != null && !argumentList.getExpressions().isEmpty()) {
                ClassNode type = GenericsUtils.parameterizeType(cceType, cceType);
                type = this.inferReturnTypeGenerics(type, constructor, argumentList);
                if (lType.getGenericsTypes() != null && StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(lType, type, cce) && !GenericsUtils.buildWildcardType(lType).isCompatibleWith(type)) {
                    ClassNode pType = GenericsUtils.parameterizeType(lType, type);
                    GenericsType[] lhs = pType.getGenericsTypes();
                    GenericsType[] rhs = type.getGenericsTypes();
                    if (lhs == null || rhs == null || lhs.length != rhs.length) {
                        throw new GroovyBugError("Parameterization failed: " + StaticTypeCheckingSupport.prettyPrintType(pType) + " ~ " + StaticTypeCheckingSupport.prettyPrintType(type));
                    }
                    boolean allMatch = true;
                    int n = lhs.length;
                    for (int i = 0; i < n && allMatch; ++i) {
                        if (GenericsUtils.buildWildcardType(StaticTypeCheckingSupport.getCombinedBoundType(lhs[i])).isCompatibleWith(StaticTypeCheckingSupport.getCombinedBoundType(rhs[i]))) continue;
                        allMatch = false;
                    }
                    if (allMatch) {
                        type = pType;
                    }
                }
                inferredType = type;
            }
            if (inferredType.isGenericsPlaceHolder()) {
                inferredType = StaticTypeCheckingSupport.getCombinedBoundType(inferredType.getGenericsTypes()[0]);
            }
            this.adjustGenerics(inferredType, cceType);
            this.storeType(cce, cceType);
        }
    }

    private void adjustGenerics(ClassNode source, ClassNode target) {
        GenericsType[] genericsTypes = source.getGenericsTypes();
        if (genericsTypes == null) {
            genericsTypes = target.redirect().getGenericsTypes();
        }
        GenericsType[] copy = new GenericsType[genericsTypes.length];
        for (int i = 0; i < genericsTypes.length; ++i) {
            GenericsType genericsType = genericsTypes[i];
            copy[i] = new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(genericsType.getType()), genericsType.getUpperBounds(), genericsType.getLowerBound());
        }
        target.setGenericsTypes(copy);
    }

    protected void pushInstanceOfTypeInfo(Expression objectOfInstanceOf, Expression typeExpression) {
        Object key;
        Map<Object, List<ClassNode>> tempo = this.typeCheckingContext.temporaryIfBranchTypeInformation.peek();
        List<ClassNode> potentialTypes = tempo.get(key = this.extractTemporaryTypeInfoKey(objectOfInstanceOf));
        if (potentialTypes == null) {
            potentialTypes = new LinkedList<ClassNode>();
            tempo.put(key, potentialTypes);
        }
        potentialTypes.add(typeExpression.getType());
    }

    private boolean typeCheckMultipleAssignmentAndContinue(Expression leftExpression, Expression rightExpression) {
        if (!(leftExpression instanceof TupleExpression)) {
            return true;
        }
        if (!(rightExpression instanceof ListExpression)) {
            this.addStaticTypeError("Multiple assignments without list expressions on the right hand side are unsupported in static type checking mode", rightExpression);
            return false;
        }
        TupleExpression tuple = (TupleExpression)leftExpression;
        ListExpression list = (ListExpression)rightExpression;
        List<Expression> listExpressions = list.getExpressions();
        List<Expression> tupleExpressions = tuple.getExpressions();
        if (listExpressions.size() < tupleExpressions.size()) {
            this.addStaticTypeError("Incorrect number of values. Expected:" + tupleExpressions.size() + " Was:" + listExpressions.size(), list);
            return false;
        }
        int tupleExpressionsSize = tupleExpressions.size();
        for (int i = 0; i < tupleExpressionsSize; ++i) {
            ClassNode tupleType;
            Expression tupleExpression = tupleExpressions.get(i);
            Expression listExpression = listExpressions.get(i);
            ClassNode elemType = this.getType(listExpression);
            if (!StaticTypeCheckingSupport.isAssignableTo(elemType, tupleType = this.getType(tupleExpression))) {
                this.addStaticTypeError("Cannot assign value of type " + elemType.toString(false) + " to variable of type " + tupleType.toString(false), rightExpression);
                return false;
            }
            this.storeType(tupleExpression, elemType);
        }
        return true;
    }

    private static ClassNode adjustTypeForSpreading(ClassNode inferredRightExpressionType, Expression leftExpression) {
        ClassNode wrappedRHS = inferredRightExpressionType;
        if (leftExpression instanceof PropertyExpression && ((PropertyExpression)leftExpression).isSpreadSafe()) {
            wrappedRHS = ClassHelper.LIST_TYPE.getPlainNodeReference();
            wrappedRHS.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(inferredRightExpressionType))});
        }
        return wrappedRHS;
    }

    private boolean addedReadOnlyPropertyError(Expression expr) {
        if (expr.getNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY) == null) {
            return false;
        }
        String name = expr instanceof VariableExpression ? ((VariableExpression)expr).getName() : ((PropertyExpression)expr).getPropertyAsString();
        this.addStaticTypeError("Cannot set read-only property: " + name, expr);
        return true;
    }

    private void addPrecisionErrors(ClassNode leftRedirect, ClassNode lhsType, ClassNode rhsType, Expression rightExpression) {
        ClassNode rightComponentType;
        ClassNode leftComponentType;
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rhsType) && StaticTypeCheckingSupport.checkPossibleLossOfPrecision(leftRedirect, rhsType, rightExpression)) {
            this.addStaticTypeError("Possible loss of precision from " + rhsType.toString(false) + " to " + lhsType.toString(false), rightExpression);
            return;
        }
        if (!leftRedirect.isArray()) {
            return;
        }
        if (rightExpression instanceof ListExpression) {
            ClassNode leftComponentType2 = leftRedirect.getComponentType();
            for (Expression expression : ((ListExpression)rightExpression).getExpressions()) {
                ClassNode rightComponentType2 = this.getType(expression);
                if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType2, rightComponentType2) || StaticTypeCheckingVisitor.isNullConstant(expression) && !ClassHelper.isPrimitiveType(leftComponentType2)) continue;
                this.addStaticTypeError("Cannot assign value of type " + rightComponentType2.toString(false) + " into array of type " + lhsType.toString(false), rightExpression);
            }
        } else if (rhsType.redirect().isArray() && !StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType = leftRedirect.getComponentType(), rightComponentType = rhsType.redirect().getComponentType())) {
            this.addStaticTypeError("Cannot assign value of type " + rightComponentType.toString(false) + " into array of type " + lhsType.toString(false), rightExpression);
        }
    }

    private void addListAssignmentConstructorErrors(ClassNode leftRedirect, ClassNode leftExpressionType, ClassNode inferredRightExpressionType, Expression rightExpression, Expression assignmentExpression) {
        if (rightExpression instanceof ListExpression && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.LIST_TYPE, leftRedirect)) {
            ArgumentListExpression argList = GeneralUtils.args(((ListExpression)rightExpression).getExpressions());
            ClassNode[] args = this.getArgumentTypes(argList);
            MethodNode methodNode = this.checkGroovyStyleConstructor(leftRedirect, args, assignmentExpression);
            if (methodNode != null) {
                rightExpression.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, methodNode);
            }
        } else if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, leftRedirect) && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, ClassHelper.LIST_TYPE) && !StaticTypeCheckingSupport.isWildcardLeftHandSide(leftExpressionType) && !this.extension.handleIncompatibleAssignment(leftExpressionType, inferredRightExpressionType, assignmentExpression)) {
            this.addAssignmentError(leftExpressionType, inferredRightExpressionType, assignmentExpression);
        }
    }

    private void addMapAssignmentConstructorErrors(ClassNode leftRedirect, Expression leftExpression, Expression rightExpression) {
        if (!(rightExpression instanceof MapExpression) || leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).isDynamicTyped() || leftRedirect.equals(ClassHelper.OBJECT_TYPE) || StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(leftRedirect, ClassHelper.MAP_TYPE)) {
            return;
        }
        ClassNode[] argTypes = this.getArgumentTypes(GeneralUtils.args(rightExpression));
        this.checkGroovyStyleConstructor(leftRedirect, argTypes, rightExpression);
        MapExpression mapExpression = (MapExpression)rightExpression;
        this.checkGroovyConstructorMap(leftExpression, leftRedirect, mapExpression);
    }

    private void checkTypeGenerics(ClassNode leftExpressionType, ClassNode rightExpressionType, Expression rightExpression) {
        if (!(!leftExpressionType.isUsingGenerics() || StaticTypeCheckingSupport.missesGenericsTypes(rightExpressionType) || StaticTypeCheckingVisitor.isNullConstant(rightExpression) || StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE.equals(rightExpressionType) || GenericsUtils.buildWildcardType(leftExpressionType).isCompatibleWith(StaticTypeCheckingVisitor.wrapTypeIfNecessary(rightExpressionType)))) {
            this.addStaticTypeError("Incompatible generic argument types. Cannot assign " + StaticTypeCheckingSupport.prettyPrintType(rightExpressionType) + " to: " + StaticTypeCheckingSupport.prettyPrintType(leftExpressionType), rightExpression);
        }
    }

    private boolean hasGStringStringError(ClassNode leftExpressionType, ClassNode rightExpressionType, Expression rightExpression) {
        if (StaticTypeCheckingSupport.isParameterizedWithString(leftExpressionType) && StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(rightExpressionType)) {
            this.addStaticTypeError("You are trying to use a GString in place of a String in a type which explicitly declares accepting String. Make sure to call toString() on all GString values.", rightExpression);
            return true;
        }
        return false;
    }

    protected void typeCheckAssignment(BinaryExpression assignmentExpression, Expression leftExpression, ClassNode leftExpressionType, Expression rightExpression, ClassNode rightExpressionType) {
        if (!this.typeCheckMultipleAssignmentAndContinue(leftExpression, rightExpression)) {
            return;
        }
        if (this.addedReadOnlyPropertyError(leftExpression)) {
            return;
        }
        ClassNode rTypeInferred = rightExpression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(rightExpression) && assignmentExpression.getOperation().getType() == 100 ? this.getInferredReturnType(rightExpression) : rightExpressionType;
        ClassNode rTypeAdjusted = StaticTypeCheckingVisitor.adjustTypeForSpreading(rTypeInferred, leftExpression);
        if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftExpressionType, rTypeAdjusted, rightExpression)) {
            if (!this.extension.handleIncompatibleAssignment(leftExpressionType, rTypeAdjusted, assignmentExpression)) {
                this.addAssignmentError(leftExpressionType, rTypeInferred, rightExpression);
            }
        } else {
            ClassNode lTypeRedirect = leftExpressionType.redirect();
            this.addPrecisionErrors(lTypeRedirect, leftExpressionType, rTypeAdjusted, rightExpression);
            this.addListAssignmentConstructorErrors(lTypeRedirect, leftExpressionType, rTypeInferred, rightExpression, assignmentExpression);
            this.addMapAssignmentConstructorErrors(lTypeRedirect, leftExpression, rightExpression);
            if (!this.hasGStringStringError(leftExpressionType, rTypeAdjusted, rightExpression)) {
                this.checkTypeGenerics(leftExpressionType, rTypeAdjusted, rightExpression);
            }
        }
    }

    protected void checkGroovyConstructorMap(Expression receiver, ClassNode receiverType, MapExpression mapExpression) {
        this.typeCheckingContext.pushEnclosingBinaryExpression(null);
        for (MapEntryExpression entryExpression : mapExpression.getMapEntryExpressions()) {
            Expression keyExpression = entryExpression.getKeyExpression();
            if (!(keyExpression instanceof ConstantExpression)) {
                this.addStaticTypeError("Dynamic keys in map-style constructors are unsupported in static type checking", keyExpression);
                continue;
            }
            String propName = keyExpression.getText();
            PropertyLookup requestor = new PropertyLookup(receiverType);
            if (!this.existsProperty(new PropertyExpression((Expression)GeneralUtils.varX("_", receiverType), propName), false, requestor)) {
                this.addStaticTypeError("No such property: " + propName + " for class: " + StaticTypeCheckingSupport.prettyPrintTypeName(receiverType), receiver);
                continue;
            }
            ClassNode targetType = requestor.propertyType;
            Expression valueExpression = entryExpression.getValueExpression();
            ClassNode valueType = this.getType(valueExpression);
            ClassNode resultType = this.getResultType(targetType, 100, valueType, StaticTypeCheckingVisitor.assignX(keyExpression, valueExpression, entryExpression));
            if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(targetType, resultType, valueExpression) || this.extension.handleIncompatibleAssignment(targetType, valueType, entryExpression)) continue;
            this.addAssignmentError(targetType, valueType, entryExpression);
        }
        this.typeCheckingContext.popEnclosingBinaryExpression();
    }

    @Deprecated
    protected static boolean hasRHSIncompleteGenericTypeInfo(ClassNode inferredRightExpressionType) {
        boolean replaceType = false;
        GenericsType[] genericsTypes = inferredRightExpressionType.getGenericsTypes();
        if (genericsTypes != null) {
            for (GenericsType genericsType : genericsTypes) {
                if (!genericsType.isPlaceholder()) continue;
                replaceType = true;
                break;
            }
        }
        return replaceType;
    }

    @Deprecated
    protected void checkGroovyStyleConstructor(ClassNode node, ClassNode[] arguments) {
        this.checkGroovyStyleConstructor(node, arguments, this.typeCheckingContext.getEnclosingClassNode());
    }

    protected MethodNode checkGroovyStyleConstructor(ClassNode node, ClassNode[] arguments, ASTNode source) {
        if (node.equals(ClassHelper.OBJECT_TYPE) || node.equals(ClassHelper.DYNAMIC_TYPE)) {
            return null;
        }
        List<ConstructorNode> constructors = node.getDeclaredConstructors();
        if (constructors.isEmpty() && arguments.length == 0) {
            return null;
        }
        List<MethodNode> constructorList = this.findMethod(node, "<init>", arguments);
        if (constructorList.isEmpty()) {
            if (StaticTypeCheckingSupport.isBeingCompiled(node) && arguments.length == 1 && LINKEDHASHMAP_CLASSNODE.equals(arguments[0])) {
                ConstructorNode cn = new ConstructorNode(1, new Parameter[]{new Parameter(LINKEDHASHMAP_CLASSNODE, "args")}, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                return cn;
            }
            this.addStaticTypeError("No matching constructor found: " + node + StaticTypeCheckingSupport.toMethodParametersString("<init>", arguments), source);
            return null;
        }
        if (constructorList.size() > 1) {
            this.addStaticTypeError("Ambiguous constructor call " + node + StaticTypeCheckingSupport.toMethodParametersString("<init>", arguments), source);
            return null;
        }
        return constructorList.get(0);
    }

    protected Object extractTemporaryTypeInfoKey(Expression expression) {
        return expression instanceof VariableExpression ? StaticTypeCheckingSupport.findTargetVariable((VariableExpression)expression) : expression.getText();
    }

    protected ClassNode findCurrentInstanceOfClass(Expression expr, ClassNode type) {
        List<ClassNode> nodes;
        if (!this.typeCheckingContext.temporaryIfBranchTypeInformation.isEmpty() && (nodes = this.getTemporaryTypesForExpression(expr)) != null && nodes.size() == 1) {
            return nodes.get(0);
        }
        return type;
    }

    protected boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly) {
        return this.existsProperty(pexp, checkForReadOnly, null);
    }

    protected boolean existsProperty(PropertyExpression pexp, boolean readMode, ClassCodeVisitorSupport visitor) {
        ClassNode receiverType;
        super.visitPropertyExpression(pexp);
        String propertyName = pexp.getPropertyAsString();
        if (propertyName == null) {
            return false;
        }
        Expression objectExpression = pexp.getObjectExpression();
        ClassNode objectExpressionType = this.getType(objectExpression);
        if (objectExpression instanceof ConstructorCallExpression) {
            ClassNode rawType = objectExpressionType.getPlainNodeReference();
            this.inferDiamondType((ConstructorCallExpression)objectExpression, rawType);
        }
        List<ClassNode> enclosingTypes = this.typeCheckingContext.getEnclosingClassNodes();
        boolean staticOnlyAccess = StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(objectExpressionType);
        if ("this".equals(propertyName) && staticOnlyAccess) {
            ClassNode outerNode = objectExpressionType.getGenericsTypes()[0].getType();
            ClassNode found = null;
            for (ClassNode enclosingType : enclosingTypes) {
                if (enclosingType.isStaticClass() || !outerNode.equals(enclosingType.getOuterClass())) continue;
                found = enclosingType;
                break;
            }
            if (found != null) {
                this.storeType(pexp, outerNode);
                return true;
            }
        }
        boolean foundGetterOrSetter = false;
        ArrayList<Receiver<String>> receivers = new ArrayList<Receiver<String>>();
        this.addReceivers(receivers, this.makeOwnerList(objectExpression), pexp.isImplicitThis());
        String capName = MetaClassHelper.capitalize(propertyName);
        String isserName = "is" + capName;
        String getterName = "get" + capName;
        String setterName = "set" + capName;
        boolean isAttributeExpression = pexp instanceof AttributeExpression;
        HashSet<ClassNode[]> handledNodes = new HashSet<ClassNode[]>();
        for (Receiver receiver : receivers) {
            ClassNode[] classNodeArray;
            receiverType = receiver.getType();
            if (receiverType.isArray() && "length".equals(propertyName)) {
                this.storeType(pexp, ClassHelper.int_TYPE);
                if (visitor != null) {
                    FieldNode length = new FieldNode("length", 17, ClassHelper.int_TYPE, receiverType, null);
                    length.setDeclaringClass(receiverType);
                    visitor.visitField(length);
                }
                return true;
            }
            LinkedList<ClassNode> queue = new LinkedList<ClassNode>();
            queue.add(receiverType);
            if (ClassHelper.isPrimitiveType(receiverType)) {
                queue.add(ClassHelper.getWrapper(receiverType));
            }
            while (!queue.isEmpty()) {
                boolean checkGetterOrSetter;
                boolean staticOnly;
                ClassNode[] current = (ClassNode[])queue.removeFirst();
                if (!handledNodes.add(current)) continue;
                FieldNode field = current.getDeclaredField(propertyName);
                if (field == null) {
                    if (current.getSuperClass() != null) {
                        queue.addFirst(current.getUnresolvedSuperClass());
                    }
                    for (ClassNode face : current.getAllInterfaces()) {
                        queue.add(GenericsUtils.parameterizeType((ClassNode)current, face));
                    }
                }
                boolean bl = staticOnly = receiver.getData() == null ? staticOnlyAccess : false;
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType((ClassNode)current)) {
                    staticOnly = false;
                }
                if (this.storeField(field = this.allowStaticAccessToMember(field, staticOnly), isAttributeExpression, pexp, receiverType, visitor, (String)receiver.getData(), !readMode)) {
                    pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                    return true;
                }
                if (isAttributeExpression) continue;
                if (this.storeField(field, enclosingTypes.contains(current), pexp, receiverType, visitor, (String)receiver.getData(), !readMode)) {
                    pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                    return true;
                }
                MethodNode getter = StaticTypeCheckingVisitor.findGetter((ClassNode)current, getterName, pexp.isImplicitThis());
                if ((getter = this.allowStaticAccessToMember(getter, staticOnly)) == null) {
                    getter = StaticTypeCheckingVisitor.findGetter((ClassNode)current, isserName, pexp.isImplicitThis());
                }
                getter = this.allowStaticAccessToMember(getter, staticOnly);
                List<MethodNode> setters = StaticTypeCheckingSupport.findSetters((ClassNode)current, setterName, false);
                setters = this.allowStaticAccessToMember(setters, staticOnly);
                if (readMode && getter != null && visitor != null) {
                    visitor.visitMethod(getter);
                }
                Object propertyNode = current.getProperty(propertyName);
                boolean bl2 = checkGetterOrSetter = (propertyNode = (PropertyNode)this.allowStaticAccessToMember(propertyNode, staticOnly)) == null || !enclosingTypes.contains(receiverType);
                if (readMode && checkGetterOrSetter) {
                    if (getter != null) {
                        ClassNode cn = this.inferReturnTypeGenerics((ClassNode)current, getter, ArgumentListExpression.EMPTY_ARGUMENTS);
                        this.storeInferredTypeForPropertyExpression(pexp, cn);
                        this.storeTargetMethod(pexp, getter);
                        pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                        String delegationData = (String)receiver.getData();
                        if (delegationData != null) {
                            pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
                        }
                        return true;
                    }
                } else if (!readMode && checkGetterOrSetter) {
                    if (!setters.isEmpty()) {
                        if (visitor != null) {
                            for (MethodNode setter : setters) {
                                FieldNode virtual = new FieldNode(propertyName, 0, setter.getParameters()[0].getOriginType(), (ClassNode)current, null);
                                virtual.setDeclaringClass(setter.getDeclaringClass());
                                visitor.visitField(virtual);
                            }
                        }
                        SetterInfo info = new SetterInfo((ClassNode)current, setterName, setters);
                        BinaryExpression enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
                        if (enclosingBinaryExpression != null) {
                            StaticTypeCheckingVisitor.putSetterInfo(enclosingBinaryExpression.getLeftExpression(), info);
                        }
                        pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                        String delegationData = (String)receiver.getData();
                        if (delegationData != null) {
                            pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
                        }
                        return true;
                    }
                    if (propertyNode == null) {
                        if (field != null && StaticTypeCheckingVisitor.hasAccessToField(field, this.typeCheckingContext.getEnclosingClassNode())) {
                            pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                        } else if (getter != null) {
                            pexp.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, Boolean.TRUE);
                        }
                    }
                }
                boolean bl3 = foundGetterOrSetter = foundGetterOrSetter || !setters.isEmpty() || getter != null;
                if (this.storeProperty((PropertyNode)propertyNode, pexp, receiverType, visitor, (String)receiver.getData())) {
                    return true;
                }
                if (!this.storeField(field, true, pexp, receiverType, visitor, (String)receiver.getData(), !readMode)) continue;
                return true;
            }
            if (ClassHelper.isPrimitiveType(receiverType)) {
                ClassNode[] classNodeArray2 = new ClassNode[2];
                classNodeArray2[0] = receiverType;
                classNodeArray = classNodeArray2;
                classNodeArray2[1] = ClassHelper.getWrapper(receiverType);
            } else {
                ClassNode[] classNodeArray3 = new ClassNode[1];
                classNodeArray = classNodeArray3;
                classNodeArray3[0] = receiverType;
            }
            for (ClassNode dgmReceiver : classNodeArray) {
                List<MethodNode> methodNodes;
                List<MethodNode> methods = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(this.getSourceUnit().getClassLoader(), dgmReceiver, getterName, ClassNode.EMPTY_ARRAY);
                for (MethodNode m : StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(this.getSourceUnit().getClassLoader(), dgmReceiver, isserName, ClassNode.EMPTY_ARRAY)) {
                    if (!ClassHelper.Boolean_TYPE.equals(ClassHelper.getWrapper(m.getReturnType()))) continue;
                    methods.add(m);
                }
                if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(dgmReceiver)) {
                    Iterator<MethodNode> it = methods.iterator();
                    while (it.hasNext()) {
                        MethodNode method = it.next();
                        if (StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(dgmReceiver, ClassNode.EMPTY_ARRAY, method)) continue;
                        it.remove();
                    }
                }
                if (methods.isEmpty() || (methodNodes = StaticTypeCheckingSupport.chooseBestMethod(dgmReceiver, methods, ClassNode.EMPTY_ARRAY)).size() != 1) continue;
                MethodNode getter = methodNodes.get(0);
                if (visitor != null) {
                    visitor.visitMethod(getter);
                }
                ClassNode cn = this.inferReturnTypeGenerics(dgmReceiver, getter, ArgumentListExpression.EMPTY_ARGUMENTS);
                this.storeInferredTypeForPropertyExpression(pexp, cn);
                if (readMode) {
                    this.storeTargetMethod(pexp, getter);
                }
                return true;
            }
            if (receiverType.isArray() || ClassHelper.isPrimitiveType(ClassHelper.getUnwrapper(receiverType)) || !pexp.isImplicitThis() || this.typeCheckingContext.getEnclosingClosure() == null) continue;
            MethodNode mopMethod = readMode ? receiverType.getMethod("get", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name")}) : receiverType.getMethod("set", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "value")});
            if (mopMethod == null) {
                mopMethod = receiverType.getMethod("propertyMissing", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "propertyName")});
            }
            if (mopMethod == null || mopMethod.isStatic() || mopMethod.isSynthetic()) continue;
            pexp.putNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION, Boolean.TRUE);
            pexp.removeNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            pexp.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            visitor.visitMethod(mopMethod);
            return true;
        }
        for (Receiver receiver : receivers) {
            receiverType = receiver.getType();
            ClassNode propertyType = this.getTypeForMapPropertyExpression(receiverType, objectExpressionType, pexp);
            if (propertyType == null) {
                propertyType = this.getTypeForListPropertyExpression(receiverType, objectExpressionType, pexp);
            }
            if (propertyType == null) {
                propertyType = this.getTypeForSpreadExpression(receiverType, objectExpressionType, pexp);
            }
            if (propertyType == null) continue;
            if (visitor != null) {
                PropertyNode node = new PropertyNode(propertyName, 1, propertyType, receiverType, null, null, null);
                node.setDeclaringClass(receiverType);
                visitor.visitProperty(node);
            }
            this.storeType(pexp, propertyType);
            String delegationData = (String)receiver.getData();
            if (delegationData != null) {
                pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
            }
            return true;
        }
        return foundGetterOrSetter;
    }

    private static boolean hasAccessToField(FieldNode field, ClassNode accessor) {
        if (field.isPublic() || accessor.equals(field.getDeclaringClass())) {
            return true;
        }
        if (field.isProtected()) {
            return accessor.isDerivedFrom(field.getDeclaringClass());
        }
        return !field.isPrivate() && Objects.equals(accessor.getPackageName(), field.getDeclaringClass().getPackageName());
    }

    private static MethodNode findGetter(ClassNode current, String name, boolean searchOuterClasses) {
        MethodNode getterMethod = current.getGetterMethod(name);
        if (getterMethod == null && searchOuterClasses && current instanceof InnerClassNode) {
            return StaticTypeCheckingVisitor.findGetter(current.getOuterClass(), name, true);
        }
        return getterMethod;
    }

    private ClassNode getTypeForSpreadExpression(ClassNode testClass, ClassNode objectExpressionType, PropertyExpression pexp) {
        if (pexp.isSpreadSafe()) {
            MethodCallExpression mce = GeneralUtils.callX(GeneralUtils.varX("_", testClass), "iterator");
            mce.setImplicitThis(false);
            mce.visit(this);
            ClassNode iteratorType = this.getType(mce);
            if (GeneralUtils.isOrImplements(iteratorType, ClassHelper.Iterator_TYPE)) {
                GenericsType[] gts = iteratorType.getGenericsTypes();
                ClassNode itemType = gts != null && gts.length == 1 ? StaticTypeCheckingSupport.getCombinedBoundType(gts[0]) : ClassHelper.OBJECT_TYPE;
                PropertyLookup requestor = new PropertyLookup(itemType);
                if (this.existsProperty(new PropertyExpression((Expression)GeneralUtils.varX("{}", itemType), pexp.getPropertyAsString()), true, requestor)) {
                    return GenericsUtils.makeClassSafe0(ClassHelper.LIST_TYPE, new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(requestor.propertyType)));
                }
            }
        }
        return null;
    }

    private ClassNode getTypeForListPropertyExpression(ClassNode testClass, ClassNode objectExpressionType, PropertyExpression pexp) {
        if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(testClass, ClassHelper.LIST_TYPE)) {
            ClassNode listType = GenericsUtils.parameterizeType(objectExpressionType, ClassHelper.LIST_TYPE.getPlainNodeReference());
            GenericsType[] gts = listType.getGenericsTypes();
            ClassNode itemType = gts != null && gts.length == 1 ? gts[0].getType() : ClassHelper.OBJECT_TYPE;
            PropertyLookup requestor = new PropertyLookup(itemType);
            if (this.existsProperty(new PropertyExpression((Expression)GeneralUtils.varX("{}", itemType), pexp.getPropertyAsString()), true, requestor)) {
                return GenericsUtils.makeClassSafe0(ClassHelper.LIST_TYPE, new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(requestor.propertyType)));
            }
        }
        return null;
    }

    private ClassNode getTypeForMapPropertyExpression(ClassNode testClass, ClassNode objectExpressionType, PropertyExpression pexp) {
        if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(testClass, ClassHelper.MAP_TYPE)) {
            return null;
        }
        ClassNode intf = objectExpressionType.getGenericsTypes() != null ? GenericsUtils.parameterizeType(objectExpressionType, ClassHelper.MAP_TYPE.getPlainNodeReference()) : ClassHelper.MAP_TYPE.getPlainNodeReference();
        GenericsType[] types = intf.getGenericsTypes();
        if (types == null || types.length != 2) {
            return ClassHelper.OBJECT_TYPE;
        }
        if (pexp.isSpreadSafe()) {
            if ("key".equals(pexp.getPropertyAsString())) {
                ClassNode listKey = ClassHelper.LIST_TYPE.getPlainNodeReference();
                listKey.setGenericsTypes(new GenericsType[]{types[0]});
                return listKey;
            }
            if ("value".equals(pexp.getPropertyAsString())) {
                ClassNode listValue = ClassHelper.LIST_TYPE.getPlainNodeReference();
                listValue.setGenericsTypes(new GenericsType[]{types[1]});
                return listValue;
            }
        } else {
            return types[1].getType();
        }
        this.addStaticTypeError("Spread operator on map only allows one of [key,value]", pexp);
        return null;
    }

    private <T> T allowStaticAccessToMember(T member, boolean staticOnly) {
        boolean isStatic;
        if (member == null) {
            return null;
        }
        if (!staticOnly) {
            return member;
        }
        if (member instanceof Variable) {
            Variable v = (Variable)member;
            isStatic = Modifier.isStatic(v.getModifiers());
        } else {
            if (member instanceof List) {
                List list = (List)member;
                if (list.size() == 1) {
                    return (T)Collections.singletonList(this.allowStaticAccessToMember(list.get(0), staticOnly));
                }
                return (T)Collections.emptyList();
            }
            MethodNode mn = (MethodNode)member;
            isStatic = mn.isStatic();
        }
        if (staticOnly && !isStatic) {
            return null;
        }
        return member;
    }

    private void storeWithResolve(ClassNode typeToResolve, ClassNode receiver, ClassNode declaringClass, boolean isStatic, PropertyExpression expressionToStoreOn) {
        ClassNode type = typeToResolve;
        if (StaticTypeCheckingSupport.getGenericsWithoutArray(type) != null) {
            Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = StaticTypeCheckingVisitor.resolvePlaceHoldersFromDeclaration(receiver, declaringClass, null, isStatic);
            type = this.resolveGenericsWithContext(resolvedPlaceholders, type);
        }
        this.storeInferredTypeForPropertyExpression(expressionToStoreOn, type);
        this.storeType(expressionToStoreOn, type);
    }

    private boolean storeField(FieldNode field, boolean returnTrueIfFieldExists, PropertyExpression expressionToStoreOn, ClassNode receiver, ClassCodeVisitorSupport visitor, String delegationData, boolean lhsOfAssignment) {
        if (field == null || !returnTrueIfFieldExists) {
            return false;
        }
        if (visitor != null) {
            visitor.visitField(field);
        }
        this.checkOrMarkPrivateAccess(expressionToStoreOn, field, lhsOfAssignment);
        this.storeWithResolve(field.getOriginType(), receiver, field.getDeclaringClass(), field.isStatic(), expressionToStoreOn);
        if (delegationData != null) {
            expressionToStoreOn.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
        }
        return true;
    }

    private boolean storeProperty(PropertyNode property, PropertyExpression expressionToStoreOn, ClassNode receiver, ClassCodeVisitorSupport visitor, String delegationData) {
        if (property == null) {
            return false;
        }
        if (visitor != null) {
            visitor.visitProperty(property);
        }
        this.storeWithResolve(property.getOriginType(), receiver, property.getDeclaringClass(), property.isStatic(), expressionToStoreOn);
        if (delegationData != null) {
            expressionToStoreOn.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
        }
        return true;
    }

    protected void storeInferredTypeForPropertyExpression(PropertyExpression pexp, ClassNode flatInferredType) {
        if (pexp.isSpreadSafe()) {
            ClassNode list = ClassHelper.LIST_TYPE.getPlainNodeReference();
            list.setGenericsTypes(new GenericsType[]{new GenericsType(flatInferredType)});
            this.storeType(pexp, list);
        } else {
            this.storeType(pexp, flatInferredType);
        }
    }

    @Deprecated
    protected SetterInfo hasSetter(PropertyExpression pexp) {
        String propertyName = pexp.getPropertyAsString();
        if (propertyName == null) {
            return null;
        }
        Expression objectExpression = pexp.getObjectExpression();
        LinkedList<Receiver<String>> receivers = new LinkedList<Receiver<String>>();
        List<Receiver<String>> owners = this.makeOwnerList(objectExpression);
        this.addReceivers(receivers, owners, pexp.isImplicitThis());
        String capName = MetaClassHelper.capitalize(propertyName);
        boolean isAttributeExpression = pexp instanceof AttributeExpression;
        for (Receiver receiver : receivers) {
            ClassNode testClass = receiver.getType();
            LinkedList<ClassNode> queue = new LinkedList<ClassNode>();
            queue.add(testClass);
            if (testClass.isInterface()) {
                queue.addAll(testClass.getAllInterfaces());
            }
            while (!queue.isEmpty()) {
                String setterName;
                ClassNode current = (ClassNode)queue.removeFirst();
                List<MethodNode> setterMethods = StaticTypeCheckingSupport.findSetters(current = current.redirect(), setterName = "set" + capName, false);
                if (!setterMethods.isEmpty()) {
                    return new SetterInfo(current, setterName, setterMethods);
                }
                if (isAttributeExpression || current.getSuperClass() == null) continue;
                queue.add(current.getSuperClass());
            }
        }
        return null;
    }

    @Override
    public void visitProperty(PropertyNode node) {
        boolean osc = this.typeCheckingContext.isInStaticContext;
        try {
            this.typeCheckingContext.isInStaticContext = node.isInStaticContext();
            this.currentProperty = node;
            this.visitAnnotations(node);
            this.visitClassCodeContainer(node.getGetterBlock());
            this.visitClassCodeContainer(node.getSetterBlock());
        }
        finally {
            this.currentProperty = null;
            this.typeCheckingContext.isInStaticContext = osc;
        }
    }

    @Override
    public void visitField(FieldNode node) {
        boolean osc = this.typeCheckingContext.isInStaticContext;
        try {
            this.typeCheckingContext.isInStaticContext = node.isInStaticContext();
            this.currentField = node;
            this.visitAnnotations(node);
            this.visitInitialExpression(node.getInitialExpression(), new FieldExpression(node), node);
        }
        finally {
            this.currentField = null;
            this.typeCheckingContext.isInStaticContext = osc;
        }
    }

    private void visitInitialExpression(Expression value, Expression target, ASTNode position) {
        if (value != null) {
            ClassNode lType = target.getType();
            if (StaticTypeCheckingVisitor.isFunctionalInterface(lType)) {
                this.processFunctionalInterfaceAssignment(lType, value);
            } else if (StaticTypeCheckingVisitor.isClosureWithType(lType) && value instanceof ClosureExpression) {
                this.storeInferredReturnType(value, StaticTypeCheckingSupport.getCombinedBoundType(lType.getGenericsTypes()[0]));
            }
            this.typeCheckingContext.pushEnclosingBinaryExpression(StaticTypeCheckingVisitor.assignX(target, value, position));
            value.visit(this);
            ClassNode rType = this.getType(value);
            if (value instanceof ConstructorCallExpression) {
                this.inferDiamondType((ConstructorCallExpression)value, lType);
            }
            BinaryExpression dummy = this.typeCheckingContext.popEnclosingBinaryExpression();
            this.typeCheckAssignment(dummy, target, lType, value, this.getResultType(lType, 100, rType, dummy));
        }
    }

    private static BinaryExpression assignX(Expression lhs, Expression rhs, ASTNode pos) {
        BinaryExpression exp = (BinaryExpression)GeneralUtils.assignX(lhs, rhs);
        exp.setSourcePosition(pos);
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitForLoop(ForStatement forLoop) {
        HashMap<VariableExpression, ClassNode> varOrigType = new HashMap<VariableExpression, ClassNode>();
        forLoop.getLoopBlock().visit(new VariableExpressionTypeMemoizer(varOrigType));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        Expression collectionExpression = forLoop.getCollectionExpression();
        if (collectionExpression instanceof ClosureListExpression) {
            super.visitForLoop(forLoop);
        } else {
            this.visitStatement(forLoop);
            collectionExpression.visit(this);
            ClassNode collectionType = collectionExpression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(collectionExpression) ? this.getInferredReturnType(collectionExpression) : this.getType(collectionExpression);
            ClassNode forLoopVariableType = forLoop.getVariableType();
            ClassNode componentType = ClassHelper.Character_TYPE.equals(ClassHelper.getWrapper(forLoopVariableType)) && ClassHelper.STRING_TYPE.equals(collectionType) ? forLoopVariableType : StaticTypeCheckingVisitor.inferLoopElementType(collectionType);
            if (ClassHelper.getUnwrapper(componentType) == forLoopVariableType) {
                componentType = forLoopVariableType;
            }
            if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(forLoopVariableType, componentType)) {
                this.addStaticTypeError("Cannot loop with element of type " + forLoopVariableType.toString(false) + " with collection of type " + collectionType.toString(false), forLoop);
            }
            if (forLoopVariableType != ClassHelper.DYNAMIC_TYPE) {
                componentType = forLoopVariableType;
            }
            this.typeCheckingContext.controlStructureVariables.put(forLoop.getVariable(), componentType);
            try {
                forLoop.getLoopBlock().visit(this);
            }
            finally {
                this.typeCheckingContext.controlStructureVariables.remove(forLoop.getVariable());
            }
        }
        if (this.isSecondPassNeededForControlStructure(varOrigType, oldTracker)) {
            this.visitForLoop(forLoop);
        }
    }

    public static ClassNode inferLoopElementType(ClassNode collectionType) {
        ClassNode componentType = collectionType.getComponentType();
        if (componentType == null) {
            if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, ITERABLE_TYPE)) {
                ClassNode col = GenericsUtils.parameterizeType(collectionType, ITERABLE_TYPE);
                componentType = col.getGenericsTypes()[0].getType();
            } else if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, ClassHelper.MAP_TYPE)) {
                ClassNode col = GenericsUtils.parameterizeType(collectionType, ClassHelper.MAP_TYPE);
                componentType = MAP_ENTRY_TYPE.getPlainNodeReference();
                componentType.setGenericsTypes(col.getGenericsTypes());
            } else if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, ENUMERATION_TYPE)) {
                ClassNode col = GenericsUtils.parameterizeType(collectionType, ENUMERATION_TYPE);
                componentType = col.getGenericsTypes()[0].getType();
            } else {
                componentType = collectionType.equals(ClassHelper.STRING_TYPE) ? ClassHelper.STRING_TYPE : ClassHelper.OBJECT_TYPE;
            }
        }
        return componentType;
    }

    protected boolean isSecondPassNeededForControlStructure(Map<VariableExpression, ClassNode> varOrigType, Map<VariableExpression, List<ClassNode>> oldTracker) {
        Map<VariableExpression, ClassNode> assignedVars = this.popAssignmentTracking(oldTracker);
        for (Map.Entry<VariableExpression, ClassNode> entry : assignedVars.entrySet()) {
            Variable key = StaticTypeCheckingSupport.findTargetVariable(entry.getKey());
            if (!(key instanceof VariableExpression)) continue;
            ClassNode origType = varOrigType.get(key);
            ClassNode newType = entry.getValue();
            if (!varOrigType.containsKey(key) || newType.equals(origType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitWhileLoop(WhileStatement loop) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        super.visitWhileLoop(loop);
        this.popAssignmentTracking(oldTracker);
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        MethodNode mn;
        super.visitBitwiseNegationExpression(expression);
        ClassNode type = this.getType(expression);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isBigIntCategory(typeRe) ? type : (typeRe == ClassHelper.STRING_TYPE || typeRe == ClassHelper.GSTRING_TYPE ? ClassHelper.PATTERN_TYPE : (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE ? StaticTypeCheckingSupport.ArrayList_TYPE : (typeRe.equals(ClassHelper.PATTERN_TYPE) ? ClassHelper.PATTERN_TYPE : ((mn = this.findMethodOrFail(expression, type, "bitwiseNegate", new ClassNode[0])) != null ? mn.getReturnType() : ClassHelper.OBJECT_TYPE))));
        this.storeType(expression, resultType);
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        super.visitUnaryPlusExpression(expression);
        this.negativeOrPositiveUnary(expression, "positive");
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        super.visitUnaryMinusExpression(expression);
        this.negativeOrPositiveUnary(expression, "negative");
    }

    @Override
    public void visitPostfixExpression(PostfixExpression expression) {
        Expression inner = expression.getExpression();
        int op = expression.getOperation().getType();
        this.visitPrefixOrPostifExpression(expression, inner, op);
    }

    @Override
    public void visitPrefixExpression(PrefixExpression expression) {
        Expression inner = expression.getExpression();
        int type = expression.getOperation().getType();
        this.visitPrefixOrPostifExpression(expression, inner, type);
    }

    private static Token asAssignment(int op) {
        switch (op) {
            case 250: 
            case 251: 
            case 252: {
                return Token.newSymbol(210, -1, -1);
            }
            case 260: 
            case 261: 
            case 262: {
                return Token.newSymbol(211, -1, -1);
            }
        }
        return null;
    }

    private static ClassNode getMathWideningClassNode(ClassNode type) {
        if (ClassHelper.byte_TYPE.equals(type) || ClassHelper.short_TYPE.equals(type) || ClassHelper.int_TYPE.equals(type)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(type) || ClassHelper.Short_TYPE.equals(type) || ClassHelper.Integer_TYPE.equals(type)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(type)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(type)) {
            return ClassHelper.Double_TYPE;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitPrefixOrPostifExpression(Expression origin, Expression operand, int operator) {
        Token token = StaticTypeCheckingVisitor.asAssignment(operator);
        if (token != null) {
            this.typeCheckingContext.pushEnclosingBinaryExpression(GeneralUtils.binX(operand, token, GeneralUtils.constX(1)));
        }
        try {
            MethodNode node;
            String name;
            operand.visit(this);
            SetterInfo setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(operand);
            if (setterInfo != null) {
                BinaryExpression rewrite = this.typeCheckingContext.getEnclosingBinaryExpression();
                rewrite.setSourcePosition(origin);
                if (this.ensureValidSetter(rewrite, operand, rewrite.getRightExpression(), setterInfo)) {
                    return;
                }
            }
            ClassNode operandType = this.getType(operand);
            boolean isPostfix = origin instanceof PostfixExpression;
            String string = operator == 250 ? "next" : (name = operator == 260 ? "previous" : null);
            if (name != null && ClassHelper.isNumberType(operandType)) {
                MethodNode node2;
                if (!ClassHelper.isPrimitiveType(operandType) && (node2 = this.findMethodOrFail(GeneralUtils.varX("_dummy_", operandType), operandType, name, new ClassNode[0])) != null) {
                    this.storeTargetMethod(origin, node2);
                    this.storeType(origin, isPostfix ? operandType : StaticTypeCheckingVisitor.getMathWideningClassNode(operandType));
                    return;
                }
                this.storeType(origin, operandType);
                return;
            }
            if (name != null && operandType.isDerivedFrom(ClassHelper.Number_TYPE) && (node = this.findMethodOrFail(operand, operandType, name, new ClassNode[0])) != null) {
                this.storeTargetMethod(origin, node);
                this.storeType(origin, StaticTypeCheckingVisitor.getMathWideningClassNode(operandType));
                return;
            }
            if (name == null) {
                this.addUnsupportedPreOrPostfixExpressionError(origin);
                return;
            }
            node = this.findMethodOrFail(operand, operandType, name, new ClassNode[0]);
            if (node != null) {
                this.storeTargetMethod(origin, node);
                this.storeType(origin, isPostfix ? operandType : this.inferReturnTypeGenerics(operandType, node, ArgumentListExpression.EMPTY_ARGUMENTS));
            }
        }
        finally {
            if (token != null) {
                this.typeCheckingContext.popEnclosingBinaryExpression();
            }
        }
    }

    private void negativeOrPositiveUnary(Expression expression, String name) {
        MethodNode mn;
        ClassNode type = this.getType(expression);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isDoubleCategory(ClassHelper.getUnwrapper(typeRe)) ? type : (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE ? StaticTypeCheckingSupport.ArrayList_TYPE : ((mn = this.findMethodOrFail(expression, type, name, new ClassNode[0])) != null ? mn.getReturnType() : type));
        this.storeType(expression, resultType);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.typeCheckingContext.pushEnclosingMethod(node);
        if (!this.isSkipMode(node) && !this.shouldSkipMethodNode(node)) {
            super.visitConstructorOrMethod(node, isConstructor);
        }
        if (!isConstructor) {
            this.returnAdder.visitMethod(node);
        }
        this.typeCheckingContext.popEnclosingMethod();
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement) {
        this.typeCheckingContext.pushTemporaryTypeInfo();
        super.visitExpressionStatement(statement);
        this.typeCheckingContext.popTemporaryTypeInfo();
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement) {
        this.typeCheckingContext.pushEnclosingReturnStatement(statement);
        try {
            super.visitReturnStatement(statement);
            this.returnListener.returnStatementAdded(statement);
        }
        finally {
            this.typeCheckingContext.popEnclosingReturnStatement();
        }
    }

    private ClassNode infer(ClassNode target, ClassNode source) {
        DeclarationExpression virtualDecl = GeneralUtils.declX(GeneralUtils.varX("{target}", target), GeneralUtils.varX("{source}", source));
        ((ASTNode)virtualDecl).visit(this);
        ClassNode newlyInferred = (ClassNode)virtualDecl.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        return !StaticTypeCheckingSupport.missesGenericsTypes(newlyInferred) ? newlyInferred : null;
    }

    protected ClassNode checkReturnType(ReturnStatement statement) {
        Expression expression = statement.getExpression();
        ClassNode type = expression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(expression) ? this.getInferredReturnType(expression) : this.getType(expression);
        if (this.typeCheckingContext.getEnclosingClosure() != null) {
            ClassNode inferredReturnType = this.getInferredReturnType(this.typeCheckingContext.getEnclosingClosure().getClosureExpression());
            if (expression instanceof ConstructorCallExpression && inferredReturnType != null) {
                this.inferDiamondType((ConstructorCallExpression)expression, inferredReturnType);
            }
            if (ClassHelper.STRING_TYPE.equals(inferredReturnType) && StaticTypeCheckingSupport.isGStringOrGStringStringLUB(type)) {
                type = ClassHelper.STRING_TYPE;
            }
            return type;
        }
        MethodNode enclosingMethod = this.typeCheckingContext.getEnclosingMethod();
        if (enclosingMethod != null && !enclosingMethod.isVoidMethod()) {
            ClassNode returnType = enclosingMethod.getReturnType();
            if (!(StaticTypeCheckingVisitor.isNullConstant(expression) || type.equals(ClassHelper.VOID_TYPE) || type.equals(ClassHelper.void_WRAPPER_TYPE) || StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(returnType, type, null, false))) {
                if (!this.extension.handleIncompatibleReturnType(statement, type)) {
                    this.addStaticTypeError("Cannot return value of type " + StaticTypeCheckingSupport.prettyPrintType(type) + " on method returning type " + StaticTypeCheckingSupport.prettyPrintType(returnType), expression);
                }
            } else {
                ClassNode inferred;
                ClassNode previousType = this.getInferredReturnType(enclosingMethod);
                ClassNode classNode = inferred = previousType == null ? type : WideningCategories.lowestUpperBound(type, previousType);
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferred, enclosingMethod.getReturnType())) {
                    if (StaticTypeCheckingSupport.missesGenericsTypes(inferred)) {
                        ClassNode newlyInferred = this.infer(enclosingMethod.getReturnType(), type);
                        if (newlyInferred != null) {
                            type = newlyInferred;
                        }
                    } else {
                        this.checkTypeGenerics(enclosingMethod.getReturnType(), inferred, expression);
                    }
                } else {
                    return enclosingMethod.getReturnType();
                }
            }
        }
        return type;
    }

    protected void addClosureReturnType(ClassNode returnType) {
        if (returnType != null && !returnType.equals(ClassHelper.VOID_TYPE)) {
            this.typeCheckingContext.getEnclosingClosure().addReturnType(returnType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.typeCheckingContext.pushEnclosingConstructorCall(call);
        try {
            Set<MethodNode> methods;
            MethodNode ctor;
            if (this.extension.beforeMethodCall(call)) {
                this.extension.afterMethodCall(call);
                return;
            }
            ClassNode receiver = call.isThisCall() ? this.makeThis() : (call.isSuperCall() ? this.makeSuper() : call.getType());
            Expression arguments = call.getArguments();
            ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(arguments);
            this.checkForbiddenSpreadArgument(argumentList);
            this.visitMethodCallArguments(receiver, argumentList, false, null);
            ClassNode[] argumentTypes = this.getArgumentTypes(argumentList);
            if (this.looksLikeNamedArgConstructor(receiver, argumentTypes) && this.findMethod(receiver, "<init>", argumentTypes).isEmpty() && this.findMethod(receiver, "<init>", DefaultGroovyMethods.init(argumentTypes)).size() == 1) {
                ctor = this.typeCheckMapConstructor(call, receiver, arguments);
            } else {
                ctor = this.findMethodOrFail(call, receiver, "<init>", argumentTypes);
                if (ctor != null) {
                    Parameter[] parameters = ctor.getParameters();
                    if (this.looksLikeNamedArgConstructor(receiver, argumentTypes) && parameters.length == argumentTypes.length - 1) {
                        ctor = this.typeCheckMapConstructor(call, receiver, arguments);
                    } else {
                        if (parameters.length > 0 && DefaultGroovyMethods.asBoolean(receiver.getGenericsTypes())) {
                            Map<GenericsType.GenericsTypeName, GenericsType> context = StaticTypeCheckingVisitor.extractPlaceHolders(null, receiver, ctor.getDeclaringClass());
                            parameters = (Parameter[])parameters.clone();
                            for (int i = 0; i < parameters.length; ++i) {
                                parameters[i] = new Parameter(StaticTypeCheckingSupport.applyGenericsContext(context, parameters[i].getType()), parameters[i].getName());
                            }
                        }
                        this.resolvePlaceholdersFromImplicitTypeHints(argumentTypes, argumentList, parameters);
                        this.typeCheckMethodsWithGenericsOrFail(receiver, argumentTypes, ctor, call);
                        this.visitMethodCallArguments(receiver, argumentList, true, ctor);
                    }
                }
            }
            if (ctor != null) {
                this.storeTargetMethod(call, ctor);
            }
            if (call.isUsingAnonymousInnerClass() && !(methods = this.typeCheckingContext.methodsToBeVisited).isEmpty()) {
                this.typeCheckingContext.methodsToBeVisited = Collections.emptySet();
                ClassNode anonType = call.getType();
                this.visitClass(anonType);
                anonType.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
                this.typeCheckingContext.methodsToBeVisited = methods;
            }
            this.extension.afterMethodCall(call);
        }
        finally {
            this.typeCheckingContext.popEnclosingConstructorCall();
        }
    }

    private boolean looksLikeNamedArgConstructor(ClassNode receiver, ClassNode[] args) {
        return (args.length == 1 || args.length == 2 && this.isInnerConstructor(receiver, args[0])) && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(args[args.length - 1], ClassHelper.MAP_TYPE);
    }

    private boolean isInnerConstructor(ClassNode receiver, ClassNode parent) {
        return receiver.isRedirectNode() && receiver.redirect() instanceof InnerClassNode && receiver.redirect().getOuterClass().equals(parent);
    }

    protected MethodNode typeCheckMapConstructor(ConstructorCallExpression call, ClassNode receiver, Expression arguments) {
        Expression expression;
        TupleExpression texp;
        List<Expression> expressions;
        ConstructorNode node = null;
        if (arguments instanceof TupleExpression && ((expressions = (texp = (TupleExpression)arguments).getExpressions()).size() == 1 || expressions.size() == 2) && (expression = expressions.get(expressions.size() - 1)) instanceof MapExpression) {
            Parameter[] parameterArray;
            MapExpression argList = (MapExpression)expression;
            this.checkGroovyConstructorMap(call, receiver, argList);
            if (expressions.size() == 1) {
                Parameter[] parameterArray2 = new Parameter[1];
                parameterArray = parameterArray2;
                parameterArray2[0] = new Parameter(ClassHelper.MAP_TYPE, "map");
            } else {
                Parameter[] parameterArray3 = new Parameter[2];
                parameterArray3[0] = new Parameter(receiver.redirect().getOuterClass(), "$p$");
                parameterArray = parameterArray3;
                parameterArray3[1] = new Parameter(ClassHelper.MAP_TYPE, "map");
            }
            Parameter[] params = parameterArray;
            node = new ConstructorNode(1, params, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
            node.setDeclaringClass(receiver);
        }
        return node;
    }

    protected ClassNode[] getArgumentTypes(ArgumentListExpression args) {
        List<Expression> arglist = args.getExpressions();
        ClassNode[] ret = new ClassNode[arglist.size()];
        for (int i = 0; i < arglist.size(); ++i) {
            Expression exp = arglist.get(i);
            ret[i] = StaticTypeCheckingVisitor.isNullConstant(exp) ? StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE : this.getInferredTypeFromTempInfo(exp, this.getType(exp));
        }
        return ret;
    }

    private ClassNode getInferredTypeFromTempInfo(Expression expression, ClassNode expressionType) {
        List<ClassNode> tempTypes;
        if (expression instanceof VariableExpression && !this.typeCheckingContext.temporaryIfBranchTypeInformation.isEmpty() && (tempTypes = this.getTemporaryTypesForExpression(expression)) != null && !tempTypes.isEmpty()) {
            ArrayList<ClassNode> types = new ArrayList<ClassNode>(tempTypes.size() + 1);
            if (expressionType != null && !expressionType.equals(ClassHelper.OBJECT_TYPE) && StaticTypeCheckingVisitor.noneMatch(tempTypes, expressionType)) {
                types.add(expressionType);
            }
            types.addAll(tempTypes);
            if (types.isEmpty()) {
                return ClassHelper.OBJECT_TYPE;
            }
            if (types.size() == 1) {
                return (ClassNode)types.get(0);
            }
            return new UnionTypeClassNode(types.toArray(ClassNode.EMPTY_ARRAY));
        }
        return expressionType;
    }

    private static boolean noneMatch(List<ClassNode> types, ClassNode type) {
        for (ClassNode t : types) {
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(t, type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        HashMap<VariableExpression, ClassNode> varTypes = new HashMap<VariableExpression, ClassNode>();
        expression.getCode().visit(new VariableExpressionTypeMemoizer(varTypes, true));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        SharedVariableCollector collector = new SharedVariableCollector(this.getSourceUnit());
        collector.visitClosureExpression(expression);
        Set<VariableExpression> closureSharedExpressions = collector.getClosureSharedExpressions();
        HashMap<VariableExpression, ListHashMap> typesBeforeVisit = null;
        if (!closureSharedExpressions.isEmpty()) {
            typesBeforeVisit = new HashMap<VariableExpression, ListHashMap>();
            this.saveVariableExpressionMetadata(closureSharedExpressions, typesBeforeVisit);
        }
        this.typeCheckingContext.pushEnclosingClosureExpression(expression);
        DelegationMetadata dmd = this.getDelegationMetadata(expression);
        this.typeCheckingContext.delegationMetadata = dmd == null ? new DelegationMetadata(this.typeCheckingContext.getEnclosingClassNode(), 0, this.typeCheckingContext.delegationMetadata) : new DelegationMetadata(dmd.getType(), dmd.getStrategy(), this.typeCheckingContext.delegationMetadata);
        super.visitClosureExpression(expression);
        this.typeCheckingContext.delegationMetadata = this.typeCheckingContext.delegationMetadata.getParent();
        this.returnAdder.visitMethod(new MethodNode("dummy", 0, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, expression.getCode()));
        TypeCheckingContext.EnclosingClosure enclosingClosure = this.typeCheckingContext.getEnclosingClosure();
        if (!enclosingClosure.getReturnTypes().isEmpty()) {
            ClassNode returnType = WideningCategories.lowestUpperBound(enclosingClosure.getReturnTypes());
            this.storeInferredReturnType(expression, returnType);
            ClassNode inferredType = StaticTypeCheckingVisitor.wrapClosureType(returnType);
            this.storeType(enclosingClosure.getClosureExpression(), inferredType);
        }
        this.typeCheckingContext.popEnclosingClosure();
        if (this.isSecondPassNeededForControlStructure(varTypes, oldTracker)) {
            this.visitClosureExpression(expression);
        }
        this.restoreVariableExpressionMetadata(typesBeforeVisit);
        for (Parameter parameter : ClosureUtils.getParametersSafe(expression)) {
            this.typeCheckingContext.controlStructureVariables.remove(parameter);
            this.visitInitialExpression(parameter.getInitialExpression(), GeneralUtils.varX(parameter), parameter);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        super.visitMethodPointerExpression(expression);
        Expression nameExpr = expression.getMethodName();
        if (nameExpr instanceof ConstantExpression && this.getType(nameExpr).equals(ClassHelper.STRING_TYPE)) {
            String nameText = nameExpr.getText();
            if ("new".equals(nameText)) {
                ClassNode receiverType = this.getType(expression.getExpression());
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiverType)) {
                    this.storeType(expression, StaticTypeCheckingVisitor.wrapClosureType(receiverType));
                }
                return;
            }
            ArrayList<Receiver<String>> receivers = new ArrayList<Receiver<String>>();
            this.addReceivers(receivers, this.makeOwnerList(expression.getExpression()), false);
            List<MethodNode> candidates = EMPTY_METHODNODE_LIST;
            for (Receiver receiver : receivers) {
                ClassNode receiverType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(receiver.getType());
                candidates = this.findMethodsWithGenerated(receiverType, nameText);
                if (StaticTypeCheckingSupport.isBeingCompiled(receiverType) && !receiverType.isInterface()) {
                    MethodNode generated = StaticTypeCheckingVisitor.findPropertyMethod(receiverType, nameText);
                    if (generated != null) {
                        boolean contains = false;
                        for (MethodNode candidate : candidates) {
                            if (!candidate.getName().equals(generated.getName())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) {
                            candidates.add(generated);
                        }
                    }
                    candidates.addAll(ClassHelper.GROOVY_OBJECT_TYPE.getMethods(nameText));
                }
                candidates.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode(this.getSourceUnit().getClassLoader(), receiverType, nameText));
                if ((candidates = this.filterMethodsByVisibility(candidates)).isEmpty()) continue;
                break;
            }
            if (candidates.isEmpty()) {
                candidates = this.extension.handleMissingMethod(this.getType(expression.getExpression()), nameText, null, null, null);
            } else if (candidates.size() > 1) {
                candidates = this.extension.handleAmbiguousMethods(candidates, expression);
            }
            int n = candidates.size();
            if (n > 0) {
                void var7_12;
                if (n == 1) {
                    ClassNode classNode = candidates.get(0).getReturnType();
                } else {
                    ArrayList<ClassNode> returnTypes = new ArrayList<ClassNode>(n);
                    for (MethodNode candidate : candidates) {
                        returnTypes.add(candidate.getReturnType());
                    }
                    ClassNode classNode = WideningCategories.lowestUpperBound(returnTypes);
                }
                if (!var7_12.equals(ClassHelper.OBJECT_TYPE)) {
                    this.storeType(expression, StaticTypeCheckingVisitor.wrapClosureType((ClassNode)var7_12));
                }
                expression.putNodeMetaData(MethodNode.class, candidates);
            } else {
                void var7_15;
                ClassNode classNode = StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.getType(expression.getExpression()));
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(classNode)) {
                    ClassNode classNode2 = classNode.getGenericsTypes()[0].getType();
                }
                this.addStaticTypeError("Cannot find matching method " + var7_15.getText() + "#" + nameText + ". Please check if the declared type is correct and if the method exists.", nameExpr);
            }
        }
    }

    private static ClassNode wrapClosureType(ClassNode returnType) {
        ClassNode inferredType = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
        inferredType.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(returnType))});
        return inferredType;
    }

    private static MethodNode findPropertyMethod(ClassNode type, String name) {
        for (ClassNode cn = type; cn != null; cn = cn.getSuperClass()) {
            for (PropertyNode pn : cn.getProperties()) {
                String properName = MetaClassHelper.capitalize(pn.getName());
                String getterName = "get" + properName;
                if (ClassHelper.boolean_TYPE.equals(pn.getType()) && StaticTypeCheckingVisitor.findGetter(cn, getterName, false) == null) {
                    getterName = "is" + properName;
                }
                if (name.equals(getterName)) {
                    MethodNode node = new MethodNode(name, 1 | (pn.isStatic() ? 8 : 0), pn.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
                    node.setDeclaringClass(pn.getDeclaringClass());
                    return node;
                }
                if (!name.equals("set" + properName) || Modifier.isFinal(pn.getModifiers())) continue;
                MethodNode node = new MethodNode(name, 1 | (pn.isStatic() ? 8 : 0), ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(pn.getType(), pn.getName())}, ClassNode.EMPTY_ARRAY, null);
                node.setDeclaringClass(pn.getDeclaringClass());
                return node;
            }
        }
        return null;
    }

    protected DelegationMetadata getDelegationMetadata(ClosureExpression expression) {
        return (DelegationMetadata)expression.getNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA);
    }

    protected void restoreVariableExpressionMetadata(Map<VariableExpression, ListHashMap> typesBeforeVisit) {
        if (typesBeforeVisit != null) {
            for (Map.Entry<VariableExpression, ListHashMap> entry : typesBeforeVisit.entrySet()) {
                VariableExpression ve = entry.getKey();
                ListHashMap metadata = entry.getValue();
                for (StaticTypesMarker marker : StaticTypesMarker.values()) {
                    if (marker == StaticTypesMarker.INFERRED_TYPE) continue;
                    ve.removeNodeMetaData((Object)marker);
                    Object value = metadata.get((Object)marker);
                    if (value == null) continue;
                    ve.setNodeMetaData((Object)marker, value);
                }
            }
        }
    }

    protected void saveVariableExpressionMetadata(Set<VariableExpression> closureSharedExpressions, Map<VariableExpression, ListHashMap> typesBeforeVisit) {
        for (VariableExpression ve : closureSharedExpressions) {
            Variable v;
            this.getType(ve);
            while ((v = ve.getAccessedVariable()) != ve && v instanceof VariableExpression) {
                ve = (VariableExpression)v;
            }
            ListHashMap metadata = new ListHashMap();
            for (StaticTypesMarker marker : StaticTypesMarker.values()) {
                Object value = ve.getNodeMetaData((Object)marker);
                if (value == null) continue;
                metadata.put(marker, value);
            }
            typesBeforeVisit.put(ve, metadata);
        }
    }

    protected boolean shouldSkipMethodNode(MethodNode node) {
        Object type = node.getNodeMetaData(StaticTypeCheckingVisitor.class);
        return Boolean.TRUE.equals(type);
    }

    @Override
    public void visitMethod(MethodNode node) {
        if (this.shouldSkipMethodNode(node)) {
            return;
        }
        if (!this.extension.beforeVisitMethod(node)) {
            ErrorCollector collector = (ErrorCollector)node.getNodeMetaData(ERROR_COLLECTOR);
            if (collector != null) {
                this.typeCheckingContext.getErrorCollector().addCollectorContents(collector);
            } else {
                this.startMethodInference(node, this.typeCheckingContext.getErrorCollector());
            }
            node.removeNodeMetaData(ERROR_COLLECTOR);
        }
        this.extension.afterVisitMethod(node);
    }

    @Override
    public void visitConstructor(ConstructorNode node) {
        if (this.shouldSkipMethodNode(node)) {
            return;
        }
        super.visitConstructor(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMethodInference(MethodNode node, ErrorCollector collector) {
        if (this.isSkipMode(node)) {
            return;
        }
        if ((this.typeCheckingContext.methodsToBeVisited.isEmpty() || this.typeCheckingContext.methodsToBeVisited.contains(node)) && this.typeCheckingContext.alreadyVisitedMethods.add(node)) {
            this.typeCheckingContext.pushErrorCollector(collector);
            boolean osc = this.typeCheckingContext.isInStaticContext;
            try {
                this.typeCheckingContext.isInStaticContext = StaticTypeCheckingVisitor.isNonStaticHelperMethod(node) ? false : node.isStatic();
                super.visitMethod(node);
            }
            finally {
                this.typeCheckingContext.isInStaticContext = osc;
            }
            this.typeCheckingContext.popErrorCollector();
            node.putNodeMetaData(ERROR_COLLECTOR, collector);
        }
    }

    protected void addTypeCheckingInfoAnnotation(MethodNode node) {
        if (node instanceof ConstructorNode) {
            return;
        }
        ClassNode rtype = this.getInferredReturnType(node);
        if (rtype != null && node.getAnnotations(TYPECHECKING_INFO_NODE).isEmpty()) {
            AnnotationNode anno = new AnnotationNode(TYPECHECKING_INFO_NODE);
            anno.setMember("version", CURRENT_SIGNATURE_PROTOCOL);
            SignatureCodec codec = SignatureCodecFactory.getCodec(1, this.getTransformLoader());
            String genericsSignature = codec.encode(rtype);
            if (genericsSignature != null) {
                ConstantExpression signature = new ConstantExpression(genericsSignature);
                signature.setType(ClassHelper.STRING_TYPE);
                anno.setMember("inferredType", signature);
                node.addAnnotation(anno);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        String name = call.getMethod();
        if (name == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call);
            return;
        }
        if (this.extension.beforeMethodCall(call)) {
            this.extension.afterMethodCall(call);
            return;
        }
        Expression callArguments = call.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(callArguments);
        this.checkForbiddenSpreadArgument(argumentList);
        ClassNode receiver = call.getOwnerType();
        this.visitMethodCallArguments(receiver, argumentList, false, null);
        ClassNode[] args = this.getArgumentTypes(argumentList);
        try {
            LinkedList<Receiver<String>> receivers = new LinkedList<Receiver<String>>();
            this.addReceivers(receivers, this.makeOwnerList(new ClassExpression(receiver)), false);
            List<MethodNode> mn = null;
            Receiver chosenReceiver = null;
            for (Receiver receiver2 : receivers) {
                mn = this.findMethod(receiver2.getType(), name, args);
                if (mn.isEmpty()) continue;
                if (mn.size() == 1) {
                    this.typeCheckMethodsWithGenericsOrFail(receiver2.getType(), args, mn.get(0), call);
                }
                chosenReceiver = receiver2;
                break;
            }
            if (mn.isEmpty()) {
                mn = this.extension.handleMissingMethod(receiver, name, argumentList, args, call);
            }
            boolean callArgsVisited = false;
            if (mn.isEmpty()) {
                this.addNoMatchingMethodError(receiver, name, args, call);
            } else {
                if ((mn = this.disambiguateMethods(mn, receiver, args, call)).size() == 1) {
                    MethodNode methodNode = mn.get(0);
                    ClassNode returnType = this.getType(methodNode);
                    if (returnType.isUsingGenerics() && !returnType.isEnum()) {
                        this.visitMethodCallArguments(receiver, argumentList, true, methodNode);
                        ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver.getType(), methodNode, callArguments);
                        returnType = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, returnType) ? irtg : returnType;
                        callArgsVisited = true;
                    }
                    this.storeType(call, returnType);
                    this.storeTargetMethod(call, methodNode);
                } else {
                    this.addAmbiguousErrorMessage(mn, name, args, call);
                }
                if (!callArgsVisited) {
                    this.visitMethodCallArguments(receiver, argumentList, true, (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
                }
            }
        }
        finally {
            this.extension.afterMethodCall(call);
        }
    }

    @Deprecated
    protected void checkClosureParameters(Expression callArguments, ClassNode receiver) {
        if (callArguments instanceof ArgumentListExpression) {
            Parameter param;
            ArgumentListExpression argList = (ArgumentListExpression)callArguments;
            ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
            Parameter[] parameters = closure.getParameters();
            if (parameters.length > 1) {
                this.addStaticTypeError("Unexpected number of parameters for a with call", argList);
            } else if (parameters.length == 1 && !(param = parameters[0]).isDynamicTyped() && !StaticTypeCheckingSupport.isAssignableTo(receiver, param.getType().redirect())) {
                this.addStaticTypeError("Expected parameter type: " + receiver.toString(false) + " but was: " + param.getType().redirect().toString(false), param);
            }
            closure.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(receiver, 1, this.typeCheckingContext.delegationMetadata));
        }
    }

    protected void silentlyVisitMethodNode(MethodNode directMethodCallCandidate) {
        ErrorCollector collector = new ErrorCollector(this.typeCheckingContext.getErrorCollector().getConfiguration());
        this.startMethodInference(directMethodCallCandidate, collector);
    }

    protected void visitMethodCallArguments(ClassNode receiver, ArgumentListExpression arguments, boolean visitClosures, MethodNode selectedMethod) {
        Parameter[] params = selectedMethod != null ? selectedMethod.getParameters() : Parameter.EMPTY_ARRAY;
        LinkedList<Expression> expressions = new LinkedList<Expression>(arguments.getExpressions());
        if (selectedMethod instanceof ExtensionMethodNode) {
            params = ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode().getParameters();
            expressions.add(0, GeneralUtils.varX("$self", receiver));
        }
        if (expressions.isEmpty()) {
            return;
        }
        int n = expressions.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)expressions.get(i);
            if ((!visitClosures || !(expression instanceof ClosureExpression)) && (visitClosures || expression instanceof ClosureExpression)) continue;
            if (i < params.length && visitClosures) {
                ClassNode targetType;
                Parameter param = params[i];
                this.checkClosureWithDelegatesTo(receiver, selectedMethod, GeneralUtils.args(expressions), params, expression, param);
                if (selectedMethod instanceof ExtensionMethodNode) {
                    if (i > 0) {
                        this.inferClosureParameterTypes(receiver, arguments, (ClosureExpression)expression, param, selectedMethod);
                    }
                } else {
                    this.inferClosureParameterTypes(receiver, arguments, (ClosureExpression)expression, param, selectedMethod);
                }
                if (StaticTypeCheckingVisitor.isFunctionalInterface(targetType = param.getType())) {
                    this.processFunctionalInterfaceAssignment(targetType, expression);
                } else if (StaticTypeCheckingVisitor.isClosureWithType(targetType)) {
                    this.storeInferredReturnType(expression, StaticTypeCheckingSupport.getCombinedBoundType(targetType.getGenericsTypes()[0]));
                }
            }
            expression.visit(this);
            expression.removeNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA);
        }
        if (params.length > 0 && expressions.get(0) instanceof MapExpression) {
            this.checkNamedParamsAnnotation(params[0], (MapExpression)expressions.get(0));
        }
    }

    private void checkNamedParamsAnnotation(Parameter param, MapExpression args) {
        if (!param.getType().isDerivedFrom(ClassHelper.MAP_TYPE)) {
            return;
        }
        List<MapEntryExpression> entryExpressions = args.getMapEntryExpressions();
        LinkedHashMap<Object, Expression> entries = new LinkedHashMap<Object, Expression>();
        for (MapEntryExpression entry : entryExpressions) {
            Object key = entry.getKeyExpression();
            if (key instanceof ConstantExpression) {
                key = ((ConstantExpression)key).getValue();
            }
            entries.put(key, entry.getValueExpression());
        }
        List<AnnotationNode> annotations = param.getAnnotations(NAMED_PARAMS_CLASSNODE);
        if (annotations != null && !annotations.isEmpty()) {
            AnnotationNode an = null;
            for (AnnotationNode next : annotations) {
                if (!next.getClassNode().getName().equals(NamedParams.class.getName())) continue;
                an = next;
            }
            ArrayList<String> collectedNames = new ArrayList<String>();
            if (an != null) {
                Expression value = an.getMember("value");
                if (value instanceof AnnotationConstantExpression) {
                    this.processNamedParam((AnnotationConstantExpression)value, entries, args, collectedNames);
                } else if (value instanceof ListExpression) {
                    ListExpression le = (ListExpression)value;
                    for (Expression next : le.getExpressions()) {
                        if (!(next instanceof AnnotationConstantExpression)) continue;
                        this.processNamedParam((AnnotationConstantExpression)next, entries, args, collectedNames);
                    }
                }
                for (Map.Entry entry : entries.entrySet()) {
                    if (collectedNames.contains(entry.getKey())) continue;
                    this.addStaticTypeError("unexpected named arg: " + entry.getKey(), args);
                }
            }
        }
    }

    private void processNamedParam(AnnotationConstantExpression value, Map<Object, Expression> entries, Expression expression, List<String> collectedNames) {
        ClassNode argumentType;
        ClassExpression typeX;
        AnnotationNode namedParam = (AnnotationNode)value.getValue();
        if (!namedParam.getClassNode().getName().equals(NamedParam.class.getName())) {
            return;
        }
        String name = null;
        boolean required = false;
        ClassNode expectedType = null;
        ConstantExpression constX = (ConstantExpression)namedParam.getMember("value");
        if (constX != null) {
            name = (String)constX.getValue();
            collectedNames.add(name);
        }
        if ((constX = (ConstantExpression)namedParam.getMember("required")) != null) {
            required = (Boolean)constX.getValue();
        }
        if ((typeX = (ClassExpression)namedParam.getMember("type")) != null) {
            expectedType = typeX.getType();
        }
        if (!entries.keySet().contains(name)) {
            if (required) {
                this.addStaticTypeError("required named param '" + name + "' not found.", expression);
            }
        } else if (expectedType != null && !StaticTypeCheckingSupport.isAssignableTo(argumentType = this.getDeclaredOrInferredType(entries.get(name)), expectedType)) {
            this.addStaticTypeError("argument for named param '" + name + "' has type '" + StaticTypeCheckingSupport.prettyPrintType(argumentType) + "' but expected '" + StaticTypeCheckingSupport.prettyPrintType(expectedType) + "'.", expression);
        }
    }

    private ClassNode getDeclaredOrInferredType(Expression expression) {
        ClassNode declaredOrInferred = expression instanceof Variable && !((Variable)((Object)expression)).isDynamicTyped() ? this.getOriginalDeclarationType(expression) : this.getType(expression);
        return this.getInferredTypeFromTempInfo(expression, declaredOrInferred);
    }

    protected void inferClosureParameterTypes(ClassNode receiver, Expression arguments, ClosureExpression expression, Parameter param, MethodNode selectedMethod) {
        List<AnnotationNode> annotations = param.getAnnotations(CLOSUREPARAMS_CLASSNODE);
        if (annotations != null && !annotations.isEmpty()) {
            for (AnnotationNode annotation : annotations) {
                Expression hintClass = annotation.getMember("value");
                if (!(hintClass instanceof ClassExpression)) continue;
                Expression options = annotation.getMember("options");
                Expression resolverClass = annotation.getMember("conflictResolutionStrategy");
                this.doInferClosureParameterTypes(receiver, arguments, expression, selectedMethod, hintClass, resolverClass, options);
            }
        } else if (ClassHelper.isSAMType(param.getOriginType())) {
            this.inferSAMType(param, receiver, selectedMethod, InvocationWriter.makeArgumentList(arguments), expression);
        }
    }

    private void inferSAMType(Parameter param, ClassNode receiver, MethodNode methodWithSAMParameter, ArgumentListExpression originalMethodCallArguments, ClosureExpression openBlock) {
        int i;
        HashMap<GenericsType.GenericsTypeName, GenericsType> targetMethodDeclarationClassConnections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        StaticTypeCheckingSupport.extractGenericsConnections(targetMethodDeclarationClassConnections, receiver, receiver.redirect());
        Parameter[] parametersOfMethodContainingSAM = methodWithSAMParameter.getParameters();
        for (int i2 = 0; i2 < parametersOfMethodContainingSAM.length; ++i2) {
            Expression callArg;
            if (i2 == parametersOfMethodContainingSAM.length - 1 && i2 == originalMethodCallArguments.getExpressions().size() && parametersOfMethodContainingSAM[i2].getType().isArray() || (callArg = originalMethodCallArguments.getExpression(i2)) == openBlock) continue;
            ClassNode parameterType = parametersOfMethodContainingSAM[i2].getType();
            StaticTypeCheckingSupport.extractGenericsConnections(targetMethodDeclarationClassConnections, this.getType(callArg), parameterType);
        }
        ClassNode paramTypeWithReceiverInformation = StaticTypeCheckingSupport.applyGenericsContext(targetMethodDeclarationClassConnections, param.getOriginType());
        HashMap<GenericsType.GenericsTypeName, GenericsType> SAMTypeConnections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        ClassNode classForSAM = paramTypeWithReceiverInformation.redirect();
        StaticTypeCheckingSupport.extractGenericsConnections(SAMTypeConnections, paramTypeWithReceiverInformation, classForSAM);
        MethodNode methodForSAM = ClassHelper.findSAM(classForSAM);
        ClassNode[] parameterTypesForSAM = StaticTypeCheckingVisitor.extractTypesFromParameters(methodForSAM.getParameters());
        ClassNode[] blockParameterTypes = (ClassNode[])openBlock.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
        if (blockParameterTypes == null) {
            Parameter[] p = openBlock.getParameters();
            if (p == null) {
                blockParameterTypes = ClassNode.EMPTY_ARRAY;
            } else if (p.length == 0 && parameterTypesForSAM.length != 0) {
                blockParameterTypes = parameterTypesForSAM;
            } else {
                blockParameterTypes = new ClassNode[p.length];
                for (int i3 = 0; i3 < p.length; ++i3) {
                    blockParameterTypes[i3] = p[i3] != null && !p[i3].isDynamicTyped() ? p[i3].getType() : this.typeOrNull(parameterTypesForSAM, i3);
                }
            }
        }
        for (i = 0; i < blockParameterTypes.length; ++i) {
            StaticTypeCheckingSupport.extractGenericsConnections(SAMTypeConnections, blockParameterTypes[i], this.typeOrNull(parameterTypesForSAM, i));
        }
        for (i = 0; i < blockParameterTypes.length; ++i) {
            ClassNode resolvedParameter;
            blockParameterTypes[i] = resolvedParameter = StaticTypeCheckingSupport.applyGenericsContext(SAMTypeConnections, this.typeOrNull(parameterTypesForSAM, i));
        }
        openBlock.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, blockParameterTypes);
    }

    private ClassNode typeOrNull(ClassNode[] parameterTypesForSAM, int i) {
        return i < parameterTypesForSAM.length ? parameterTypesForSAM[i] : null;
    }

    private List<ClassNode[]> getSignaturesFromHint(ClosureExpression expression, MethodNode selectedMethod, Expression hintClass, Expression options) {
        List<ClassNode[]> closureSignatures;
        try {
            ClassLoader transformLoader = this.getTransformLoader();
            Class<?> hint = transformLoader.loadClass(hintClass.getText());
            ClosureSignatureHint hintInstance = (ClosureSignatureHint)hint.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            closureSignatures = hintInstance.getClosureSignatures(selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod, this.typeCheckingContext.getSource(), this.typeCheckingContext.getCompilationUnit(), StaticTypeCheckingVisitor.convertToStringArray(options), expression);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new GroovyBugError(e);
        }
        return closureSignatures;
    }

    private List<ClassNode[]> resolveWithResolver(List<ClassNode[]> candidates, ClassNode receiver, Expression arguments, ClosureExpression expression, MethodNode selectedMethod, Expression resolverClass, Expression options) {
        try {
            ClassLoader transformLoader = this.getTransformLoader();
            Class<?> resolver = transformLoader.loadClass(resolverClass.getText());
            ClosureSignatureConflictResolver resolverInstance = (ClosureSignatureConflictResolver)resolver.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return resolverInstance.resolve(candidates, receiver, arguments, expression, selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod, this.typeCheckingContext.getSource(), this.typeCheckingContext.getCompilationUnit(), StaticTypeCheckingVisitor.convertToStringArray(options));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new GroovyBugError(e);
        }
    }

    private ClassLoader getTransformLoader() {
        CompilationUnit compilationUnit = this.typeCheckingContext.getCompilationUnit();
        return compilationUnit != null ? compilationUnit.getTransformLoader() : this.getSourceUnit().getClassLoader();
    }

    private void doInferClosureParameterTypes(ClassNode receiver, Expression arguments, ClosureExpression expression, MethodNode selectedMethod, Expression hintClass, Expression resolverClass, Expression options) {
        Parameter[] closureParams = expression.getParameters();
        if (closureParams == null) {
            return;
        }
        List<ClassNode[]> closureSignatures = this.getSignaturesFromHint(expression, selectedMethod, hintClass, options);
        List<ClassNode[]> candidates = new LinkedList<ClassNode[]>();
        for (ClassNode[] signature : closureSignatures) {
            ClassNode[] inferred = this.resolveGenericsFromTypeHint(receiver, arguments, selectedMethod, signature);
            if (signature.length != closureParams.length && (signature.length != 1 || closureParams.length != 0) && (closureParams.length <= signature.length || !inferred[inferred.length - 1].isArray())) continue;
            candidates.add(inferred);
        }
        if (candidates.size() > 1) {
            Iterator candIt = candidates.iterator();
            while (candIt.hasNext()) {
                ClassNode[] inferred = (ClassNode[])candIt.next();
                int n = closureParams.length;
                for (int i = 0; i < n; ++i) {
                    ClassNode inferredType;
                    Parameter closureParam = closureParams[i];
                    ClassNode originType = closureParam.getOriginType();
                    if (i < inferred.length - 1 || inferred.length == closureParams.length) {
                        inferredType = inferred[i];
                    } else {
                        ClassNode lastArgInferred = inferred[inferred.length - 1];
                        if (lastArgInferred.isArray()) {
                            inferredType = lastArgInferred.getComponentType();
                        } else {
                            candIt.remove();
                            continue;
                        }
                    }
                    if (StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(originType, inferredType, i == n - 1)) continue;
                    candIt.remove();
                }
            }
            if (candidates.size() > 1 && resolverClass instanceof ClassExpression) {
                candidates = this.resolveWithResolver(candidates, receiver, arguments, expression, selectedMethod, resolverClass, options);
            }
            if (candidates.size() > 1) {
                this.addError("Ambiguous prototypes for closure. More than one target method matches. Please use explicit argument types.", expression);
            }
        }
        if (candidates.size() == 1) {
            ClassNode[] inferred = (ClassNode[])candidates.get(0);
            if (closureParams.length == 0 && inferred.length == 1) {
                expression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, inferred);
            } else {
                int n = closureParams.length;
                for (int i = 0; i < n; ++i) {
                    boolean lastArg;
                    Parameter closureParam = closureParams[i];
                    ClassNode originType = closureParam.getOriginType();
                    ClassNode inferredType = ClassHelper.OBJECT_TYPE;
                    if (i < inferred.length - 1 || inferred.length == closureParams.length) {
                        inferredType = inferred[i];
                    } else {
                        ClassNode lastArgInferred = inferred[inferred.length - 1];
                        if (lastArgInferred.isArray()) {
                            inferredType = lastArgInferred.getComponentType();
                        } else {
                            this.addError("Incorrect number of parameters. Expected " + inferred.length + " but found " + closureParams.length, expression);
                        }
                    }
                    boolean bl = lastArg = i == n - 1;
                    if (!StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(originType, inferredType, lastArg)) {
                        this.addError("Expected parameter of type " + inferredType.toString(false) + " but got " + originType.toString(false), closureParam.getType());
                    }
                    this.typeCheckingContext.controlStructureVariables.put(closureParam, inferredType);
                }
            }
        }
    }

    private ClassNode[] resolveGenericsFromTypeHint(ClassNode receiver, Expression arguments, MethodNode selectedMethod, ClassNode[] signature) {
        ClassNode dummyResultNode = new ClassNode("ClForInference$" + UNIQUE_LONG.incrementAndGet(), 0, ClassHelper.OBJECT_TYPE).getPlainNodeReference();
        GenericsType[] genericTypes = new GenericsType[signature.length];
        int n = signature.length;
        for (int i = 0; i < n; ++i) {
            genericTypes[i] = new GenericsType(signature[i]);
        }
        dummyResultNode.setGenericsTypes(genericTypes);
        MethodNode dummyMN = selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod;
        dummyMN = new MethodNode(dummyMN.getName(), dummyMN.getModifiers(), dummyResultNode, dummyMN.getParameters(), dummyMN.getExceptions(), EmptyStatement.INSTANCE);
        dummyMN.setDeclaringClass(selectedMethod.getDeclaringClass());
        dummyMN.setGenericsTypes(selectedMethod.getGenericsTypes());
        if (selectedMethod instanceof ExtensionMethodNode) {
            ExtensionMethodNode orig = (ExtensionMethodNode)selectedMethod;
            dummyMN = new ExtensionMethodNode(dummyMN, dummyMN.getName(), dummyMN.getModifiers(), dummyResultNode, orig.getParameters(), orig.getExceptions(), EmptyStatement.INSTANCE, orig.isStaticExtension());
            dummyMN.setDeclaringClass(orig.getDeclaringClass());
            dummyMN.setGenericsTypes(orig.getGenericsTypes());
        }
        ClassNode returnType = this.inferReturnTypeGenerics(receiver, dummyMN, arguments);
        GenericsType[] returnTypeGenerics = returnType.getGenericsTypes();
        ClassNode[] inferred = new ClassNode[returnTypeGenerics.length];
        int n2 = returnTypeGenerics.length;
        for (int i = 0; i < n2; ++i) {
            inferred[i] = StaticTypeCheckingSupport.getCombinedBoundType(returnTypeGenerics[i]);
        }
        return inferred;
    }

    private static String[] convertToStringArray(Expression options) {
        if (options == null) {
            return ResolveVisitor.EMPTY_STRING_ARRAY;
        }
        if (options instanceof ConstantExpression) {
            return new String[]{options.getText()};
        }
        if (options instanceof ListExpression) {
            List<Expression> list = ((ListExpression)options).getExpressions();
            ArrayList<String> result = new ArrayList<String>(list.size());
            for (Expression expression : list) {
                result.add(expression.getText());
            }
            return result.toArray(new String[0]);
        }
        throw new IllegalArgumentException("Unexpected options for @ClosureParams:" + options);
    }

    private void checkClosureWithDelegatesTo(ClassNode receiver, MethodNode mn, ArgumentListExpression arguments, Parameter[] params, Expression expression, Parameter param) {
        List<AnnotationNode> annotations = param.getAnnotations(DELEGATES_TO);
        if (annotations != null && !annotations.isEmpty()) {
            for (AnnotationNode annotation : annotations) {
                Expression value = annotation.getMember("value");
                Expression strategy = annotation.getMember("strategy");
                Expression genericTypeIndex = annotation.getMember("genericTypeIndex");
                Expression type = annotation.getMember("type");
                Integer stInt = 0;
                if (strategy != null) {
                    stInt = (Integer)StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(ClassHelper.Integer_TYPE, strategy), this.typeCheckingContext.source.getConfiguration());
                }
                if (value instanceof ClassExpression && !value.getType().equals(DELEGATES_TO_TARGET)) {
                    if (genericTypeIndex != null) {
                        this.addStaticTypeError("Cannot use @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") without @DelegatesTo.Target because generic argument types are not available at runtime", value);
                    }
                    expression.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(value.getType(), stInt, this.typeCheckingContext.delegationMetadata));
                    continue;
                }
                if (type != null && !"".equals(type.getText()) && type instanceof ConstantExpression) {
                    String typeString = type.getText();
                    ClassNode[] resolved = GenericsUtils.parseClassNodesFromString(typeString, this.getSourceUnit(), this.typeCheckingContext.compilationUnit, mn, type);
                    if (resolved == null) continue;
                    if (resolved.length == 1) {
                        resolved = this.resolveGenericsFromTypeHint(receiver, arguments, mn, resolved);
                        expression.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(resolved[0], stInt, this.typeCheckingContext.delegationMetadata));
                        continue;
                    }
                    this.addStaticTypeError("Incorrect type hint found in method " + mn, type);
                    continue;
                }
                List<Expression> expressions = arguments.getExpressions();
                int expressionsSize = expressions.size();
                Expression parameter = annotation.getMember("target");
                String parameterName = parameter instanceof ConstantExpression ? parameter.getText() : "";
                int paramsLength = params.length;
                for (int j = 0; j < paramsLength; ++j) {
                    String id;
                    Parameter methodParam = params[j];
                    List<AnnotationNode> targets = methodParam.getAnnotations(DELEGATES_TO_TARGET);
                    if (targets == null || targets.size() != 1) continue;
                    AnnotationNode targetAnnotation = targets.get(0);
                    Expression idMember = targetAnnotation.getMember("value");
                    String string = id = idMember instanceof ConstantExpression ? idMember.getText() : "";
                    if (!id.equals(parameterName) || j >= expressionsSize) continue;
                    Expression actualArgument = expressions.get(j);
                    ClassNode actualType = this.getType(actualArgument);
                    if (genericTypeIndex instanceof ConstantExpression) {
                        int gti = Integer.parseInt(genericTypeIndex.getText());
                        ClassNode paramType = methodParam.getType();
                        GenericsType[] genericsTypes = paramType.getGenericsTypes();
                        if (genericsTypes == null) {
                            this.addStaticTypeError("Cannot use @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") with a type that doesn't use generics", methodParam);
                        } else if (gti < 0 || gti >= genericsTypes.length) {
                            this.addStaticTypeError("Index of generic type @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") " + (gti < 0 ? "lower" : "greater") + " than those of the selected type", methodParam);
                        } else {
                            ClassNode pType = GenericsUtils.parameterizeType(actualType, paramType);
                            GenericsType[] pTypeGenerics = pType.getGenericsTypes();
                            if (pTypeGenerics != null && pTypeGenerics.length > gti) {
                                actualType = pTypeGenerics[gti].getType();
                            } else {
                                this.addStaticTypeError("Unable to map actual type [" + actualType.toString(false) + "] onto " + paramType.toString(false), methodParam);
                            }
                        }
                    }
                    expression.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(actualType, stInt, this.typeCheckingContext.delegationMetadata));
                    break;
                }
                if (expression.getNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA) != null) continue;
                this.addError("Not enough arguments found for a @DelegatesTo method call. Please check that you either use an explicit class or @DelegatesTo.Target with a correct id", annotation);
            }
        }
    }

    protected void addReceivers(List<Receiver<String>> receivers, Collection<Receiver<String>> owners, boolean implicitThis) {
        if (!implicitThis || this.typeCheckingContext.delegationMetadata == null) {
            receivers.addAll(owners);
        } else {
            StaticTypeCheckingVisitor.addReceivers(receivers, owners, this.typeCheckingContext.delegationMetadata, "");
        }
    }

    private static void addReceivers(List<Receiver<String>> receivers, Collection<Receiver<String>> owners, DelegationMetadata dmd, String path) {
        int strategy = dmd.getStrategy();
        switch (strategy) {
            case 1: 
            case 3: {
                StaticTypeCheckingVisitor.addDelegateReceiver(receivers, dmd.getType(), path + "delegate");
                if (strategy != 1) break;
                if (dmd.getParent() == null) {
                    receivers.addAll(owners);
                    break;
                }
                StaticTypeCheckingVisitor.addReceivers(receivers, owners, dmd.getParent(), path + "owner.");
                break;
            }
            case 0: 
            case 2: {
                if (dmd.getParent() == null) {
                    receivers.addAll(owners);
                } else {
                    StaticTypeCheckingVisitor.addReceivers(receivers, owners, dmd.getParent(), path + "owner.");
                }
                if (strategy != 0) break;
                StaticTypeCheckingVisitor.addDelegateReceiver(receivers, dmd.getType(), path + "delegate");
            }
        }
    }

    private static void addDelegateReceiver(List<Receiver<String>> receivers, ClassNode delegate, String path) {
        for (Receiver<String> receiver : receivers) {
            if (!receiver.getType().equals(delegate)) continue;
            return;
        }
        receivers.add(new Receiver<String>(delegate, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        String name = call.getMethodAsString();
        if (name == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call.getMethod());
            return;
        }
        if (this.extension.beforeMethodCall(call)) {
            this.extension.afterMethodCall(call);
            return;
        }
        this.typeCheckingContext.pushEnclosingMethodCall(call);
        Expression objectExpression = call.getObjectExpression();
        objectExpression.visit(this);
        call.getMethod().visit(this);
        if (call.isSpreadSafe()) {
            ClassNode expressionType = this.getType(objectExpression);
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(expressionType, StaticTypeCheckingSupport.Collection_TYPE) && !expressionType.isArray()) {
                this.addStaticTypeError("Spread operator can only be used on collection types", objectExpression);
                return;
            }
            ClassNode componentType = this.inferComponentType(expressionType, ClassHelper.int_TYPE);
            MethodCallExpression subcall = GeneralUtils.callX((Expression)GeneralUtils.castX(componentType, EmptyExpression.INSTANCE), name, call.getArguments());
            subcall.setLineNumber(call.getLineNumber());
            subcall.setColumnNumber(call.getColumnNumber());
            subcall.setImplicitThis(call.isImplicitThis());
            this.visitMethodCallExpression(subcall);
            ClassNode subcallReturnType = this.getType(subcall);
            ClassNode listNode = ClassHelper.LIST_TYPE.getPlainNodeReference();
            listNode.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(subcallReturnType))});
            this.storeType(call, listNode);
            this.storeTargetMethod(call, (MethodNode)subcall.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
            this.typeCheckingContext.popEnclosingMethodCall();
            return;
        }
        Expression callArguments = call.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(callArguments);
        this.checkForbiddenSpreadArgument(argumentList);
        ClassNode receiver = this.getType(objectExpression);
        this.visitMethodCallArguments(receiver, argumentList, false, null);
        ClassNode[] args = this.getArgumentTypes(argumentList);
        boolean isCallOnClosure = this.isClosureCall(name, objectExpression, callArguments);
        try {
            Parameter[] parameters;
            boolean callArgsVisited = false;
            if (isCallOnClosure) {
                if (ExpressionUtils.isThisExpression(objectExpression)) {
                    FieldNode field = this.typeCheckingContext.getEnclosingClassNode().getDeclaredField(name);
                    GenericsType[] genericsTypes = field.getType().getGenericsTypes();
                    if (genericsTypes != null) {
                        parameters = (Parameter[])field.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                        if (parameters != null) {
                            this.typeCheckClosureCall(callArguments, args, parameters);
                        }
                        ClassNode closureReturnType = genericsTypes[0].getType();
                        this.storeType(call, closureReturnType);
                    }
                } else if (objectExpression instanceof VariableExpression) {
                    Variable variable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression);
                    if (variable instanceof ASTNode) {
                        ClassNode type;
                        Object data = ((ASTNode)((Object)variable)).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                        if (data != null) {
                            parameters = (Parameter[])data;
                            this.typeCheckClosureCall(callArguments, args, parameters);
                        }
                        if (ClassHelper.CLOSURE_TYPE.equals(type = this.getType((ASTNode)((Object)variable)))) {
                            GenericsType[] genericsTypes = type.getGenericsTypes();
                            type = genericsTypes != null && genericsTypes.length == 1 && genericsTypes[0].getLowerBound() == null ? StaticTypeCheckingSupport.getCombinedBoundType(genericsTypes[0]) : ClassHelper.OBJECT_TYPE;
                        }
                        if (type != null) {
                            this.storeType(call, type);
                        }
                    }
                } else if (objectExpression instanceof ClosureExpression) {
                    ClassNode type;
                    Parameter[] parameters2 = ((ClosureExpression)objectExpression).getParameters();
                    if (parameters2 != null) {
                        this.typeCheckClosureCall(callArguments, args, parameters2);
                    }
                    if ((type = this.getInferredReturnType(objectExpression)) != null) {
                        this.storeType(call, type);
                    }
                }
                int nArgs = 0;
                if (callArguments instanceof ArgumentListExpression) {
                    nArgs = ((ArgumentListExpression)callArguments).getExpressions().size();
                }
                this.storeTargetMethod(call, nArgs == 0 ? CLOSURE_CALL_NO_ARG : (nArgs == 1 ? CLOSURE_CALL_ONE_ARG : CLOSURE_CALL_VARGS));
            } else {
                ArrayList<Receiver<String>> receivers = new ArrayList<Receiver<String>>();
                this.addReceivers(receivers, this.makeOwnerList(objectExpression), call.isImplicitThis());
                List<MethodNode> mn = null;
                Receiver chosenReceiver = null;
                for (Receiver receiver2 : receivers) {
                    ClassNode receiverType = receiver2.getType();
                    mn = this.findMethod(receiverType, name, args);
                    if (!mn.isEmpty() && receiver2.getData() == null && (ExpressionUtils.isThisExpression(objectExpression) || call.isImplicitThis()) && (this.typeCheckingContext.isInStaticContext || Modifier.isStatic(receiverType.getModifiers()))) {
                        LinkedList<MethodNode> accessibleMethods = new LinkedList<MethodNode>();
                        LinkedList<MethodNode> inaccessibleMethods = new LinkedList<MethodNode>();
                        for (MethodNode node : mn) {
                            if (node.isStatic() || !this.typeCheckingContext.isInStaticContext && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(receiverType, node.getDeclaringClass())) {
                                accessibleMethods.add(node);
                                continue;
                            }
                            inaccessibleMethods.add(node);
                        }
                        mn = accessibleMethods;
                        if (accessibleMethods.isEmpty()) {
                            MethodNode node = (MethodNode)inaccessibleMethods.get(0);
                            ClassNode owner = node.getDeclaringClass();
                            this.addStaticTypeError("Non static method " + owner.getName() + "#" + node.getName() + " cannot be called from static context", call);
                        }
                    }
                    if (mn.isEmpty()) continue;
                    chosenReceiver = receiver2;
                    break;
                }
                if (mn.isEmpty() && call.isImplicitThis() && ExpressionUtils.isThisExpression(objectExpression) && this.typeCheckingContext.getEnclosingClosure() != null && !(mn = ClassHelper.CLOSURE_TYPE.getDeclaredMethods(name)).isEmpty()) {
                    chosenReceiver = Receiver.make(ClassHelper.CLOSURE_TYPE);
                    objectExpression.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                }
                if (mn.isEmpty()) {
                    mn = this.extension.handleMissingMethod(receiver, name, argumentList, args, call);
                }
                if (mn.isEmpty()) {
                    this.addNoMatchingMethodError(receiver, name, args, call);
                } else {
                    if (this.areCategoryMethodCalls(mn, name, args)) {
                        this.addCategoryMethodCallError(call);
                    }
                    if ((mn = this.disambiguateMethods(mn, chosenReceiver != null ? chosenReceiver.getType() : null, args, call)).size() == 1) {
                        ClassNode classNode;
                        MethodNode directMethodCallCandidate = mn.get(0);
                        if (call.getNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION) == null && !directMethodCallCandidate.isStatic() && objectExpression instanceof ClassExpression && !"java.lang.Class".equals(directMethodCallCandidate.getDeclaringClass().getName())) {
                            ClassNode classNode2 = directMethodCallCandidate.getDeclaringClass();
                            this.addStaticTypeError("Non static method " + classNode2.getName() + "#" + directMethodCallCandidate.getName() + " cannot be called from static context", call);
                        }
                        if (chosenReceiver == null) {
                            chosenReceiver = Receiver.make(directMethodCallCandidate.getDeclaringClass());
                        }
                        if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(classNode = this.getType(directMethodCallCandidate))) {
                            this.visitMethodCallArguments(chosenReceiver.getType(), argumentList, true, directMethodCallCandidate);
                            ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver.getType(), directMethodCallCandidate, callArguments, call.getGenericsTypes());
                            ClassNode classNode3 = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, classNode) ? irtg : classNode;
                            callArgsVisited = true;
                        }
                        if (directMethodCallCandidate == GET_DELEGATE && this.typeCheckingContext.getEnclosingClosure() != null) {
                            DelegationMetadata md = this.getDelegationMetadata(this.typeCheckingContext.getEnclosingClosure().getClosureExpression());
                            if (md != null) {
                                ClassNode classNode4 = md.getType();
                            } else {
                                ClassNode classNode5 = this.typeCheckingContext.getEnclosingClassNode();
                            }
                        }
                        this.resolvePlaceholdersFromImplicitTypeHints(args, argumentList, directMethodCallCandidate.getParameters());
                        if (this.typeCheckMethodsWithGenericsOrFail(chosenReceiver.getType(), args, directMethodCallCandidate, call)) {
                            VariableExpression var;
                            String data;
                            void var14_32;
                            ClassNode classNode6 = StaticTypeCheckingVisitor.adjustWithTraits(directMethodCallCandidate, chosenReceiver.getType(), args, (ClassNode)var14_32);
                            this.storeType(call, classNode6);
                            this.storeTargetMethod(call, directMethodCallCandidate);
                            ClassNode declaringClass = directMethodCallCandidate.getDeclaringClass();
                            if (declaringClass.isInterface() && directMethodCallCandidate.isStatic() && !(directMethodCallCandidate instanceof ExtensionMethodNode)) {
                                this.typeCheckingContext.getEnclosingClassNode().putNodeMetaData("_MINIMUM_BYTECODE_VERSION", 52);
                            }
                            if ((data = (String)chosenReceiver.getData()) != null) {
                                call.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, data);
                            }
                            receiver = chosenReceiver.getType();
                            if (objectExpression instanceof VariableExpression && (var = (VariableExpression)objectExpression).isClosureSharedVariable()) {
                                SecondPassExpression<ClassNode[]> wrapper = new SecondPassExpression<ClassNode[]>(call, args);
                                this.typeCheckingContext.secondPassExpressions.add(wrapper);
                            }
                        }
                    } else {
                        this.addAmbiguousErrorMessage(mn, name, args, call);
                    }
                }
            }
            if (StaticTypeCheckingSupport.NUMBER_OPS.containsKey(name) && ClassHelper.isNumberType(receiver) && argumentList.getExpressions().size() == 1 && ClassHelper.isNumberType(this.getType(argumentList.getExpression(0)))) {
                ClassNode right = this.getType(argumentList.getExpression(0));
                ClassNode resultType = this.getMathResultType(StaticTypeCheckingSupport.NUMBER_OPS.get(name), receiver, right, name);
                if (resultType != null) {
                    this.storeType(call, resultType);
                }
            }
            if (!callArgsVisited) {
                MethodNode mn = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                this.visitMethodCallArguments(receiver, argumentList, true, mn);
                if (mn != null) {
                    List<Expression> argExpressions = argumentList.getExpressions();
                    parameters = mn.getParameters();
                    for (int i = 0; i < argExpressions.size() && i < parameters.length; ++i) {
                        Expression expression = argExpressions.get(i);
                        ClassNode pType = parameters[i].getType();
                        ClassNode aType = this.getType(expression);
                        if (!ClassHelper.CLOSURE_TYPE.equals(pType) || !ClassHelper.CLOSURE_TYPE.equals(aType) || StaticTypeCheckingSupport.isAssignableTo(aType, pType)) continue;
                        this.addNoMatchingMethodError(receiver, name, this.getArgumentTypes(argumentList), call);
                        call.removeNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                    }
                }
            }
        }
        finally {
            this.typeCheckingContext.popEnclosingMethodCall();
            this.extension.afterMethodCall(call);
        }
    }

    private static ClassNode adjustWithTraits(MethodNode directMethodCallCandidate, ClassNode receiver, ClassNode[] args, ClassNode returnType) {
        ExtensionMethodNode emn;
        if (directMethodCallCandidate instanceof ExtensionMethodNode && "withTraits".equals((emn = (ExtensionMethodNode)directMethodCallCandidate).getName()) && "DefaultGroovyMethods".equals(emn.getExtensionMethodNode().getDeclaringClass().getNameWithoutPackage())) {
            LinkedList<ClassNode> nodes = new LinkedList<ClassNode>();
            Collections.addAll(nodes, receiver.getInterfaces());
            for (ClassNode arg : args) {
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(arg)) {
                    nodes.add(arg.getGenericsTypes()[0].getType());
                    continue;
                }
                nodes.add(arg);
            }
            return new WideningCategories.LowestUpperBoundClassNode(returnType.getName() + "Composed", ClassHelper.OBJECT_TYPE, nodes.toArray(ClassNode.EMPTY_ARRAY));
        }
        return returnType;
    }

    private static void addArrayMethods(List<MethodNode> methods, ClassNode receiver, String name, ClassNode[] args) {
        if (!receiver.isArray()) {
            return;
        }
        if (args == null || args.length != 1) {
            return;
        }
        if (!WideningCategories.isIntCategory(ClassHelper.getUnwrapper(args[0]))) {
            return;
        }
        if ("getAt".equals(name)) {
            MethodNode node = new MethodNode(name, 1, receiver.getComponentType(), new Parameter[]{new Parameter(args[0], "arg")}, null, null);
            node.setDeclaringClass(receiver.redirect());
            methods.add(node);
        } else if ("setAt".equals(name)) {
            MethodNode node = new MethodNode(name, 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(args[0], "arg")}, null, null);
            node.setDeclaringClass(receiver.redirect());
            methods.add(node);
        }
    }

    protected ClassNode getInferredReturnTypeFromWithClosureArgument(Expression callArguments) {
        if (!(callArguments instanceof ArgumentListExpression)) {
            return null;
        }
        ArgumentListExpression argList = (ArgumentListExpression)callArguments;
        ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
        this.visitClosureExpression(closure);
        return this.getInferredReturnType(closure);
    }

    protected List<Receiver<String>> makeOwnerList(Expression objectExpression) {
        ClassNode receiver = this.getType(objectExpression);
        ArrayList<Receiver<String>> owners = new ArrayList<Receiver<String>>();
        if (this.typeCheckingContext.delegationMetadata != null && objectExpression instanceof VariableExpression && ((Variable)((Object)objectExpression)).getName().equals("owner") && this.typeCheckingContext.delegationMetadata.getParent() != null) {
            List<Receiver<String>> enclosingClass = Collections.singletonList(Receiver.make(this.typeCheckingContext.getEnclosingClassNode()));
            StaticTypeCheckingVisitor.addReceivers(owners, enclosingClass, this.typeCheckingContext.delegationMetadata.getParent(), "owner.");
        } else {
            ClassNode commonType;
            int temporaryTypesCount;
            List<ClassNode> temporaryTypes = this.getTemporaryTypesForExpression(objectExpression);
            int n = temporaryTypesCount = temporaryTypes != null ? temporaryTypes.size() : 0;
            if (temporaryTypesCount > 0 && !(commonType = WideningCategories.lowestUpperBound(temporaryTypes)).equals(ClassHelper.OBJECT_TYPE)) {
                owners.add(Receiver.make(commonType));
            }
            if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver)) {
                ClassNode staticType = receiver.getGenericsTypes()[0].getType();
                owners.add(Receiver.make(staticType));
                StaticTypeCheckingVisitor.addTraitType(staticType, owners);
                owners.add(Receiver.make(receiver));
            } else {
                StaticTypeCheckingVisitor.addBoundType(receiver, owners);
                StaticTypeCheckingVisitor.addSelfTypes(receiver, owners);
                StaticTypeCheckingVisitor.addTraitType(receiver, owners);
                if (receiver.redirect().isInterface()) {
                    owners.add(Receiver.make(ClassHelper.OBJECT_TYPE));
                }
            }
            if (this.typeCheckingContext.lastImplicitItType != null && objectExpression instanceof VariableExpression && ((Variable)((Object)objectExpression)).getName().equals("it")) {
                owners.add(Receiver.make(this.typeCheckingContext.lastImplicitItType));
            }
            if (temporaryTypesCount > 1) {
                owners.add(Receiver.make(new UnionTypeClassNode(temporaryTypes.toArray(ClassNode.EMPTY_ARRAY))));
            }
        }
        return owners;
    }

    private static void addBoundType(ClassNode receiver, List<Receiver<String>> owners) {
        if (!receiver.isGenericsPlaceHolder() || receiver.getGenericsTypes() == null) {
            owners.add(Receiver.make(receiver));
            return;
        }
        GenericsType gt = receiver.getGenericsTypes()[0];
        if (gt.getLowerBound() == null && gt.getUpperBounds() != null) {
            for (ClassNode cn : gt.getUpperBounds()) {
                StaticTypeCheckingVisitor.addBoundType(cn, owners);
                StaticTypeCheckingVisitor.addSelfTypes(cn, owners);
            }
        } else {
            owners.add(Receiver.make(ClassHelper.OBJECT_TYPE));
        }
    }

    private static void addSelfTypes(ClassNode receiver, List<Receiver<String>> owners) {
        for (ClassNode selfType : Traits.collectSelfTypes(receiver, new LinkedHashSet<ClassNode>())) {
            owners.add(Receiver.make(selfType));
        }
    }

    private static void addTraitType(ClassNode receiver, List<Receiver<String>> owners) {
        if (Traits.isTrait(receiver.getOuterClass()) && receiver.getName().endsWith("$Helper")) {
            ClassNode traitType = receiver.getOuterClass();
            owners.add(Receiver.make(traitType));
            StaticTypeCheckingVisitor.addSelfTypes(traitType, owners);
        }
    }

    protected void checkForbiddenSpreadArgument(ArgumentListExpression argumentList) {
        for (Expression arg : argumentList.getExpressions()) {
            if (!(arg instanceof SpreadExpression)) continue;
            this.addStaticTypeError("The spread operator cannot be used as argument of method or closure calls with static type checking because the number of arguments cannot be determined at compile time", arg);
        }
    }

    protected List<ClassNode> getTemporaryTypesForExpression(Expression objectExpression) {
        List classNodes = null;
        int depth = this.typeCheckingContext.temporaryIfBranchTypeInformation.size();
        while (classNodes == null && depth > 0) {
            Map tempo = (Map)this.typeCheckingContext.temporaryIfBranchTypeInformation.get(--depth);
            Object key = objectExpression instanceof ParameterVariableExpression ? ((ParameterVariableExpression)objectExpression).parameter : this.extractTemporaryTypeInfoKey(objectExpression);
            classNodes = (List)tempo.get(key);
        }
        return classNodes;
    }

    protected void storeTargetMethod(Expression call, MethodNode directMethodCallCandidate) {
        call.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, directMethodCallCandidate);
        this.checkOrMarkPrivateAccess(call, directMethodCallCandidate);
        this.checkSuperCallFromClosure(call, directMethodCallCandidate);
        this.extension.onMethodSelection(call, directMethodCallCandidate);
    }

    protected boolean isClosureCall(String name, Expression objectExpression, Expression arguments) {
        if (objectExpression instanceof ClosureExpression && ("call".equals(name) || "doCall".equals(name))) {
            return true;
        }
        if (ExpressionUtils.isThisExpression(objectExpression)) {
            ClassNode type;
            FieldNode fieldNode = this.typeCheckingContext.getEnclosingClassNode().getDeclaredField(name);
            if (fieldNode != null && ClassHelper.CLOSURE_TYPE.equals(type = fieldNode.getType()) && !this.typeCheckingContext.getEnclosingClassNode().hasPossibleMethod(name, arguments)) {
                return true;
            }
        } else if (!"call".equals(name) && !"doCall".equals(name)) {
            return false;
        }
        return this.getType(objectExpression).equals(ClassHelper.CLOSURE_TYPE);
    }

    protected void typeCheckClosureCall(Expression arguments, ClassNode[] argumentTypes, Parameter[] parameters) {
        if (StaticTypeCheckingSupport.allParametersAndArgumentsMatchWithDefaultParams(parameters, argumentTypes) < 0 && StaticTypeCheckingSupport.lastArgMatchesVarg(parameters, argumentTypes) < 0) {
            this.addStaticTypeError("Cannot call closure that accepts " + StaticTypeCheckingVisitor.formatArgumentList(StaticTypeCheckingVisitor.extractTypesFromParameters(parameters)) + "with " + StaticTypeCheckingVisitor.formatArgumentList(argumentTypes), arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIfElse(IfStatement ifElse) {
        BinaryExpression instanceOfExpression;
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        try {
            this.typeCheckingContext.pushTemporaryTypeInfo();
            this.visitStatement(ifElse);
            ifElse.getBooleanExpression().visit(this);
            ifElse.getIfBlock().visit(this);
            this.typeCheckingContext.popTemporaryTypeInfo();
            this.restoreTypeBeforeConditional();
            Statement elseBlock = ifElse.getElseBlock();
            if (elseBlock instanceof EmptyStatement) {
                this.visitEmptyStatement((EmptyStatement)elseBlock);
            } else {
                elseBlock.visit(this);
            }
            Map updates = (Map)elseBlock.getNodeMetaData("assignments");
            if (updates != null) {
                for (Map.Entry entry : updates.entrySet()) {
                    this.recordAssignment((VariableExpression)entry.getKey(), (ClassNode)entry.getValue());
                }
            }
        }
        finally {
            ifElse.putNodeMetaData("assignments", this.popAssignmentTracking(oldTracker));
        }
        if (!this.typeCheckingContext.enclosingBlocks.isEmpty() && (instanceOfExpression = this.findInstanceOfNotReturnExpression(ifElse)) != null) {
            this.visitInstanceofNot(instanceOfExpression);
        }
    }

    public void visitInstanceofNot(BinaryExpression be) {
        BlockStatement currentBlock = this.typeCheckingContext.enclosingBlocks.getFirst();
        if (!this.typeCheckingContext.blockStatements2Types.containsKey(currentBlock)) {
            Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
            this.getTypeCheckingContext().pushTemporaryTypeInfo();
            this.typeCheckingContext.blockStatements2Types.put(currentBlock, oldTracker);
        }
        this.pushInstanceOfTypeInfo(be.getLeftExpression(), be.getRightExpression());
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        if (block != null) {
            this.typeCheckingContext.enclosingBlocks.addFirst(block);
        }
        super.visitBlockStatement(block);
        if (block != null) {
            this.visitClosingBlock(block);
        }
    }

    public void visitClosingBlock(BlockStatement block) {
        BlockStatement peekBlock = this.typeCheckingContext.enclosingBlocks.removeFirst();
        boolean found = this.typeCheckingContext.blockStatements2Types.containsKey(peekBlock);
        if (found) {
            Map<VariableExpression, List<ClassNode>> oldTracker = this.typeCheckingContext.blockStatements2Types.remove(peekBlock);
            this.getTypeCheckingContext().popTemporaryTypeInfo();
            this.popAssignmentTracking(oldTracker);
        }
    }

    public BinaryExpression findInstanceOfNotReturnExpression(IfStatement ifElse) {
        Statement elseBlock = ifElse.getElseBlock();
        if (!(elseBlock instanceof EmptyStatement)) {
            return null;
        }
        Expression conditionExpression = ifElse.getBooleanExpression().getExpression();
        if (!(conditionExpression instanceof NotExpression)) {
            return null;
        }
        NotExpression notExpression = (NotExpression)conditionExpression;
        Expression expression = notExpression.getExpression();
        if (!(expression instanceof BinaryExpression)) {
            return null;
        }
        BinaryExpression instanceOfExpression = (BinaryExpression)expression;
        int op = instanceOfExpression.getOperation().getType();
        if (op != 544) {
            return null;
        }
        Statement block = ifElse.getIfBlock();
        if (!(block instanceof BlockStatement)) {
            return null;
        }
        BlockStatement bs = (BlockStatement)block;
        if (bs.getStatements().size() == 0) {
            return null;
        }
        Statement last = DefaultGroovyMethods.last(bs.getStatements());
        if (!(last instanceof ReturnStatement)) {
            return null;
        }
        return instanceOfExpression;
    }

    @Override
    public void visitSwitch(SwitchStatement statement) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        try {
            super.visitSwitch(statement);
        }
        finally {
            this.popAssignmentTracking(oldTracker);
        }
    }

    @Override
    public void visitCaseStatement(CaseStatement statement) {
        super.visitCaseStatement(statement);
        this.restoreTypeBeforeConditional();
    }

    private void recordAssignment(VariableExpression lhsExpr, ClassNode rhsType) {
        List<ClassNode> types = this.typeCheckingContext.ifElseForWhileAssignmentTracker.get(lhsExpr);
        if (types == null) {
            types = new LinkedList<ClassNode>();
            ClassNode lhsType = (ClassNode)lhsExpr.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            types.add(lhsType);
            this.typeCheckingContext.ifElseForWhileAssignmentTracker.put(lhsExpr, types);
        }
        types.add(rhsType);
    }

    private void restoreTypeBeforeConditional() {
        Set<Map.Entry<VariableExpression, List<ClassNode>>> entries = this.typeCheckingContext.ifElseForWhileAssignmentTracker.entrySet();
        for (Map.Entry<VariableExpression, List<ClassNode>> entry : entries) {
            VariableExpression ve = entry.getKey();
            List<ClassNode> types = entry.getValue();
            ve.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, types.get(0));
        }
    }

    protected Map<VariableExpression, ClassNode> popAssignmentTracking(Map<VariableExpression, List<ClassNode>> oldTracker) {
        HashMap<VariableExpression, ClassNode> assignments = new HashMap<VariableExpression, ClassNode>();
        if (!this.typeCheckingContext.ifElseForWhileAssignmentTracker.isEmpty()) {
            for (Map.Entry<VariableExpression, List<ClassNode>> entry : this.typeCheckingContext.ifElseForWhileAssignmentTracker.entrySet()) {
                VariableExpression key = entry.getKey();
                List<ClassNode> allValues = entry.getValue();
                ArrayList<ClassNode> nonNullValues = new ArrayList<ClassNode>(allValues.size());
                for (ClassNode value : allValues) {
                    if (value == null || value == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE) continue;
                    nonNullValues.add(value);
                }
                if (nonNullValues.isEmpty()) continue;
                ClassNode cn = WideningCategories.lowestUpperBound(nonNullValues);
                assignments.put(key, cn);
                this.storeType(key, cn);
            }
        }
        this.typeCheckingContext.ifElseForWhileAssignmentTracker = oldTracker;
        return assignments;
    }

    protected Map<VariableExpression, List<ClassNode>> pushAssignmentTracking() {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.typeCheckingContext.ifElseForWhileAssignmentTracker;
        this.typeCheckingContext.ifElseForWhileAssignmentTracker = new HashMap<VariableExpression, List<ClassNode>>();
        return oldTracker;
    }

    @Override
    public void visitCastExpression(CastExpression expression) {
        ClassNode type = expression.getType();
        Expression target = expression.getExpression();
        if (StaticTypeCheckingVisitor.isFunctionalInterface(type)) {
            this.processFunctionalInterfaceAssignment(type, target);
        }
        target.visit(this);
        if (!(expression.isCoerce() || this.checkCast(type, target) || this.isDelegateOrOwnerInClosure(target))) {
            this.addStaticTypeError("Inconvertible types: cannot cast " + StaticTypeCheckingSupport.prettyPrintType(this.getType(target)) + " to " + StaticTypeCheckingSupport.prettyPrintType(type), expression);
        }
    }

    private boolean isDelegateOrOwnerInClosure(Expression exp) {
        return this.typeCheckingContext.getEnclosingClosure() != null && exp instanceof VariableExpression && ("delegate".equals(((VariableExpression)exp).getName()) || "owner".equals(((VariableExpression)exp).getName()));
    }

    protected boolean checkCast(ClassNode targetType, Expression source) {
        boolean sourceIsNull = StaticTypeCheckingVisitor.isNullConstant(source);
        ClassNode expressionType = this.getType(source);
        if (targetType.isArray() && expressionType.isArray()) {
            return this.checkCast(targetType.getComponentType(), GeneralUtils.varX("foo", expressionType.getComponentType()));
        }
        if (!(targetType.equals(ClassHelper.char_TYPE) && expressionType == ClassHelper.STRING_TYPE && source instanceof ConstantExpression && source.getText().length() == 1 || targetType.equals(ClassHelper.Character_TYPE) && (expressionType == ClassHelper.STRING_TYPE || sourceIsNull) && (sourceIsNull || source instanceof ConstantExpression && source.getText().length() == 1) || WideningCategories.isNumberCategory(ClassHelper.getWrapper(targetType)) && (WideningCategories.isNumberCategory(ClassHelper.getWrapper(expressionType)) || ClassHelper.char_TYPE == expressionType) || sourceIsNull && !ClassHelper.isPrimitiveType(targetType) || ClassHelper.char_TYPE == targetType && ClassHelper.isPrimitiveType(expressionType) && ClassHelper.isNumberType(expressionType))) {
            if (sourceIsNull && ClassHelper.isPrimitiveType(targetType) && !ClassHelper.boolean_TYPE.equals(targetType)) {
                return false;
            }
            if (!Modifier.isFinal(expressionType.getModifiers()) && targetType.isInterface()) {
                return true;
            }
            if (!Modifier.isFinal(targetType.getModifiers()) && expressionType.isInterface()) {
                return true;
            }
            if (!StaticTypeCheckingSupport.isAssignableTo(targetType, expressionType) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(expressionType, targetType)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void visitTernaryExpression(TernaryExpression expression) {
        ClassNode resultType;
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        this.typeCheckingContext.pushTemporaryTypeInfo();
        if (!(expression instanceof ElvisOperatorExpression)) {
            expression.getBooleanExpression().visit(this);
        }
        Expression trueExpression = expression.getTrueExpression();
        ClassNode typeOfTrue = this.findCurrentInstanceOfClass(trueExpression, null);
        trueExpression.visit(this);
        if (typeOfTrue == null) {
            typeOfTrue = this.getType(trueExpression);
        }
        this.typeCheckingContext.popTemporaryTypeInfo();
        Expression falseExpression = expression.getFalseExpression();
        falseExpression.visit(this);
        ClassNode typeOfFalse = this.getType(falseExpression);
        if (StaticTypeCheckingVisitor.isNullConstant(trueExpression) && StaticTypeCheckingVisitor.isNullConstant(falseExpression)) {
            resultType = this.checkForTargetType(trueExpression, StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE);
        } else if (StaticTypeCheckingVisitor.isNullConstant(trueExpression) || StaticTypeCheckingVisitor.isEmptyCollection(trueExpression) && GeneralUtils.isOrImplements(typeOfTrue, typeOfFalse)) {
            resultType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.checkForTargetType(falseExpression, typeOfFalse));
        } else if (StaticTypeCheckingVisitor.isNullConstant(falseExpression) || StaticTypeCheckingVisitor.isEmptyCollection(falseExpression) && GeneralUtils.isOrImplements(typeOfFalse, typeOfTrue)) {
            resultType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.checkForTargetType(trueExpression, typeOfTrue));
        } else {
            typeOfFalse = this.checkForTargetType(falseExpression, typeOfFalse);
            typeOfTrue = this.checkForTargetType(trueExpression, typeOfTrue);
            resultType = WideningCategories.lowestUpperBound(typeOfTrue, typeOfFalse);
        }
        this.storeType(expression, resultType);
        this.popAssignmentTracking(oldTracker);
    }

    private ClassNode checkForTargetType(Expression expr, ClassNode type) {
        ClassNode sourceType = type;
        ClassNode targetType = null;
        MethodNode enclosingMethod = this.typeCheckingContext.getEnclosingMethod();
        BinaryExpression enclosingExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
        if (enclosingExpression != null && StaticTypeCheckingSupport.isAssignment(enclosingExpression.getOperation().getType()) && StaticTypeCheckingVisitor.isTypeSource(expr, enclosingExpression.getRightExpression())) {
            targetType = this.getDeclaredOrInferredType(enclosingExpression.getLeftExpression());
        } else if (enclosingMethod != null && !enclosingMethod.isAbstract() && !enclosingMethod.isVoidMethod() && StaticTypeCheckingVisitor.isTypeSource(expr, enclosingMethod)) {
            targetType = enclosingMethod.getReturnType();
        }
        if (expr instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(expr)) {
            sourceType = this.getInferredReturnType(expr);
        }
        if (expr instanceof ConstructorCallExpression) {
            if (targetType == null) {
                targetType = sourceType.getPlainNodeReference();
            }
            this.inferDiamondType((ConstructorCallExpression)expr, targetType);
            return sourceType;
        }
        if (targetType == null) {
            return sourceType;
        }
        if (!ClassHelper.isPrimitiveType(ClassHelper.getUnwrapper(targetType)) && !ClassHelper.OBJECT_TYPE.equals(targetType) && !sourceType.isGenericsPlaceHolder() && StaticTypeCheckingSupport.missesGenericsTypes(sourceType)) {
            return GenericsUtils.parameterizeType(targetType, sourceType.getPlainNodeReference());
        }
        return sourceType != StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE ? sourceType : targetType;
    }

    private static boolean isTypeSource(Expression expr, Expression right) {
        if (right instanceof TernaryExpression) {
            return StaticTypeCheckingVisitor.isTypeSource(expr, ((TernaryExpression)right).getTrueExpression()) || StaticTypeCheckingVisitor.isTypeSource(expr, ((TernaryExpression)right).getFalseExpression());
        }
        return expr == right;
    }

    private static boolean isTypeSource(final Expression expr, MethodNode mNode) {
        final boolean[] returned = new boolean[1];
        mNode.getCode().visit(new CodeVisitorSupport(){

            @Override
            public void visitReturnStatement(ReturnStatement returnStatement) {
                if (StaticTypeCheckingVisitor.isTypeSource(expr, returnStatement.getExpression())) {
                    returned[0] = true;
                }
            }

            @Override
            public void visitClosureExpression(ClosureExpression expression) {
            }
        });
        if (!returned[0]) {
            new ReturnAdder(new ReturnAdder.ReturnStatementListener(){

                @Override
                public void returnStatementAdded(ReturnStatement returnStatement) {
                    if (StaticTypeCheckingVisitor.isTypeSource(expr, returnStatement.getExpression())) {
                        returned[0] = true;
                    }
                }
            }).visitMethod(mNode);
        }
        return returned[0];
    }

    private static boolean isEmptyCollection(Expression expr) {
        return expr instanceof ListExpression && ((ListExpression)expr).getExpressions().isEmpty() || expr instanceof MapExpression && ((MapExpression)expr).getMapEntryExpressions().isEmpty();
    }

    private static boolean hasInferredReturnType(Expression expression) {
        ClassNode type = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        return type != null && !type.getName().equals("java.lang.Object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitTryCatchFinally(TryCatchStatement statement) {
        List<CatchStatement> catchStatements = statement.getCatchStatements();
        for (CatchStatement catchStatement : catchStatements) {
            ClassNode exceptionType = catchStatement.getExceptionType();
            this.typeCheckingContext.controlStructureVariables.put(catchStatement.getVariable(), exceptionType);
        }
        try {
            super.visitTryCatchFinally(statement);
        }
        finally {
            for (CatchStatement catchStatement : catchStatements) {
                this.typeCheckingContext.controlStructureVariables.remove(catchStatement.getVariable());
            }
        }
    }

    protected void storeType(Expression exp, ClassNode cn) {
        ClassNode oldValue;
        if (cn == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE) {
            cn = this.getOriginalDeclarationType(exp);
        }
        if (cn != null && ClassHelper.isPrimitiveType(cn)) {
            if (exp instanceof VariableExpression && ((VariableExpression)exp).isClosureSharedVariable()) {
                cn = ClassHelper.getWrapper(cn);
            } else if (exp instanceof MethodCallExpression && ((MethodCallExpression)exp).isSafe()) {
                cn = ClassHelper.getWrapper(cn);
            } else if (exp instanceof PropertyExpression && ((PropertyExpression)exp).isSafe()) {
                cn = ClassHelper.getWrapper(cn);
            }
        }
        if ((oldValue = (ClassNode)exp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, cn)) != null) {
            ClassNode oldDIT = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            if (oldDIT != null) {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, cn == null ? oldDIT : WideningCategories.lowestUpperBound(oldDIT, cn));
            } else {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, cn == null ? null : WideningCategories.lowestUpperBound(oldValue, cn));
            }
        }
        if (exp instanceof VariableExpression) {
            List<ClassNode> temporaryTypesForExpression;
            VariableExpression var = (VariableExpression)exp;
            Variable accessedVariable = var.getAccessedVariable();
            if (accessedVariable instanceof VariableExpression) {
                if (accessedVariable != var) {
                    this.storeType((VariableExpression)accessedVariable, cn);
                }
            } else if (accessedVariable instanceof Parameter) {
                ((Parameter)accessedVariable).putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, cn);
            }
            if (cn != null && var.isClosureSharedVariable()) {
                List<ClassNode> assignedTypes = this.typeCheckingContext.closureSharedVariablesAssignmentTypes.get(var);
                if (assignedTypes == null) {
                    assignedTypes = new LinkedList<ClassNode>();
                    this.typeCheckingContext.closureSharedVariablesAssignmentTypes.put(var, assignedTypes);
                }
                assignedTypes.add(cn);
            }
            if (!this.typeCheckingContext.temporaryIfBranchTypeInformation.isEmpty() && (temporaryTypesForExpression = this.getTemporaryTypesForExpression(var)) != null && !temporaryTypesForExpression.isEmpty()) {
                temporaryTypesForExpression.clear();
            }
        }
    }

    protected ClassNode getResultType(ClassNode left, int op, ClassNode right, BinaryExpression expr) {
        MethodNode method;
        ClassNode leftRedirect = left.redirect();
        ClassNode rightRedirect = right.redirect();
        Expression leftExpression = expr.getLeftExpression();
        Expression rightExpression = expr.getRightExpression();
        if (op == 100 || op == 1100) {
            if (leftRedirect.isArray() && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(rightRedirect, StaticTypeCheckingSupport.Collection_TYPE)) {
                return leftRedirect;
            }
            if (leftRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE) && rightRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE)) {
                List<Expression> list;
                if (rightExpression instanceof ListExpression && (list = ((ListExpression)rightExpression).getExpressions()).isEmpty()) {
                    return left;
                }
                return right;
            }
            if (rightRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE) && rightRedirect.isDerivedFrom(leftRedirect)) {
                return right;
            }
            if (rightExpression instanceof ClosureExpression && rightRedirect.isDerivedFrom(ClassHelper.CLOSURE_TYPE) && ClassHelper.isSAMType(leftRedirect)) {
                return this.inferSAMTypeGenericsInAssignment(left, ClassHelper.findSAM(left), right, (ClosureExpression)rightExpression);
            }
            if (leftExpression instanceof VariableExpression) {
                ClassNode initialType = this.getOriginalDeclarationType(leftExpression).redirect();
                if (ClassHelper.isPrimitiveType(right) && initialType.isDerivedFrom(ClassHelper.Number_TYPE)) {
                    return ClassHelper.getWrapper(right);
                }
                if (ClassHelper.isPrimitiveType(initialType) && rightRedirect.isDerivedFrom(ClassHelper.Number_TYPE)) {
                    return ClassHelper.getUnwrapper(right);
                }
                if (ClassHelper.STRING_TYPE.equals(initialType) || ClassHelper.CLASS_Type.equals(initialType) || ClassHelper.Boolean_TYPE.equals(initialType) || ClassHelper.boolean_TYPE.equals(initialType)) {
                    return initialType;
                }
            }
            return right;
        }
        if (StaticTypeCheckingSupport.isBoolIntrinsicOp(op)) {
            return ClassHelper.boolean_TYPE;
        }
        if (op == 90) {
            return StaticTypeCheckingSupport.Matcher_TYPE;
        }
        if (StaticTypeCheckingSupport.isArrayOp(op)) {
            BinaryExpression newExpr = GeneralUtils.binX(leftExpression, expr.getOperation(), rightExpression);
            newExpr.setSourcePosition(expr);
            MethodNode method2 = this.findMethodOrFail(newExpr, left.getPlainNodeReference(), "getAt", right.getPlainNodeReference());
            if (method2 != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(right, ClassHelper.RANGE_TYPE)) {
                return this.inferReturnTypeGenerics(left, method2, rightExpression);
            }
            return method2 != null ? this.inferComponentType(left, right) : null;
        }
        String operationName = StaticTypeCheckingSupport.getOperationName(op);
        if (operationName == null) {
            throw new GroovyBugError("Unknown result type for binary operator " + op);
        }
        ClassNode mathResultType = this.getMathResultType(op, leftRedirect, rightRedirect, operationName);
        if (mathResultType != null) {
            return mathResultType;
        }
        if ("equals".equals(operationName) && (left == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE || right == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE)) {
            return ClassHelper.boolean_TYPE;
        }
        if (leftExpression instanceof ClassExpression) {
            left = ClassHelper.CLASS_Type.getPlainNodeReference();
        }
        if ((method = this.findMethodOrFail(expr, left, operationName, right)) != null) {
            this.storeTargetMethod(expr, method);
            this.typeCheckMethodsWithGenericsOrFail(left, new ClassNode[]{right}, method, expr);
            if (StaticTypeCheckingSupport.isAssignment(op)) {
                return left;
            }
            if (!"compareTo".equals(operationName)) {
                return this.inferReturnTypeGenerics(left, method, GeneralUtils.args(rightExpression));
            }
        }
        if (StaticTypeCheckingSupport.isCompareToBoolean(op)) {
            return ClassHelper.boolean_TYPE;
        }
        if (op == 128) {
            return ClassHelper.int_TYPE;
        }
        return null;
    }

    private ClassNode getMathResultType(int op, ClassNode leftRedirect, ClassNode rightRedirect, String operationName) {
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
            if (StaticTypeCheckingSupport.isOperationInGroup(op)) {
                if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                    return ClassHelper.int_TYPE;
                }
                if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                    return ClassHelper.long_TYPE;
                }
                if (WideningCategories.isFloat(leftRedirect) && WideningCategories.isFloat(rightRedirect)) {
                    return ClassHelper.float_TYPE;
                }
                if (WideningCategories.isDouble(leftRedirect) && WideningCategories.isDouble(rightRedirect)) {
                    return ClassHelper.double_TYPE;
                }
            } else {
                if (StaticTypeCheckingSupport.isPowerOperator(op)) {
                    return ClassHelper.Number_TYPE;
                }
                if (StaticTypeCheckingSupport.isBitOperator(op) || op == 204 || op == 214) {
                    if (WideningCategories.isIntCategory(ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isIntCategory(ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.int_TYPE;
                    }
                    if (WideningCategories.isLongCategory(ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isLongCategory(ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.long_TYPE;
                    }
                    if (WideningCategories.isBigIntCategory(ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isBigIntCategory(ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.BigInteger_TYPE;
                    }
                } else if (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120) {
                    return ClassHelper.boolean_TYPE;
                }
            }
        } else if (ClassHelper.char_TYPE.equals(leftRedirect) && ClassHelper.char_TYPE.equals(rightRedirect) && (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120)) {
            return ClassHelper.boolean_TYPE;
        }
        if (StaticTypeCheckingSupport.isShiftOperation(operationName) && WideningCategories.isNumberCategory(leftRedirect) && (WideningCategories.isIntCategory(rightRedirect) || WideningCategories.isLongCategory(rightRedirect))) {
            return leftRedirect;
        }
        if (WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && (203 == op || 213 == op)) {
            if (WideningCategories.isFloatingCategory(leftRedirect) || WideningCategories.isFloatingCategory(rightRedirect)) {
                if (!ClassHelper.isPrimitiveType(leftRedirect) || !ClassHelper.isPrimitiveType(rightRedirect)) {
                    return ClassHelper.Double_TYPE;
                }
                return ClassHelper.double_TYPE;
            }
            if (203 == op) {
                return ClassHelper.BigDecimal_TYPE;
            }
            return leftRedirect;
        }
        if (StaticTypeCheckingSupport.isOperationInGroup(op) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect))) {
            return StaticTypeCheckingVisitor.getGroupOperationResultType(leftRedirect, rightRedirect);
        }
        if (WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && (205 == op || 215 == op)) {
            return leftRedirect;
        }
        return null;
    }

    private ClassNode inferSAMTypeGenericsInAssignment(ClassNode samUsage, MethodNode sam, ClassNode closureType, ClosureExpression closureExpression) {
        GenericsType[] samGt = samUsage.getGenericsTypes();
        GenericsType[] closureGt = closureType.getGenericsTypes();
        if (samGt == null || closureGt == null) {
            return samUsage;
        }
        HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        StaticTypeCheckingSupport.extractGenericsConnections(connections, StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.getInferredReturnType(closureExpression)), sam.getReturnType());
        if (closureExpression.isParameterSpecified()) {
            Parameter[] closureParams = closureExpression.getParameters();
            Parameter[] methodParams = sam.getParameters();
            int n = Math.min(closureParams.length, methodParams.length);
            for (int i = 0; i < n; ++i) {
                ClassNode fromClosure = closureParams[i].getType();
                ClassNode fromMethod = methodParams[i].getType();
                StaticTypeCheckingSupport.extractGenericsConnections(connections, fromClosure, fromMethod);
            }
        }
        return StaticTypeCheckingSupport.applyGenericsContext(connections, samUsage.redirect());
    }

    protected static ClassNode getGroupOperationResultType(ClassNode a, ClassNode b) {
        if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
            return ClassHelper.BigInteger_TYPE;
        }
        if (WideningCategories.isBigDecCategory(a) && WideningCategories.isBigDecCategory(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigDecimal_TYPE.equals(a) || ClassHelper.BigDecimal_TYPE.equals(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigInteger_TYPE.equals(a) || ClassHelper.BigInteger_TYPE.equals(b)) {
            if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
                return ClassHelper.BigInteger_TYPE;
            }
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.double_TYPE.equals(a) || ClassHelper.double_TYPE.equals(b)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Double_TYPE.equals(a) || ClassHelper.Double_TYPE.equals(b)) {
            return ClassHelper.Double_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(a) || ClassHelper.float_TYPE.equals(b)) {
            return ClassHelper.float_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(a) || ClassHelper.Float_TYPE.equals(b)) {
            return ClassHelper.Float_TYPE;
        }
        if (ClassHelper.long_TYPE.equals(a) || ClassHelper.long_TYPE.equals(b)) {
            return ClassHelper.long_TYPE;
        }
        if (ClassHelper.Long_TYPE.equals(a) || ClassHelper.Long_TYPE.equals(b)) {
            return ClassHelper.Long_TYPE;
        }
        if (ClassHelper.int_TYPE.equals(a) || ClassHelper.int_TYPE.equals(b)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Integer_TYPE.equals(a) || ClassHelper.Integer_TYPE.equals(b)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.short_TYPE.equals(a) || ClassHelper.short_TYPE.equals(b)) {
            return ClassHelper.short_TYPE;
        }
        if (ClassHelper.Short_TYPE.equals(a) || ClassHelper.Short_TYPE.equals(b)) {
            return ClassHelper.Short_TYPE;
        }
        if (ClassHelper.byte_TYPE.equals(a) || ClassHelper.byte_TYPE.equals(b)) {
            return ClassHelper.byte_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(a) || ClassHelper.Byte_TYPE.equals(b)) {
            return ClassHelper.Byte_TYPE;
        }
        if (ClassHelper.char_TYPE.equals(a) || ClassHelper.char_TYPE.equals(b)) {
            return ClassHelper.char_TYPE;
        }
        if (ClassHelper.Character_TYPE.equals(a) || ClassHelper.Character_TYPE.equals(b)) {
            return ClassHelper.Character_TYPE;
        }
        return ClassHelper.Number_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassNode inferComponentType(ClassNode containerType, ClassNode indexType) {
        ClassNode componentType = containerType.getComponentType();
        if (componentType == null) {
            this.typeCheckingContext.pushErrorCollector();
            MethodCallExpression vcall = GeneralUtils.callX((Expression)GeneralUtils.localVarX("_hash_", containerType), "getAt", (Expression)GeneralUtils.varX("_index_", indexType));
            vcall.setImplicitThis(false);
            try {
                this.visitMethodCallExpression(vcall);
            }
            finally {
                this.typeCheckingContext.popErrorCollector();
            }
            return this.getType(vcall);
        }
        return componentType;
    }

    protected MethodNode findMethodOrFail(Expression expr, ClassNode receiver, String name, ClassNode ... args) {
        List<MethodNode> methods = this.findMethod(receiver, name, args);
        if (methods.isEmpty() && expr instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expr;
            MethodCallExpression call = GeneralUtils.callX(be.getLeftExpression(), name, be.getRightExpression());
            methods = this.extension.handleMissingMethod(receiver, name, GeneralUtils.args(be.getLeftExpression()), args, call);
        }
        if (methods.isEmpty()) {
            this.addNoMatchingMethodError(receiver, name, args, expr);
        } else {
            if (this.areCategoryMethodCalls(methods, name, args)) {
                this.addCategoryMethodCallError(expr);
            }
            if ((methods = this.disambiguateMethods(methods, receiver, args, expr)).size() == 1) {
                return methods.get(0);
            }
            this.addAmbiguousErrorMessage(methods, name, args, expr);
        }
        return null;
    }

    private List<MethodNode> disambiguateMethods(List<MethodNode> methods, ClassNode receiver, ClassNode[] argTypes, Expression expr) {
        if (methods.size() > 1 && receiver != null && argTypes != null) {
            LinkedList<MethodNode> filteredWithGenerics = new LinkedList<MethodNode>();
            for (MethodNode methodNode : methods) {
                if (!StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(receiver, argTypes, methodNode) || (methodNode.getModifiers() & 0x40) != 0) continue;
                filteredWithGenerics.add(methodNode);
            }
            if (filteredWithGenerics.size() == 1) {
                return filteredWithGenerics;
            }
            methods = this.extension.handleAmbiguousMethods(methods, expr);
        }
        return methods;
    }

    protected static String prettyPrintMethodList(List<MethodNode> nodes) {
        StringBuilder sb = new StringBuilder("[");
        int nodesSize = nodes.size();
        for (int i = 0; i < nodesSize; ++i) {
            MethodNode node = nodes.get(i);
            sb.append(node.getReturnType().toString(false));
            sb.append(" ");
            sb.append(node.getDeclaringClass().toString(false));
            sb.append("#");
            sb.append(StaticTypeCheckingSupport.toMethodParametersString(node.getName(), StaticTypeCheckingVisitor.extractTypesFromParameters(node.getParameters())));
            if (i >= nodesSize - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected boolean areCategoryMethodCalls(List<MethodNode> foundMethods, String name, ClassNode[] args) {
        boolean category = false;
        if ("use".equals(name) && args != null && args.length == 2 && args[1].equals(ClassHelper.CLOSURE_TYPE)) {
            category = true;
            for (MethodNode method : foundMethods) {
                if (method instanceof ExtensionMethodNode && ((ExtensionMethodNode)method).getExtensionMethodNode().getDeclaringClass().equals(DGM_CLASSNODE)) continue;
                category = false;
                break;
            }
        }
        return category;
    }

    protected List<MethodNode> findMethodsWithGenerated(ClassNode receiver, String name) {
        if (receiver.isArray()) {
            if (name.equals("clone")) {
                MethodNode clone = new MethodNode("clone", 1, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
                clone.setDeclaringClass(ClassHelper.OBJECT_TYPE);
                clone.setNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, receiver);
                return Collections.singletonList(clone);
            }
            return ClassHelper.OBJECT_TYPE.getMethods(name);
        }
        List<MethodNode> methods = receiver.getMethods(name);
        HashSet<ClassNode> done = new HashSet<ClassNode>();
        for (ClassNode next = receiver; next != null; next = next.getSuperClass()) {
            done.add(next);
            for (ClassNode face : next.getAllInterfaces()) {
                if (!done.add(face)) continue;
                for (MethodNode mn : face.getDeclaredMethods(name)) {
                    if (!mn.isPublic() || mn.isStatic()) continue;
                    methods.add(mn);
                }
            }
        }
        if (receiver.isInterface()) {
            methods.addAll(ClassHelper.OBJECT_TYPE.getMethods(name));
        }
        if (!receiver.isResolved() && !methods.isEmpty()) {
            methods = StaticTypeCheckingVisitor.addGeneratedMethods(receiver, methods);
        }
        return methods;
    }

    private static List<MethodNode> addGeneratedMethods(ClassNode receiver, List<MethodNode> methods) {
        LinkedList<MethodNode> result = new LinkedList<MethodNode>();
        for (MethodNode method : methods) {
            result.add(method);
            Parameter[] parameters = method.getParameters();
            int counter = 0;
            int size = parameters.length;
            for (int i = size - 1; i >= 0; --i) {
                Parameter parameter = parameters[i];
                if (parameter == null || !parameter.hasInitialExpression()) continue;
                ++counter;
            }
            for (int j = 1; j <= counter; ++j) {
                MethodNode stubbed;
                Parameter[] newParams = new Parameter[parameters.length - j];
                int index = 0;
                int k = 1;
                for (Parameter parameter : parameters) {
                    if (k > counter - j && parameter != null && parameter.hasInitialExpression()) {
                        ++k;
                        continue;
                    }
                    if (parameter != null && parameter.hasInitialExpression()) {
                        newParams[index++] = parameter;
                        ++k;
                        continue;
                    }
                    newParams[index++] = parameter;
                }
                if ("<init>".equals(method.getName())) {
                    stubbed = new ConstructorNode(method.getModifiers(), newParams, method.getExceptions(), GENERATED_EMPTY_STATEMENT);
                } else {
                    stubbed = new MethodNode(method.getName(), method.getModifiers(), method.getReturnType(), newParams, method.getExceptions(), GENERATED_EMPTY_STATEMENT);
                    stubbed.setGenericsTypes(method.getGenericsTypes());
                }
                stubbed.setDeclaringClass(method.getDeclaringClass());
                result.add(stubbed);
            }
        }
        return result;
    }

    protected List<MethodNode> findMethod(ClassNode receiver, String name, ClassNode ... args) {
        List<MethodNode> result;
        MethodNode constructor;
        List<MethodNode> chosen;
        List<MethodNode> methods;
        if (ClassHelper.isPrimitiveType(receiver)) {
            receiver = ClassHelper.getWrapper(receiver);
        }
        if ("<init>".equals(name) && !receiver.isInterface()) {
            methods = StaticTypeCheckingVisitor.addGeneratedMethods(receiver, new ArrayList<MethodNode>(receiver.getDeclaredConstructors()));
            if (methods.isEmpty()) {
                ConstructorNode node = new ConstructorNode(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                node.setDeclaringClass(receiver);
                methods.add(node);
                if (receiver.isArray()) {
                    return methods;
                }
            }
        } else {
            PropertyNode property;
            String pname;
            methods = this.findMethodsWithGenerated(receiver, name);
            if (!receiver.isStaticClass() && receiver.getOuterClass() != null && !receiver.getName().endsWith("$Trait$Helper") && this.typeCheckingContext.getEnclosingClassNodes().contains(receiver)) {
                ClassNode outer = receiver.getOuterClass();
                do {
                    methods.addAll(this.findMethodsWithGenerated(outer, name));
                } while (!outer.isStaticClass() && (outer = outer.getOuterClass()) != null);
            }
            if (methods.isEmpty()) {
                StaticTypeCheckingVisitor.addArrayMethods(methods, receiver, name, args);
            }
            if (methods.isEmpty() && (args == null || args.length == 0)) {
                pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("get", name);
                if (pname == null) {
                    pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("is", name);
                }
                if (pname != null && (property = this.findProperty(receiver, pname)) != null) {
                    int mods = 1 | (property.isStatic() ? 8 : 0);
                    MethodNode node = new MethodNode(name, mods, property.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                    node.setDeclaringClass(property.getDeclaringClass());
                    return Collections.singletonList(node);
                }
            } else if (methods.isEmpty() && args != null && args.length == 1 && (pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("set", name)) != null && (property = this.findProperty(receiver, pname)) != null && !Modifier.isFinal(property.getModifiers())) {
                ClassNode type = property.getOriginType();
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(StaticTypeCheckingVisitor.wrapTypeIfNecessary(args[0]), StaticTypeCheckingVisitor.wrapTypeIfNecessary(type))) {
                    int mods = 1 | (property.isStatic() ? 8 : 0);
                    MethodNode node = new MethodNode(name, mods, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(type, name)}, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                    node.setDeclaringClass(property.getDeclaringClass());
                    return Collections.singletonList(node);
                }
            }
        }
        if (!"<init>".equals(name) && !"<clinit>".equals(name)) {
            StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(this.getSourceUnit().getClassLoader(), receiver, name, args, methods);
        }
        if (!(chosen = StaticTypeCheckingSupport.chooseBestMethod(receiver, methods = this.filterMethodsByVisibility(methods), args)).isEmpty()) {
            return chosen;
        }
        if (receiver instanceof InnerClassNode && ((InnerClassNode)receiver).isAnonymous() && methods.size() == 1 && args != null && "<init>".equals(name) && (constructor = methods.get(0)).getParameters().length == args.length) {
            return methods;
        }
        if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver) && !(result = this.findMethod(receiver.getGenericsTypes()[0].getType(), name, args)).isEmpty()) {
            return result;
        }
        if (receiver.equals(ClassHelper.GSTRING_TYPE)) {
            return this.findMethod(ClassHelper.STRING_TYPE, name, args);
        }
        if (StaticTypeCheckingSupport.isBeingCompiled(receiver)) {
            return this.findMethod(ClassHelper.GROOVY_OBJECT_TYPE, name, args);
        }
        return EMPTY_METHODNODE_LIST;
    }

    private PropertyNode findProperty(ClassNode receiver, String name) {
        for (ClassNode cn = receiver; cn != null; cn = cn.getSuperClass()) {
            PropertyNode property = cn.getProperty(name);
            if (property != null) {
                return property;
            }
            if (cn.isStaticClass() || cn.getOuterClass() == null || !this.typeCheckingContext.getEnclosingClassNodes().contains(cn)) continue;
            ClassNode outer = cn.getOuterClass();
            do {
                if ((property = outer.getProperty(name)) == null) continue;
                return property;
            } while (!outer.isStaticClass() && (outer = outer.getOuterClass()) != null);
        }
        return null;
    }

    private List<MethodNode> filterMethodsByVisibility(List<MethodNode> methods) {
        if (!DefaultGroovyMethods.asBoolean(methods)) {
            return EMPTY_METHODNODE_LIST;
        }
        LinkedList<MethodNode> result = new LinkedList<MethodNode>();
        ClassNode enclosingClassNode = this.typeCheckingContext.getEnclosingClassNode();
        boolean isEnclosingInnerClass = enclosingClassNode instanceof InnerClassNode;
        List<ClassNode> outerClasses = enclosingClassNode.getOuterClasses();
        block0: for (MethodNode methodNode : methods) {
            if (methodNode instanceof ExtensionMethodNode) {
                result.add(methodNode);
                continue;
            }
            ClassNode declaringClass = methodNode.getDeclaringClass();
            if (isEnclosingInnerClass) {
                for (ClassNode outerClass : outerClasses) {
                    if (!outerClass.isDerivedFrom(declaringClass)) continue;
                    if (outerClass.equals(declaringClass)) {
                        result.add(methodNode);
                        continue block0;
                    }
                    if (!methodNode.isPublic() && !methodNode.isProtected()) continue;
                    result.add(methodNode);
                    continue block0;
                }
            }
            if (declaringClass instanceof InnerClassNode && declaringClass.getOuterClasses().contains(enclosingClassNode)) {
                result.add(methodNode);
                continue;
            }
            if (methodNode.isPrivate() && !enclosingClassNode.equals(declaringClass) || methodNode.isProtected() && !enclosingClassNode.isDerivedFrom(declaringClass) && !ClassNodeUtils.samePackageName(enclosingClassNode, declaringClass) || methodNode.isPackageScope() && !ClassNodeUtils.samePackageName(enclosingClassNode, declaringClass)) continue;
            result.add(methodNode);
        }
        return result;
    }

    public static String extractPropertyNameFromMethodName(String prefix, String methodName) {
        String propertyName;
        String result;
        if (prefix == null || methodName == null) {
            return null;
        }
        if (methodName.startsWith(prefix) && prefix.length() < methodName.length() && (result = methodName.substring(prefix.length())).equals(MetaClassHelper.capitalize(propertyName = Introspector.decapitalize(result)))) {
            return propertyName;
        }
        return null;
    }

    @Deprecated
    protected void collectAllInterfaceMethodsByName(ClassNode type, String name, List<MethodNode> methods) {
        LinkedHashSet<ClassNode> done = new LinkedHashSet<ClassNode>();
        for (ClassNode next = type; next != null; next = next.getSuperClass()) {
            done.add(next);
            for (ClassNode face : next.getAllInterfaces()) {
                if (!done.add(face)) continue;
                methods.addAll(face.getDeclaredMethods(name));
            }
        }
    }

    protected ClassNode getType(ASTNode exp) {
        MethodNode target;
        ClassNode cn = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn != null) {
            return cn;
        }
        if (exp instanceof ClassExpression) {
            ClassNode node = ClassHelper.CLASS_Type.getPlainNodeReference();
            node.setGenericsTypes(new GenericsType[]{new GenericsType(((ClassExpression)exp).getType())});
            return node;
        }
        if (exp instanceof VariableExpression) {
            VariableExpression vexp = (VariableExpression)exp;
            ClassNode selfTrait = StaticTypeCheckingSupport.isTraitSelf(vexp);
            if (selfTrait != null) {
                return StaticTypeCheckingVisitor.makeSelf(selfTrait);
            }
            if (vexp.isThisExpression()) {
                return this.makeThis();
            }
            if (vexp.isSuperExpression()) {
                return this.makeSuper();
            }
            Variable variable = vexp.getAccessedVariable();
            if (variable instanceof FieldNode) {
                ClassNode fieldType = variable.getOriginType();
                if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(fieldType)) {
                    boolean isStatic = Modifier.isStatic(variable.getModifiers());
                    ClassNode thisType = this.typeCheckingContext.getEnclosingClassNode();
                    ClassNode declType = ((FieldNode)variable).getDeclaringClass();
                    Map<GenericsType.GenericsTypeName, GenericsType> placeholders = StaticTypeCheckingVisitor.resolvePlaceHoldersFromDeclaration(thisType, declType, null, isStatic);
                    fieldType = this.resolveGenericsWithContext(placeholders, fieldType);
                }
                return fieldType;
            }
            if (variable != vexp && variable instanceof VariableExpression) {
                return this.getType((Expression)((Object)variable));
            }
            if (variable instanceof Parameter) {
                Parameter parameter = (Parameter)variable;
                ClassNode type = null;
                List<ClassNode> temporaryTypesForExpression = this.getTemporaryTypesForExpression(vexp);
                if (temporaryTypesForExpression == null || temporaryTypesForExpression.isEmpty()) {
                    type = this.typeCheckingContext.controlStructureVariables.get(parameter);
                }
                if (type == null && temporaryTypesForExpression == null) {
                    type = this.getTypeFromClosureArguments(parameter);
                }
                if (type != null) {
                    this.storeType(vexp, type);
                    return type;
                }
                return this.getType((Parameter)variable);
            }
            return vexp.getOriginType();
        }
        if (exp instanceof ListExpression) {
            return this.inferListExpressionType((ListExpression)exp);
        }
        if (exp instanceof MapExpression) {
            return this.inferMapExpressionType((MapExpression)exp);
        }
        if (exp instanceof ConstructorCallExpression) {
            return ((ConstructorCallExpression)exp).getType();
        }
        if (exp instanceof MethodNode) {
            if ((exp == GET_DELEGATE || exp == GET_OWNER || exp == GET_THISOBJECT) && this.typeCheckingContext.getEnclosingClosure() != null) {
                return this.typeCheckingContext.getEnclosingClassNode();
            }
            ClassNode ret = this.getInferredReturnType(exp);
            return ret != null ? ret : ((MethodNode)exp).getReturnType();
        }
        if (exp instanceof FieldNode || exp instanceof PropertyNode) {
            return ((Variable)((Object)exp)).getOriginType();
        }
        if (exp instanceof RangeExpression) {
            ClassNode toType;
            ClassNode plain = ClassHelper.RANGE_TYPE.getPlainNodeReference();
            RangeExpression re = (RangeExpression)exp;
            ClassNode fromType = this.getType(re.getFrom());
            if (fromType.equals(toType = this.getType(re.getTo()))) {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(fromType))});
            } else {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(WideningCategories.lowestUpperBound(fromType, toType)))});
            }
            return plain;
        }
        if (exp instanceof UnaryPlusExpression) {
            return this.getType(((UnaryPlusExpression)exp).getExpression());
        }
        if (exp instanceof UnaryMinusExpression) {
            return this.getType(((UnaryMinusExpression)exp).getExpression());
        }
        if (exp instanceof BitwiseNegationExpression) {
            return this.getType(((BitwiseNegationExpression)exp).getExpression());
        }
        if (exp instanceof Parameter) {
            return ((Parameter)exp).getOriginType();
        }
        if (exp instanceof ClosureExpression) {
            ClassNode irt = this.getInferredReturnType(exp);
            if (irt != null) {
                irt = StaticTypeCheckingVisitor.wrapTypeIfNecessary(irt);
                ClassNode result = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
                result.setGenericsTypes(new GenericsType[]{new GenericsType(irt)});
                return result;
            }
        } else if (exp instanceof MethodCall && (target = (MethodNode)exp.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)) != null) {
            return this.getType(target);
        }
        return ((Expression)exp).getType();
    }

    private ClassNode getTypeFromClosureArguments(Parameter parameter) {
        for (TypeCheckingContext.EnclosingClosure enclosingClosure : this.typeCheckingContext.getEnclosingClosureStack()) {
            Parameter[] parameters;
            ClosureExpression closureExpression = enclosingClosure.getClosureExpression();
            ClassNode[] closureParamTypes = (ClassNode[])closureExpression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
            if (closureParamTypes == null || (parameters = closureExpression.getParameters()) == null) continue;
            int n = parameters.length;
            String parameterName = parameter.getName();
            if (n == 0 && parameterName.equals("it")) {
                return closureParamTypes.length > 0 ? closureParamTypes[0] : null;
            }
            for (int i = 0; i < n; ++i) {
                if (!parameterName.equals(parameters[i].getName())) continue;
                return closureParamTypes.length > i ? closureParamTypes[i] : null;
            }
        }
        return null;
    }

    private ClassNode makeSuper() {
        return StaticTypeCheckingVisitor.makeType(this.typeCheckingContext.getEnclosingClassNode().getUnresolvedSuperClass(), this.typeCheckingContext.isInStaticContext);
    }

    private ClassNode makeThis() {
        return StaticTypeCheckingVisitor.makeType(this.typeCheckingContext.getEnclosingClassNode(), this.typeCheckingContext.isInStaticContext);
    }

    private static ClassNode makeSelf(ClassNode trait) {
        ClassNode ret = trait;
        LinkedHashSet<ClassNode> selfTypes = new LinkedHashSet<ClassNode>();
        Traits.collectSelfTypes(ret, selfTypes);
        if (!selfTypes.isEmpty()) {
            selfTypes.add(ret);
            ret = new UnionTypeClassNode(selfTypes.toArray(ClassNode.EMPTY_ARRAY));
        }
        return ret;
    }

    protected ClassNode storeInferredReturnType(ASTNode node, ClassNode type) {
        if (!(node instanceof ClosureExpression)) {
            throw new IllegalArgumentException("Storing inferred return type is only allowed on closures but found " + node.getClass());
        }
        return (ClassNode)node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, type);
    }

    protected ClassNode getInferredReturnType(ASTNode exp) {
        return (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
    }

    protected ClassNode inferListExpressionType(ListExpression list) {
        List<Expression> expressions = list.getExpressions();
        int nExpressions = expressions.size();
        if (nExpressions == 0) {
            return list.getType();
        }
        ClassNode listType = list.getType();
        GenericsType[] genericsTypes = listType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length == 0 || genericsTypes.length == 1 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType())) {
            ArrayList<ClassNode> nodes = new ArrayList<ClassNode>(nExpressions);
            for (Expression expression : expressions) {
                if (StaticTypeCheckingVisitor.isNullConstant(expression)) continue;
                nodes.add(this.getType(expression));
            }
            if (!nodes.isEmpty()) {
                ClassNode itemType = WideningCategories.lowestUpperBound(nodes);
                listType = listType.getPlainNodeReference();
                listType.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(itemType))});
            }
        }
        return listType;
    }

    protected static boolean isNullConstant(Expression expression) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).isNullExpression();
    }

    protected ClassNode inferMapExpressionType(MapExpression map) {
        ClassNode mapType = LINKEDHASHMAP_CLASSNODE.getPlainNodeReference();
        List<MapEntryExpression> entryExpressions = map.getMapEntryExpressions();
        int nExpressions = entryExpressions.size();
        if (nExpressions == 0) {
            return mapType;
        }
        GenericsType[] genericsTypes = mapType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length < 2 || genericsTypes.length == 2 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType()) && ClassHelper.OBJECT_TYPE.equals(genericsTypes[1].getType())) {
            ClassNode keyType;
            ClassNode valueType;
            ArrayList<ClassNode> keyTypes = new ArrayList<ClassNode>(nExpressions);
            ArrayList<ClassNode> valueTypes = new ArrayList<ClassNode>(nExpressions);
            for (MapEntryExpression entryExpression : entryExpressions) {
                valueType = this.getType(entryExpression.getValueExpression());
                if (!(entryExpression.getKeyExpression() instanceof SpreadMapExpression)) {
                    keyType = this.getType(entryExpression.getKeyExpression());
                } else {
                    valueType = GenericsUtils.parameterizeType(valueType, ClassHelper.MAP_TYPE);
                    keyType = StaticTypeCheckingSupport.getCombinedBoundType(valueType.getGenericsTypes()[0]);
                    valueType = StaticTypeCheckingSupport.getCombinedBoundType(valueType.getGenericsTypes()[1]);
                }
                keyTypes.add(keyType);
                valueTypes.add(valueType);
            }
            keyType = WideningCategories.lowestUpperBound(keyTypes);
            valueType = WideningCategories.lowestUpperBound(valueTypes);
            if (!ClassHelper.OBJECT_TYPE.equals(keyType) || !ClassHelper.OBJECT_TYPE.equals(valueType)) {
                mapType.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(keyType)), new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(valueType))});
            }
        }
        return mapType;
    }

    protected ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments) {
        return this.inferReturnTypeGenerics(receiver, method, arguments, null);
    }

    protected ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments, GenericsType[] explicitTypeHints) {
        GenericsType[] methodGenericTypes;
        ClassNode returnType;
        ClassNode classNode = returnType = method instanceof ConstructorNode ? method.getDeclaringClass() : method.getReturnType();
        if (!GenericsUtils.hasUnresolvedGenerics(returnType)) {
            if (StaticTypeCheckingSupport.getGenericsWithoutArray(returnType) != null) {
                returnType = StaticTypeCheckingSupport.boundUnboundedWildcards(returnType);
            }
            return returnType;
        }
        if (method instanceof ExtensionMethodNode) {
            ArgumentListExpression args = new ArgumentListExpression();
            VariableExpression vexp = GeneralUtils.varX("$self", receiver);
            args.addExpression(vexp);
            if (arguments instanceof TupleExpression) {
                for (Expression argument : (TupleExpression)arguments) {
                    args.addExpression(argument);
                }
            } else {
                args.addExpression(arguments);
            }
            vexp.setNodeMetaData(ExtensionMethodDeclaringClass.class, method.getDeclaringClass());
            return this.inferReturnTypeGenerics(receiver, ((ExtensionMethodNode)method).getExtensionMethodNode(), args, explicitTypeHints);
        }
        Map<GenericsType.GenericsTypeName, GenericsType> context = method.isStatic() || method instanceof ConstructorNode ? null : StaticTypeCheckingVisitor.extractPlaceHolders(null, receiver, StaticTypeCheckingVisitor.getDeclaringClass(method, arguments));
        GenericsType[] genericsTypeArray = methodGenericTypes = method instanceof ConstructorNode ? method.getDeclaringClass().getGenericsTypes() : StaticTypeCheckingSupport.applyGenericsContext(context, method.getGenericsTypes());
        if (methodGenericTypes != null) {
            HashMap<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
            for (GenericsType gt : methodGenericTypes) {
                resolvedPlaceholders.put(new GenericsType.GenericsTypeName(gt.getName()), gt);
            }
            Parameter[] parameters = method.getParameters();
            int nParameters = parameters.length;
            if (explicitTypeHints != null) {
                int n = methodGenericTypes.length;
                if (n == explicitTypeHints.length) {
                    for (int i = 0; i < n; ++i) {
                        resolvedPlaceholders.put(new GenericsType.GenericsTypeName(methodGenericTypes[i].getName()), explicitTypeHints[i]);
                    }
                }
            } else if (nParameters > 0) {
                List<Expression> expressions = InvocationWriter.makeArgumentList(arguments).getExpressions();
                boolean isVargs = StaticTypeCheckingSupport.isVargs(parameters);
                if (expressions.size() >= nParameters) {
                    for (int i = 0; i < nParameters; ++i) {
                        MethodNode sam;
                        if (StaticTypeCheckingVisitor.isNullConstant(expressions.get(i))) continue;
                        boolean lastArg = i == nParameters - 1;
                        ClassNode paramType = parameters[i].getType();
                        ClassNode argumentType = this.getDeclaredOrInferredType(expressions.get(i));
                        while (paramType.isArray() && argumentType.isArray()) {
                            paramType = paramType.getComponentType();
                            argumentType = argumentType.getComponentType();
                        }
                        if (!StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(paramType)) continue;
                        if (argumentType.isDerivedFrom(ClassHelper.CLOSURE_TYPE) && (sam = ClassHelper.findSAM(paramType)) != null) {
                            ClassNode classNode2 = argumentType = !paramType.isUsingGenerics() ? paramType : StaticTypeCheckingVisitor.convertClosureTypeToSAMType(expressions.get(i), argumentType, sam, paramType, StaticTypeCheckingSupport.applyGenericsContextToParameterClass(resolvedPlaceholders, paramType));
                        }
                        if (isVargs && lastArg && paramType.isArray() && !argumentType.isArray()) {
                            paramType = paramType.getComponentType();
                        }
                        HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                        StaticTypeCheckingSupport.extractGenericsConnections(connections, StaticTypeCheckingVisitor.wrapTypeIfNecessary(argumentType), paramType);
                        StaticTypeCheckingVisitor.extractGenericsConnectionsForSuperClassAndInterfaces(resolvedPlaceholders, connections);
                        StaticTypeCheckingSupport.applyGenericsConnections(connections, resolvedPlaceholders);
                    }
                }
            }
            returnType = StaticTypeCheckingSupport.applyGenericsContext(resolvedPlaceholders, returnType);
        }
        if (context != null) {
            returnType = StaticTypeCheckingSupport.applyGenericsContext(context, returnType);
        }
        returnType = StaticTypeCheckingSupport.applyGenericsContext(StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext), returnType);
        return returnType;
    }

    private void resolvePlaceholdersFromImplicitTypeHints(ClassNode[] actuals, ArgumentListExpression argumentList, Parameter[] parameterArray) {
        int np = parameterArray.length;
        int n = actuals.length;
        for (int i = 0; i < n && np > 0; ++i) {
            MethodNode aNode;
            Expression a = argumentList.getExpression(i);
            Parameter p = parameterArray[Math.min(i, np - 1)];
            ClassNode at = actuals[i];
            ClassNode pt = p.getOriginType();
            if (!StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(pt)) continue;
            if (i >= np - 1 && pt.isArray() && !at.isArray()) {
                pt = pt.getComponentType();
            }
            if (a instanceof ConstructorCallExpression) {
                this.inferDiamondType((ConstructorCallExpression)a, pt);
            }
            if (!(a instanceof MethodCall) || a instanceof MethodCallExpression && ((MethodCallExpression)a).isUsingGenerics() || (aNode = (MethodNode)a.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)) == null || aNode.getGenericsTypes() == null || !GenericsUtils.hasUnresolvedGenerics(at)) continue;
            while (!(at.equals(pt) || at.equals(ClassHelper.OBJECT_TYPE) || StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf(at) || StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf(pt))) {
                ClassNode sc = GenericsUtils.getSuperClass(at, pt);
                at = StaticTypeCheckingSupport.applyGenericsContext(GenericsUtils.extractPlaceholders(at), sc);
            }
            HashMap<GenericsType.GenericsTypeName, GenericsType> linked = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
            Map<GenericsType.GenericsTypeName, GenericsType> source = GenericsUtils.extractPlaceholders(at);
            Map<GenericsType.GenericsTypeName, GenericsType> target = GenericsUtils.extractPlaceholders(pt);
            if (at.isGenericsPlaceHolder()) {
                target.put(new GenericsType.GenericsTypeName(at.getUnresolvedName()), pt.asGenericsType());
            }
            block2: for (GenericsType placeholder : aNode.getGenericsTypes()) {
                for (Map.Entry<GenericsType.GenericsTypeName, GenericsType> e : source.entrySet()) {
                    if (e.getValue() != placeholder) continue;
                    GenericsType gt = target.get(e.getKey());
                    if (gt == null || !StaticTypeCheckingSupport.isAssignableTo(gt.getType(), placeholder.getType())) continue block2;
                    linked.put(new GenericsType.GenericsTypeName(placeholder.getName()), gt);
                    continue block2;
                }
            }
            actuals[i] = StaticTypeCheckingSupport.applyGenericsContext(linked, at);
        }
    }

    private static void extractGenericsConnectionsForSuperClassAndInterfaces(Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders, Map<GenericsType.GenericsTypeName, GenericsType> connections) {
        for (GenericsType value : new HashSet<GenericsType>(connections.values())) {
            if (value.isPlaceholder() || value.isWildcard()) continue;
            ClassNode valueType = value.getType();
            LinkedList<ClassNode> deepNodes = new LinkedList<ClassNode>();
            ClassNode unresolvedSuperClass = valueType.getUnresolvedSuperClass();
            if (unresolvedSuperClass != null && unresolvedSuperClass.isUsingGenerics()) {
                deepNodes.add(unresolvedSuperClass);
            }
            for (ClassNode classNode : valueType.getUnresolvedInterfaces()) {
                if (!classNode.isUsingGenerics()) continue;
                deepNodes.add(classNode);
            }
            if (deepNodes.isEmpty()) continue;
            for (GenericsType genericsType : resolvedPlaceholders.values()) {
                ClassNode[] classNodeArray;
                ClassNode lowerBound = genericsType.getLowerBound();
                if (lowerBound != null) {
                    for (ClassNode deepNode : deepNodes) {
                        if (!lowerBound.equals(deepNode)) continue;
                        StaticTypeCheckingSupport.extractGenericsConnections(connections, deepNode, lowerBound);
                    }
                }
                if ((classNodeArray = genericsType.getUpperBounds()) == null) continue;
                for (ClassNode upperBound : classNodeArray) {
                    for (ClassNode deepNode : deepNodes) {
                        if (!upperBound.equals(deepNode)) continue;
                        StaticTypeCheckingSupport.extractGenericsConnections(connections, deepNode, upperBound);
                    }
                }
            }
        }
    }

    private static MethodNode chooseMethod(MethodPointerExpression source, Function<Void, ClassNode[]> samSignature) {
        List options = (List)source.getNodeMetaData(MethodNode.class);
        if (options != null && !options.isEmpty()) {
            ClassNode[] paramTypes = samSignature.apply(null);
            for (MethodNode option : options) {
                ClassNode[] types = StaticTypeCheckingVisitor.collateMethodReferenceParameterTypes(source, option);
                int nTypes = types.length;
                if (nTypes != paramTypes.length) continue;
                for (int i = 0; i < nTypes; ++i) {
                    if (!types[i].isGenericsPlaceHolder() && StaticTypeCheckingSupport.isAssignableTo(types[i], paramTypes[i])) continue;
                }
                return option;
            }
        }
        return null;
    }

    private static ClassNode[] collateMethodReferenceParameterTypes(MethodPointerExpression source, MethodNode target) {
        Parameter[] params;
        if (target instanceof ExtensionMethodNode && !((ExtensionMethodNode)target).isStaticExtension()) {
            params = ((ExtensionMethodNode)target).getExtensionMethodNode().getParameters();
        } else if (!target.isStatic() && source.getExpression() instanceof ClassExpression) {
            ClassNode thisType = ((ClassExpression)source.getExpression()).getType();
            int n = target.getParameters().length;
            params = new Parameter[n + 1];
            params[0] = new Parameter(thisType, "");
            System.arraycopy(target.getParameters(), 0, params, 1, n);
        } else {
            params = target.getParameters();
        }
        return StaticTypeCheckingVisitor.extractTypesFromParameters(params);
    }

    private static ClassNode convertClosureTypeToSAMType(Expression expression, ClassNode closureType, MethodNode sam, ClassNode samType, final Map<GenericsType.GenericsTypeName, GenericsType> placeholders) {
        if (StaticTypeCheckingVisitor.isClosureWithType(closureType)) {
            MethodPointerExpression mp;
            MethodNode mn;
            ClassNode closureReturnType = closureType.getGenericsTypes()[0].getType();
            final Parameter[] parameters = sam.getParameters();
            if (parameters.length > 0 && expression instanceof MethodPointerExpression && (mn = StaticTypeCheckingVisitor.chooseMethod(mp = (MethodPointerExpression)expression, new Function<Void, ClassNode[]>(){

                @Override
                public ClassNode[] apply(Void x) {
                    return StaticTypeCheckingSupport.applyGenericsContext((Map<GenericsType.GenericsTypeName, GenericsType>)placeholders, StaticTypeCheckingVisitor.extractTypesFromParameters(parameters));
                }
            })) != null) {
                ClassNode[] pTypes = StaticTypeCheckingVisitor.collateMethodReferenceParameterTypes(mp, mn);
                HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                int n = parameters.length;
                for (int i = 0; i < n; ++i) {
                    StaticTypeCheckingSupport.extractGenericsConnections(connections, parameters[i].getOriginType(), pTypes[i]);
                }
                closureReturnType = StaticTypeCheckingSupport.applyGenericsContext(connections, closureReturnType);
                closureReturnType = StaticTypeCheckingSupport.applyGenericsContext(placeholders, closureReturnType);
                Parameter[] pa = new Parameter[pTypes.length];
                for (int i = 0; i < pTypes.length; ++i) {
                    pa[i] = new Parameter(pTypes[i], "");
                }
                expression = new ClosureExpression(pa, null);
            }
            StaticTypeCheckingSupport.extractGenericsConnections(placeholders, closureReturnType, sam.getReturnType());
            if (parameters.length > 0 && expression instanceof ClosureExpression) {
                ClassNode[] paramTypes = StaticTypeCheckingSupport.applyGenericsContext(placeholders, StaticTypeCheckingVisitor.extractTypesFromParameters(parameters));
                int i = 0;
                for (Parameter p : ClosureUtils.getParametersSafe((ClosureExpression)expression)) {
                    if (p.isDynamicTyped()) continue;
                    StaticTypeCheckingSupport.extractGenericsConnections(placeholders, p.getType(), paramTypes[i++]);
                }
            }
        }
        return StaticTypeCheckingSupport.applyGenericsContext(placeholders, samType.redirect());
    }

    private ClassNode resolveGenericsWithContext(Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders, ClassNode currentType) {
        Map<GenericsType.GenericsTypeName, GenericsType> placeholdersFromContext = StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext);
        return StaticTypeCheckingSupport.resolveClassNodeGenerics(resolvedPlaceholders, placeholdersFromContext, currentType);
    }

    private static ClassNode getDeclaringClass(MethodNode method, Expression arguments) {
        ClassNode declaringClass = method.getDeclaringClass();
        if (arguments instanceof ArgumentListExpression) {
            ArgumentListExpression al = (ArgumentListExpression)arguments;
            List<Expression> list = al.getExpressions();
            if (list.isEmpty()) {
                return declaringClass;
            }
            Expression exp = list.get(0);
            ClassNode cn = (ClassNode)exp.getNodeMetaData(ExtensionMethodDeclaringClass.class);
            if (cn != null) {
                return cn;
            }
        }
        return declaringClass;
    }

    private static Map<GenericsType.GenericsTypeName, GenericsType> resolvePlaceHoldersFromDeclaration(ClassNode receiver, ClassNode declaration, MethodNode method, boolean isStaticTarget) {
        if (isStaticTarget && ClassHelper.CLASS_Type.equals(receiver) && receiver.isUsingGenerics() && receiver.getGenericsTypes().length > 0 && !ClassHelper.OBJECT_TYPE.equals(receiver.getGenericsTypes()[0].getType())) {
            return StaticTypeCheckingVisitor.resolvePlaceHoldersFromDeclaration(receiver.getGenericsTypes()[0].getType(), declaration, method, isStaticTarget);
        }
        Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = StaticTypeCheckingVisitor.extractPlaceHolders(method, receiver, declaration);
        return resolvedPlaceholders;
    }

    private static boolean isGenericsPlaceHolderOrArrayOf(ClassNode cn) {
        if (cn.isArray()) {
            return StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf(cn.getComponentType());
        }
        return cn.isGenericsPlaceHolder();
    }

    private static Map<GenericsType.GenericsTypeName, GenericsType> extractPlaceHolders(MethodNode method, ClassNode receiver, ClassNode declaringClass) {
        if (declaringClass.equals(ClassHelper.OBJECT_TYPE)) {
            HashMap<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
            if (method != null) {
                StaticTypeCheckingSupport.addMethodLevelDeclaredGenerics(method, resolvedPlaceholders);
            }
            return resolvedPlaceholders;
        }
        HashMap<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = null;
        if (ClassHelper.isPrimitiveType(receiver) && !ClassHelper.isPrimitiveType(declaringClass)) {
            receiver = ClassHelper.getWrapper(receiver);
        }
        List<ClassNode> queue = receiver instanceof UnionTypeClassNode ? Arrays.asList(((UnionTypeClassNode)receiver).getDelegates()) : Collections.singletonList(receiver);
        Iterator<ClassNode> iterator = queue.iterator();
        block0: while (iterator.hasNext()) {
            ClassNode item;
            ClassNode current = item = iterator.next();
            while (current != null) {
                boolean continueLoop = true;
                HashMap<GenericsType.GenericsTypeName, GenericsType> currentPlaceHolders = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                if (StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf(declaringClass) || declaringClass.equals(current)) {
                    StaticTypeCheckingSupport.extractGenericsConnections(currentPlaceHolders, current, declaringClass);
                    if (method != null) {
                        StaticTypeCheckingSupport.addMethodLevelDeclaredGenerics(method, currentPlaceHolders);
                    }
                    continueLoop = false;
                } else {
                    GenericsUtils.extractPlaceholders(current, currentPlaceHolders);
                }
                if (resolvedPlaceholders != null) {
                    Set entries = currentPlaceHolders.entrySet();
                    for (Map.Entry entry : entries) {
                        GenericsType referenced;
                        GenericsType gt = (GenericsType)entry.getValue();
                        if (!gt.isPlaceholder() || (referenced = (GenericsType)resolvedPlaceholders.get(new GenericsType.GenericsTypeName(gt.getName()))) == null) continue;
                        entry.setValue(referenced);
                    }
                }
                resolvedPlaceholders = currentPlaceHolders;
                if (!continueLoop) continue block0;
                if ((current = ClassHelper.getNextSuperClass(current, declaringClass)) != null || !ClassHelper.CLASS_Type.equals(declaringClass)) continue;
                current = declaringClass;
            }
        }
        if (resolvedPlaceholders == null) {
            String descriptor = "<>";
            if (method != null) {
                descriptor = method.getTypeDescriptor();
            }
            throw new GroovyBugError("Declaring class for method call to '" + descriptor + "' declared in " + declaringClass.getName() + " was not matched with found receiver " + receiver.getName() + ". This should not have happened!");
        }
        return resolvedPlaceholders;
    }

    protected boolean typeCheckMethodsWithGenericsOrFail(ClassNode receiver, ClassNode[] arguments, MethodNode candidateMethod, Expression location) {
        if (!StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(receiver, arguments, candidateMethod)) {
            Map<GenericsType.GenericsTypeName, GenericsType> generics = GenericsUtils.extractPlaceholders(receiver);
            StaticTypeCheckingSupport.applyGenericsConnections(StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext), generics);
            StaticTypeCheckingSupport.addMethodLevelDeclaredGenerics(candidateMethod, generics);
            Parameter[] parameters = candidateMethod.getParameters();
            ClassNode[] paramTypes = new ClassNode[parameters.length];
            int n = parameters.length;
            for (int i = 0; i < n; ++i) {
                paramTypes[i] = StaticTypeCheckingSupport.fullyResolveType(parameters[i].getType(), generics);
                if (i >= arguments.length || !this.hasGStringStringError(paramTypes[i], arguments[i], location)) continue;
                return false;
            }
            GenericsType[] mgt = candidateMethod.getGenericsTypes();
            this.addStaticTypeError("Cannot call " + (mgt == null ? "" : GenericsUtils.toGenericTypesString(mgt)) + receiver.toString(false) + "#" + StaticTypeCheckingSupport.toMethodParametersString(candidateMethod.getName(), paramTypes) + " with arguments " + StaticTypeCheckingVisitor.formatArgumentList(arguments), location);
            return false;
        }
        return true;
    }

    protected static String formatArgumentList(ClassNode[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return "[] ";
        }
        StringBuilder sb = new StringBuilder(24 * nodes.length);
        sb.append("[");
        for (ClassNode node : nodes) {
            sb.append(StaticTypeCheckingSupport.prettyPrintType(node));
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setCharAt(sb.length() - 2, ']');
        }
        return sb.toString();
    }

    private static void putSetterInfo(Expression exp, SetterInfo info) {
        exp.putNodeMetaData(SetterInfo.class, info);
    }

    private static SetterInfo removeSetterInfo(Expression exp) {
        Object nodeMetaData = exp.getNodeMetaData(SetterInfo.class);
        if (nodeMetaData != null) {
            exp.removeNodeMetaData(SetterInfo.class);
            return (SetterInfo)nodeMetaData;
        }
        return null;
    }

    @Override
    public void addError(String msg, ASTNode expr) {
        Long err = (long)expr.getLineNumber() << 16 + expr.getColumnNumber();
        if (DEBUG_GENERATED_CODE && expr.getLineNumber() < 0 || !this.typeCheckingContext.reportedErrors.contains(err)) {
            this.typeCheckingContext.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', expr.getLineNumber(), expr.getColumnNumber(), expr.getLastLineNumber(), expr.getLastColumnNumber()), this.typeCheckingContext.source));
            this.typeCheckingContext.reportedErrors.add(err);
        }
    }

    protected void addStaticTypeError(String msg, ASTNode expr) {
        if (expr.getColumnNumber() > 0 && expr.getLineNumber() > 0) {
            this.addError("[Static type checking] - " + msg, expr);
        } else if (DEBUG_GENERATED_CODE) {
            this.addError("[Static type checking] - Error in generated code [" + expr.getText() + "] - " + msg, expr);
        }
    }

    protected void addNoMatchingMethodError(ClassNode receiver, String name, ClassNode[] args, Expression call) {
        if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver)) {
            receiver = receiver.getGenericsTypes()[0].getType();
        }
        this.addStaticTypeError("Cannot find matching method " + receiver.getText() + "#" + StaticTypeCheckingSupport.toMethodParametersString(name, args) + ". Please check if the declared type is correct and if the method exists.", call);
    }

    protected void addAmbiguousErrorMessage(List<MethodNode> foundMethods, String name, ClassNode[] args, Expression expr) {
        this.addStaticTypeError("Reference to method is ambiguous. Cannot choose between " + StaticTypeCheckingVisitor.prettyPrintMethodList(foundMethods), expr);
    }

    protected void addCategoryMethodCallError(Expression call) {
        this.addStaticTypeError("Due to their dynamic nature, usage of categories is not possible with static type checking active", call);
    }

    protected void addAssignmentError(ClassNode leftType, ClassNode rightType, Expression assignmentExpression) {
        this.addStaticTypeError("Cannot assign value of type " + rightType.toString(false) + " to variable of type " + leftType.toString(false), assignmentExpression);
    }

    protected void addUnsupportedPreOrPostfixExpressionError(Expression expression) {
        if (expression instanceof PostfixExpression) {
            this.addStaticTypeError("Unsupported postfix operation type [" + ((PostfixExpression)expression).getOperation() + "]", expression);
        } else if (expression instanceof PrefixExpression) {
            this.addStaticTypeError("Unsupported prefix operation type [" + ((PrefixExpression)expression).getOperation() + "]", expression);
        } else {
            throw new IllegalArgumentException("Method should be called with a PostfixExpression or a PrefixExpression");
        }
    }

    public void setMethodsToBeVisited(Set<MethodNode> methodsToBeVisited) {
        this.typeCheckingContext.methodsToBeVisited = methodsToBeVisited;
    }

    public void performSecondPass() {
        for (SecondPassExpression wrapper : this.typeCheckingContext.secondPassExpressions) {
            VariableExpression var;
            List<ClassNode> classNodes;
            Variable target;
            MethodCallExpression call;
            Expression objectExpression;
            Expression expression = wrapper.getExpression();
            if (expression instanceof BinaryExpression) {
                List<MethodNode> method;
                VariableExpression var2;
                List<ClassNode> classNodes2;
                Variable target2;
                Expression left = ((BinaryExpression)expression).getLeftExpression();
                if (!(left instanceof VariableExpression) || !((target2 = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)left)) instanceof VariableExpression) || (classNodes2 = this.typeCheckingContext.closureSharedVariablesAssignmentTypes.get(var2 = (VariableExpression)target2)) == null || classNodes2.size() <= 1) continue;
                ClassNode lub = WideningCategories.lowestUpperBound(classNodes2);
                String message = StaticTypeCheckingSupport.getOperationName(((BinaryExpression)expression).getOperation().getType());
                if (message == null || !(method = this.findMethod(lub, message, this.getType(((BinaryExpression)expression).getRightExpression()))).isEmpty()) continue;
                this.addStaticTypeError("A closure shared variable [" + target2.getName() + "] has been assigned with various types and the method [" + StaticTypeCheckingSupport.toMethodParametersString(message, this.getType(((BinaryExpression)expression).getRightExpression())) + "] does not exist in the lowest upper bound of those types: [" + lub.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot determine safely what is the type of the variable at the moment of the call in a multithreaded context.", expression);
                continue;
            }
            if (!(expression instanceof MethodCallExpression) || !((objectExpression = (call = (MethodCallExpression)expression).getObjectExpression()) instanceof VariableExpression) || !((target = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression)) instanceof VariableExpression) || (classNodes = this.typeCheckingContext.closureSharedVariablesAssignmentTypes.get(var = (VariableExpression)target)) == null || classNodes.size() <= 1) continue;
            ClassNode lub = WideningCategories.lowestUpperBound(classNodes);
            MethodNode methodNode = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            Parameter[] parameters = methodNode.getParameters();
            ClassNode[] params = StaticTypeCheckingVisitor.extractTypesFromParameters(parameters);
            ClassNode[] argTypes = (ClassNode[])wrapper.getData();
            List<MethodNode> method = this.findMethod(lub, methodNode.getName(), argTypes);
            if (method.size() == 1) continue;
            this.addStaticTypeError("A closure shared variable [" + target.getName() + "] has been assigned with various types and the method [" + StaticTypeCheckingSupport.toMethodParametersString(methodNode.getName(), params) + "] does not exist in the lowest upper bound of those types: [" + lub.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot determine safely what is the type of the variable at the moment of the call in a multithreaded context.", call);
        }
        this.extension.finish();
    }

    protected static ClassNode[] extractTypesFromParameters(Parameter[] parameters) {
        ClassNode[] params = new ClassNode[parameters.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = parameters[i].getType();
        }
        return params;
    }

    protected static ClassNode wrapTypeIfNecessary(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type)) {
            return ClassHelper.getWrapper(type);
        }
        return type;
    }

    protected static boolean isClassInnerClassOrEqualTo(ClassNode toBeChecked, ClassNode start) {
        if (start == toBeChecked) {
            return true;
        }
        if (start instanceof InnerClassNode) {
            return StaticTypeCheckingVisitor.isClassInnerClassOrEqualTo(toBeChecked, start.getOuterClass());
        }
        return false;
    }

    private static boolean isNonStaticHelperMethod(MethodNode method) {
        Parameter[] parameters = method.getParameters();
        if (parameters.length > 0 && parameters[0].getName().equals("$self")) {
            return !method.getName().contains("$init$") && Traits.isTrait(method.getDeclaringClass().getOuterClass());
        }
        return false;
    }

    private static class ParameterVariableExpression
    extends VariableExpression {
        private final Parameter parameter;

        ParameterVariableExpression(Parameter parameter) {
            super(parameter);
            this.parameter = parameter;
            ClassNode inferredType = (ClassNode)this.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            if (inferredType == null) {
                this.setNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, parameter.getOriginType());
            }
        }

        @Override
        public void copyNodeMetaData(ASTNode other) {
            this.parameter.copyNodeMetaData(other);
        }

        @Override
        public void removeNodeMetaData(Object key) {
            this.parameter.removeNodeMetaData(key);
        }

        @Override
        public Map<?, ?> getNodeMetaData() {
            return this.parameter.getNodeMetaData();
        }

        @Override
        public <T> T getNodeMetaData(Object key) {
            return this.parameter.getNodeMetaData(key);
        }

        @Override
        public Object putNodeMetaData(Object key, Object value) {
            return this.parameter.putNodeMetaData(key, value);
        }
    }

    private class PropertyLookup
    extends ClassCodeVisitorSupport {
        ClassNode propertyType;
        ClassNode receiverType;

        PropertyLookup(ClassNode type) {
            this.receiverType = type;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return StaticTypeCheckingVisitor.this.getSourceUnit();
        }

        @Override
        public void visitField(FieldNode node) {
            this.storePropertyType(node.getType(), node.isStatic() ? null : node.getDeclaringClass());
        }

        @Override
        public void visitMethod(MethodNode node) {
            this.storePropertyType(node.getReturnType(), node.isStatic() ? null : node.getDeclaringClass());
        }

        @Override
        public void visitProperty(PropertyNode node) {
            this.storePropertyType(node.getOriginType(), node.isStatic() ? null : node.getDeclaringClass());
        }

        private void storePropertyType(ClassNode type, ClassNode declaringClass) {
            if (declaringClass != null && GenericsUtils.hasUnresolvedGenerics(type)) {
                Map spec = StaticTypeCheckingVisitor.extractPlaceHolders(null, this.receiverType, declaringClass);
                type = StaticTypeCheckingSupport.applyGenericsContext((Map<GenericsType.GenericsTypeName, GenericsType>)spec, type);
            }
            this.propertyType = type;
        }
    }

    private static class SetterInfo {
        final ClassNode receiverType;
        final String name;
        final List<MethodNode> setters;

        private SetterInfo(ClassNode receiverType, String name, List<MethodNode> setters) {
            this.receiverType = receiverType;
            this.setters = setters;
            this.name = name;
        }
    }

    public static class SignatureCodecFactory {
        public static SignatureCodec getCodec(int version, ClassLoader classLoader) {
            switch (version) {
                case 1: {
                    return new SignatureCodecVersion1(classLoader);
                }
            }
            return null;
        }
    }

    protected class VariableExpressionTypeMemoizer
    extends ClassCodeVisitorSupport {
        private final boolean onlySharedVariables;
        private final Map<VariableExpression, ClassNode> varOrigType;

        public VariableExpressionTypeMemoizer(Map<VariableExpression, ClassNode> varOrigType) {
            this(varOrigType, false);
        }

        public VariableExpressionTypeMemoizer(Map<VariableExpression, ClassNode> varOrigType, boolean onlySharedVariables) {
            this.varOrigType = varOrigType;
            this.onlySharedVariables = onlySharedVariables;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return StaticTypeCheckingVisitor.this.typeCheckingContext.source;
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            Variable var = StaticTypeCheckingSupport.findTargetVariable(expression);
            if ((!this.onlySharedVariables || var.isClosureSharedVariable()) && var instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)var;
                ClassNode cn = (ClassNode)ve.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                if (cn == null) {
                    cn = ve.getOriginType();
                }
                this.varOrigType.put(ve, cn);
            }
            super.visitVariableExpression(expression);
        }
    }

    private static class ExtensionMethodDeclaringClass {
        private ExtensionMethodDeclaringClass() {
        }
    }
}

