/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovyjarjarasm.asm.Opcodes;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.groovy.ast.tools.MethodNodeUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AstToTextHelper;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class MethodNode
extends AnnotatedNode
implements Opcodes {
    public static final String SCRIPT_BODY_METHOD_KEY = "org.codehaus.groovy.ast.MethodNode.isScriptBody";
    private String name;
    private int modifiers;
    private boolean syntheticPublic;
    private ClassNode returnType;
    private Parameter[] parameters;
    private boolean hasDefaultValue;
    private Statement code;
    private boolean dynamicReturnType;
    private VariableScope variableScope;
    private ClassNode[] exceptions;
    private boolean staticConstructor;
    private GenericsType[] genericsTypes;
    private boolean hasDefault;
    String typeDescriptor;

    protected MethodNode() {
    }

    public MethodNode(String name, int modifiers, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        this.name = name;
        this.modifiers = modifiers;
        this.exceptions = exceptions;
        this.code = code;
        this.setReturnType(returnType);
        this.setParameters(parameters);
        this.staticConstructor = "<clinit>".equals(name);
    }

    public String getTypeDescriptor() {
        if (this.typeDescriptor == null) {
            this.typeDescriptor = MethodNodeUtils.methodDescriptor(this);
        }
        return this.typeDescriptor;
    }

    private void invalidateCachedData() {
        this.typeDescriptor = null;
    }

    public boolean isVoidMethod() {
        return ClassHelper.VOID_TYPE.equals(this.getReturnType());
    }

    public Statement getCode() {
        return this.code;
    }

    public void setCode(Statement code) {
        this.code = code;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.invalidateCachedData();
        this.modifiers = modifiers;
    }

    public String getName() {
        return this.name;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameter[] parameters) {
        this.invalidateCachedData();
        VariableScope scope = new VariableScope();
        this.hasDefaultValue = false;
        this.parameters = parameters;
        if (parameters != null && parameters.length > 0) {
            for (Parameter para : parameters) {
                if (para.hasInitialExpression()) {
                    this.hasDefaultValue = true;
                }
                para.setInStaticContext(this.isStatic());
                scope.putDeclaredVariable(para);
            }
        }
        this.setVariableScope(scope);
    }

    public ClassNode getReturnType() {
        return this.returnType;
    }

    public VariableScope getVariableScope() {
        return this.variableScope;
    }

    public void setVariableScope(VariableScope variableScope) {
        this.variableScope = variableScope;
        variableScope.setInStaticContext(this.isStatic());
    }

    public boolean isDynamicReturnType() {
        return this.dynamicReturnType;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isDefault() {
        return (this.modifiers & 0x409) == 1 && this.getDeclaringClass() != null && this.getDeclaringClass().isInterface();
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isPackageScope() {
        return (this.modifiers & 7) == 0;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    public boolean isScriptBody() {
        return this.getNodeMetaData(SCRIPT_BODY_METHOD_KEY) != null;
    }

    public void setIsScriptBody() {
        this.setNodeMetaData(SCRIPT_BODY_METHOD_KEY, Boolean.TRUE);
    }

    public String toString() {
        return "MethodNode@" + this.hashCode() + "[" + this.getDeclaringClass().getName() + "#" + this.getTypeDescriptor() + "]";
    }

    public void setReturnType(ClassNode returnType) {
        this.invalidateCachedData();
        this.dynamicReturnType |= ClassHelper.DYNAMIC_TYPE == returnType;
        this.returnType = returnType;
        if (returnType == null) {
            this.returnType = ClassHelper.OBJECT_TYPE;
        }
    }

    public ClassNode[] getExceptions() {
        return this.exceptions;
    }

    public Statement getFirstStatement() {
        if (this.code == null) {
            return null;
        }
        Statement first = this.code;
        while (first instanceof BlockStatement) {
            List<Statement> list = ((BlockStatement)first).getStatements();
            if (list.isEmpty()) {
                first = null;
                continue;
            }
            first = list.get(0);
        }
        return first;
    }

    public GenericsType[] getGenericsTypes() {
        return this.genericsTypes;
    }

    public void setGenericsTypes(GenericsType[] genericsTypes) {
        this.invalidateCachedData();
        this.genericsTypes = genericsTypes;
    }

    public void setAnnotationDefault(boolean b) {
        this.hasDefault = b;
    }

    public boolean hasAnnotationDefault() {
        return this.hasDefault;
    }

    public boolean isStaticConstructor() {
        return this.staticConstructor;
    }

    public boolean isSyntheticPublic() {
        return this.syntheticPublic;
    }

    public void setSyntheticPublic(boolean syntheticPublic) {
        this.syntheticPublic = syntheticPublic;
    }

    @Override
    public String getText() {
        String retType = AstToTextHelper.getClassText(this.returnType);
        String exceptionTypes = AstToTextHelper.getThrowsClauseText(this.exceptions);
        String parms = AstToTextHelper.getParametersText(this.parameters);
        int mask = this instanceof ConstructorNode ? Modifier.constructorModifiers() : Modifier.methodModifiers();
        return AstToTextHelper.getModifiersText(this.modifiers & mask) + " " + retType + " " + this.name + "(" + parms + ") " + exceptionTypes + " { ... }";
    }
}

