/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.Collection;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.security.SecureCache;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ConnectionStateException;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.ProtobufUtilities;
import org.apache.logging.log4j.Logger;

@Experimental
public class GetAllRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.GetAllRequest, RegionAPI.GetAllResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<RegionAPI.GetAllResponse> process(ProtobufSerializationService serializationService, RegionAPI.GetAllRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, DecodingException, ConnectionStateException {
        String regionName = request.getRegionName();
        RegionAPI.GetAllResponse.Builder responseBuilder = RegionAPI.GetAllResponse.newBuilder();
        SecureCache cache = messageExecutionContext.getSecureCache();
        Collection<Object> keys = serializationService.decodeList(request.getKeyList());
        cache.getAll(regionName, keys, (key, value) -> this.addEntry(serializationService, responseBuilder, key, value), (key, exception) -> this.addException(serializationService, responseBuilder, key, exception));
        return Success.of(responseBuilder.build());
    }

    private void addException(ProtobufSerializationService serializationService, RegionAPI.GetAllResponse.Builder responseBuilder, Object key, Object exception) {
        logger.warn("Failure in protobuf getAll operation for key: " + key, exception);
        BasicTypes.EncodedValue encodedKey = serializationService.encode(key);
        BasicTypes.KeyedError failure = BasicTypes.KeyedError.newBuilder().setKey(encodedKey).setError(BasicTypes.Error.newBuilder().setErrorCode(BasicTypes.ErrorCode.SERVER_ERROR).setMessage(exception.toString())).build();
        responseBuilder.addFailures(failure);
    }

    private void addEntry(ProtobufSerializationService serializationService, RegionAPI.GetAllResponse.Builder responseBuilder, Object key, Object value) {
        BasicTypes.Entry entry = ProtobufUtilities.createEntry(serializationService, key, value);
        responseBuilder.addEntries(entry);
    }
}

