/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufOperationContext;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.registry.ProtobufOperationContextRegistry;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;
import org.apache.geode.internal.protocol.protobuf.v1.state.TerminateConnection;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ConnectionStateException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;

@Experimental
public class ProtobufOpsProcessor {
    private final ProtobufOperationContextRegistry protobufOperationContextRegistry;
    private static final Logger logger = LogService.getLogger(ProtobufOpsProcessor.class);

    public ProtobufOpsProcessor(ProtobufOperationContextRegistry protobufOperationContextRegistry) {
        this.protobufOperationContextRegistry = protobufOperationContextRegistry;
    }

    public ClientProtocol.Message process(ClientProtocol.Message request, MessageExecutionContext messageExecutionContext) {
        Failure<ClientProtocol.Message.Builder> result;
        ProtobufOperationContext operationContext;
        block3: {
            ClientProtocol.Message.MessageTypeCase requestType = request.getMessageTypeCase();
            logger.debug("Processing request of type {}", (Object)requestType);
            operationContext = this.protobufOperationContextRegistry.getOperationContext(requestType);
            try {
                messageExecutionContext.getConnectionState().validateOperation(operationContext);
                result = this.processOperation(request, messageExecutionContext, requestType, operationContext);
            }
            catch (VirtualMachineError error) {
                SystemFailure.initiateFailure((Error)error);
                throw error;
            }
            catch (Throwable t) {
                logger.warn("Failure for request " + request, t);
                SystemFailure.checkFailure();
                result = Failure.of(t);
                if (!(t instanceof ConnectionStateException)) break block3;
                messageExecutionContext.setState(new TerminateConnection());
            }
        }
        return result.map(operationContext.getToResponse(), operationContext.getToErrorResponse()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result processOperation(ClientProtocol.Message request, MessageExecutionContext context, ClientProtocol.Message.MessageTypeCase requestType, ProtobufOperationContext operationContext) throws ConnectionStateException, EncodingException, DecodingException {
        long startTime = context.getStatistics().startOperation();
        try {
            Result result = operationContext.getOperationHandler().process(context.getSerializationService(), operationContext.getFromRequest().apply(request), context);
            return result;
        }
        catch (InvalidExecutionContextException exception) {
            logger.error("Invalid execution context found for operation {}", (Object)requestType, (Object)exception);
            Failure failure = Failure.of(BasicTypes.ErrorCode.INVALID_REQUEST, "Invalid execution context found for operation.");
            return failure;
        }
        catch (UnsupportedOperationException exception) {
            logger.error("Unsupported operation exception for request {}", (Object)requestType, (Object)exception);
            Failure failure = Failure.of(BasicTypes.ErrorCode.UNSUPPORTED_OPERATION, "Unsupported operation:" + exception.getMessage());
            return failure;
        }
        catch (NotAuthorizedException e) {
            Failure failure = Failure.of(BasicTypes.ErrorCode.AUTHORIZATION_FAILED, "Not authorized: " + (Object)((Object)e));
            return failure;
        }
        finally {
            context.getStatistics().endOperation(startTime);
        }
    }
}

