/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.Collection;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.ListConnectionFunction;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

@Experimental
public class ListConnectionCommand
extends GfshCommand {
    public static final String JDBC_CONNECTIONS_SECTION = "jdbc-connections";
    static final String LIST_JDBC_CONNECTION = "list jdbc-connections";
    static final String LIST_JDBC_CONNECTION__HELP = "(Experimental) Display jdbc connections for all members.";
    static final String LIST_OF_CONNECTIONS = "List of connections";
    static final String NO_CONNECTIONS_FOUND = "No connections found";

    @CliCommand(value={"list jdbc-connections"}, help="(Experimental) Display jdbc connections for all members.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel listConnection() {
        Collection<ConnectorService.Connection> connections = null;
        ConfigurationPersistenceService ccService = this.getConfigurationPersistenceService();
        if (ccService != null) {
            ConnectorService service;
            CacheConfig cacheConfig = ccService.getCacheConfig("cluster");
            if (cacheConfig != null && (service = (ConnectorService)cacheConfig.findCustomCacheElement("connector-service", ConnectorService.class)) != null) {
                connections = service.getConnection();
            }
        } else {
            DistributedMember targetMember;
            CliFunctionResult result;
            Set members = this.findMembers(null, null);
            if (members.size() > 0 && (result = this.executeFunctionAndGetFunctionResult((Function)new ListConnectionFunction(), null, targetMember = (DistributedMember)members.iterator().next())) != null) {
                connections = (Set)result.getResultObject();
            }
        }
        if (connections == null) {
            return ResultModel.createInfo((String)"(Experimental) \nNo connections found");
        }
        ResultModel resultModel = new ResultModel();
        boolean connectionsExist = this.fillTabularResultData(connections, resultModel.addTable(JDBC_CONNECTIONS_SECTION));
        if (connectionsExist) {
            resultModel.setHeader("(Experimental) ");
            return resultModel;
        }
        return ResultModel.createInfo((String)"(Experimental) \nNo connections found");
    }

    private boolean fillTabularResultData(Collection<ConnectorService.Connection> connections, TabularResultModel tableModel) {
        for (ConnectorService.Connection connectionConfig : connections) {
            tableModel.accumulate(LIST_OF_CONNECTIONS, connectionConfig.getName());
        }
        return !connections.isEmpty();
    }
}

