/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

@Experimental
public class CreateMappingFunction
extends CliFunction<ConnectorService.RegionMapping> {
    CreateMappingFunction() {
    }

    public CliFunctionResult executeFunction(FunctionContext<ConnectorService.RegionMapping> context) throws Exception {
        JdbcConnectorService service = FunctionContextArgumentProvider.getJdbcConnectorService(context);
        ConnectorService.RegionMapping regionMapping = (ConnectorService.RegionMapping)context.getArguments();
        this.createRegionMapping(service, regionMapping);
        String member = context.getMemberName();
        String message = "Created JDBC mapping for region " + regionMapping.getRegionName() + " on " + member;
        return new CliFunctionResult(member, true, message);
    }

    void createRegionMapping(JdbcConnectorService service, ConnectorService.RegionMapping regionMapping) throws RegionMappingExistsException {
        service.createRegionMapping(regionMapping);
    }
}

