/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigExistsException;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

public class CreateConnectionFunction
extends CliFunction<ConnectorService.Connection> {
    public CliFunctionResult executeFunction(FunctionContext<ConnectorService.Connection> context) throws Exception {
        JdbcConnectorService service = FunctionContextArgumentProvider.getJdbcConnectorService(context);
        ConnectorService.Connection connectionConfig = (ConnectorService.Connection)context.getArguments();
        this.createConnectionConfig(service, connectionConfig);
        String member = context.getMemberName();
        return this.createSuccessResult(connectionConfig.getName(), member);
    }

    void createConnectionConfig(JdbcConnectorService service, ConnectorService.Connection connectionConfig) throws ConnectionConfigExistsException {
        service.createConnectionConfig(connectionConfig);
    }

    private CliFunctionResult createSuccessResult(String connectionName, String member) {
        String message = "Created JDBC connection " + connectionName + " on " + member;
        return new CliFunctionResult(member, (Object)message);
    }
}

