/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.AlterConnectionFunction;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class AlterConnectionCommand
extends SingleGfshCommand {
    static final String ALTER_JDBC_CONNECTION = "alter jdbc-connection";
    static final String ALTER_JDBC_CONNECTION__HELP = "(Experimental) Alter properties for an existing jdbc connection.";
    static final String ALTER_CONNECTION__NAME = "name";
    static final String ALTER_CONNECTION__NAME__HELP = "Name of the connection to be altered.";
    static final String ALTER_CONNECTION__URL = "url";
    static final String ALTER_CONNECTION__URL__HELP = "New URL location for the database.";
    static final String ALTER_CONNECTION__USER = "user";
    static final String ALTER_CONNECTION__USER__HELP = "New user name to use when connecting to database.";
    static final String ALTER_CONNECTION__PASSWORD = "password";
    static final String ALTER_CONNECTION__PASSWORD__HELP = "New password to use when connecting to database.";
    static final String ALTER_CONNECTION__PARAMS = "params";
    static final String ALTER_CONNECTION__PARAMS__HELP = "New additional parameters to use when connecting to the database. This replaces all previously existing parameters.";

    @CliCommand(value={"alter jdbc-connection"}, help="(Experimental) Alter properties for an existing jdbc connection.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel alterConnection(@CliOption(key={"name"}, mandatory=true, help="Name of the connection to be altered.") String name, @CliOption(key={"url"}, specifiedDefaultValue="", help="New URL location for the database.") String url, @CliOption(key={"user"}, specifiedDefaultValue="", help="New user name to use when connecting to database.") String user, @CliOption(key={"password"}, specifiedDefaultValue="", help="New password to use when connecting to database.") String password, @CliOption(key={"params"}, specifiedDefaultValue="", help="New additional parameters to use when connecting to the database. This replaces all previously existing parameters.") String[] params) {
        Set targetMembers = this.getMembers(null, null);
        ConnectorService.Connection newConnection = new ConnectorService.Connection(name, url, user, password, params);
        ConfigurationPersistenceService ccService = this.getConfigurationPersistenceService();
        if (ccService != null) {
            CacheConfig cacheConfig = ccService.getCacheConfig("cluster");
            ConnectorService service = (ConnectorService)cacheConfig.findCustomCacheElement("connector-service", ConnectorService.class);
            if (service == null) {
                throw new EntityNotFoundException("connection with name '" + name + "' does not exist.");
            }
            ConnectorService.Connection conn = (ConnectorService.Connection)CacheElement.findElement(service.getConnection(), (String)name);
            if (conn == null) {
                throw new EntityNotFoundException("connection with name '" + name + "' does not exist.");
            }
        }
        List results = this.executeAndGetFunctionResult((Function)new AlterConnectionFunction(), newConnection, targetMembers);
        CliFunctionResult successResult = results.stream().filter(CliFunctionResult::isSuccessful).findAny().get();
        ConnectorService.Connection mergedConnection = (ConnectorService.Connection)successResult.getResultObject();
        ResultModel result = ResultModel.createMemberStatusResult((List)results, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
        result.setConfigObject((Object)mergedConnection);
        return result;
    }

    public void updateClusterConfig(String group, CacheConfig config, Object element) {
        ConnectorService.Connection connection = (ConnectorService.Connection)element;
        ConnectorService service = (ConnectorService)config.findCustomCacheElement("connector-service", ConnectorService.class);
        CacheElement.removeElement(service.getConnection(), (String)connection.getId());
        service.getConnection().add(connection);
    }
}

