/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigExistsException;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigNotFoundException;
import org.apache.geode.connectors.jdbc.internal.DataSourceManager;
import org.apache.geode.connectors.jdbc.internal.HikariJdbcDataSourceFactory;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.RegionMappingNotFoundException;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;

@Experimental
public class JdbcConnectorServiceImpl
implements JdbcConnectorService {
    private final Map<String, ConnectorService.Connection> connectionsByName = new ConcurrentHashMap<String, ConnectorService.Connection>();
    private final Map<String, ConnectorService.RegionMapping> mappingsByRegion = new ConcurrentHashMap<String, ConnectorService.RegionMapping>();
    private final DataSourceManager manager = new DataSourceManager(new HikariJdbcDataSourceFactory());
    private volatile InternalCache cache;
    private boolean registered;

    @Override
    public void createConnectionConfig(ConnectorService.Connection config) throws ConnectionConfigExistsException {
        ConnectorService.Connection existing = this.connectionsByName.putIfAbsent(config.getName(), config);
        if (existing != null) {
            throw new ConnectionConfigExistsException("Connection " + config.getName() + " exists");
        }
    }

    @Override
    public void replaceConnectionConfig(ConnectorService.Connection alteredConfig) throws ConnectionConfigNotFoundException {
        ConnectorService.Connection existingConfig = this.connectionsByName.get(alteredConfig.getName());
        if (existingConfig == null) {
            throw new ConnectionConfigNotFoundException("Connection configuration " + alteredConfig.getName() + " was not found");
        }
        this.connectionsByName.put(existingConfig.getName(), alteredConfig);
    }

    @Override
    public void destroyConnectionConfig(String connectionName) {
        this.connectionsByName.remove(connectionName);
    }

    @Override
    public ConnectorService.Connection getConnectionConfig(String connectionName) {
        return this.connectionsByName.get(connectionName);
    }

    @Override
    public Set<ConnectorService.Connection> getConnectionConfigs() {
        HashSet<ConnectorService.Connection> connectionConfigs = new HashSet<ConnectorService.Connection>();
        connectionConfigs.addAll(this.connectionsByName.values());
        return connectionConfigs;
    }

    @Override
    public Set<ConnectorService.RegionMapping> getRegionMappings() {
        HashSet<ConnectorService.RegionMapping> regionMappings = new HashSet<ConnectorService.RegionMapping>();
        regionMappings.addAll(this.mappingsByRegion.values());
        return regionMappings;
    }

    @Override
    public DataSourceManager getDataSourceManager() {
        return this.manager;
    }

    @Override
    public void createRegionMapping(ConnectorService.RegionMapping mapping) throws RegionMappingExistsException {
        ConnectorService.RegionMapping existing = this.mappingsByRegion.putIfAbsent(mapping.getRegionName(), mapping);
        if (existing != null) {
            throw new RegionMappingExistsException("RegionMapping for region " + mapping.getRegionName() + " exists");
        }
    }

    @Override
    public void replaceRegionMapping(ConnectorService.RegionMapping alteredMapping) throws RegionMappingNotFoundException {
        ConnectorService.RegionMapping existingMapping = this.mappingsByRegion.get(alteredMapping.getRegionName());
        if (existingMapping == null) {
            throw new RegionMappingNotFoundException("RegionMapping for region " + existingMapping.getRegionName() + " was not found");
        }
        this.mappingsByRegion.put(existingMapping.getRegionName(), alteredMapping);
    }

    @Override
    public ConnectorService.RegionMapping getMappingForRegion(String regionName) {
        return this.mappingsByRegion.get(regionName);
    }

    @Override
    public void destroyRegionMapping(String regionName) {
        this.mappingsByRegion.remove(regionName);
    }

    public void init(Cache cache) {
        this.cache = (InternalCache)cache;
    }

    public Class<? extends CacheService> getInterface() {
        return JdbcConnectorService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }
}

