/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClasspathOrModulePathEntry;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.NestedJarHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.LinkedHashSet;

public class ClasspathOrder {
    private final ScanSpec scanSpec;
    private final NestedJarHandler nestedJarHandler;
    private final LinkedHashSet<ClasspathOrModulePathEntry> classpathOrder = new LinkedHashSet();

    ClasspathOrder(ScanSpec scanSpec, NestedJarHandler nestedJarHandler) {
        this.scanSpec = scanSpec;
        this.nestedJarHandler = nestedJarHandler;
    }

    LinkedHashSet<ClasspathOrModulePathEntry> get() {
        return this.classpathOrder;
    }

    private boolean filter(String classpathElementPath) {
        if (this.scanSpec.classpathElementFilters != null) {
            for (ClassGraph.ClasspathElementFilter filter : this.scanSpec.classpathElementFilters) {
                if (filter.includeClasspathElement(classpathElementPath)) continue;
                return false;
            }
        }
        return true;
    }

    boolean addClasspathElement(String pathElement, ClassLoader[] classLoaders, ScanSpec scanSpec, LogNode log) {
        if (pathElement == null || pathElement.isEmpty()) {
            return false;
        }
        LogNode subLog = null;
        if (log != null) {
            subLog = log.log("Found classpath element: " + pathElement);
        }
        if (pathElement.endsWith("*")) {
            if (pathElement.length() == 1 || pathElement.length() > 2 && pathElement.charAt(pathElement.length() - 1) == '*' && (pathElement.charAt(pathElement.length() - 2) == File.separatorChar || File.separatorChar != '/' && pathElement.charAt(pathElement.length() - 2) == '/')) {
                try {
                    ClasspathOrModulePathEntry classpathEltParentDirRelativePath = new ClasspathOrModulePathEntry(FileUtils.CURR_DIR_PATH, pathElement.substring(0, pathElement.length() - 2), classLoaders, this.nestedJarHandler, scanSpec, subLog);
                    String classpathEltParentDirPath = classpathEltParentDirRelativePath.getResolvedPath();
                    if (!this.filter(classpathEltParentDirPath)) {
                        if (log != null) {
                            log.log("Classpath element did not match filter criterion, skipping: " + classpathEltParentDirRelativePath);
                        }
                        return false;
                    }
                    File classpathEltParentDir = classpathEltParentDirRelativePath.getFile(subLog);
                    if (!classpathEltParentDir.exists()) {
                        if (subLog != null) {
                            subLog.log("Directory does not exist for wildcard classpath element: " + pathElement);
                        }
                        return false;
                    }
                    if (!classpathEltParentDir.isDirectory()) {
                        if (subLog != null) {
                            subLog.log("Wildcard classpath element is not a directory: " + pathElement);
                        }
                        return false;
                    }
                    for (File fileInDir : classpathEltParentDir.listFiles()) {
                        String name = fileInDir.getName();
                        if (name.equals(".") || name.equals("..")) continue;
                        String fileInDirPath = fileInDir.getPath();
                        LogNode subSubLog = subLog == null ? null : subLog.log("Including classpath element matching wildcard: " + fileInDirPath);
                        this.addClasspathElement(fileInDirPath, classLoaders, scanSpec, subSubLog);
                    }
                    return true;
                }
                catch (IOException e) {
                    if (subLog != null) {
                        subLog.log("Could not add wildcard classpath element " + pathElement + " : " + e);
                    }
                    return false;
                }
            }
            if (subLog != null) {
                subLog.log("Wildcard classpath elements can only end with a leaf of \"*\", can't have a partial name and then a wildcard: " + pathElement);
            }
            return false;
        }
        ClasspathOrModulePathEntry classpathEltRelativePath = new ClasspathOrModulePathEntry(FileUtils.CURR_DIR_PATH, pathElement, classLoaders, this.nestedJarHandler, scanSpec, subLog);
        String classpathEltPath = classpathEltRelativePath.getResolvedPath();
        if (!this.filter(classpathEltPath)) {
            if (log != null) {
                log.log("Classpath element did not match filter criterion, skipping: " + classpathEltRelativePath);
            }
            return false;
        }
        if (this.classpathOrder.add(classpathEltRelativePath)) {
            if (subLog != null && !classpathEltRelativePath.toString().equals(pathElement)) {
                subLog.log("Normalized path: " + classpathEltRelativePath);
            }
            return true;
        }
        if (subLog != null) {
            if (!classpathEltRelativePath.toString().equals(pathElement)) {
                subLog.log("Ignoring duplicate classpath element: " + classpathEltRelativePath);
            } else {
                subLog.log("Ignoring duplicate classpath element");
            }
        }
        return false;
    }

    public boolean addClasspathElements(String pathStr, ClassLoader[] classLoaders, LogNode log) {
        if (pathStr == null || pathStr.isEmpty()) {
            return false;
        }
        String[] parts = JarUtils.smartPathSplit(pathStr);
        if (parts.length == 0) {
            return false;
        }
        for (String pathElement : parts) {
            this.addClasspathElement(pathElement, classLoaders, this.scanSpec, log);
        }
        return true;
    }

    public boolean addClasspathElement(String pathElement, ClassLoader classLoader, LogNode log) {
        return this.addClasspathElement(pathElement, new ClassLoader[]{classLoader}, this.scanSpec, log);
    }

    public boolean addClasspathElementObject(Object pathObject, ClassLoader classLoader, LogNode log) {
        boolean valid = false;
        if (pathObject != null) {
            if (pathObject instanceof String) {
                valid |= this.addClasspathElements((String)pathObject, classLoader, log);
            } else if (pathObject instanceof Iterable) {
                for (Object p : (Iterable)pathObject) {
                    if (p == null) continue;
                    valid |= this.addClasspathElements(p.toString(), classLoader, log);
                }
            } else {
                Class<?> valClass = pathObject.getClass();
                if (valClass.isArray()) {
                    int n = Array.getLength(pathObject);
                    for (int j = 0; j < n; ++j) {
                        Object elt = Array.get(pathObject, j);
                        if (elt == null) continue;
                        valid |= this.addClasspathElementObject(elt, classLoader, log);
                    }
                } else {
                    valid |= this.addClasspathElements(pathObject.toString(), classLoader, log);
                }
            }
        }
        return valid;
    }

    public boolean addClasspathElements(String pathStr, ClassLoader classLoader, LogNode log) {
        return this.addClasspathElements(pathStr, new ClassLoader[]{classLoader}, log);
    }

    public boolean addClasspathElements(ClasspathOrder subsequentOrder) {
        return this.classpathOrder.addAll(subsequentOrder.classpathOrder);
    }
}

