/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.json.JSONDeserializer;
import io.github.classgraph.json.JSONSerializer;
import io.github.classgraph.utils.ClassLoaderAndModuleFinder;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.JarfileMetadataReader;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.NestedJarHandler;
import java.io.Closeable;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScanResult
implements Closeable,
AutoCloseable {
    final ScanSpec scanSpec;
    private final List<String> rawClasspathEltOrderStrs;
    private final List<ClasspathElement> classpathOrder;
    private ResourceList allResources;
    private final ClassLoader[] envClassLoaderOrder;
    private final NestedJarHandler nestedJarHandler;
    private final Map<File, Long> fileToLastModified;
    private final Map<String, ClassInfo> classNameToClassInfo;
    private volatile boolean closed;
    private final LogNode log;
    private static final String CURRENT_SERIALIZATION_FORMAT = "4";

    ScanResult(ScanSpec scanSpec, List<ClasspathElement> classpathOrder, List<String> rawClasspathEltOrderStrs, ClassLoader[] envClassLoaderOrder, Map<String, ClassInfo> classNameToClassInfo, Map<File, Long> fileToLastModified, NestedJarHandler nestedJarHandler, LogNode log) {
        this.scanSpec = scanSpec;
        this.rawClasspathEltOrderStrs = rawClasspathEltOrderStrs;
        this.classpathOrder = classpathOrder;
        for (ClasspathElement classpathElt : classpathOrder) {
            if (classpathElt.fileMatches == null) continue;
            if (this.allResources == null) {
                this.allResources = new ResourceList();
            }
            this.allResources.addAll(classpathElt.fileMatches);
        }
        this.envClassLoaderOrder = envClassLoaderOrder;
        this.fileToLastModified = fileToLastModified;
        this.classNameToClassInfo = classNameToClassInfo;
        this.nestedJarHandler = nestedJarHandler;
        this.log = log;
        if (classNameToClassInfo != null) {
            for (ClassInfo classInfo : classNameToClassInfo.values()) {
                classInfo.setScanResult(this);
            }
        }
        Runtime.getRuntime().addShutdownHook(new CleanupThread(this));
    }

    public List<File> getClasspathFiles() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        ArrayList<File> classpathElementOrderFiles = new ArrayList<File>();
        for (ClasspathElement classpathElement : this.classpathOrder) {
            ModuleRef modRef = classpathElement.getClasspathElementModuleRef();
            if (modRef != null) {
                File moduleLocationFile;
                if (modRef.isSystemModule() || (moduleLocationFile = modRef.getLocationFile()) == null) continue;
                classpathElementOrderFiles.add(moduleLocationFile);
                continue;
            }
            classpathElementOrderFiles.add(classpathElement.getClasspathElementFile(this.log));
        }
        return classpathElementOrderFiles;
    }

    public String getClasspath() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        return JarUtils.pathElementsToPathStr(this.getClasspathFiles());
    }

    public List<URL> getClasspathURLs() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        ArrayList<URL> classpathElementOrderURLs = new ArrayList<URL>();
        for (ClasspathElement classpathElement : this.classpathOrder) {
            ModuleRef modRef = classpathElement.getClasspathElementModuleRef();
            if (modRef != null) {
                try {
                    classpathElementOrderURLs.add(modRef.getLocation().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
                continue;
            }
            try {
                classpathElementOrderURLs.add(classpathElement.getClasspathElementFile(this.log).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return classpathElementOrderURLs;
    }

    public List<ModuleRef> getModules() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        ArrayList<ModuleRef> moduleRefs = new ArrayList<ModuleRef>();
        for (ClasspathElement classpathElement : this.classpathOrder) {
            ModuleRef moduleRef = classpathElement.getClasspathElementModuleRef();
            if (moduleRef == null) continue;
            moduleRefs.add(moduleRef);
        }
        return moduleRefs;
    }

    public ResourceList getAllResources() {
        if (this.allResources == null || this.allResources.isEmpty()) {
            return new ResourceList(1);
        }
        return this.allResources;
    }

    public ResourceList getResourcesWithPath(String resourcePath) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (this.allResources == null || this.allResources.isEmpty()) {
            return new ResourceList(1);
        }
        String path = resourcePath;
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        ResourceList filteredResources = new ResourceList();
        for (Resource classpathResource : this.allResources) {
            if (!classpathResource.getPath().equals(path)) continue;
            filteredResources.add(classpathResource);
        }
        return filteredResources;
    }

    public ResourceList getResourcesWithLeafName(String leafName) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (this.allResources == null || this.allResources.isEmpty()) {
            return new ResourceList(1);
        }
        ResourceList filteredResources = new ResourceList();
        for (Resource classpathResource : this.allResources) {
            int lastSlashIdx;
            String relativePath = classpathResource.getPath();
            if (!relativePath.substring((lastSlashIdx = relativePath.lastIndexOf(47)) + 1).equals(leafName)) continue;
            filteredResources.add(classpathResource);
        }
        return filteredResources;
    }

    public ResourceList getResourcesWithExtension(String extension) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (this.allResources == null || this.allResources.isEmpty()) {
            return new ResourceList(1);
        }
        String bareExtension = extension;
        while (bareExtension.startsWith(".")) {
            bareExtension = bareExtension.substring(1);
        }
        ResourceList filteredResources = new ResourceList();
        for (Resource classpathResource : this.allResources) {
            String relativePath = classpathResource.getPath();
            int lastSlashIdx = relativePath.lastIndexOf(47);
            int lastDotIdx = relativePath.lastIndexOf(46);
            if (lastDotIdx <= lastSlashIdx || !relativePath.substring(lastDotIdx + 1).equalsIgnoreCase(bareExtension)) continue;
            filteredResources.add(classpathResource);
        }
        return filteredResources;
    }

    public ResourceList getResourcesMatchingPattern(Pattern pattern) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (this.allResources == null || this.allResources.isEmpty()) {
            return new ResourceList(1);
        }
        ResourceList filteredResources = new ResourceList();
        for (Resource classpathResource : this.allResources) {
            String relativePath = classpathResource.getPath();
            if (!pattern.matcher(relativePath).matches()) continue;
            filteredResources.add(classpathResource);
        }
        return filteredResources;
    }

    public boolean classpathContentsModifiedSinceScan() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (this.fileToLastModified == null) {
            return true;
        }
        for (Map.Entry<File, Long> ent : this.fileToLastModified.entrySet()) {
            if (ent.getKey().lastModified() == ent.getValue().longValue()) continue;
            return true;
        }
        return false;
    }

    public long classpathContentsLastModifiedTime() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        long maxLastModifiedTime = 0L;
        if (this.fileToLastModified != null) {
            long currTime = System.currentTimeMillis();
            for (long timestamp : this.fileToLastModified.values()) {
                if (timestamp <= maxLastModifiedTime || timestamp >= currTime) continue;
                maxLastModifiedTime = timestamp;
            }
        }
        return maxLastModifiedTime;
    }

    public ClassInfo getClassInfo(String className) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return this.classNameToClassInfo.get(className);
    }

    public ClassInfoList getAllClasses() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return ClassInfo.getAllClasses(this.classNameToClassInfo.values(), this.scanSpec, this);
    }

    public ClassInfoList getAllStandardClasses() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return ClassInfo.getAllStandardClasses(this.classNameToClassInfo.values(), this.scanSpec, this);
    }

    public ClassInfoList getSubclasses(String superclassName) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        if (superclassName.equals("java.lang.Object")) {
            return this.getAllStandardClasses();
        }
        ClassInfo superclass = this.classNameToClassInfo.get(superclassName);
        return superclass == null ? ClassInfoList.EMPTY_LIST : superclass.getSubclasses();
    }

    public ClassInfoList getSuperclasses(String subclassName) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        ClassInfo subclass = this.classNameToClassInfo.get(subclassName);
        return subclass == null ? ClassInfoList.EMPTY_LIST : subclass.getSuperclasses();
    }

    public ClassInfoList getClassesWithMethodAnnotation(String methodAnnotationName) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!(this.scanSpec.enableClassInfo && this.scanSpec.enableMethodInfo && this.scanSpec.enableAnnotationInfo)) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo(), #enableMethodInfo(), and #enableAnnotationInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(methodAnnotationName);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getClassesWithMethodAnnotation();
    }

    public ClassInfoList getClassesWithFieldAnnotation(String fieldAnnotationName) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!(this.scanSpec.enableClassInfo && this.scanSpec.enableFieldInfo && this.scanSpec.enableAnnotationInfo)) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo(), #enableFieldInfo(), and #enableAnnotationInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(fieldAnnotationName);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getClassesWithFieldAnnotation();
    }

    public ClassInfoList getAllInterfaces() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return ClassInfo.getAllImplementedInterfaceClasses(this.classNameToClassInfo.values(), this.scanSpec, this);
    }

    public ClassInfoList getInterfaces(String className) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getInterfaces();
    }

    public ClassInfoList getClassesImplementing(String interfaceName) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getClassesImplementing();
    }

    public ClassInfoList getAllAnnotations() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo || !this.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() and #enableAnnotationInfo() before #scan()");
        }
        return ClassInfo.getAllAnnotationClasses(this.classNameToClassInfo.values(), this.scanSpec, this);
    }

    public ClassInfoList getAllInterfacesAndAnnotations() {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo || !this.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() and #enableAnnotationInfo() before #scan()");
        }
        return ClassInfo.getAllInterfacesOrAnnotationClasses(this.classNameToClassInfo.values(), this.scanSpec, this);
    }

    public ClassInfoList getClassesWithAnnotation(String annotationName) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo || !this.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() and #enableAnnotationInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(annotationName);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getClassesWithAnnotation();
    }

    public ClassInfoList getAnnotationsOnClass(String className) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo || !this.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() and #enableAnnotationInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getAnnotations();
    }

    private Class<?> loadClass(String className, ClassLoader classLoader, LogNode log) throws IllegalArgumentException {
        try {
            return Class.forName(className, this.scanSpec.initializeLoadedClasses, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Exception while loading class " + className, e);
        }
    }

    private Class<?> loadClass(String className, boolean returnNullIfClassNotFound, LogNode log) throws IllegalArgumentException {
        block16: {
            Class<?> classRef;
            ClassLoader[] classLoadersForClass;
            if (this.closed) {
                throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
            }
            if (className == null || className.isEmpty()) {
                throw new IllegalArgumentException("Cannot load class -- class names cannot be null or empty");
            }
            ClassInfo classInfo = this.classNameToClassInfo.get(className);
            ClassLoader[] classLoaderArray = classLoadersForClass = classInfo != null ? classInfo.classLoaders : this.envClassLoaderOrder;
            if (classLoadersForClass != null) {
                for (ClassLoader classLoader : classLoadersForClass) {
                    Class<?> classRef2 = this.loadClass(className, classLoader, log);
                    if (classRef2 == null) continue;
                    return classRef2;
                }
            }
            if ((classRef = this.loadClass(className, null, log)) != null) {
                return classRef;
            }
            if (classInfo != null && this.nestedJarHandler != null) {
                try {
                    ClassLoader customClassLoader = null;
                    if (classInfo.classpathElementFile.isDirectory()) {
                        customClassLoader = new URLClassLoader(new URL[]{classInfo.classpathElementFile.toURI().toURL()});
                    } else {
                        File outermostJar = this.nestedJarHandler.getOutermostJar(classInfo.classpathElementFile);
                        JarfileMetadataReader jarfileMetadataReader = this.nestedJarHandler.getJarfileMetadataReader(outermostJar, "", log);
                        customClassLoader = jarfileMetadataReader.getCustomClassLoader(this.nestedJarHandler, log);
                    }
                    if (customClassLoader != null) {
                        Class<?> classRefFromCustomClassLoader = this.loadClass(className, customClassLoader, log);
                        if (classRefFromCustomClassLoader != null) {
                            return classRefFromCustomClassLoader;
                        }
                    } else if (log != null) {
                        log.log("Unable to create custom classLoader to load class " + className);
                    }
                }
                catch (Throwable e) {
                    if (log == null) break block16;
                    log.log("Exception while trying to load class " + className + " : " + e);
                }
            }
        }
        if (!returnNullIfClassNotFound) {
            throw new IllegalArgumentException("No classloader was able to load class " + className);
        }
        if (log != null) {
            log.log("No classloader was able to load class " + className);
        }
        return null;
    }

    Class<?> loadClass(String className, boolean ignoreExceptions) throws IllegalArgumentException {
        try {
            Class<?> clazz = this.loadClass(className, ignoreExceptions, this.log);
            return clazz;
        }
        catch (Throwable e) {
            if (ignoreExceptions) {
                Class<?> clazz = null;
                return clazz;
            }
            throw new IllegalArgumentException("Could not load class " + className, e);
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    <T> Class<T> loadClass(String className, Class<T> superclassOrInterfaceType, boolean ignoreExceptions) throws IllegalArgumentException {
        try {
            Class<?> castClass;
            if (superclassOrInterfaceType == null) {
                if (ignoreExceptions) {
                    Class<T> clazz = null;
                    return clazz;
                }
                throw new IllegalArgumentException("classType parameter cannot be null");
            }
            Class<?> loadedClass = this.loadClass(className, ignoreExceptions, this.log);
            if (loadedClass != null && !superclassOrInterfaceType.isAssignableFrom(loadedClass)) {
                if (ignoreExceptions) {
                    Class<T> clazz = null;
                    return clazz;
                }
                throw new IllegalArgumentException("Loaded class " + loadedClass.getName() + " cannot be cast to " + superclassOrInterfaceType.getName());
            }
            Class<?> clazz = castClass = loadedClass;
            return clazz;
        }
        catch (Throwable e) {
            if (ignoreExceptions) {
                Class<T> clazz = null;
                return clazz;
            }
            throw new IllegalArgumentException("Could not load class " + className, e);
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public static ScanResult fromJSON(String json) {
        Matcher matcher = Pattern.compile("\\{[\\n\\r ]*\"serializationFormat\"[ ]?:[ ]?\"([^\"]+)\"").matcher(json);
        if (!matcher.find()) {
            throw new IllegalArgumentException("JSON is not in correct format");
        }
        if (!CURRENT_SERIALIZATION_FORMAT.equals(matcher.group(1))) {
            throw new IllegalArgumentException("JSON was serialized in a different format from the format used by the current version of ClassGraph -- please serialize and deserialize your ScanResult using the same version of ClassGraph");
        }
        SerializationFormat deserialized = JSONDeserializer.deserializeObject(SerializationFormat.class, json);
        if (!deserialized.serializationFormat.equals(CURRENT_SERIALIZATION_FORMAT)) {
            throw new IllegalArgumentException("JSON was serialized by newer version of ClassGraph");
        }
        List<URL> urls = new ClassGraph().overrideClasspath(deserialized.classpath).getClasspathURLs();
        ClassLoader[] envClassLoaderOrder = new ClassLoaderAndModuleFinder(deserialized.scanSpec, null).getClassLoaders();
        ClassLoader parentClassLoader = envClassLoaderOrder == null || envClassLoaderOrder.length == 0 ? null : envClassLoaderOrder[0];
        URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[0]), parentClassLoader);
        ClassLoader[] classLoaderOrder = new ClassLoader[]{urlClassLoader};
        HashMap<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
        for (ClassInfo ci : deserialized.classInfo) {
            ci.classLoaders = classLoaderOrder;
            classNameToClassInfo.put(ci.getName(), ci);
        }
        ScanResult scanResult = new ScanResult(deserialized.scanSpec, Collections.emptyList(), deserialized.classpath, classLoaderOrder, classNameToClassInfo, null, null, null);
        return scanResult;
    }

    public String toJSON(int indentWidth) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        ArrayList<ClassInfo> allClassInfo = new ArrayList<ClassInfo>(this.classNameToClassInfo.values());
        Collections.sort(allClassInfo);
        return JSONSerializer.serializeObject(new SerializationFormat(CURRENT_SERIALIZATION_FORMAT, this.scanSpec, allClassInfo, this.rawClasspathEltOrderStrs), indentWidth, false);
    }

    public String toJSON() {
        return this.toJSON(0);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.allResources != null) {
                for (Resource classpathResource : this.allResources) {
                    classpathResource.close();
                }
                this.allResources.clear();
            }
            if (this.rawClasspathEltOrderStrs != null) {
                this.rawClasspathEltOrderStrs.clear();
            }
            if (this.nestedJarHandler != null) {
                this.nestedJarHandler.close(this.log);
            }
            if (this.classpathOrder != null) {
                for (ClasspathElement classpathElement : this.classpathOrder) {
                    classpathElement.closeRecyclers();
                }
                this.classpathOrder.clear();
            }
            if (this.classNameToClassInfo != null) {
                this.classNameToClassInfo.clear();
            }
            if (this.fileToLastModified != null) {
                this.fileToLastModified.clear();
            }
            if (this.log != null) {
                this.log.flush();
            }
            this.closed = true;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private static class SerializationFormat {
        public String serializationFormat;
        public ScanSpec scanSpec;
        public List<String> classpath;
        public List<ClassInfo> classInfo;

        public SerializationFormat() {
        }

        public SerializationFormat(String serializationFormat, ScanSpec scanSpec, List<ClassInfo> classInfo, List<String> classpath) {
            this.serializationFormat = serializationFormat;
            this.scanSpec = scanSpec;
            this.classpath = classpath;
            this.classInfo = classInfo;
        }
    }

    private static class CleanupThread
    extends Thread {
        private final WeakReference<ScanResult> weakScanResult;

        public CleanupThread(ScanResult scanResult) {
            this.weakScanResult = new WeakReference<ScanResult>(scanResult);
        }

        @Override
        public void run() {
            ScanResult scanResult = (ScanResult)this.weakScanResult.get();
            if (scanResult != null) {
                scanResult.close();
            }
        }
    }
}

