/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClasspathOrModulePathEntry;
import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import io.github.classgraph.utils.JarfileMetadataReader;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.NestedJarHandler;
import io.github.classgraph.utils.Recycler;
import io.github.classgraph.utils.URLPathEncoder;
import io.github.classgraph.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ClasspathElementZip
extends ClasspathElement {
    private File classpathEltZipFile;
    private JarfileMetadataReader jarfileMetadataReader;
    private String packageRootPrefix;
    private Recycler<ZipFile, IOException> zipFileRecycler;

    ClasspathElementZip(ClasspathOrModulePathEntry classpathEltPath, ScanSpec scanSpec, boolean scanFiles, NestedJarHandler nestedJarHandler, WorkQueue<ClasspathOrModulePathEntry> workQueue, LogNode log) {
        super(classpathEltPath, scanSpec, scanFiles);
        try {
            this.classpathEltZipFile = classpathEltPath.getFile(log);
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while trying to canonicalize path " + classpathEltPath.getResolvedPath(), e);
            }
            this.skipClasspathElement = true;
            return;
        }
        if (this.classpathEltZipFile == null || !FileUtils.canRead(this.classpathEltZipFile)) {
            if (log != null) {
                log.log("Skipping non-existent jarfile " + classpathEltPath.getResolvedPath());
            }
            this.skipClasspathElement = true;
            return;
        }
        try {
            this.zipFileRecycler = nestedJarHandler.getZipFileRecycler(this.classpathEltZipFile, log);
        }
        catch (Exception e) {
            if (log != null) {
                log.log("Exception while creating zipfile recycler for " + this.classpathEltZipFile + " : " + e);
            }
            this.skipClasspathElement = true;
            return;
        }
        String packageRoot = this.getJarfilePackageRoot();
        try {
            this.jarfileMetadataReader = nestedJarHandler.getJarfileMetadataReader(this.classpathEltZipFile, packageRoot, log);
        }
        catch (Exception e) {
            if (log != null) {
                log.log("Exception while reading metadata from " + this.classpathEltZipFile + " : " + e);
            }
            this.skipClasspathElement = true;
            return;
        }
        if (this.jarfileMetadataReader == null) {
            this.skipClasspathElement = true;
            return;
        }
        if (!packageRoot.isEmpty()) {
            if (log != null) {
                log.log("Package root within jarfile: " + packageRoot);
            }
            this.packageRootPrefix = packageRoot + "/";
        } else {
            this.packageRootPrefix = "";
        }
        while (this.packageRootPrefix.startsWith("/")) {
            this.packageRootPrefix = this.packageRootPrefix.substring(1);
        }
        if (this.jarfileMetadataReader != null && this.jarfileMetadataReader.classPathEntriesToScan != null) {
            LogNode childClasspathLog = log == null ? null : log.log("Found additional classpath entries in metadata for " + this.classpathEltZipFile);
            String pathOfContainingDir = FastPathResolver.resolve(this.classpathEltZipFile.getParent());
            if (this.childClasspathElts == null) {
                this.childClasspathElts = new ArrayList(this.jarfileMetadataReader.classPathEntriesToScan.size());
            }
            for (int i = 0; i < this.jarfileMetadataReader.classPathEntriesToScan.size(); ++i) {
                String childClassPathEltPath = this.jarfileMetadataReader.classPathEntriesToScan.get(i);
                ClasspathOrModulePathEntry childRelativePath = new ClasspathOrModulePathEntry(pathOfContainingDir, childClassPathEltPath, classpathEltPath.getClassLoaders(), nestedJarHandler, scanSpec, log);
                if (childRelativePath.equals(classpathEltPath)) continue;
                this.childClasspathElts.add(childRelativePath);
                if (childClasspathLog == null) continue;
                childClasspathLog.log(childRelativePath.toString());
            }
            if (!this.childClasspathElts.isEmpty()) {
                if (workQueue != null) {
                    workQueue.addWorkUnits(this.childClasspathElts);
                } else if (log != null) {
                    log.log("Ignoring Class-Path entries in rt.jar: " + this.childClasspathElts);
                }
            }
        }
        if (scanFiles) {
            this.fileMatches = new ArrayList();
            this.classfileMatches = new ArrayList();
            this.fileToLastModified = new HashMap();
        }
    }

    private Resource newClasspathResource(final File jarFile, final String packageRootPrefix, final String pathRelativeToPackageRoot, final ZipEntry zipEntry) {
        return new Resource(){
            private Recycler.Recyclable zipFileRecyclable;
            private ZipFile zipFile;
            private String pathRelativeToClasspathElt = null;
            {
                this.length = zipEntry.getSize();
            }

            @Override
            public String getPath() {
                return pathRelativeToPackageRoot;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                return this.pathRelativeToClasspathElt == null ? (this.pathRelativeToClasspathElt = packageRootPrefix + pathRelativeToPackageRoot) : this.pathRelativeToClasspathElt;
            }

            @Override
            public URL getURL() {
                try {
                    return new URL(jarFile.toURI().toURL().toString() + "!" + URLPathEncoder.encodePath(this.getPathRelativeToClasspathElement()));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Could not form URL for jarfile: " + jarFile + " ; path: " + this.pathRelativeToClasspathElt);
                }
            }

            @Override
            public InputStream open() throws IOException {
                if (ClasspathElementZip.this.skipClasspathElement) {
                    throw new IOException("Jarfile could not be opened");
                }
                if (this.inputStream != null) {
                    throw new IllegalArgumentException("Resource is already open -- cannot open it again without first calling close()");
                }
                try {
                    this.zipFileRecyclable = ClasspathElementZip.this.zipFileRecycler.acquire();
                    this.zipFile = (ZipFile)this.zipFileRecyclable.get();
                    this.inputStream = this.zipFile.getInputStream(zipEntry);
                    this.length = zipEntry.getSize();
                    return this.inputStream;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            InputStreamOrByteBufferAdapter openOrRead() throws IOException {
                return InputStreamOrByteBufferAdapter.create(this.open());
            }

            @Override
            public ByteBuffer read() throws IOException {
                this.open();
                return this.inputStreamToByteBuffer();
            }

            @Override
            public byte[] load() throws IOException {
                try {
                    this.read();
                    byte[] byteArray = this.inputStreamToByteArray();
                    this.length = byteArray.length;
                    byte[] byArray = byteArray;
                    return byArray;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public void close() {
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                        this.inputStream = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.byteBuffer != null) {
                    this.byteBuffer = null;
                }
                if (this.zipFile != null) {
                    this.zipFile = null;
                }
                if (this.zipFileRecyclable != null) {
                    this.zipFileRecyclable.close();
                    this.zipFileRecyclable = null;
                }
            }

            @Override
            protected String toStringImpl() {
                return "[jar " + jarFile + "]/" + this.getPathRelativeToClasspathElement();
            }
        };
    }

    @Override
    void scanPaths(LogNode log) {
        String path;
        String canonicalPath = path = this.classpathEltPath.getResolvedPath();
        try {
            canonicalPath = this.classpathEltPath.getCanonicalPath(log);
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception canonicalizing path " + this.classpathEltPath + " : " + e);
            }
            this.skipClasspathElement = true;
            return;
        }
        if (this.jarfileMetadataReader == null) {
            this.skipClasspathElement = true;
            return;
        }
        LogNode subLog = log == null ? null : log.log(canonicalPath, "Scanning jarfile classpath entry " + this.classpathEltPath + (path.equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        int requiredPrefixLen = this.packageRootPrefix.length();
        HashSet<String> loggedNestedClasspathRootPrefixes = null;
        String prevParentRelativePath = null;
        ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
        for (ZipEntry zipEntry : this.jarfileMetadataReader.zipEntries) {
            int lastSlashIdx;
            String relativePath = zipEntry.getName();
            while (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (requiredPrefixLen > 0) {
                if (!relativePath.startsWith(this.packageRootPrefix)) continue;
                relativePath = relativePath.substring(requiredPrefixLen);
            }
            if (this.nestedClasspathRootPrefixes != null) {
                boolean reachedNestedRoot = false;
                for (String nestedClasspathRoot : this.nestedClasspathRootPrefixes) {
                    if (!relativePath.startsWith(nestedClasspathRoot)) continue;
                    if (subLog != null) {
                        if (loggedNestedClasspathRootPrefixes == null) {
                            loggedNestedClasspathRootPrefixes = new HashSet<String>();
                        }
                        if (loggedNestedClasspathRootPrefixes.add(nestedClasspathRoot)) {
                            subLog.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + nestedClasspathRoot);
                        }
                    }
                    reachedNestedRoot = true;
                    break;
                }
                if (reachedNestedRoot) continue;
            }
            String parentRelativePath = (lastSlashIdx = relativePath.lastIndexOf("/")) < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
            boolean parentRelativePathChanged = prevParentRelativePath == null || !parentRelativePath.equals(prevParentRelativePath);
            ScanSpec.ScanSpecPathMatch parentMatchStatus = parentRelativePathChanged ? this.scanSpec.dirWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
            prevParentRelativePath = parentRelativePath;
            prevParentMatchStatus = parentMatchStatus;
            if (!(parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE && this.scanSpec.isSpecificallyWhitelistedClass(relativePath))) {
                if (subLog == null) continue;
                subLog.log("Skipping non-whitelisted path: " + relativePath);
                continue;
            }
            if (subLog != null) {
                subLog.log(relativePath, "Found whitelisted file: " + relativePath);
            }
            if (this.scanSpec.enableClassInfo && FileUtils.isClassfile(relativePath)) {
                this.classfileMatches.add(this.newClasspathResource(this.classpathEltZipFile, this.packageRootPrefix, relativePath, zipEntry));
            }
            this.fileMatches.add(this.newClasspathResource(this.classpathEltZipFile, this.packageRootPrefix, relativePath, zipEntry));
        }
        this.fileToLastModified.put(this.classpathEltZipFile, this.classpathEltZipFile.lastModified());
        if (subLog != null) {
            subLog.addElapsedTime();
        }
    }

    @Override
    void closeRecyclers() {
        if (this.zipFileRecycler != null) {
            this.zipFileRecycler.close();
        }
    }
}

