/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.http.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.management.internal.web.http.converter.SerializableObjectHttpMessageConverter;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.NotAuthorizedException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpRequester {
    private final RestTemplate restTemplate;
    private Properties securityProperties;
    protected static final String USER_AGENT_HTTP_REQUEST_HEADER_VALUE = "GemFire-Shell/v" + GemFireVersion.getGemFireVersion();
    private final List<MediaType> acceptableMediaTypes = Arrays.asList(MediaType.APPLICATION_JSON, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OCTET_STREAM);

    public HttpRequester() {
        this(null, null);
    }

    public HttpRequester(Properties securityProperties) {
        this(securityProperties, null);
    }

    HttpRequester(Properties securityProperties, RestTemplate restTemplate) {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        this.securityProperties = securityProperties;
        this.restTemplate = restTemplate == null ? new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory) : restTemplate;
        List converters = this.restTemplate.getMessageConverters();
        for (int i = converters.size() - 1; i >= 0; --i) {
            HttpMessageConverter converter = (HttpMessageConverter)converters.get(i);
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            converters.remove(converter);
        }
        converters.add(new SerializableObjectHttpMessageConverter());
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
                String body = IOUtils.toString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
                String message = String.format("The HTTP request failed with: %1$d - %2$s.", response.getRawStatusCode(), body);
                if (response.getRawStatusCode() == 401) {
                    throw new AuthenticationFailedException(message);
                }
                if (response.getRawStatusCode() == 403) {
                    throw new NotAuthorizedException(message);
                }
                throw new RuntimeException(message);
            }
        });
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public <T> T get(URI url, Class<T> responseType) {
        return this.exchange(url, HttpMethod.GET, null, null, responseType);
    }

    public <T> T post(URI url, MediaType mediaType, Object content, Class<T> responseType) {
        return this.exchange(url, HttpMethod.POST, mediaType, content, responseType);
    }

    <T> T exchange(URI url, HttpMethod method, MediaType mediaType, Object content, Class<T> responseType) {
        HttpHeaders headers = new HttpHeaders();
        this.addHeaderValues(headers);
        HttpEntity httpEntity = new HttpEntity(content, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, method, httpEntity, responseType);
        return (T)response.getBody();
    }

    public Object executeWithResponseExtractor(URI url) {
        return this.restTemplate.execute(url, HttpMethod.POST, this::addHeaderValues, this::extractResponse);
    }

    void addHeaderValues(ClientHttpRequest request) {
        this.addHeaderValues(request.getHeaders());
    }

    Object extractResponse(ClientHttpResponse response) throws IOException {
        MediaType mediaType = response.getHeaders().getContentType();
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON)) {
            return IOUtils.toString((InputStream)response.getBody(), (String)"UTF-8");
        }
        Path tempFile = Files.createTempFile("fileDownload", "", new FileAttribute[0]);
        if (tempFile.toFile().exists()) {
            FileUtils.deleteQuietly((File)tempFile.toFile());
        }
        Files.copy(response.getBody(), tempFile, new CopyOption[0]);
        return tempFile;
    }

    void addHeaderValues(HttpHeaders headers) {
        headers.add("User-Agent", USER_AGENT_HTTP_REQUEST_HEADER_VALUE);
        headers.setAccept(this.acceptableMediaTypes);
        if (this.securityProperties != null) {
            for (String key : this.securityProperties.stringPropertyNames()) {
                headers.add(key, this.securityProperties.getProperty(key));
            }
        }
    }

    public static URI createURI(String baseUrl, String path, String ... queryParams) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)baseUrl).path(path);
        if (queryParams != null) {
            if (queryParams.length % 2 != 0) {
                throw new IllegalArgumentException("invalid queryParams count");
            }
            for (int i = 0; i < queryParams.length; i += 2) {
                builder.queryParam(queryParams[i], new Object[]{queryParams[i + 1]});
            }
        }
        return builder.build().encode().toUri();
    }
}

