/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import org.springframework.shell.support.util.AnsiEscapeCode;
import org.springframework.util.StringUtils;

public class Completion {
    private final int order;
    private final String formattedValue;
    private final String heading;
    private final String value;

    public Completion(String value) {
        this(value, value, null, 0);
    }

    public Completion(String value, String formattedValue, String heading, int order) {
        this.formattedValue = formattedValue;
        this.order = order;
        this.value = value;
        if (StringUtils.hasText((String)heading)) {
            heading = AnsiEscapeCode.decorate(heading, AnsiEscapeCode.UNDERSCORE, AnsiEscapeCode.FG_GREEN);
        }
        this.heading = heading;
    }

    public String getValue() {
        return this.value;
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public String getHeading() {
        return this.heading;
    }

    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return this.order + ". " + this.heading + " - " + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Completion that = (Completion)o;
        if (this.formattedValue != null ? !this.formattedValue.equals(that.formattedValue) : that.formattedValue != null) {
            return false;
        }
        if (this.heading != null ? !this.heading.equals(that.heading) : that.heading != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.formattedValue != null ? this.formattedValue.hashCode() : 0);
        result = 31 * result + (this.heading != null ? this.heading.hashCode() : 0);
        return result;
    }
}

