/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SRandMemberExecutor
extends SetExecutor {
    private static final String ERROR_NOT_NUMERIC = "The count provided must be numeric";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SRANDMEMBER command is \"SRANDMEMBER key [count]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<?, ?> keyRegion = context.getRegionProvider().getRegion(key);
        int count = 1;
        if (commandElems.size() > 2) {
            try {
                count = Coder.bytesToInt(commandElems.get(2));
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), ERROR_NOT_NUMERIC));
                return;
            }
        }
        if (keyRegion == null || count == 0) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        int members = keyRegion.size();
        if (members <= count && count != 1) {
            command.setResponse(Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), new HashSet<ByteArrayWrapper>(keyRegion.keySet())));
            return;
        }
        Random rand = new Random();
        ByteArrayWrapper[] entries = keyRegion.keySet().toArray(new ByteArrayWrapper[members]);
        if (count == 1) {
            ByteArrayWrapper randEntry = entries[rand.nextInt(entries.length)];
            command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), randEntry.toBytes()));
        } else if (count > 0) {
            HashSet<ByteArrayWrapper> randEntries = new HashSet<ByteArrayWrapper>();
            do {
                ByteArrayWrapper s = entries[rand.nextInt(entries.length)];
                randEntries.add(s);
            } while (randEntries.size() < count);
            command.setResponse(Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), randEntries));
        } else {
            count = -count;
            ArrayList<ByteArrayWrapper> randEntries = new ArrayList<ByteArrayWrapper>();
            for (int i = 0; i < count; ++i) {
                ByteArrayWrapper s = entries[rand.nextInt(entries.length)];
                randEntries.add(s);
            }
            command.setResponse(Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), randEntries));
        }
    }
}

